/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.warnings;

import dev.wxmc.weatheraddon.Config;
import dev.wxmc.weatheraddon.WXMCWeatherAddon;
import dev.wxmc.weatheraddon.block.ModBlocks;
import dev.wxmc.weatheraddon.block.RadarOverlayBlock;
import dev.wxmc.weatheraddon.block.RadarOverlayBlockEntity;
import dev.wxmc.weatheraddon.block.WallRadarBlockEntity;
import dev.wxmc.weatheraddon.compat.BukkitEventBridge;
import dev.wxmc.weatheraddon.item.EASReceiverItem;
import dev.wxmc.weatheraddon.network.WarningNetworkHandler;
import dev.wxmc.weatheraddon.util.WXMCDebugLogger;
import dev.wxmc.weatheraddon.warnings.AlertPolygon;
import dev.wxmc.weatheraddon.warnings.AlertPolygonManager;
import dev.wxmc.weatheraddon.warnings.IssuedWarning;
import dev.wxmc.weatheraddon.warnings.StormTracker;
import dev.wxmc.weatheraddon.warnings.TrackedStorm;
import dev.wxmc.weatheraddon.warnings.WarningConfig;
import dev.wxmc.weatheraddon.warnings.WarningGenerator;
import dev.wxmc.weatheraddon.warnings.WarningLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

public class WarningSystem {
    private static final int CHECK_INTERVAL = 20;
    private static final int RADAR_SCAN_INTERVAL = 60;
    private static final int CACHE_CLEANUP_INTERVAL = 20;
    private static final AtomicInteger tickCounter = new AtomicInteger(0);
    private static final AtomicInteger radarScanCounter = new AtomicInteger(0);
    private static final AtomicInteger cacheCleanupCounter = new AtomicInteger(0);
    private static final Map<BlockPos, String> activeRadars = new ConcurrentHashMap<BlockPos, String>();
    private static final Set<BlockPos> knownRadarOverlays = ConcurrentHashMap.newKeySet();
    private static final Map<Long, Long> lastTorWarningTimes = new ConcurrentHashMap<Long, Long>();
    private static final Map<Long, Long> lastSvrWarningTimes = new ConcurrentHashMap<Long, Long>();
    private static final Map<Long, Integer> previousStormStages = new ConcurrentHashMap<Long, Integer>();
    private static final Map<Long, StormDissipateData> stormDissipateData = new ConcurrentHashMap<Long, StormDissipateData>();
    private static final Map<UUID, Set<Long>> playerWarningStates = new ConcurrentHashMap<UUID, Set<Long>>();
    private static final Map<Long, IssuedWarning> activeWarnings = new ConcurrentHashMap<Long, IssuedWarning>();
    private static final Map<Long, Long> stormToTorWarningMap = new ConcurrentHashMap<Long, Long>();
    private static final Map<Long, Long> stormToSvrWarningMap = new ConcurrentHashMap<Long, Long>();
    @Deprecated
    private static final Map<Long, Long> stormToWarningMap = new ConcurrentHashMap<Long, Long>();
    private static final Object WARNING_MAP_LOCK = new Object();
    private static final Map<BlockPos, PendingSync> pendingSyncs = new ConcurrentHashMap<BlockPos, PendingSync>();
    private static final int MAX_SYNC_RETRIES = 200;

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        if (!((Boolean)WarningConfig.WARNING_SYSTEM_ENABLED.get()).booleanValue()) {
            return;
        }
        tickCounter.incrementAndGet();
        radarScanCounter.incrementAndGet();
        if (radarScanCounter.get() >= 60) {
            radarScanCounter.set(0);
            if (WarningConfig.shouldLogRadarScans()) {
                WXMCDebugLogger.debug("[RADAR-SCAN] ========== Starting player-proximity radar scan ==========");
            }
            for (ServerLevel level : event.getServer().getAllLevels()) {
                WarningSystem.scanForRadarsNearPlayers(level);
            }
            WarningSystem.cleanupInactiveRadars(event.getServer().getAllLevels());
            cacheCleanupCounter.incrementAndGet();
            if (cacheCleanupCounter.get() >= 20) {
                int overlaysRemoved;
                cacheCleanupCounter.set(0);
                int staleRemoved = AlertPolygonManager.cleanupStaleEntries();
                if (staleRemoved > 0 && WarningConfig.isDebugMode()) {
                    WXMCDebugLogger.debug("[CACHE-CLEANUP] Removed {} stale polygon entries", staleRemoved);
                }
                if ((overlaysRemoved = WarningSystem.cleanupStaleRadarOverlays(event.getServer().getAllLevels())) > 0 && WarningConfig.isDebugMode()) {
                    WXMCDebugLogger.debug("[CACHE-CLEANUP] Removed {} stale radar overlay entries", overlaysRemoved);
                }
            }
            if (WarningConfig.shouldLogRadarScans()) {
                WXMCDebugLogger.debug("[RADAR-SCAN] ========== Scan complete. Active radars: {} ==========", activeRadars.size());
            }
        }
        if (!pendingSyncs.isEmpty()) {
            WarningSystem.processPendingSyncs();
        }
        if (tickCounter.get() >= 20) {
            Iterator levelIterator;
            tickCounter.set(0);
            StormTracker tracker = StormTracker.getInstance();
            tracker.beginUpdateCycle();
            for (ServerLevel level : event.getServer().getAllLevels()) {
                tracker.updateFromLevel(level);
            }
            WarningSystem.checkForTornadoSpawnEvents(tracker, event.getServer().getAllLevels());
            Set<Long> clearedStormIds = tracker.endUpdateCycle();
            if (!clearedStormIds.isEmpty()) {
                WarningSystem.fireTornadoDissipateEvents(clearedStormIds, event.getServer().getAllLevels());
            }
            boolean warningsCleared = false;
            if (!clearedStormIds.isEmpty()) {
                warningsCleared = WarningSystem.cancelWarningsForClearedStorms(clearedStormIds);
            }
            if (!(levelIterator = event.getServer().getAllLevels().iterator()).hasNext()) {
                return;
            }
            ServerLevel firstLevel = (ServerLevel)levelIterator.next();
            long currentGameTime = firstLevel.getDayTime();
            boolean warningsExpired = WarningSystem.removeExpiredWarnings(currentGameTime);
            WarningSystem.checkWarningCriteria(tracker, currentGameTime);
            WarningSystem.updateActiveWarningPolygons(tracker, currentGameTime);
            for (ServerLevel level : event.getServer().getAllLevels()) {
                WarningSystem.processWarningsForLevel(level, tracker);
                WarningSystem.updatePolygonsForLevel(level, tracker);
            }
            WarningSystem.checkPlayersInWarnings(event.getServer().getAllLevels());
            if (warningsCleared || warningsExpired) {
                WarningSystem.forcePolygonSyncAllRadars(event.getServer().getAllLevels());
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            BlockPos pos = event.getPos();
            BlockState state = event.getState();
            ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
            String namespace = blockId.getNamespace();
            String path = blockId.getPath().toLowerCase();
            if (namespace.equals("pmweather") && (path.contains("radar") || path.contains("wsr88d"))) {
                WXMCDebugLogger.debug("[RADAR-BREAK] PMWeather radar destroyed at {} - immediate cleanup", pos);
                WarningSystem.removeRadarImmediate(level, pos);
            }
            if (state.is((Block)ModBlocks.RADAR_OVERLAY.get())) {
                WXMCDebugLogger.debug("[RADAR-BREAK] Radar overlay destroyed at {} - cleaning up", pos);
                BlockPos radarPos = pos.below();
                WarningSystem.removeRadarImmediate(level, radarPos);
            }
        }
    }

    private static void scanForRadarsNearPlayers(ServerLevel level) {
        String dimensionKey = level.dimension().location().toString();
        ArrayList<ServerPlayer> players = new ArrayList<ServerPlayer>(level.players());
        if (players.isEmpty()) {
            if (WarningConfig.shouldLogRadarScans()) {
                WXMCDebugLogger.debug("[RADAR-SCAN] No players in {} - skipping", dimensionKey);
            }
            return;
        }
        if (WarningConfig.shouldLogRadarScans()) {
            WXMCDebugLogger.debug("[RADAR-SCAN] Scanning around {} player(s) in {} (radius: {} blocks)", players.size(), dimensionKey, Config.RADAR_DETECTION_RADIUS.get());
        }
        int totalChunksScanned = 0;
        int totalBlockEntitiesChecked = 0;
        int radarsFound = 0;
        HashSet<ChunkPos> chunksToScan = new HashSet<ChunkPos>();
        for (ServerPlayer player : players) {
            BlockPos playerPos = player.blockPosition();
            if (WarningConfig.shouldLogRadarScans()) {
                WXMCDebugLogger.debug("[RADAR-SCAN] Player {} at ({}, {}, {})", player.getName().getString(), playerPos.getX(), playerPos.getY(), playerPos.getZ());
            }
            int chunkRadius = (Integer)Config.RADAR_DETECTION_RADIUS.get() / 16 + 1;
            ChunkPos playerChunk = new ChunkPos(playerPos);
            for (int cx = -chunkRadius; cx <= chunkRadius; ++cx) {
                for (int i = -chunkRadius; i <= chunkRadius; ++i) {
                    ChunkPos checkPos = new ChunkPos(playerChunk.x + cx, playerChunk.z + i);
                    if (level.getChunkSource().getChunkNow(checkPos.x, checkPos.z) == null) continue;
                    chunksToScan.add(checkPos);
                }
            }
        }
        if (WarningConfig.shouldLogRadarScans()) {
            WXMCDebugLogger.debug("[RADAR-SCAN] Will scan {} chunks around players", chunksToScan.size());
        }
        for (ChunkPos chunkPos : chunksToScan) {
            LevelChunk chunk = level.getChunkSource().getChunkNow(chunkPos.x, chunkPos.z);
            if (chunk == null) continue;
            ++totalChunksScanned;
            Map blockEntities = chunk.getBlockEntities();
            ArrayList blockEntitySnapshot = new ArrayList(blockEntities.entrySet());
            totalBlockEntitiesChecked += blockEntitySnapshot.size();
            for (Map.Entry entry : blockEntitySnapshot) {
                boolean playerNearby;
                BlockPos pos = (BlockPos)entry.getKey();
                if (pos == null || !WarningSystem.isRadarBlock(level, pos) || !(playerNearby = WarningSystem.isAnyPlayerNearby(players, pos)) || activeRadars.containsKey(pos)) continue;
                ++radarsFound;
                WarningSystem.activateRadar(level, pos, dimensionKey);
            }
        }
        if (WarningConfig.shouldLogRadarScans()) {
            WXMCDebugLogger.debug("[RADAR-SCAN] {} results: {} chunks, {} block entities checked, {} new radars activated", dimensionKey, totalChunksScanned, totalBlockEntitiesChecked, radarsFound);
        }
    }

    private static boolean isAnyPlayerNearby(List<ServerPlayer> players, BlockPos pos) {
        for (ServerPlayer player : players) {
            double radiusSquared;
            double distance = player.blockPosition().distSqr((Vec3i)pos);
            if (!(distance <= (radiusSquared = (double)((Integer)Config.RADAR_DETECTION_RADIUS.get() * (Integer)Config.RADAR_DETECTION_RADIUS.get())))) continue;
            return true;
        }
        return false;
    }

    private static void activateRadar(ServerLevel level, BlockPos radarPos, String dimensionKey) {
        if (WarningConfig.shouldLogRadarScans()) {
            WXMCDebugLogger.debug("[RADAR-ACTIVATE] Activating radar at {} in {}", radarPos, dimensionKey);
        }
        activeRadars.put(radarPos, dimensionKey);
        boolean isWallRadar = WarningSystem.isWallRadarBlock(level, radarPos);
        if (isWallRadar) {
            WarningSystem.syncWallRadarPolygons(level, radarPos);
            if (WarningConfig.shouldLogRadarScans()) {
                WXMCDebugLogger.debug("[RADAR-ACTIVATE] Wall radar at {} is now active (polygons synced)", radarPos);
            }
        } else {
            WarningSystem.placeOverlayIfNeeded(level, radarPos);
            WarningSystem.syncRadarPolygons(level, radarPos);
            if (WarningConfig.shouldLogRadarScans()) {
                WXMCDebugLogger.debug("[RADAR-ACTIVATE] Radar at {} is now active (overlay placed, polygons synced)", radarPos);
            }
        }
    }

    private static void cleanupInactiveRadars(Iterable<ServerLevel> levels) {
        if (activeRadars.isEmpty()) {
            return;
        }
        if (WarningConfig.shouldLogRadarScans()) {
            WXMCDebugLogger.debug("[RADAR-CLEANUP] Checking {} active radar(s) for cleanup", activeRadars.size());
        }
        HashMap<String, List<Object>> playersByDimension = new HashMap<String, List<Object>>();
        for (ServerLevel level : levels) {
            String dimKey = level.dimension().location().toString();
            playersByDimension.put(dimKey, new ArrayList(level.players()));
        }
        Iterator<Map.Entry<BlockPos, String>> iter = activeRadars.entrySet().iterator();
        int removed = 0;
        block1: while (iter.hasNext()) {
            Map.Entry<BlockPos, String> entry = iter.next();
            BlockPos radarPos = entry.getKey();
            String dimensionKey = entry.getValue();
            List<ServerPlayer> players = playersByDimension.getOrDefault(dimensionKey, Collections.emptyList());
            boolean playerNearby = WarningSystem.isAnyPlayerNearby(players, radarPos);
            if (!playerNearby) {
                if (WarningConfig.shouldLogRadarScans()) {
                    WXMCDebugLogger.debug("[RADAR-CLEANUP] No players near radar at {} - deactivating", radarPos);
                }
                for (ServerLevel level : levels) {
                    if (!level.dimension().location().toString().equals(dimensionKey)) continue;
                    WarningSystem.deactivateRadar(level, radarPos);
                    break;
                }
                iter.remove();
                ++removed;
                continue;
            }
            for (ServerLevel level : levels) {
                if (!level.dimension().location().toString().equals(dimensionKey)) continue;
                if (!level.isLoaded(radarPos) || WarningSystem.isRadarBlock(level, radarPos)) continue block1;
                if (WarningConfig.shouldLogRadarScans()) {
                    WXMCDebugLogger.debug("[RADAR-CLEANUP] Radar at {} no longer exists - removing", radarPos);
                }
                WarningSystem.deactivateRadar(level, radarPos);
                iter.remove();
                ++removed;
                continue block1;
            }
        }
        if (removed > 0 && WarningConfig.shouldLogRadarScans()) {
            WXMCDebugLogger.debug("[RADAR-CLEANUP] Removed {} inactive radar(s). {} remaining.", removed, activeRadars.size());
        }
    }

    private static int cleanupStaleRadarOverlays(Iterable<ServerLevel> levels) {
        if (knownRadarOverlays.isEmpty()) {
            return 0;
        }
        HashMap<String, ServerLevel> levelByDimension = new HashMap<String, ServerLevel>();
        for (ServerLevel level : levels) {
            levelByDimension.put(level.dimension().location().toString(), level);
        }
        int removed = 0;
        Iterator<BlockPos> iter = knownRadarOverlays.iterator();
        while (iter.hasNext()) {
            BlockPos overlayPos = iter.next();
            boolean found = false;
            boolean shouldRemove = false;
            for (ServerLevel level : levels) {
                if (!level.isLoaded(overlayPos)) continue;
                found = true;
                BlockState state = level.getBlockState(overlayPos);
                if (state.is((Block)ModBlocks.RADAR_OVERLAY.get())) break;
                shouldRemove = true;
                break;
            }
            if (!found || !shouldRemove) continue;
            iter.remove();
            AlertPolygonManager.clearPolygons(overlayPos);
            ++removed;
        }
        return removed;
    }

    private static void deactivateRadar(ServerLevel level, BlockPos radarPos) {
        BlockState overlayState;
        BlockPos overlayPos = radarPos.above();
        if (WarningConfig.shouldLogRadarScans()) {
            WXMCDebugLogger.debug("[RADAR-DEACTIVATE] Deactivating radar at {}", radarPos);
        }
        if (level.isLoaded(overlayPos) && (overlayState = level.getBlockState(overlayPos)).is((Block)ModBlocks.RADAR_OVERLAY.get())) {
            level.removeBlock(overlayPos, false);
            if (WarningConfig.shouldLogRadarScans()) {
                WXMCDebugLogger.debug("[RADAR-DEACTIVATE] Removed overlay block at {}", overlayPos);
            }
        }
        knownRadarOverlays.remove(overlayPos);
        AlertPolygonManager.clearPolygons(overlayPos);
        WarningNetworkHandler.broadcastRadarRemoved(radarPos);
        if (WarningConfig.shouldLogRadarScans()) {
            WXMCDebugLogger.debug("[RADAR-DEACTIVATE] Radar at {} fully deactivated", radarPos);
        }
    }

    private static void removeRadarImmediate(ServerLevel level, BlockPos radarPos) {
        String dimensionKey = level.dimension().location().toString();
        WXMCDebugLogger.debug("[RADAR-REMOVE] Immediate removal of radar at {} in {}", radarPos, dimensionKey);
        activeRadars.remove(radarPos);
        WarningSystem.deactivateRadar(level, radarPos);
    }

    private static boolean isRadarBlock(ServerLevel level, BlockPos pos) {
        boolean isWallRadar;
        BlockState state = level.getBlockState(pos);
        if (state.isAir()) {
            return false;
        }
        ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
        String namespace = blockId.getNamespace();
        String path = blockId.getPath().toLowerCase();
        boolean isRadar = namespace.equals("pmweather") && (path.contains("radar") || path.contains("wsr88d"));
        boolean bl = isWallRadar = namespace.equals("wxmcweatheraddon") && path.equals("wall_radar");
        if ((isRadar || isWallRadar) && WarningConfig.isDebugMode()) {
            WXMCDebugLogger.debug("[DEBUG] Found radar block: {} at {}", blockId, pos);
        }
        return isRadar || isWallRadar;
    }

    private static boolean isWallRadarBlock(ServerLevel level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (state.isAir()) {
            return false;
        }
        ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
        return blockId.getNamespace().equals("wxmcweatheraddon") && blockId.getPath().equals("wall_radar");
    }

    private static void placeOverlayIfNeeded(ServerLevel level, BlockPos radarPos) {
        BlockPos overlayPos = radarPos.above();
        BlockState currentState = level.getBlockState(overlayPos);
        if (currentState.isAir() || currentState.canBeReplaced()) {
            level.setBlockAndUpdate(overlayPos, ((RadarOverlayBlock)((Object)ModBlocks.RADAR_OVERLAY.get())).defaultBlockState());
            knownRadarOverlays.add(overlayPos);
            if (WarningConfig.isDebugMode()) {
                WXMCWeatherAddon.LOGGER.info("Placed radar overlay at {} above radar at {}", (Object)overlayPos, (Object)radarPos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean removeExpiredWarnings(long currentGameTime) {
        Iterator<Map.Entry<Long, IssuedWarning>> iter = activeWarnings.entrySet().iterator();
        boolean anyRemoved = false;
        while (iter.hasNext()) {
            Map.Entry<Long, IssuedWarning> entry = iter.next();
            IssuedWarning warning = entry.getValue();
            boolean timeExpired = warning.isExpired(currentGameTime);
            boolean criteriaExpired = warning.shouldExpireDueToCriteria(currentGameTime);
            if (!timeExpired && !criteriaExpired) continue;
            long stormId = warning.getStormId();
            boolean isTorWarning = warning.getLevel().isTornadoWarning();
            Object object = WARNING_MAP_LOCK;
            synchronized (object) {
                stormToWarningMap.remove(stormId);
                if (isTorWarning) {
                    stormToTorWarningMap.remove(stormId);
                    lastTorWarningTimes.remove(stormId);
                } else {
                    stormToSvrWarningMap.remove(stormId);
                    lastSvrWarningTimes.remove(stormId);
                }
                iter.remove();
            }
            anyRemoved = true;
            if (!WarningConfig.isDebugMode()) continue;
            long durationTicks = currentGameTime - warning.getCreationGameTime();
            long durationMCMinutes = durationTicks * 60L / 1000L;
            String expirationReason = criteriaExpired ? "storm below criteria for 15 MC minutes" : "time expired";
            WXMCDebugLogger.debug("[WARNING-EXPIRED] {} warning {} for storm {} expired ({}) after {} MC minutes ({} ticks). Polygon removed from radar.", isTorWarning ? "TOR" : "SVR", warning.getWarningId(), stormId, expirationReason, durationMCMinutes, durationTicks);
        }
        return anyRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean cancelWarningsForClearedStorms(Set<Long> clearedStormIds) {
        boolean anyRemoved = false;
        Iterator<Map.Entry<Long, IssuedWarning>> iter = activeWarnings.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Long, IssuedWarning> entry = iter.next();
            IssuedWarning warning = entry.getValue();
            if (!clearedStormIds.contains(warning.getStormId())) continue;
            Object object = WARNING_MAP_LOCK;
            synchronized (object) {
                stormToWarningMap.remove(warning.getStormId());
                stormToTorWarningMap.remove(warning.getStormId());
                stormToSvrWarningMap.remove(warning.getStormId());
                lastTorWarningTimes.remove(warning.getStormId());
                lastSvrWarningTimes.remove(warning.getStormId());
                iter.remove();
            }
            anyRemoved = true;
            WXMCDebugLogger.debug("[WARNING-CANCEL] Cancelled {} ({}) for storm {} - storm no longer exists", warning.getLevel().getDisplayName(), warning.getWarningId(), warning.getStormId());
        }
        return anyRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkStormMovement(StormTracker tracker) {
        for (IssuedWarning warning : activeWarnings.values()) {
            if (warning.hasStormLeft()) continue;
            TrackedStorm storm = tracker.getStorm(warning.getStormId());
            if (storm == null) {
                warning.setStormHasLeft(true);
                continue;
            }
            if (warning.containsPosition(storm.getPosition())) continue;
            warning.setStormHasLeft(true);
            WXMCWeatherAddon.LOGGER.info("Storm {} has moved out of warning {} polygon", (Object)storm.getId(), (Object)warning.getWarningId());
            Object object = WARNING_MAP_LOCK;
            synchronized (object) {
                activeWarnings.remove(warning.getWarningId());
                stormToWarningMap.remove(storm.getId());
            }
        }
    }

    private static void updateActiveWarningPolygons(StormTracker tracker, long currentGameTime) {
        for (IssuedWarning warning : activeWarnings.values()) {
            boolean updated;
            TrackedStorm storm = tracker.getStorm(warning.getStormId());
            if (storm == null || !(updated = warning.updatePolygonFromStorm(storm, currentGameTime)) || !WarningConfig.isDebugMode()) continue;
            WXMCDebugLogger.debug("[POLYGON-UPDATE] Updated polygon for warning {} (storm {})", warning.getWarningId(), storm.getId());
        }
    }

    private static void checkWarningCriteria(StormTracker tracker, long currentGameTime) {
        for (IssuedWarning warning : activeWarnings.values()) {
            boolean meetsCriteria;
            TrackedStorm storm = tracker.getStorm(warning.getStormId());
            if (storm == null) {
                warning.markBelowCriteria(currentGameTime);
                continue;
            }
            boolean isTorWarning = warning.getLevel().isTornadoWarning();
            WarningLevel currentLevel = isTorWarning ? WarningGenerator.calculateTornadoLevel(storm) : WarningGenerator.calculateSevereLevel(storm);
            boolean bl = meetsCriteria = currentLevel != WarningLevel.NONE;
            if (meetsCriteria) {
                if (warning.isBelowCriteria()) {
                    WXMCDebugLogger.debug("[WARNING-CRITERIA] Storm #{} {} warning: criteria met again, resetting expiration countdown", warning.getStormId(), isTorWarning ? "TOR" : "SVR");
                }
                warning.markMeetsCriteria();
                continue;
            }
            if (!warning.isBelowCriteria()) {
                WXMCDebugLogger.debug("[WARNING-CRITERIA] Storm #{} {} warning: fell below criteria, starting 15 MC minute countdown", warning.getStormId(), isTorWarning ? "TOR" : "SVR");
            }
            warning.markBelowCriteria(currentGameTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IssuedWarning issueWarning(TrackedStorm storm, WarningLevel level, long currentGameTime) {
        IssuedWarning oldWarning;
        boolean isTorWarning = level.isTornadoWarning();
        Map<Long, Long> targetMap = isTorWarning ? stormToTorWarningMap : stormToSvrWarningMap;
        Long oldWarningId = targetMap.get(storm.getId());
        if (oldWarningId != null && (oldWarning = activeWarnings.remove(oldWarningId)) != null && WarningConfig.isDebugMode()) {
            WXMCDebugLogger.debug("[DEBUG] Removing old {} warning {} at polygon center ({}, {})", isTorWarning ? "TOR" : "SVR", oldWarningId, (int)oldWarning.getPolygonCenter().x, (int)oldWarning.getPolygonCenter().z);
        }
        IssuedWarning warning = IssuedWarning.fromStorm(storm, level, currentGameTime);
        Object object = WARNING_MAP_LOCK;
        synchronized (object) {
            activeWarnings.put(warning.getWarningId(), warning);
            targetMap.put(storm.getId(), warning.getWarningId());
            stormToWarningMap.put(storm.getId(), warning.getWarningId());
        }
        String anchorType = isTorWarning ? "MESO" : "CORE";
        WXMCDebugLogger.debug("Issued {} warning {} ({}) for storm {} - anchor={}, polygon center at ({}, {}), size {}x{}", isTorWarning ? "TOR" : "SVR", warning.getWarningId(), level.getDisplayName(), storm.getId(), anchorType, (int)warning.getPolygonCenter().x, (int)warning.getPolygonCenter().z, (int)(warning.getPolygonHalfWidth() * 2.0f), (int)(warning.getPolygonHalfHeight() * 2.0f));
        return warning;
    }

    public static Collection<IssuedWarning> getActiveWarnings() {
        return Collections.unmodifiableCollection(activeWarnings.values());
    }

    private static void updatePolygonsForLevel(ServerLevel level, StormTracker tracker) {
        String dimensionKey = level.dimension().location().toString();
        HashSet<BlockPos> radarsInDimension = new HashSet<BlockPos>();
        for (Map.Entry<BlockPos, String> entry : activeRadars.entrySet()) {
            if (!dimensionKey.equals(entry.getValue())) continue;
            radarsInDimension.add(entry.getKey());
        }
        if (radarsInDimension.isEmpty()) {
            return;
        }
        int polygonsSent = 0;
        for (BlockPos radarPos : radarsInDimension) {
            BlockEntity be;
            if (!level.isLoaded(radarPos)) continue;
            List<AlertPolygon> polygons = WarningSystem.getPolygonsForRadar(radarPos);
            boolean isWallRadar = WarningSystem.isWallRadarBlock(level, radarPos);
            if (isWallRadar) {
                BlockEntity be2;
                AlertPolygonManager.clearPolygons(radarPos);
                for (AlertPolygon poly : polygons) {
                    AlertPolygonManager.addPolygon(radarPos, poly);
                }
                if (!polygons.isEmpty()) {
                    polygonsSent += polygons.size();
                }
                if ((be2 = level.getBlockEntity(radarPos)) instanceof WallRadarBlockEntity) {
                    WallRadarBlockEntity wallRadarBE = (WallRadarBlockEntity)be2;
                    wallRadarBE.requestClientUpdate();
                }
                WarningNetworkHandler.broadcastRadarPolygons(radarPos, polygons);
                continue;
            }
            BlockPos overlayPos = radarPos.above();
            AlertPolygonManager.clearPolygons(radarPos);
            for (AlertPolygon poly : polygons) {
                AlertPolygonManager.addPolygon(radarPos, poly);
            }
            AlertPolygonManager.clearPolygons(overlayPos);
            for (AlertPolygon poly : polygons) {
                AlertPolygonManager.addPolygon(overlayPos, poly);
            }
            if (!polygons.isEmpty()) {
                polygonsSent += polygons.size();
            }
            if (knownRadarOverlays.contains(overlayPos) && (be = level.getBlockEntity(overlayPos)) instanceof RadarOverlayBlockEntity) {
                RadarOverlayBlockEntity overlayBE = (RadarOverlayBlockEntity)be;
                overlayBE.requestClientUpdate();
            }
            WarningNetworkHandler.broadcastRadarPolygons(radarPos, polygons);
        }
        if (polygonsSent > 0) {
            WXMCDebugLogger.debug("[POLYGON-SYNC] Synced {} polygon(s) for {} active radar(s) in {}", polygonsSent, radarsInDimension.size(), dimensionKey);
        }
    }

    private static List<AlertPolygon> getPolygonsForRadar(BlockPos radarPos) {
        ArrayList<AlertPolygon> polygons = new ArrayList<AlertPolygon>();
        double radarRange = 2048.0;
        double radarX = (double)radarPos.getX() + 0.5;
        double radarZ = (double)radarPos.getZ() + 0.5;
        for (IssuedWarning warning : activeWarnings.values()) {
            Vec3 polygonCenter = warning.getPolygonCenter();
            double distance = Math.sqrt(Math.pow(polygonCenter.x - radarX, 2.0) + Math.pow(polygonCenter.z - radarZ, 2.0));
            if (distance > radarRange + (double)warning.getPolygonHalfWidth()) continue;
            AlertPolygon polygon = warning.toAlertPolygon(radarX, radarZ, radarRange);
            polygons.add(polygon);
        }
        return polygons;
    }

    private static void processWarningsForLevel(ServerLevel level, StormTracker tracker) {
        String dimensionKey = level.dimension().location().toString();
        List<TrackedStorm> storms = tracker.getTrackedStorms().stream().filter(storm -> dimensionKey.equals(storm.getDimensionKey())).toList();
        if (storms.isEmpty()) {
            return;
        }
        double warningRadius = ((Integer)WarningConfig.WARNING_RADIUS.get()).intValue();
        long currentTime = System.currentTimeMillis();
        long currentGameTime = level.getDayTime();
        long warningCooldownMs = WarningConfig.getWarningCooldownMs();
        long upgradeCooldownMs = WarningConfig.getUpgradeCooldownMs();
        for (TrackedStorm storm2 : storms) {
            if (storm2.getStormType() == 2) continue;
            WarningLevel torLevel = WarningGenerator.calculateTornadoLevel(storm2);
            WarningLevel svrLevel = WarningGenerator.calculateSevereLevel(storm2);
            if (WarningConfig.isDebugMode()) {
                String occlusionStatus = storm2.isCycling() ? "OCCLUDING" : "normal";
                float peakDBZ = WarningGenerator.calculatePeakDBZ(storm2);
                WXMCDebugLogger.debug("[DEBUG] Storm #{} ({}): type={} stage={} energy={} wind={} peakDBZ={} occlusion={} ({}) -> TOR={}, SVR={}", storm2.getId(), storm2.getStormTypeName(), storm2.getStormType(), storm2.getStage(), storm2.getEnergy(), storm2.getWindspeed(), String.format("%.1f", Float.valueOf(peakDBZ)), String.format("%.2f", Float.valueOf(storm2.getOcclusion())), occlusionStatus, torLevel.getDisplayName(), svrLevel.getDisplayName());
            }
            WarningLevel highestLevel = torLevel.isHigherThan(svrLevel) ? torLevel : svrLevel;
            storm2.setCurrentWarningLevel(highestLevel);
            tracker.updateStormWarningLevel(storm2.getId(), highestLevel);
            if (torLevel != WarningLevel.NONE && WarningConfig.shouldSendWarning(torLevel)) {
                WarningSystem.processWarningType(storm2, torLevel, true, level, tracker, currentTime, currentGameTime, warningRadius, upgradeCooldownMs);
            }
            if (svrLevel == WarningLevel.NONE || !WarningConfig.shouldSendWarning(svrLevel)) continue;
            WarningSystem.processWarningType(storm2, svrLevel, false, level, tracker, currentTime, currentGameTime, warningRadius, upgradeCooldownMs);
        }
        HashSet<Long> activeStormIds = new HashSet<Long>();
        for (TrackedStorm storm3 : storms) {
            activeStormIds.add(storm3.getId());
        }
        lastTorWarningTimes.keySet().removeIf(id -> !activeStormIds.contains(id));
        lastSvrWarningTimes.keySet().removeIf(id -> !activeStormIds.contains(id));
    }

    private static void processWarningType(TrackedStorm storm, WarningLevel newLevel, boolean isTorWarning, ServerLevel level, StormTracker tracker, long currentTime, long currentGameTime, double warningRadius, long upgradeCooldownMs) {
        Map<Long, Long> warningMap = isTorWarning ? stormToTorWarningMap : stormToSvrWarningMap;
        Map<Long, Long> lastWarnTimes = isTorWarning ? lastTorWarningTimes : lastSvrWarningTimes;
        String warningType = isTorWarning ? "TOR" : "SVR";
        Long existingWarningId = warningMap.get(storm.getId());
        IssuedWarning existingWarning = existingWarningId != null ? activeWarnings.get(existingWarningId) : null;
        WarningLevel previousLevel = existingWarning != null ? existingWarning.getLevel() : WarningLevel.NONE;
        boolean isUpgrade = newLevel.isHigherThan(previousLevel);
        boolean isFirstWarning = previousLevel == WarningLevel.NONE;
        boolean shouldWarn = false;
        if (isFirstWarning) {
            shouldWarn = true;
            WXMCDebugLogger.debug("[WARN-ISSUE] Storm #{}: First {} warning ({})", storm.getId(), warningType, newLevel.getDisplayName());
        } else if (isUpgrade) {
            Long lastWarnTime = lastWarnTimes.get(storm.getId());
            if (lastWarnTime == null || currentTime - lastWarnTime >= upgradeCooldownMs) {
                shouldWarn = true;
                WXMCDebugLogger.debug("[WARN-ISSUE] Storm #{}: {} upgrade from {} to {}", storm.getId(), warningType, previousLevel.getDisplayName(), newLevel.getDisplayName());
            }
        } else if (existingWarning != null) {
            existingWarning.updatePolygonFromStorm(storm, currentGameTime);
            return;
        }
        if (!shouldWarn) {
            return;
        }
        IssuedWarning issuedWarning = WarningSystem.issueWarning(storm, newLevel, currentGameTime);
        boolean warningSent = false;
        double NEAR_POLYGON_DISTANCE = 512.0;
        for (ServerPlayer player : new ArrayList(level.players())) {
            Vec3 playerPos = player.position();
            boolean isInsidePolygon = issuedWarning.containsPosition(playerPos);
            boolean isNearPolygon = issuedWarning.isNearPolygon(playerPos, 512.0);
            if (!isInsidePolygon && !isNearPolygon) continue;
            WarningSystem.sendWarningToPlayer(player, storm, newLevel, isUpgrade, issuedWarning, isInsidePolygon);
            warningSent = true;
        }
        if (warningSent) {
            lastWarnTimes.put(storm.getId(), currentTime);
            tracker.markStormWarned(storm.getId());
            if (WarningConfig.isDebugMode()) {
                WXMCDebugLogger.debug("{} warning issued: {} for storm {} (upgrade: {}, polygon at {}, {})", warningType, newLevel.getDisplayName(), storm.getId(), isUpgrade, (int)issuedWarning.getPolygonCenter().x, (int)issuedWarning.getPolygonCenter().z);
            }
        }
    }

    private static void sendWarningToPlayer(ServerPlayer player, TrackedStorm storm, WarningLevel level, boolean isUpgrade, IssuedWarning warning, boolean isInsidePolygon) {
        if (!EASReceiverItem.playerHasEnabledReceiver((Player)player)) {
            return;
        }
        if (((Boolean)WarningConfig.SHOW_CHAT_WARNINGS.get()).booleanValue()) {
            long worldTime = player.level().getDayTime() % 24000L;
            long worldDay = player.level().getDayTime() / 24000L;
            WarningGenerator.WarningAlertData alertData = WarningGenerator.generateChatAlertWithData(storm, level, worldTime, worldDay, isInsidePolygon);
            storm.setClientWarningId(alertData.warningId);
            WarningNetworkHandler.sendWarningAlert(player, storm.getId(), level, WarningGenerator.getCompactWarningText(level, isInsidePolygon), storm.getPosition().x, storm.getPosition().z, storm.getMovementDirectionString(), alertData.rawTemplate, alertData.color, alertData.warningId);
            String locationDesc = isInsidePolygon ? "INSIDE polygon" : "OUTSIDE polygon (near)";
            WXMCDebugLogger.debug("[WARNING-SEND] {} to {} - player at ({}, {}) is {} | polygon center=({}, {}), halfW={}, halfH={}, rot={}", level.getDisplayName(), player.getName().getString(), (int)player.position().x, (int)player.position().z, locationDesc, (int)warning.getPolygonCenter().x, (int)warning.getPolygonCenter().z, (int)warning.getPolygonHalfWidth(), (int)warning.getPolygonHalfHeight(), (int)warning.getPolygonRotation());
        }
    }

    public static void issueTestWarning(ServerPlayer player, WarningLevel level) {
        TrackedStorm testStorm = new TrackedStorm(-1L);
        testStorm.setStormType(0);
        testStorm.setStage(3);
        testStorm.setWindspeed(level == WarningLevel.TOR_EMERGENCY ? 200 : (level == WarningLevel.TOR_PDS ? 160 : (level == WarningLevel.TOR_CONFIRMED ? 65 : 30)));
        testStorm.setWidth(level == WarningLevel.TOR_EMERGENCY ? 180.0f : 80.0f);
        testStorm.setPosition(player.position().add(100.0, 0.0, 100.0));
        testStorm.setVelocity(new Vec3(0.6, 0.0, 0.45));
        testStorm.setCurrentWarningLevel(level);
        testStorm.setEnergy(50);
        long worldTime = player.level().getDayTime() % 24000L;
        long worldDay = player.level().getDayTime() / 24000L;
        WarningGenerator.WarningAlertData alertData = WarningGenerator.generateChatAlertWithData(testStorm, level, worldTime, worldDay);
        player.sendSystemMessage((Component)Component.literal((String)"=== TEST WARNING ===").withStyle(s -> s.withBold(Boolean.valueOf(true))));
        player.sendSystemMessage(alertData.chatMessage);
        player.sendSystemMessage((Component)Component.literal((String)"=== END TEST ===").withStyle(s -> s.withBold(Boolean.valueOf(true))));
        WarningNetworkHandler.sendWarningAlert(player, testStorm.getId(), level, WarningGenerator.getCompactWarningText(level), testStorm.getPosition().x, testStorm.getPosition().z, testStorm.getMovementDirectionString(), alertData.rawTemplate, alertData.color, alertData.warningId);
    }

    public static void registerRadarOverlay(BlockPos pos) {
        knownRadarOverlays.add(pos);
    }

    public static void unregisterRadarOverlay(BlockPos pos) {
        knownRadarOverlays.remove(pos);
        AlertPolygonManager.clearPolygons(pos);
    }

    public static String getStatusSummary() {
        StormTracker tracker = StormTracker.getInstance();
        StringBuilder sb = new StringBuilder();
        sb.append("Warning System Status:\n");
        sb.append("- PMWeather Available: ").append(tracker.isPMWeatherAvailable()).append("\n");
        sb.append("- System Enabled: ").append(WarningConfig.WARNING_SYSTEM_ENABLED.get()).append("\n");
        sb.append("- Active Storms: ").append(tracker.getStormCount()).append("\n");
        sb.append("- Tornado Storms: ").append(tracker.getTornadoStorms().size()).append("\n");
        sb.append("- Active Polygons: ").append(AlertPolygonManager.getTotalPolygonCount()).append("\n");
        sb.append("- Active Radars (player nearby): ").append(activeRadars.size()).append("\n");
        sb.append("- Known Radar Overlays: ").append(knownRadarOverlays.size()).append("\n");
        sb.append("- Detection Radius: ").append(Config.RADAR_DETECTION_RADIUS.get()).append(" blocks\n");
        sb.append("- Scan Interval: ").append(3.0).append(" seconds\n");
        Collection<TrackedStorm> storms = tracker.getTrackedStorms();
        if (!storms.isEmpty()) {
            sb.append("\nActive Warnings:\n");
            for (TrackedStorm storm : storms) {
                if (storm.getCurrentWarningLevel() == WarningLevel.NONE) continue;
                sb.append(String.format("- Storm %d: %s (%s, stage %d)\n", storm.getId(), storm.getCurrentWarningLevel().getDisplayName(), storm.getStormTypeName(), storm.getStage()));
            }
        }
        return sb.toString();
    }

    public static String getRadarStatusSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append("\u00a76=== Radar Detection Status (Player-Proximity) ===\n");
        sb.append("\u00a77Detection Radius: \u00a7f").append(Config.RADAR_DETECTION_RADIUS.get()).append(" blocks\n");
        sb.append("\u00a77Scan Interval: \u00a7f").append(3.0).append(" seconds\n");
        sb.append("\u00a77Active Radars: \u00a7f").append(activeRadars.size()).append("\n");
        sb.append("\u00a77Active Overlays: \u00a7f").append(knownRadarOverlays.size()).append("\n");
        HashMap<String, List> radarsByDimension = new HashMap<String, List>();
        for (Map.Entry<BlockPos, String> entry : activeRadars.entrySet()) {
            radarsByDimension.computeIfAbsent(entry.getValue(), k -> new ArrayList()).add(entry.getKey());
        }
        for (Map.Entry<Object, String> entry : radarsByDimension.entrySet()) {
            sb.append("\u00a7e").append((String)entry.getKey()).append(": \u00a7f").append(((List)((Object)entry.getValue())).size()).append(" radar(s)\n");
            for (BlockPos pos : (List)((Object)entry.getValue())) {
                boolean hasOverlay = knownRadarOverlays.contains(pos.above());
                sb.append("  \u00a77- ").append(pos.toShortString());
                sb.append(hasOverlay ? " \u00a7a[overlay active]" : " \u00a7c[no overlay]").append("\n");
            }
        }
        if (activeRadars.isEmpty()) {
            sb.append("\u00a77No active radars. Radars are only active when:\n");
            sb.append("  \u00a77- A player is within ").append(Config.RADAR_DETECTION_RADIUS.get()).append(" blocks\n");
            sb.append("  \u00a77- PMWeather radar block exists\n");
        }
        sb.append("\n\u00a76Polygon Status:\n");
        sb.append("\u00a77Total Polygons: \u00a7f").append(AlertPolygonManager.getTotalPolygonCount()).append("\n");
        for (BlockPos blockPos : knownRadarOverlays) {
            int count = AlertPolygonManager.getPolygonCount(blockPos);
            if (count <= 0) continue;
            sb.append("  \u00a77- ").append(blockPos.below().toShortString()).append(": \u00a7f").append(count).append(" polygon(s)\n");
        }
        return sb.toString();
    }

    public static int getActiveRadarCount() {
        return activeRadars.size();
    }

    public static Map<BlockPos, String> getActiveRadars() {
        return Collections.unmodifiableMap(activeRadars);
    }

    public static Set<BlockPos> getKnownOverlays() {
        return Collections.unmodifiableSet(knownRadarOverlays);
    }

    public static void clearWarningData() {
        WXMCDebugLogger.debug("[CLEAR] Clearing all warning system data...");
        lastTorWarningTimes.clear();
        lastSvrWarningTimes.clear();
        activeWarnings.clear();
        stormToWarningMap.clear();
        stormToTorWarningMap.clear();
        stormToSvrWarningMap.clear();
        pendingSyncs.clear();
        StormTracker.getInstance().clearStorms();
        AlertPolygonManager.clearAll();
        knownRadarOverlays.clear();
        activeRadars.clear();
        WXMCDebugLogger.debug("[CLEAR] Warning system data cleared");
    }

    public static void onRadarRemoved(BlockPos overlayPos) {
        knownRadarOverlays.remove(overlayPos);
        BlockPos radarPos = overlayPos.below();
        activeRadars.remove(radarPos);
        AlertPolygonManager.clearPolygons(overlayPos);
        WarningNetworkHandler.broadcastRadarRemoved(radarPos);
    }

    public static void forceRescan() {
        WXMCDebugLogger.debug("[FORCE-RESCAN] Clearing active radars - will re-detect on next scan cycle");
        activeRadars.clear();
        knownRadarOverlays.clear();
    }

    private static void processPendingSyncs() {
        Iterator<Map.Entry<BlockPos, PendingSync>> iter = pendingSyncs.entrySet().iterator();
        while (iter.hasNext()) {
            BlockPos overlayPos;
            Map.Entry<BlockPos, PendingSync> entry = iter.next();
            BlockPos radarPos = entry.getKey();
            PendingSync pending = entry.getValue();
            ServerLevel level = pending.level();
            BlockEntity be = level.getBlockEntity(overlayPos = radarPos.above());
            if (be instanceof RadarOverlayBlockEntity) {
                RadarOverlayBlockEntity overlayBE = (RadarOverlayBlockEntity)be;
                List<AlertPolygon> polygons = WarningSystem.getPolygonsForRadar(radarPos);
                AlertPolygonManager.clearPolygons(overlayPos);
                for (AlertPolygon poly : polygons) {
                    AlertPolygonManager.addPolygon(overlayPos, poly);
                }
                overlayBE.requestClientUpdate();
                iter.remove();
                if (!WarningConfig.isDebugMode()) continue;
                WXMCDebugLogger.debug("[PENDING-SYNC] Overlay BE ready at {} (retry #{})", radarPos, pending.retryCount());
                continue;
            }
            if (pending.retryCount() >= 200) {
                iter.remove();
                if (!WarningConfig.isDebugMode()) continue;
                WXMCDebugLogger.debug("[PENDING-SYNC] No overlay BE at {} after {} retries (using network sync)", radarPos, 200);
                continue;
            }
            pendingSyncs.put(radarPos, new PendingSync(level, pending.retryCount() + 1));
        }
    }

    private static void syncRadarPolygons(ServerLevel level, BlockPos radarPos) {
        BlockPos overlayPos = radarPos.above();
        knownRadarOverlays.add(overlayPos);
        List<AlertPolygon> polygons = WarningSystem.getPolygonsForRadar(radarPos);
        AlertPolygonManager.clearPolygons(radarPos);
        for (AlertPolygon poly : polygons) {
            AlertPolygonManager.addPolygon(radarPos, poly);
        }
        AlertPolygonManager.clearPolygons(overlayPos);
        for (AlertPolygon poly : polygons) {
            AlertPolygonManager.addPolygon(overlayPos, poly);
        }
        WarningNetworkHandler.broadcastRadarPolygons(radarPos, polygons);
        BlockEntity be = level.getBlockEntity(overlayPos);
        if (be instanceof RadarOverlayBlockEntity) {
            RadarOverlayBlockEntity overlayBE = (RadarOverlayBlockEntity)be;
            overlayBE.requestClientUpdate();
            pendingSyncs.remove(radarPos);
        } else {
            pendingSyncs.put(radarPos, new PendingSync(level, 1));
        }
    }

    private static void syncWallRadarPolygons(ServerLevel level, BlockPos wallRadarPos) {
        List<AlertPolygon> polygons = WarningSystem.getPolygonsForRadar(wallRadarPos);
        AlertPolygonManager.clearPolygons(wallRadarPos);
        for (AlertPolygon poly : polygons) {
            AlertPolygonManager.addPolygon(wallRadarPos, poly);
        }
        BlockEntity be = level.getBlockEntity(wallRadarPos);
        if (be instanceof WallRadarBlockEntity) {
            WallRadarBlockEntity wallRadarBE = (WallRadarBlockEntity)be;
            wallRadarBE.requestClientUpdate();
        }
        WarningNetworkHandler.broadcastRadarPolygons(wallRadarPos, polygons);
    }

    public static void registerRadarImmediate(BlockPos radarPos, ServerLevel level) {
        String dimensionKey = level.dimension().location().toString();
        activeRadars.put(radarPos, dimensionKey);
        if (WarningSystem.isWallRadarBlock(level, radarPos)) {
            WarningSystem.syncWallRadarPolygons(level, radarPos);
        } else {
            WarningSystem.syncRadarPolygons(level, radarPos);
        }
    }

    private static void forcePolygonSyncAllRadars(Iterable<ServerLevel> levels) {
        for (Map.Entry<BlockPos, String> entry : activeRadars.entrySet()) {
            BlockPos radarPos = entry.getKey();
            List<AlertPolygon> polygons = WarningSystem.getPolygonsForRadar(radarPos);
            BlockPos overlayPos = radarPos.above();
            AlertPolygonManager.clearPolygons(radarPos);
            AlertPolygonManager.clearPolygons(overlayPos);
            for (AlertPolygon poly : polygons) {
                AlertPolygonManager.addPolygon(radarPos, poly);
                AlertPolygonManager.addPolygon(overlayPos, poly);
            }
            WarningNetworkHandler.broadcastRadarPolygons(radarPos, polygons);
            if (!WarningConfig.isDebugMode()) continue;
            WXMCDebugLogger.debug("[WARNING-SYSTEM] Force synced {} polygon(s) for radar at {}", polygons.size(), radarPos);
        }
    }

    public static void refreshWarningForStorm(TrackedStorm storm, ServerLevel level) {
        if (storm == null || storm.getCurrentWarningLevel() == WarningLevel.NONE) {
            WXMCDebugLogger.debug("[REFRESH] Cannot refresh - storm null or no warning level");
            return;
        }
        String warningId = storm.getClientWarningId();
        WXMCDebugLogger.debug("[REFRESH] Refreshing warning for storm {} with warningId: '{}'", storm.getId(), warningId);
        if (warningId == null || warningId.isEmpty()) {
            WXMCDebugLogger.debug("[REFRESH] Cannot refresh warning for storm {} - no warningId stored", storm.getId());
            return;
        }
        long worldTime = level.getDayTime() % 24000L;
        long worldDay = level.getDayTime() / 24000L;
        String updatedTemplate = WarningGenerator.getFilledTemplate(storm, storm.getCurrentWarningLevel(), worldTime, worldDay);
        double warningRadius = ((Integer)WarningConfig.WARNING_RADIUS.get()).intValue();
        int playersSent = 0;
        for (ServerPlayer player : new ArrayList(level.players())) {
            double distance = player.position().distanceTo(storm.getPosition());
            if (!(distance <= warningRadius)) continue;
            WarningNetworkHandler.sendWarningTemplateUpdate(player, warningId, updatedTemplate);
            ++playersSent;
            WXMCDebugLogger.debug("[REFRESH] Sent template update to player {} for warning {}", player.getName().getString(), warningId);
        }
        if (playersSent == 0) {
            WXMCDebugLogger.debug("[REFRESH] No players in range ({} blocks) for storm {} template update", warningRadius, storm.getId());
        }
    }

    private static void checkForTornadoSpawnEvents(StormTracker tracker, Iterable<ServerLevel> levels) {
        for (TrackedStorm storm : tracker.getTrackedStorms()) {
            ServerLevel stormLevel;
            long stormId = storm.getId();
            int currentStage = storm.getStage();
            int previousStage = previousStormStages.getOrDefault(stormId, 0);
            if (currentStage >= 3) {
                stormDissipateData.put(stormId, new StormDissipateData(storm.getMaxWindspeed(), storm.getTornadoOnGroundTicks(), storm.getDimensionKey()));
            }
            if (currentStage >= 3 && previousStage < 3 && (stormLevel = WarningSystem.findLevelForDimension(levels, storm.getDimensionKey())) != null) {
                BukkitEventBridge.fireTornadoSpawned((Level)stormLevel, stormId, storm.getPosition().x, storm.getPosition().z, storm.getMaxWindspeed());
                WXMCDebugLogger.debug("[BQ] Tornado spawned event fired for storm {}", stormId);
            }
            previousStormStages.put(stormId, currentStage);
        }
    }

    private static void fireTornadoDissipateEvents(Set<Long> clearedStormIds, Iterable<ServerLevel> levels) {
        for (Long stormId : clearedStormIds) {
            ServerLevel stormLevel;
            StormDissipateData data = stormDissipateData.remove(stormId);
            previousStormStages.remove(stormId);
            if (data == null || (stormLevel = WarningSystem.findLevelForDimension(levels, data.dimensionKey())) == null) continue;
            BukkitEventBridge.fireTornadoDissipated((Level)stormLevel, stormId, data.peakWindspeed(), data.durationTicks());
            WXMCDebugLogger.debug("[BQ] Tornado dissipated event fired for storm {}", stormId);
        }
    }

    private static ServerLevel findLevelForDimension(Iterable<ServerLevel> levels, String dimensionKey) {
        if (dimensionKey == null) {
            return null;
        }
        for (ServerLevel level : levels) {
            if (!level.dimension().location().toString().equals(dimensionKey)) continue;
            return level;
        }
        return null;
    }

    private static void checkPlayersInWarnings(Iterable<ServerLevel> levels) {
        if (activeWarnings.isEmpty()) {
            playerWarningStates.clear();
            return;
        }
        for (ServerLevel level : levels) {
            for (ServerPlayer player : new ArrayList(level.players())) {
                UUID playerUUID = player.getUUID();
                Vec3 playerPos = player.position();
                HashSet<Long> currentlyInside = new HashSet<Long>();
                for (IssuedWarning warning : activeWarnings.values()) {
                    if (!warning.containsPosition(playerPos)) continue;
                    currentlyInside.add(warning.getWarningId());
                }
                Set previouslyInside = playerWarningStates.getOrDefault(playerUUID, Collections.emptySet());
                for (Long warningId : currentlyInside) {
                    IssuedWarning warning;
                    if (previouslyInside.contains(warningId) || (warning = activeWarnings.get(warningId)) == null) continue;
                    String warningType = warning.getLevel().isTornadoWarning() ? "TOR" : "SVR";
                    long stormId = warning.getStormId();
                    WXMCDebugLogger.debug("[BQ] Player {} entered {} warning (storm {})", player.getName().getString(), warningType, stormId);
                    BukkitEventBridge.firePlayerEnteredWarning(player, warningType, stormId);
                }
                if (currentlyInside.isEmpty()) {
                    playerWarningStates.remove(playerUUID);
                    continue;
                }
                playerWarningStates.put(playerUUID, currentlyInside);
            }
        }
        HashSet<UUID> onlinePlayerUUIDs = new HashSet<UUID>();
        for (ServerLevel level : levels) {
            for (ServerPlayer player : new ArrayList(level.players())) {
                onlinePlayerUUIDs.add(player.getUUID());
            }
        }
        playerWarningStates.keySet().removeIf(uuid -> !onlinePlayerUUIDs.contains(uuid));
    }

    private record PendingSync(ServerLevel level, int retryCount) {
    }

    private record StormDissipateData(int peakWindspeed, int durationTicks, String dimensionKey) {
    }
}

