/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.warnings;

public enum WarningLevel {
    NONE(0, "None", 0xFFFFFF),
    STATEMENT(1, "Special Weather Statement", 16770229),
    SVR_WARNING(2, "Severe Thunderstorm Warning", 16753920),
    SVR_PDS(3, "Severe Thunderstorm Warning - PDS", 16753920),
    SVR_DESTRUCTIVE(4, "Severe Thunderstorm Warning - Destructive", 16753920),
    TOR_INDICATED(5, "Tornado Warning - Radar Indicated", 0xFF0000),
    TOR_CONFIRMED(6, "Tornado Warning - Confirmed", 0xFF0000),
    TOR_PDS(7, "Tornado Warning - PDS", 0xFF0000),
    TOR_EMERGENCY(8, "Tornado Emergency", 0xFF0000);

    private final int priority;
    private final String displayName;
    private final int color;

    private WarningLevel(int priority, String displayName, int color) {
        this.priority = priority;
        this.displayName = displayName;
        this.color = color;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getColor() {
        return this.color;
    }

    public int getRed() {
        return this.color >> 16 & 0xFF;
    }

    public int getGreen() {
        return this.color >> 8 & 0xFF;
    }

    public int getBlue() {
        return this.color & 0xFF;
    }

    public boolean isTornadoWarning() {
        return this == TOR_INDICATED || this == TOR_CONFIRMED || this == TOR_PDS || this == TOR_EMERGENCY;
    }

    public boolean isSevereThunderstormWarning() {
        return this == SVR_WARNING || this == SVR_PDS || this == SVR_DESTRUCTIVE;
    }

    public boolean isPDS() {
        return this == SVR_PDS || this == TOR_PDS;
    }

    public boolean isHigherThan(WarningLevel other) {
        return this.priority > other.priority;
    }

    public String getShortCode() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "";
            case 1 -> "SPS";
            case 2 -> "SVR";
            case 3 -> "SVR-PDS";
            case 4 -> "SVR-DSW";
            case 5 -> "TOR";
            case 6 -> "TOR";
            case 7 -> "TOR-PDS";
            case 8 -> "TOR-E";
        };
    }
}

