/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.warnings;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.wxmc.weatheraddon.sounding.ServerSoundingManager;
import dev.wxmc.weatheraddon.util.PermissionHelper;
import dev.wxmc.weatheraddon.warnings.StormTracker;
import dev.wxmc.weatheraddon.warnings.TrackedStorm;
import dev.wxmc.weatheraddon.warnings.WarningGenerator;
import dev.wxmc.weatheraddon.warnings.WarningLevel;
import dev.wxmc.weatheraddon.warnings.WarningSystem;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;

public class WarningCommand {
    private static final SuggestionProvider<CommandSourceStack> RISK_SUGGESTIONS = (context, builder) -> SharedSuggestionProvider.suggest(Arrays.stream(ServerSoundingManager.RiskCategory.values()).map(ServerSoundingManager.RiskCategory::getFolderName), (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"wxmc").requires(source -> PermissionHelper.hasPermission(source, "wxmc.admin"))).executes(context -> WarningCommand.showStatus((CommandContext<CommandSourceStack>)context))).then(Commands.literal((String)"storms").executes(context -> WarningCommand.listStorms((CommandContext<CommandSourceStack>)context)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"changerisk").executes(context -> WarningCommand.showRiskStatus((CommandContext<CommandSourceStack>)context))).then(Commands.argument((String)"risk", (ArgumentType)StringArgumentType.word()).suggests(RISK_SUGGESTIONS).executes(context -> WarningCommand.setRiskOverride((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"risk"))))).then(Commands.literal((String)"clear").executes(context -> WarningCommand.clearRiskOverride((CommandContext<CommandSourceStack>)context))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"cr").executes(context -> WarningCommand.showRiskStatus((CommandContext<CommandSourceStack>)context))).then(Commands.argument((String)"risk", (ArgumentType)StringArgumentType.word()).suggests(RISK_SUGGESTIONS).executes(context -> WarningCommand.setRiskOverride((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"risk"))))).then(Commands.literal((String)"clear").executes(context -> WarningCommand.clearRiskOverride((CommandContext<CommandSourceStack>)context)))));
    }

    private static int showStatus(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String status = WarningSystem.getStatusSummary();
        for (String line : status.split("\n")) {
            source.sendSuccess(() -> Component.literal((String)line), false);
        }
        return 1;
    }

    private static int listStorms(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        StormTracker tracker = StormTracker.getInstance();
        if (!tracker.isPMWeatherAvailable()) {
            source.sendFailure((Component)Component.literal((String)"\u00a7cPMWeather not available"));
            return 0;
        }
        Collection<TrackedStorm> storms = tracker.getTrackedStorms();
        source.sendSuccess(() -> Component.literal((String)("\u00a76=== Tracked Storms (" + storms.size() + ") ===")), false);
        for (TrackedStorm storm : storms) {
            float peakDBZ = WarningGenerator.calculatePeakDBZ(storm);
            WarningLevel level = WarningGenerator.calculateWarningLevel(storm);
            String info = String.format("\u00a7eStorm %d: \u00a7f%s stage %d, energy %d, maxStage %d", storm.getId(), storm.getStormTypeName(), storm.getStage(), storm.getEnergy(), storm.getMaxStage());
            source.sendSuccess(() -> Component.literal((String)info), false);
            String dbzInfo = String.format("  \u00a77Peak dBZ: \u00a7f%.0f \u00a77\u2192 \u00a7%s%s", Float.valueOf(peakDBZ), Character.valueOf(WarningCommand.getColorCode(level)), level == WarningLevel.NONE ? "No Warning" : level.getDisplayName());
            source.sendSuccess(() -> Component.literal((String)dbzInfo), false);
            String occlusionStatus = storm.isCycling() ? "\u00a7c\u00a7lOCCLUDING" : "\u00a7aNormal";
            String occlusionInfo = String.format("  \u00a77Occlusion: \u00a7f%.0f%% \u00a77(%s\u00a77)", Float.valueOf(storm.getOcclusion() * 100.0f), occlusionStatus);
            source.sendSuccess(() -> Component.literal((String)occlusionInfo), false);
            if (storm.getStage() < 3) continue;
            String torInfo = String.format("  \u00a7cTornado: %d mph, width %.0f, ground %ds", storm.getWindspeed(), Float.valueOf(storm.getWidth()), storm.getTornadoOnGroundSeconds());
            source.sendSuccess(() -> Component.literal((String)torInfo), false);
        }
        if (storms.isEmpty()) {
            source.sendSuccess(() -> Component.literal((String)"\u00a77No storms currently tracked"), false);
        }
        return 1;
    }

    private static char getColorCode(WarningLevel level) {
        return switch (level) {
            case WarningLevel.TOR_EMERGENCY -> '5';
            case WarningLevel.TOR_PDS -> 'd';
            case WarningLevel.TOR_CONFIRMED, WarningLevel.TOR_INDICATED -> 'c';
            case WarningLevel.SVR_PDS, WarningLevel.SVR_DESTRUCTIVE -> '6';
            case WarningLevel.SVR_WARNING -> 'e';
            case WarningLevel.STATEMENT -> '7';
            default -> 'f';
        };
    }

    private static int showRiskStatus(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerSoundingManager.RiskCategory override = ServerSoundingManager.getRiskOverride();
        ServerSoundingManager.RiskCategory current = ServerSoundingManager.getCurrentRisk();
        source.sendSuccess(() -> Component.literal((String)"\u00a76=== Risk Status ==="), false);
        if (override != null) {
            source.sendSuccess(() -> Component.literal((String)("\u00a7eOverride Active: \u00a7c" + override.getFolderName())), false);
            source.sendSuccess(() -> Component.literal((String)"\u00a77(PMWeather risk calculation bypassed)"), false);
        } else {
            source.sendSuccess(() -> Component.literal((String)"\u00a7eOverride: \u00a7aNone \u00a77(using PMWeather calculation)"), false);
        }
        if (current != null) {
            source.sendSuccess(() -> Component.literal((String)("\u00a7eCurrent Risk: \u00a7f" + current.getFolderName())), false);
        }
        source.sendSuccess(() -> Component.literal((String)""), false);
        source.sendSuccess(() -> Component.literal((String)"\u00a77Usage: /wxmc changerisk <TSTM|MRGL|SLGT|ENH|MDT|HIGH>"), false);
        source.sendSuccess(() -> Component.literal((String)"\u00a77       /wxmc changerisk clear"), false);
        return 1;
    }

    private static int setRiskOverride(CommandContext<CommandSourceStack> context, String riskName) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (riskName.equalsIgnoreCase("clear")) {
            return WarningCommand.clearRiskOverride(context);
        }
        ServerSoundingManager.RiskCategory risk = null;
        for (ServerSoundingManager.RiskCategory cat : ServerSoundingManager.RiskCategory.values()) {
            if (!cat.getFolderName().equalsIgnoreCase(riskName)) continue;
            risk = cat;
            break;
        }
        if (risk == null) {
            source.sendFailure((Component)Component.literal((String)("\u00a7cUnknown risk category: " + riskName)));
            source.sendFailure((Component)Component.literal((String)"\u00a7cValid options: TSTM, MRGL, SLGT, ENH, MDT, HIGH"));
            return 0;
        }
        ServerSoundingManager.setRiskOverride(risk);
        ServerSoundingManager.RiskCategory finalRisk = risk;
        source.sendSuccess(() -> Component.literal((String)("\u00a7aRisk override set to: \u00a7e" + finalRisk.getFolderName())), true);
        source.sendSuccess(() -> Component.literal((String)"\u00a77Sounding data and storm generation will now match this risk level."), false);
        source.sendSuccess(() -> Component.literal((String)"\u00a77Use \u00a7f/wxmc changerisk clear \u00a77to revert to PMWeather calculation."), false);
        return 1;
    }

    private static int clearRiskOverride(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (!ServerSoundingManager.hasRiskOverride()) {
            source.sendSuccess(() -> Component.literal((String)"\u00a77No risk override is currently active."), false);
            return 1;
        }
        ServerSoundingManager.clearRiskOverride();
        source.sendSuccess(() -> Component.literal((String)"\u00a7aRisk override cleared."), true);
        source.sendSuccess(() -> Component.literal((String)"\u00a77Now using PMWeather's atmospheric calculation for risk."), false);
        return 1;
    }
}

