/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.warnings;

import dev.wxmc.weatheraddon.warnings.WarningLevel;
import net.minecraft.world.phys.Vec3;

public class TrackedStorm {
    private final long id;
    private int stormType;
    private int stage;
    private int maxStage;
    private int energy;
    private int windspeed;
    private int maxWindspeed;
    private float width;
    private Vec3 position;
    private Vec3 velocity;
    private int tornadoOnGroundTicks;
    private boolean isDying;
    private float occlusion;
    private WarningLevel currentWarningLevel = WarningLevel.NONE;
    private WarningLevel previousWarningLevel = WarningLevel.NONE;
    private long lastWarningTime = 0L;
    private long lastUpdateTime = 0L;
    private boolean hasBeenWarned = false;
    private boolean spotterConfirmed = false;
    private boolean spotterReportedHail = false;
    private boolean spotterReportedWind = false;
    private String clientWarningId = null;
    private String dimensionKey = null;
    private static final float PMWEATHER_STORM_SIZE = 300.0f;

    public TrackedStorm(long id) {
        this.id = id;
        this.position = Vec3.ZERO;
        this.velocity = Vec3.ZERO;
    }

    public long getId() {
        return this.id;
    }

    public int getStormType() {
        return this.stormType;
    }

    public int getStage() {
        return this.stage;
    }

    public int getMaxStage() {
        return this.maxStage;
    }

    public int getEnergy() {
        return this.energy;
    }

    public int getWindspeed() {
        return this.windspeed;
    }

    public int getMaxWindspeed() {
        return this.maxWindspeed;
    }

    public float getWidth() {
        return this.width;
    }

    public Vec3 getPosition() {
        return this.position;
    }

    public Vec3 getVelocity() {
        return this.velocity;
    }

    public int getTornadoOnGroundTicks() {
        return this.tornadoOnGroundTicks;
    }

    public boolean isDying() {
        return this.isDying;
    }

    public float getOcclusion() {
        return this.occlusion;
    }

    public WarningLevel getCurrentWarningLevel() {
        return this.currentWarningLevel;
    }

    public WarningLevel getPreviousWarningLevel() {
        return this.previousWarningLevel;
    }

    public long getLastWarningTime() {
        return this.lastWarningTime;
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public boolean hasBeenWarned() {
        return this.hasBeenWarned;
    }

    public boolean isSpotterConfirmed() {
        return this.spotterConfirmed;
    }

    public boolean isSpotterReportedHail() {
        return this.spotterReportedHail;
    }

    public boolean isSpotterReportedWind() {
        return this.spotterReportedWind;
    }

    public String getClientWarningId() {
        return this.clientWarningId;
    }

    public String getDimensionKey() {
        return this.dimensionKey;
    }

    public void setStormType(int stormType) {
        this.stormType = stormType;
    }

    public void setStage(int stage) {
        this.stage = stage;
    }

    public void setMaxStage(int maxStage) {
        this.maxStage = maxStage;
    }

    public void setEnergy(int energy) {
        this.energy = energy;
    }

    public void setWindspeed(int windspeed) {
        this.windspeed = windspeed;
    }

    public void setMaxWindspeed(int maxWindspeed) {
        this.maxWindspeed = maxWindspeed;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public void setPosition(Vec3 position) {
        this.position = position;
    }

    public void setVelocity(Vec3 velocity) {
        this.velocity = velocity;
    }

    public void setTornadoOnGroundTicks(int tornadoOnGroundTicks) {
        this.tornadoOnGroundTicks = tornadoOnGroundTicks;
    }

    public void setDying(boolean dying) {
        this.isDying = dying;
    }

    public void setOcclusion(float occlusion) {
        this.occlusion = occlusion;
    }

    public void setCurrentWarningLevel(WarningLevel level) {
        this.previousWarningLevel = this.currentWarningLevel;
        this.currentWarningLevel = level;
    }

    public void setLastWarningTime(long time) {
        this.lastWarningTime = time;
        this.hasBeenWarned = true;
    }

    public void setLastUpdateTime(long time) {
        this.lastUpdateTime = time;
    }

    public void setSpotterConfirmed(boolean spotterConfirmed) {
        this.spotterConfirmed = spotterConfirmed;
    }

    public void setSpotterReportedHail(boolean spotterReportedHail) {
        this.spotterReportedHail = spotterReportedHail;
    }

    public void setSpotterReportedWind(boolean spotterReportedWind) {
        this.spotterReportedWind = spotterReportedWind;
    }

    public void setClientWarningId(String clientWarningId) {
        this.clientWarningId = clientWarningId;
    }

    public void setDimensionKey(String dimensionKey) {
        this.dimensionKey = dimensionKey;
    }

    public boolean isSupercell() {
        return this.stormType == 0;
    }

    public boolean isSquallLine() {
        return this.stormType == 1;
    }

    public boolean isCyclone() {
        return this.stormType == 2;
    }

    public boolean hasTornadoOnGround() {
        return this.stormType == 0 && this.stage >= 3 && this.tornadoOnGroundTicks > 0;
    }

    public boolean canProduceTornado() {
        return this.stormType == 0 && this.maxStage >= 3;
    }

    public boolean hasWarningUpgraded() {
        return this.currentWarningLevel.isHigherThan(this.previousWarningLevel);
    }

    public boolean isLongTrack() {
        return this.tornadoOnGroundTicks > 600;
    }

    public boolean isWideTornado() {
        return this.width > 100.0f;
    }

    public boolean isExtremelyWideTornado() {
        return this.width > 200.0f;
    }

    public boolean isCycling() {
        return this.occlusion > 0.7f;
    }

    public boolean isNearPeakIntensity() {
        return this.maxWindspeed > 0 && (double)this.windspeed > (double)this.maxWindspeed * 0.9 && !this.isDying;
    }

    public float getMovementDirection() {
        if (this.velocity.x == 0.0 && this.velocity.z == 0.0) {
            return 0.0f;
        }
        return (float)Math.toDegrees(Math.atan2(this.velocity.x, -this.velocity.z));
    }

    public Vec3 getCorePosition() {
        float intensity = this.calculatePMWeatherIntensity();
        if (this.stormType == 0) {
            float stormSize = 900.0f;
            float scale = stormSize / 1200.0f;
            double coreOffsetX = 100.0 * (double)scale * 2.5 * (double)intensity;
            double coreOffsetZ = -350.0 * (double)scale * 2.5 * (double)intensity;
            return new Vec3(this.position.x + coreOffsetX, this.position.y, this.position.z + coreOffsetZ);
        }
        if (this.stormType == 1) {
            float stormSize = 600.0f;
            float scale = stormSize / 1200.0f;
            double forwardOffset = 200.0 * (double)scale * (double)intensity;
            double speed = this.velocity.horizontalDistance();
            if (speed < 0.001) {
                return this.position;
            }
            double dirX = this.velocity.x / speed;
            double dirZ = this.velocity.z / speed;
            return new Vec3(this.position.x + dirX * forwardOffset, this.position.y, this.position.z + dirZ * forwardOffset);
        }
        return this.position;
    }

    private float calculatePMWeatherIntensity() {
        float intensity = switch (this.stage) {
            case 1 -> 0.1f + (float)this.energy / 100.0f * 0.7f;
            case 2 -> 0.8f + (float)this.energy / 100.0f * 0.4f;
            case 3 -> 1.2f + (float)this.windspeed / 100.0f;
            default -> (float)Math.pow((float)this.energy / 100.0f, 2.0) * 0.1f;
        };
        if (intensity > 0.8f) {
            intensity = 0.8f + (intensity - 0.8f) / 4.0f;
        }
        return Math.max(0.0f, Math.min(1.0f, intensity * 1.5f));
    }

    public float getCoreIntensityFactor() {
        return this.calculatePMWeatherIntensity();
    }

    public int getMovementSpeedBlocksPerMCHour() {
        double horizontalSpeed = this.velocity.horizontalDistance();
        return (int)(horizontalSpeed * 1000.0);
    }

    public int getMovementSpeedMPH() {
        double horizontalSpeed = this.velocity.horizontalDistance();
        return (int)(horizontalSpeed * 20.0 * 2.23694);
    }

    public float getMovementSpeedBlocksPerSec() {
        return (float)(this.velocity.horizontalDistance() * 20.0);
    }

    public Vec3 getRawVelocity() {
        return this.velocity;
    }

    public float getMovementSpeed() {
        return this.getMovementSpeedBlocksPerMCHour();
    }

    public String getMovementDirectionString() {
        float dir = this.getMovementDirection();
        if (dir < 0.0f) {
            dir += 360.0f;
        }
        if ((double)dir >= 337.5 || (double)dir < 22.5) {
            return "north";
        }
        if ((double)dir >= 22.5 && (double)dir < 67.5) {
            return "northeast";
        }
        if ((double)dir >= 67.5 && (double)dir < 112.5) {
            return "east";
        }
        if ((double)dir >= 112.5 && (double)dir < 157.5) {
            return "southeast";
        }
        if ((double)dir >= 157.5 && (double)dir < 202.5) {
            return "south";
        }
        if ((double)dir >= 202.5 && (double)dir < 247.5) {
            return "southwest";
        }
        if ((double)dir >= 247.5 && (double)dir < 292.5) {
            return "west";
        }
        return "northwest";
    }

    public int getTornadoOnGroundSeconds() {
        return this.tornadoOnGroundTicks / 20;
    }

    public String getStormTypeName() {
        return switch (this.stormType) {
            case 0 -> "Supercell";
            case 1 -> "Squall Line";
            case 2 -> "Tropical Cyclone";
            default -> "Unknown";
        };
    }

    public void updateData(int stormType, int stage, int maxStage, int energy, int windspeed, int maxWindspeed, float width, Vec3 position, Vec3 velocity, int tornadoOnGroundTicks, boolean isDying, float occlusion) {
        this.stormType = stormType;
        this.stage = stage;
        this.maxStage = maxStage;
        this.energy = energy;
        this.windspeed = windspeed;
        this.maxWindspeed = maxWindspeed;
        this.width = width;
        this.position = position;
        this.velocity = velocity;
        this.tornadoOnGroundTicks = tornadoOnGroundTicks;
        this.isDying = isDying;
        this.occlusion = occlusion;
        this.lastUpdateTime = System.currentTimeMillis();
    }

    public String toString() {
        return String.format("TrackedStorm[id=%d, type=%s, stage=%d, windspeed=%d, warning=%s]", this.id, this.getStormTypeName(), this.stage, this.windspeed, this.currentWarningLevel.getShortCode());
    }
}

