/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.warnings;

public enum StormType {
    SUPERCELL(0, "Supercell"),
    SQUALL_LINE(1, "Squall Line"),
    CYCLONE(2, "Cyclone");

    private final int id;
    private final String displayName;

    private StormType(int id, String displayName) {
        this.id = id;
        this.displayName = displayName;
    }

    public int getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static StormType fromId(int id) {
        return switch (id) {
            case 0 -> SUPERCELL;
            case 1 -> SQUALL_LINE;
            default -> CYCLONE;
        };
    }

    public boolean isSupercell() {
        return this == SUPERCELL;
    }

    public boolean isSquallLine() {
        return this == SQUALL_LINE;
    }

    public boolean usesTrapezoidShape() {
        return this == SUPERCELL;
    }

    public boolean usesRectangleShape() {
        return this == SQUALL_LINE;
    }

    public float getRadarHalfWidth(int stage) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (stage >= 3) {
                    yield 0.15f;
                }
                yield 0.25f;
            }
            case 1 -> 0.4f;
            case 2 -> 0.25f;
        };
    }

    public float getRadarHalfHeight(int stage) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (stage >= 3) {
                    yield 0.1f;
                }
                yield 0.2f;
            }
            case 1 -> 0.15f;
            case 2 -> 0.2f;
        };
    }

    public float getRadarRotation(float movementAngle) {
        if (this == SQUALL_LINE) {
            return (movementAngle + 90.0f) % 360.0f;
        }
        return movementAngle;
    }
}

