/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.warnings;

import dev.wxmc.weatheraddon.WXMCWeatherAddon;
import dev.wxmc.weatheraddon.util.WXMCDebugLogger;
import dev.wxmc.weatheraddon.warnings.TrackedStorm;
import dev.wxmc.weatheraddon.warnings.WarningConfig;
import dev.wxmc.weatheraddon.warnings.WarningLevel;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.Vec3;

public class StormTracker {
    private Class<?> gameBusEventsClass;
    private Class<?> weatherHandlerClass;
    private Class<?> stormClass;
    private Field managersField;
    private Method getStormsMethod;
    private Field stormIdField;
    private Field stormTypeField;
    private Field stageField;
    private Field maxStageField;
    private Field energyField;
    private Field windspeedField;
    private Field maxWindspeedField;
    private Field widthField;
    private Field positionField;
    private Field velocityField;
    private Field tornadoOnGroundTicksField;
    private Field deadField;
    private Field dyingField;
    private Field occlusionField;
    private boolean reflectionInitialized = false;
    private boolean pmWeatherAvailable = false;
    private final Map<Long, TrackedStorm> trackedStorms = new ConcurrentHashMap<Long, TrackedStorm>();
    private final Set<Long> currentCycleStormIds = new HashSet<Long>();
    private final Set<Long> warnedStorms = ConcurrentHashMap.newKeySet();

    private StormTracker() {
        this.initializeReflection();
    }

    public static StormTracker getInstance() {
        return Holder.INSTANCE;
    }

    private void initializeReflection() {
        if (this.reflectionInitialized) {
            return;
        }
        this.reflectionInitialized = true;
        try {
            this.gameBusEventsClass = this.findClass("dev.protomanly.pmweather.event.GameBusEvents");
            this.weatherHandlerClass = this.findClass("dev.protomanly.pmweather.weather.WeatherHandler");
            this.stormClass = this.findClass("dev.protomanly.pmweather.weather.Storm");
            if (this.gameBusEventsClass == null || this.weatherHandlerClass == null || this.stormClass == null) {
                throw new ClassNotFoundException("PMWeather classes not found in any classloader");
            }
            this.managersField = this.gameBusEventsClass.getField("MANAGERS");
            this.getStormsMethod = this.weatherHandlerClass.getMethod("getStorms", new Class[0]);
            this.stormIdField = this.getFieldSafe(this.stormClass, "ID");
            this.stormTypeField = this.getFieldSafe(this.stormClass, "stormType");
            this.stageField = this.getFieldSafe(this.stormClass, "stage");
            this.maxStageField = this.getFieldSafe(this.stormClass, "maxStage");
            this.energyField = this.getFieldSafe(this.stormClass, "energy");
            this.windspeedField = this.getFieldSafe(this.stormClass, "windspeed");
            this.maxWindspeedField = this.getFieldSafe(this.stormClass, "maxWindspeed");
            this.widthField = this.getFieldSafe(this.stormClass, "width");
            this.positionField = this.getFieldSafe(this.stormClass, "position");
            this.velocityField = this.getFieldSafe(this.stormClass, "velocity");
            this.tornadoOnGroundTicksField = this.getFieldSafe(this.stormClass, "tornadoOnGroundTicks");
            this.deadField = this.getFieldSafe(this.stormClass, "dead");
            this.dyingField = this.getFieldSafe(this.stormClass, "dying");
            this.occlusionField = this.getFieldSafe(this.stormClass, "occlusion");
            this.pmWeatherAvailable = true;
            WXMCWeatherAddon.LOGGER.info("StormTracker: PMWeather reflection initialized successfully");
        }
        catch (ClassNotFoundException e) {
            WXMCWeatherAddon.LOGGER.warn("StormTracker: PMWeather mod not found - warning system disabled");
            this.pmWeatherAvailable = false;
        }
        catch (Exception e) {
            WXMCWeatherAddon.LOGGER.error("StormTracker: Failed to initialize reflection: {}", (Object)e.getMessage());
            this.pmWeatherAvailable = false;
        }
    }

    private Class<?> findClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
                if (contextCL != null) {
                    return Class.forName(className, true, contextCL);
                }
            }
            catch (ClassNotFoundException contextCL) {
                // empty catch block
            }
            try {
                return Class.forName(className, true, StormTracker.class.getClassLoader());
            }
            catch (ClassNotFoundException contextCL) {
                try {
                    ClassLoader systemCL = ClassLoader.getSystemClassLoader();
                    if (systemCL != null) {
                        return Class.forName(className, true, systemCL);
                    }
                }
                catch (ClassNotFoundException systemCL) {
                    // empty catch block
                }
                try {
                    Class<?> launchClass = Class.forName("cpw.mods.modlauncher.Launcher");
                    Object launcher = launchClass.getMethod("INSTANCE", new Class[0]).invoke(null, new Object[0]);
                    if (launcher != null) {
                        ClassLoader launchCL = launcher.getClass().getClassLoader();
                        return Class.forName(className, true, launchCL);
                    }
                }
                catch (Exception launchClass) {
                    // empty catch block
                }
                try {
                    for (ClassLoader cl = StormTracker.class.getClassLoader(); cl != null; cl = cl.getParent()) {
                        try {
                            return Class.forName(className, true, cl);
                        }
                        catch (ClassNotFoundException classNotFoundException2) {
                            continue;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                WXMCWeatherAddon.LOGGER.debug("StormTracker: Could not find class {} in any classloader", (Object)className);
                return null;
            }
        }
    }

    private Field getFieldSafe(Class<?> clazz, String name) {
        try {
            Field field = clazz.getField(name);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            try {
                Field field = clazz.getDeclaredField(name);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException ex) {
                if (WarningConfig.isDebugMode()) {
                    WXMCWeatherAddon.LOGGER.warn("StormTracker: Field not found: {}", (Object)name);
                }
                return null;
            }
        }
    }

    public boolean isPMWeatherAvailable() {
        return this.pmWeatherAvailable;
    }

    public Class<?> getGameBusEventsClass() {
        return this.gameBusEventsClass;
    }

    public Class<?> getWeatherHandlerClass() {
        return this.weatherHandlerClass;
    }

    public Class<?> getStormClass() {
        return this.stormClass;
    }

    public Field getManagersField() {
        return this.managersField;
    }

    public Method getGetStormsMethod() {
        return this.getStormsMethod;
    }

    public Field getStormIdField() {
        return this.stormIdField;
    }

    public Field getStormTypeField() {
        return this.stormTypeField;
    }

    public Field getStageField() {
        return this.stageField;
    }

    public Field getWindspeedField() {
        return this.windspeedField;
    }

    public Field getPositionField() {
        return this.positionField;
    }

    public Field getVelocityField() {
        return this.velocityField;
    }

    public Field getTornadoOnGroundTicksField() {
        return this.tornadoOnGroundTicksField;
    }

    public Field getDeadField() {
        return this.deadField;
    }

    private Object getWeatherHandler(ServerLevel level) {
        if (!this.pmWeatherAvailable || this.managersField == null) {
            return null;
        }
        try {
            Map managers = (Map)this.managersField.get(null);
            return managers.get(level.dimension());
        }
        catch (Exception e) {
            if (WarningConfig.isDebugMode()) {
                WXMCWeatherAddon.LOGGER.debug("StormTracker: Failed to get weather handler: {}", (Object)e.getMessage());
            }
            return null;
        }
    }

    private List<?> getRawStorms(Object weatherHandler) {
        if (weatherHandler == null || this.getStormsMethod == null) {
            return Collections.emptyList();
        }
        try {
            return (List)this.getStormsMethod.invoke(weatherHandler, new Object[0]);
        }
        catch (Exception e) {
            if (WarningConfig.isDebugMode()) {
                WXMCWeatherAddon.LOGGER.debug("StormTracker: Failed to get storms: {}", (Object)e.getMessage());
            }
            return Collections.emptyList();
        }
    }

    public void beginUpdateCycle() {
        this.currentCycleStormIds.clear();
    }

    public Set<Long> endUpdateCycle() {
        HashSet<Long> removedStormIds = new HashSet<Long>();
        Iterator<Long> iter = this.trackedStorms.keySet().iterator();
        while (iter.hasNext()) {
            Long stormId = iter.next();
            if (this.currentCycleStormIds.contains(stormId)) continue;
            iter.remove();
            this.warnedStorms.remove(stormId);
            removedStormIds.add(stormId);
        }
        if (!removedStormIds.isEmpty() && WarningConfig.isDebugMode()) {
            WXMCDebugLogger.debug("[STORM-CLEAR] {} storm(s) no longer exist in PMWeather: {}", removedStormIds.size(), removedStormIds);
        }
        return removedStormIds;
    }

    public void updateFromLevel(ServerLevel level) {
        if (!this.pmWeatherAvailable) {
            return;
        }
        Object weatherHandler = this.getWeatherHandler(level);
        if (weatherHandler == null) {
            return;
        }
        List<?> rawStorms = this.getRawStorms(weatherHandler);
        if (WarningConfig.isDebugMode() && !rawStorms.isEmpty()) {
            WXMCDebugLogger.debug("[DEBUG] StormTracker: Found {} raw storms in {}", rawStorms.size(), level.dimension().location());
        }
        for (Object storm : rawStorms) {
            if (storm == null) continue;
            try {
                boolean isNew;
                TrackedStorm tracked = this.parseStorm(storm);
                if (tracked == null) continue;
                tracked.setDimensionKey(level.dimension().location().toString());
                this.currentCycleStormIds.add(tracked.getId());
                TrackedStorm existing = this.trackedStorms.get(tracked.getId());
                boolean bl = isNew = existing == null;
                if (existing != null) {
                    tracked.setCurrentWarningLevel(existing.getCurrentWarningLevel());
                    tracked.setSpotterConfirmed(existing.isSpotterConfirmed());
                    tracked.setSpotterReportedHail(existing.isSpotterReportedHail());
                    tracked.setSpotterReportedWind(existing.isSpotterReportedWind());
                    if (existing.getClientWarningId() != null) {
                        tracked.setClientWarningId(existing.getClientWarningId());
                    }
                }
                this.trackedStorms.put(tracked.getId(), tracked);
                if (!WarningConfig.isDebugMode() || !isNew) continue;
                WXMCDebugLogger.debug("[DEBUG] Storm #{}: type={} ({}) stage={}/{} energy={} wind={} width={} pos=({}, {})", tracked.getId(), tracked.getStormType(), tracked.getStormTypeName(), tracked.getStage(), tracked.getMaxStage(), tracked.getEnergy(), tracked.getWindspeed(), Float.valueOf(tracked.getWidth()), (int)tracked.getPosition().x, (int)tracked.getPosition().z);
            }
            catch (Exception e) {
                if (!WarningConfig.isDebugMode()) continue;
                WXMCWeatherAddon.LOGGER.debug("StormTracker: Error parsing storm: {}", (Object)e.getMessage());
            }
        }
    }

    private TrackedStorm parseStorm(Object storm) {
        try {
            long id = this.getLongField(storm, this.stormIdField, 0L);
            if (id == 0L) {
                return null;
            }
            boolean dead = this.getBooleanField(storm, this.deadField, false);
            if (dead) {
                return null;
            }
            TrackedStorm tracked = new TrackedStorm(id);
            tracked.setStormType(this.getIntField(storm, this.stormTypeField, 0));
            tracked.setStage(this.getIntField(storm, this.stageField, 1));
            tracked.setMaxStage(this.getIntField(storm, this.maxStageField, 1));
            tracked.setEnergy(this.getIntField(storm, this.energyField, 0));
            tracked.setWindspeed(this.getIntField(storm, this.windspeedField, 0));
            tracked.setMaxWindspeed(this.getIntField(storm, this.maxWindspeedField, 0));
            tracked.setWidth(this.getFloatField(storm, this.widthField, 0.0f));
            tracked.setPosition(this.getVec3Field(storm, this.positionField, Vec3.ZERO));
            tracked.setVelocity(this.getVec3Field(storm, this.velocityField, Vec3.ZERO));
            tracked.setTornadoOnGroundTicks(this.getIntField(storm, this.tornadoOnGroundTicksField, 0));
            tracked.setDying(this.getBooleanField(storm, this.dyingField, false));
            tracked.setOcclusion(this.getFloatField(storm, this.occlusionField, 0.0f));
            return tracked;
        }
        catch (Exception e) {
            if (WarningConfig.isDebugMode()) {
                WXMCWeatherAddon.LOGGER.debug("StormTracker: Error in parseStorm: {}", (Object)e.getMessage());
            }
            return null;
        }
    }

    private int getIntField(Object obj, Field field, int defaultValue) {
        if (field == null) {
            return defaultValue;
        }
        try {
            return field.getInt(obj);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private long getLongField(Object obj, Field field, long defaultValue) {
        if (field == null) {
            return defaultValue;
        }
        try {
            return field.getLong(obj);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private float getFloatField(Object obj, Field field, float defaultValue) {
        if (field == null) {
            return defaultValue;
        }
        try {
            return field.getFloat(obj);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private boolean getBooleanField(Object obj, Field field, boolean defaultValue) {
        if (field == null) {
            return defaultValue;
        }
        try {
            return field.getBoolean(obj);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private Vec3 getVec3Field(Object obj, Field field, Vec3 defaultValue) {
        if (field == null) {
            return defaultValue;
        }
        try {
            Object value = field.get(obj);
            if (value instanceof Vec3) {
                return (Vec3)value;
            }
            return defaultValue;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public Collection<TrackedStorm> getTrackedStorms() {
        return Collections.unmodifiableCollection(this.trackedStorms.values());
    }

    public TrackedStorm getStorm(long id) {
        return this.trackedStorms.get(id);
    }

    public List<TrackedStorm> getSupercells() {
        return this.trackedStorms.values().stream().filter(TrackedStorm::isSupercell).toList();
    }

    public List<TrackedStorm> getTornadoStorms() {
        ArrayList<TrackedStorm> result = new ArrayList<TrackedStorm>();
        for (TrackedStorm storm : this.trackedStorms.values()) {
            if (!storm.hasTornadoOnGround()) continue;
            result.add(storm);
        }
        return result;
    }

    public List<TrackedStorm> getStormsWithinRadius(Vec3 position, double radius) {
        double radiusSq = radius * radius;
        return this.trackedStorms.values().stream().filter(storm -> storm.getPosition().distanceToSqr(position) <= radiusSq).toList();
    }

    public int getStormCount() {
        return this.trackedStorms.size();
    }

    public void clearStorms() {
        this.trackedStorms.clear();
        this.warnedStorms.clear();
        this.currentCycleStormIds.clear();
    }

    public void updateStormWarningLevel(long stormId, WarningLevel level) {
        TrackedStorm storm = this.trackedStorms.get(stormId);
        if (storm != null) {
            storm.setCurrentWarningLevel(level);
        }
    }

    public void markStormWarned(long stormId) {
        this.warnedStorms.add(stormId);
    }

    public boolean hasBeenWarned(long stormId) {
        return this.warnedStorms.contains(stormId);
    }

    private static class Holder {
        private static final StormTracker INSTANCE = new StormTracker();

        private Holder() {
        }
    }
}

