/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.warnings;

import dev.wxmc.weatheraddon.Config;
import dev.wxmc.weatheraddon.util.WXMCDebugLogger;
import dev.wxmc.weatheraddon.warnings.AlertPolygon;
import dev.wxmc.weatheraddon.warnings.StormType;
import dev.wxmc.weatheraddon.warnings.TrackedStorm;
import dev.wxmc.weatheraddon.warnings.WarningConfig;
import dev.wxmc.weatheraddon.warnings.WarningLevel;
import net.minecraft.world.phys.Vec3;

public class IssuedWarning {
    private static long nextWarningId = 1L;
    private final long warningId = nextWarningId++;
    private final long stormId;
    private WarningLevel level;
    private Vec3 polygonCenter;
    private float polygonHalfWidth;
    private float polygonHalfHeight;
    private float polygonRotation;
    private final int stormType;
    private int stormStage;
    private final long creationTime;
    private final long creationGameTime;
    private long expirationGameTime;
    private boolean stormHasLeft;
    private float lastStormWidth;
    private long lastSizeUpdateGameTime;
    private long belowCriteriaStartTime = -1L;
    public static final long SIZE_UPDATE_INTERVAL_TICKS = 250L;
    public static final long BELOW_CRITERIA_EXPIRATION_TICKS = 250L;
    public static final float PMWEATHER_STORM_SIZE = 300.0f;
    public static final float DEFAULT_REAR_BUFFER = 200.0f;
    public static final float DEFAULT_FRONT_BUFFER = 200.0f;
    public static final float DEFAULT_MIN_PROJECTION = 250.0f;
    public static final float DEFAULT_MAX_PROJECTION = 1200.0f;
    public static final float DEFAULT_WOBBLE_BUFFER = 80.0f;
    public static final float DOWNSTREAM_MINUTES = 30.0f;
    public static final float MAX_OCCLUSION_ROTATION_DEG = 20.0f;
    public static final long DEFAULT_DURATION_TICKS = 2000L;

    public static float getRearBuffer() {
        try {
            return ((Double)Config.POLYGON_REAR_BUFFER.get()).floatValue();
        }
        catch (Exception e) {
            return 200.0f;
        }
    }

    public static float getFrontBuffer() {
        try {
            return ((Double)Config.POLYGON_FRONT_BUFFER.get()).floatValue();
        }
        catch (Exception e) {
            return 200.0f;
        }
    }

    public static float getWobbleBuffer() {
        try {
            return ((Double)Config.POLYGON_WOBBLE_BUFFER.get()).floatValue();
        }
        catch (Exception e) {
            return 80.0f;
        }
    }

    public static float getMinProjection() {
        try {
            return ((Double)Config.POLYGON_MIN_PROJECTION.get()).floatValue();
        }
        catch (Exception e) {
            return 250.0f;
        }
    }

    public static float getMaxProjection() {
        try {
            return ((Double)Config.POLYGON_MAX_PROJECTION.get()).floatValue();
        }
        catch (Exception e) {
            return 1200.0f;
        }
    }

    private static float calculatePolygonHalfWidth(int stormTypeId) {
        float coreHalfWidth;
        StormType type = StormType.fromId(stormTypeId);
        if (type.isSupercell()) {
            float supercellFootprint = 900.0f;
            coreHalfWidth = supercellFootprint * 0.4f;
        } else if (type.isSquallLine()) {
            float squallFootprint = 600.0f;
            coreHalfWidth = squallFootprint * 0.6f;
        } else {
            coreHalfWidth = 180.0f;
        }
        return coreHalfWidth + IssuedWarning.getWobbleBuffer();
    }

    private static float[] calculatePolygonLength(Vec3 velocity) {
        float stormSpeedBlocksPerTick = (float)velocity.horizontalDistance();
        float stormSpeedBlocksPerMinute = stormSpeedBlocksPerTick * 16.67f;
        float projectionDistance = stormSpeedBlocksPerMinute * 30.0f;
        projectionDistance = Math.max(projectionDistance, IssuedWarning.getMinProjection());
        projectionDistance = Math.min(projectionDistance, IssuedWarning.getMaxProjection());
        float totalLength = IssuedWarning.getRearBuffer() + projectionDistance + IssuedWarning.getFrontBuffer();
        float halfH = totalLength / 2.0f;
        return new float[]{projectionDistance, totalLength, halfH};
    }

    private static Vec3 calculatePolygonCenter(Vec3 stormPos, Vec3 velocity, float projectionDistance) {
        if (velocity.horizontalDistance() > 0.01) {
            Vec3 motionDir = velocity.normalize();
            float offsetFromStorm = (projectionDistance + IssuedWarning.getFrontBuffer() - IssuedWarning.getRearBuffer()) / 2.0f;
            return stormPos.add(motionDir.x * (double)offsetFromStorm, 0.0, motionDir.z * (double)offsetFromStorm);
        }
        return stormPos;
    }

    public IssuedWarning(long stormId, WarningLevel level, Vec3 polygonCenter, float halfWidth, float halfHeight, float rotation, int stormType, int stormStage, long durationTicks, float stormWidth, long currentGameTime) {
        this.stormId = stormId;
        this.level = level;
        this.polygonCenter = polygonCenter;
        this.polygonHalfWidth = halfWidth;
        this.polygonHalfHeight = halfHeight;
        this.polygonRotation = rotation;
        this.stormType = stormType;
        this.stormStage = stormStage;
        this.creationTime = System.currentTimeMillis();
        this.creationGameTime = currentGameTime;
        this.expirationGameTime = currentGameTime + durationTicks;
        this.stormHasLeft = false;
        this.lastStormWidth = stormWidth;
        this.lastSizeUpdateGameTime = currentGameTime;
    }

    public static IssuedWarning fromStorm(TrackedStorm storm, WarningLevel level, long currentGameTime) {
        String anchorType;
        Vec3 stormPos;
        int type = storm.getStormType();
        int stage = storm.getStage();
        Vec3 mesoPos = storm.getPosition();
        Vec3 corePos = storm.getCorePosition();
        Vec3 velocity = storm.getVelocity();
        float stormWidth = storm.getWidth();
        if (level.isTornadoWarning()) {
            stormPos = mesoPos;
            anchorType = "MESO";
        } else {
            stormPos = corePos;
            anchorType = "CORE";
        }
        if (WarningConfig.isDebugMode()) {
            WXMCDebugLogger.debug("[POLYGON] Storm #{} {} warning: using {} position", storm.getId(), level.getShortCode(), anchorType);
            WXMCDebugLogger.debug("[POLYGON] Storm #{}: mesoPos=({}, {}), corePos=({}, {}), using=({}, {})", storm.getId(), (int)mesoPos.x, (int)mesoPos.z, (int)corePos.x, (int)corePos.z, (int)stormPos.x, (int)stormPos.z);
        }
        float halfW = IssuedWarning.calculatePolygonHalfWidth(type);
        float[] lengthParams = IssuedWarning.calculatePolygonLength(velocity);
        float projectionDistance = lengthParams[0];
        float halfH = lengthParams[2];
        Vec3 polygonCenter = IssuedWarning.calculatePolygonCenter(stormPos, velocity, projectionDistance);
        float offsetFromStorm = velocity.horizontalDistance() > 0.01 ? (projectionDistance + IssuedWarning.getFrontBuffer() - IssuedWarning.getRearBuffer()) / 2.0f : 0.0f;
        float baseRotation = storm.getMovementDirection();
        float occlusionRotation = 0.0f;
        if (type == 0 && storm.isCycling()) {
            occlusionRotation = storm.getOcclusion() * 20.0f;
            WXMCDebugLogger.debug("[OCCLUSION-ROTATE] Storm #{}: occlusion={:.2f}, rotating polygon {}\u00b0 clockwise", storm.getId(), Float.valueOf(storm.getOcclusion()), String.format("%.1f", Float.valueOf(occlusionRotation)));
        }
        float finalRotation = baseRotation + occlusionRotation;
        if (WarningConfig.isDebugMode()) {
            float totalLength = lengthParams[1];
            float stormSpeedBlocksPerMinute = (float)velocity.horizontalDistance() * 16.67f;
            float coreHalfWidth = halfW - IssuedWarning.getWobbleBuffer();
            float stormToBackEdge = IssuedWarning.getRearBuffer();
            float stormToFrontEdge = projectionDistance + IssuedWarning.getFrontBuffer();
            WXMCDebugLogger.debug("[POLYGON DEBUG] === New Polygon for Storm {} (NWS-style) ===", storm.getId());
            WXMCDebugLogger.debug("[POLYGON DEBUG] Storm Type: {} (0=supercell, 1=squall, 2=cyclone)", type);
            WXMCDebugLogger.debug("[POLYGON DEBUG] Meso Position: ({}, {}) | Core Position: ({}, {})", (int)mesoPos.x, (int)mesoPos.z, (int)stormPos.x, (int)stormPos.z);
            WXMCDebugLogger.debug("[POLYGON DEBUG] Core Offset: X={}, Z={} (intensity factor: {})", (int)(stormPos.x - mesoPos.x), (int)(stormPos.z - mesoPos.z), String.format("%.2f", Float.valueOf(storm.getCoreIntensityFactor())));
            WXMCDebugLogger.debug("[POLYGON DEBUG] Storm Velocity: ({}, {}) = {} blocks/tick, {} blocks/min", String.format("%.3f", velocity.x), String.format("%.3f", velocity.z), String.format("%.3f", velocity.horizontalDistance()), String.format("%.1f", Float.valueOf(stormSpeedBlocksPerMinute)));
            WXMCDebugLogger.debug("[POLYGON DEBUG] Polygon Width (half): {} blocks (core {} + wobble {})", (int)halfW, (int)coreHalfWidth, (int)IssuedWarning.getWobbleBuffer());
            WXMCDebugLogger.debug("[POLYGON DEBUG] Polygon Length: rear({}) + proj({}) + front({}) = {} (half={})", (int)IssuedWarning.getRearBuffer(), (int)projectionDistance, (int)IssuedWarning.getFrontBuffer(), (int)totalLength, (int)halfH);
            WXMCDebugLogger.debug("[POLYGON DEBUG] Core to back edge: {} blocks behind", (int)stormToBackEdge);
            WXMCDebugLogger.debug("[POLYGON DEBUG] Core to front edge: {} blocks ahead", (int)stormToFrontEdge);
            WXMCDebugLogger.debug("[POLYGON DEBUG] Core to center: {} blocks forward", (int)offsetFromStorm);
            WXMCDebugLogger.debug("[POLYGON DEBUG] Polygon Center: ({}, {})", (int)polygonCenter.x, (int)polygonCenter.z);
            WXMCDebugLogger.debug("[POLYGON DEBUG] Rotation: base={}\u00b0 + occlusion={}\u00b0 = {}\u00b0", String.format("%.1f", Float.valueOf(baseRotation)), String.format("%.1f", Float.valueOf(occlusionRotation)), String.format("%.1f", Float.valueOf(finalRotation)));
        }
        return new IssuedWarning(storm.getId(), level, polygonCenter, halfW, halfH, finalRotation, type, stage, 2000L, stormWidth, currentGameTime);
    }

    public boolean updatePolygonFromStorm(TrackedStorm storm, long currentGameTime) {
        int stage;
        Vec3 stormPos = this.level.isTornadoWarning() ? storm.getPosition() : storm.getCorePosition();
        Vec3 velocity = storm.getVelocity();
        int type = storm.getStormType();
        this.stormStage = stage = storm.getStage();
        if (currentGameTime - this.lastSizeUpdateGameTime < 250L) {
            return false;
        }
        float halfW = IssuedWarning.calculatePolygonHalfWidth(type);
        float[] lengthParams = IssuedWarning.calculatePolygonLength(velocity);
        float projectionDistance = lengthParams[0];
        float halfH = lengthParams[2];
        this.polygonHalfWidth = halfW;
        this.polygonHalfHeight = halfH;
        this.polygonCenter = IssuedWarning.calculatePolygonCenter(stormPos, velocity, projectionDistance);
        float baseRotation = storm.getMovementDirection();
        float occlusionRotation = 0.0f;
        if (type == 0 && storm.isCycling()) {
            occlusionRotation = storm.getOcclusion() * 20.0f;
        }
        this.polygonRotation = baseRotation + occlusionRotation;
        this.lastStormWidth = storm.getWidth();
        this.lastSizeUpdateGameTime = currentGameTime;
        this.expirationGameTime = currentGameTime + 2000L;
        return true;
    }

    public void upgradeLevel(WarningLevel newLevel, TrackedStorm storm, long currentGameTime) {
        this.level = newLevel;
        this.lastSizeUpdateGameTime = 0L;
        this.updatePolygonFromStorm(storm, currentGameTime);
    }

    public float getLastStormWidth() {
        return this.lastStormWidth;
    }

    public long getWarningId() {
        return this.warningId;
    }

    public long getStormId() {
        return this.stormId;
    }

    public WarningLevel getLevel() {
        return this.level;
    }

    public Vec3 getPolygonCenter() {
        return this.polygonCenter;
    }

    public float getPolygonHalfWidth() {
        return this.polygonHalfWidth;
    }

    public float getPolygonHalfHeight() {
        return this.polygonHalfHeight;
    }

    public float getPolygonRotation() {
        return this.polygonRotation;
    }

    public int getStormType() {
        return this.stormType;
    }

    public int getStormStage() {
        return this.stormStage;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getCreationGameTime() {
        return this.creationGameTime;
    }

    public long getExpirationGameTime() {
        return this.expirationGameTime;
    }

    public boolean hasStormLeft() {
        return this.stormHasLeft;
    }

    public void setStormHasLeft(boolean left) {
        this.stormHasLeft = left;
    }

    public void markBelowCriteria(long currentGameTime) {
        if (this.belowCriteriaStartTime < 0L) {
            this.belowCriteriaStartTime = currentGameTime;
        }
    }

    public void markMeetsCriteria() {
        this.belowCriteriaStartTime = -1L;
    }

    public boolean isBelowCriteria() {
        return this.belowCriteriaStartTime >= 0L;
    }

    public boolean shouldExpireDueToCriteria(long currentGameTime) {
        if (this.belowCriteriaStartTime < 0L) {
            return false;
        }
        return currentGameTime - this.belowCriteriaStartTime >= 250L;
    }

    public long getRemainingCriteriaMinutes(long currentGameTime) {
        if (this.belowCriteriaStartTime < 0L) {
            return -1L;
        }
        long elapsedTicks = currentGameTime - this.belowCriteriaStartTime;
        long remainingTicks = Math.max(0L, 250L - elapsedTicks);
        return remainingTicks * 60L / 1000L;
    }

    public boolean isExpired(long currentGameTime) {
        return currentGameTime > this.expirationGameTime;
    }

    public boolean containsPosition(Vec3 pos) {
        boolean isInside;
        double dx = pos.x - this.polygonCenter.x;
        double dz = pos.z - this.polygonCenter.z;
        double radians = Math.toRadians(-this.polygonRotation);
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        double localX = dx * cos - dz * sin;
        double localZ = dx * sin + dz * cos;
        if (this.stormType == 0) {
            float trapezoidFactor = 0.2f;
            double normalizedZ = localZ / (double)this.polygonHalfHeight;
            double widthMultiplier = 1.0 - (double)trapezoidFactor * normalizedZ;
            double adjustedHalfWidth = (double)this.polygonHalfWidth * widthMultiplier;
            boolean bl = isInside = Math.abs(localX) <= adjustedHalfWidth && Math.abs(localZ) <= (double)this.polygonHalfHeight;
            if (WarningConfig.isDebugMode()) {
                WXMCDebugLogger.debug("[POLYGON-CHECK] pos=({}, {}), center=({}, {}), dx={}, dz={}, localX={}, localZ={}, halfW={}, halfH={}, adjustedHalfW={}, isInside={}", (int)pos.x, (int)pos.z, (int)this.polygonCenter.x, (int)this.polygonCenter.z, (int)dx, (int)dz, (int)localX, (int)localZ, (int)this.polygonHalfWidth, (int)this.polygonHalfHeight, (int)adjustedHalfWidth, isInside);
            }
        } else {
            isInside = Math.abs(localX) <= (double)this.polygonHalfWidth && Math.abs(localZ) <= (double)this.polygonHalfHeight;
        }
        return isInside;
    }

    public boolean isNearPolygon(Vec3 pos, double maxDistance) {
        Vec3[] corners;
        if (this.containsPosition(pos)) {
            return true;
        }
        for (Vec3 corner : corners = this.getPolygonCorners()) {
            double dist = pos.distanceTo(new Vec3(corner.x, pos.y, corner.z));
            if (!(dist <= maxDistance)) continue;
            return true;
        }
        for (int i = 0; i < 4; ++i) {
            Vec3 a = corners[i];
            Vec3 b = corners[(i + 1) % 4];
            double dist = IssuedWarning.distanceToLineSegment(pos.x, pos.z, a.x, a.z, b.x, b.z);
            if (!(dist <= maxDistance)) continue;
            return true;
        }
        return false;
    }

    public Vec3[] getPolygonCorners() {
        double radians = Math.toRadians(this.polygonRotation);
        double cos = Math.cos(radians);
        double sin = Math.sin(radians);
        float halfW = this.polygonHalfWidth;
        float halfH = this.polygonHalfHeight;
        float narrowHW = halfW;
        float wideHW = halfW;
        if (this.stormType == 0) {
            float trapezoidFactor = 0.2f;
            narrowHW = halfW * (1.0f - trapezoidFactor);
            wideHW = halfW * (1.0f + trapezoidFactor);
        }
        Vec3[] corners = new Vec3[]{new Vec3(this.polygonCenter.x + ((double)(-narrowHW) * cos - (double)halfH * sin), this.polygonCenter.y, this.polygonCenter.z + ((double)(-narrowHW) * sin + (double)halfH * cos)), new Vec3(this.polygonCenter.x + ((double)narrowHW * cos - (double)halfH * sin), this.polygonCenter.y, this.polygonCenter.z + ((double)narrowHW * sin + (double)halfH * cos)), new Vec3(this.polygonCenter.x + ((double)wideHW * cos + (double)halfH * sin), this.polygonCenter.y, this.polygonCenter.z + ((double)wideHW * sin - (double)halfH * cos)), new Vec3(this.polygonCenter.x + ((double)(-wideHW) * cos + (double)halfH * sin), this.polygonCenter.y, this.polygonCenter.z + ((double)(-wideHW) * sin - (double)halfH * cos))};
        return corners;
    }

    private static double distanceToLineSegment(double px, double pz, double ax, double az, double bx, double bz) {
        double dx = bx - ax;
        double dz = bz - az;
        double lengthSq = dx * dx + dz * dz;
        if (lengthSq == 0.0) {
            return Math.sqrt((px - ax) * (px - ax) + (pz - az) * (pz - az));
        }
        double t = Math.max(0.0, Math.min(1.0, ((px - ax) * dx + (pz - az) * dz) / lengthSq));
        double projX = ax + t * dx;
        double projZ = az + t * dz;
        return Math.sqrt((px - projX) * (px - projX) + (pz - projZ) * (pz - projZ));
    }

    public long getRemainingTicks(long currentGameTime) {
        return Math.max(0L, this.expirationGameTime - currentGameTime);
    }

    public String getRemainingTimeFormatted(long currentGameTime) {
        long remainingTicks = this.getRemainingTicks(currentGameTime);
        long mcMinutes = remainingTicks * 60L / 1000L;
        long hours = mcMinutes / 60L;
        long minutes = mcMinutes % 60L;
        if (hours > 0L) {
            return String.format("%dh %dm", hours, minutes);
        }
        return String.format("%dm", minutes);
    }

    public AlertPolygon toAlertPolygon(double radarX, double radarZ, double radarRange) {
        double worldDx = this.polygonCenter.x - radarX;
        double worldDz = this.polygonCenter.z - radarZ;
        double cx = 0.5 + worldDx / (radarRange * 2.0);
        double cz = 0.5 + worldDz / (radarRange * 2.0);
        cx = Math.max(0.0, Math.min(1.0, cx));
        cz = Math.max(0.0, Math.min(1.0, cz));
        float halfW = (float)((double)this.polygonHalfWidth / (radarRange * 2.0));
        float halfH = (float)((double)this.polygonHalfHeight / (radarRange * 2.0));
        return new AlertPolygon(this.warningId, cx, cz, halfW, halfH, this.polygonRotation, this.level.ordinal(), this.stormType, this.stormStage);
    }

    public String toString() {
        return String.format("IssuedWarning[id=%d, storm=%d, level=%s, expires at game tick %d]", this.warningId, this.stormId, this.level.getShortCode(), this.expirationGameTime);
    }
}

