/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.warnings;

import dev.wxmc.weatheraddon.util.WXMCDebugLogger;
import dev.wxmc.weatheraddon.warnings.AlertPolygon;
import dev.wxmc.weatheraddon.warnings.StormType;
import dev.wxmc.weatheraddon.warnings.TrackedStorm;
import dev.wxmc.weatheraddon.warnings.WarningConfig;
import dev.wxmc.weatheraddon.warnings.WarningLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class AlertPolygonManager {
    private static final Map<BlockPos, List<AlertPolygon>> polygonMap = new ConcurrentHashMap<BlockPos, List<AlertPolygon>>();
    private static final ReadWriteLock lock = new ReentrantReadWriteLock();
    public static final double DEFAULT_RADAR_RANGE = 2048.0;
    private static final Map<BlockPos, Long> lastUpdateTime = new ConcurrentHashMap<BlockPos, Long>();
    private static final long STALE_TIMEOUT_MS = 300000L;

    public static void addPolygon(BlockPos pos, AlertPolygon polygon) {
        lock.writeLock().lock();
        try {
            List list = polygonMap.computeIfAbsent(pos, k -> Collections.synchronizedList(new ArrayList()));
            list.removeIf(existing -> existing.stormId == polygon.stormId);
            list.add(polygon);
            lastUpdateTime.put(pos, System.currentTimeMillis());
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public static Collection<AlertPolygon> getPolygonsAt(BlockPos pos) {
        lock.readLock().lock();
        try {
            List<AlertPolygon> list = polygonMap.get(pos);
            if (list == null) {
                List<AlertPolygon> list2 = Collections.emptyList();
                return list2;
            }
            ArrayList<AlertPolygon> arrayList = new ArrayList<AlertPolygon>(list);
            return arrayList;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public static void clearPolygons(BlockPos pos) {
        lock.writeLock().lock();
        try {
            polygonMap.remove(pos);
            lastUpdateTime.remove(pos);
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public static void retainPolygons(BlockPos pos, Set<Long> keepIds) {
        lock.writeLock().lock();
        try {
            List<AlertPolygon> list = polygonMap.get(pos);
            if (list == null) {
                return;
            }
            list.removeIf(poly -> !keepIds.contains(poly.stormId));
            if (list.isEmpty()) {
                polygonMap.remove(pos);
                lastUpdateTime.remove(pos);
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePolygon(BlockPos pos, long stormId) {
        lock.writeLock().lock();
        try {
            List<AlertPolygon> list = polygonMap.get(pos);
            if (list != null) {
                list.removeIf(poly -> poly.stormId == stormId);
                if (list.isEmpty()) {
                    polygonMap.remove(pos);
                    lastUpdateTime.remove(pos);
                }
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public static void updateFromStorms(BlockPos radarPos, Collection<TrackedStorm> storms) {
        double radarRange = 2048.0;
        HashSet<Long> activeStormIds = new HashSet<Long>();
        int polygonsCreated = 0;
        int polygonsSkipped = 0;
        for (TrackedStorm storm : storms) {
            double worldDz;
            if (storm.getCurrentWarningLevel() == WarningLevel.NONE) {
                if (WarningConfig.isDebugMode()) {
                    WXMCDebugLogger.debug("[DEBUG] Storm #{} skipped for polygon - no warning level", storm.getId());
                }
                ++polygonsSkipped;
                continue;
            }
            double worldDx = storm.getPosition().x - ((double)radarPos.getX() + 0.5);
            double distanceFromRadar = Math.sqrt(worldDx * worldDx + (worldDz = storm.getPosition().z - ((double)radarPos.getZ() + 0.5)) * worldDz);
            if (distanceFromRadar > radarRange) {
                if (WarningConfig.isDebugMode()) {
                    WXMCDebugLogger.debug("[DEBUG] Storm #{} at distance {:.0f} outside radar range {}", storm.getId(), distanceFromRadar, radarRange);
                }
                ++polygonsSkipped;
                continue;
            }
            double cx = 0.5 + worldDx / (radarRange * 2.0);
            double cz = 0.5 + worldDz / (radarRange * 2.0);
            if ((cx < 0.0 || cx > 1.0 || cz < 0.0 || cz > 1.0) && WarningConfig.isDebugMode()) {
                WXMCDebugLogger.debug("[POLYGON] Clamping out-of-bounds coordinates for storm #{}: ({}, {}) -> clamped to [0,1]", storm.getId(), String.format("%.3f", cx), String.format("%.3f", cz));
            }
            cx = Math.max(0.0, Math.min(1.0, cx));
            cz = Math.max(0.0, Math.min(1.0, cz));
            int type = storm.getStormType();
            int stage = storm.getStage();
            StormType stormType = StormType.fromId(type);
            float halfW = stormType.getRadarHalfWidth(stage);
            float halfH = stormType.getRadarHalfHeight(stage);
            float movementAngle = (float)Math.toDegrees(Math.atan2(storm.getVelocity().x, -storm.getVelocity().z));
            movementAngle = (movementAngle + 360.0f) % 360.0f;
            float rotation = stormType.getRadarRotation(movementAngle);
            activeStormIds.add(storm.getId());
            AlertPolygon polygon = new AlertPolygon(storm.getId(), cx, cz, halfW, halfH, rotation, storm.getCurrentWarningLevel().ordinal(), type, stage);
            AlertPolygonManager.addPolygon(radarPos, polygon);
            ++polygonsCreated;
            if (!WarningConfig.isDebugMode()) continue;
            WXMCDebugLogger.debug("[DEBUG] Created polygon for Storm #{} at radar {}: center=({:.3f}, {:.3f}) size=({:.3f}, {:.3f}) rotation={:.1f} level={}", storm.getId(), radarPos, polygon.centerX, polygon.centerZ, Float.valueOf(polygon.halfWidth), Float.valueOf(polygon.halfHeight), Float.valueOf(polygon.rotationDeg), polygon.getWarningLevel().getDisplayName());
        }
        AlertPolygonManager.retainPolygons(radarPos, activeStormIds);
        if (WarningConfig.isDebugMode()) {
            if (polygonsCreated > 0) {
                WXMCDebugLogger.debug("[DEBUG] Polygon update complete for radar {}: {} created, {} skipped, {} active", radarPos, polygonsCreated, polygonsSkipped, AlertPolygonManager.getPolygonCount(radarPos));
            } else if (storms.size() > 0 && polygonsSkipped == storms.size()) {
                WXMCDebugLogger.debug("[DEBUG] No polygons created for radar {} - {} storms skipped (no warnings or out of range)", radarPos, polygonsSkipped);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writePolygons(BlockPos pos, CompoundTag tag) {
        lock.readLock().lock();
        try {
            List<AlertPolygon> polygons = polygonMap.get(pos);
            if (polygons == null || polygons.isEmpty()) {
                return;
            }
            ListTag list = new ListTag();
            for (AlertPolygon poly : polygons) {
                CompoundTag polyTag = new CompoundTag();
                polyTag.putLong("stormId", poly.stormId);
                polyTag.putDouble("centerX", poly.centerX);
                polyTag.putDouble("centerZ", poly.centerZ);
                polyTag.putFloat("halfWidth", poly.halfWidth);
                polyTag.putFloat("halfHeight", poly.halfHeight);
                polyTag.putFloat("rotation", poly.rotationDeg);
                polyTag.putInt("stormType", poly.stormType);
                polyTag.putInt("stormStage", poly.stormStage);
                polyTag.putInt("level", poly.level);
                list.add((Object)polyTag);
            }
            tag.put("polygons", (Tag)list);
        }
        finally {
            lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readPolygons(BlockPos pos, CompoundTag tag) {
        if (!tag.contains("polygons")) {
            return;
        }
        lock.writeLock().lock();
        try {
            ListTag list = tag.getList("polygons", 10);
            ArrayList<AlertPolygon> polygons = new ArrayList<AlertPolygon>();
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag polyTag = list.getCompound(i);
                AlertPolygon poly = new AlertPolygon(polyTag.getLong("stormId"), polyTag.getDouble("centerX"), polyTag.getDouble("centerZ"), polyTag.getFloat("halfWidth"), polyTag.getFloat("halfHeight"), polyTag.getFloat("rotation"), polyTag.getInt("level"), polyTag.getInt("stormType"), polyTag.getInt("stormStage"));
                polygons.add(poly);
            }
            if (!polygons.isEmpty()) {
                polygonMap.put(pos, Collections.synchronizedList(polygons));
                lastUpdateTime.put(pos, System.currentTimeMillis());
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public static boolean hasPolygons(BlockPos pos) {
        lock.readLock().lock();
        try {
            List<AlertPolygon> list = polygonMap.get(pos);
            boolean bl = list != null && !list.isEmpty();
            return bl;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public static int getPolygonCount(BlockPos pos) {
        lock.readLock().lock();
        try {
            List<AlertPolygon> list = polygonMap.get(pos);
            int n = list != null ? list.size() : 0;
            return n;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public static WarningLevel getHighestWarningLevel(BlockPos pos) {
        lock.readLock().lock();
        try {
            List<AlertPolygon> list = polygonMap.get(pos);
            if (list == null || list.isEmpty()) {
                WarningLevel warningLevel = WarningLevel.NONE;
                return warningLevel;
            }
            WarningLevel warningLevel = list.stream().map(AlertPolygon::getWarningLevel).max(Comparator.comparingInt(WarningLevel::getPriority)).orElse(WarningLevel.NONE);
            return warningLevel;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public static Set<BlockPos> getTrackedRadars() {
        lock.readLock().lock();
        try {
            HashSet<BlockPos> hashSet = new HashSet<BlockPos>(polygonMap.keySet());
            return hashSet;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public static int getTotalPolygonCount() {
        lock.readLock().lock();
        try {
            int n = polygonMap.values().stream().mapToInt(List::size).sum();
            return n;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public static String getAllPositionsWithPolygons() {
        lock.readLock().lock();
        try {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<BlockPos, List<AlertPolygon>> entry : polygonMap.entrySet()) {
                if (entry.getValue().isEmpty()) continue;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(entry.getKey().toShortString()).append("=").append(entry.getValue().size());
            }
            String string = sb.length() > 0 ? sb.toString() : "(none)";
            return string;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<AlertPolygon> getPolygonsByXZ(int x, int z) {
        lock.readLock().lock();
        try {
            for (Map.Entry<BlockPos, List<AlertPolygon>> entry : polygonMap.entrySet()) {
                List<AlertPolygon> list;
                BlockPos pos = entry.getKey();
                if (pos.getX() != x || pos.getZ() != z || (list = entry.getValue()) == null || list.isEmpty()) continue;
                ArrayList<AlertPolygon> arrayList = new ArrayList<AlertPolygon>(list);
                return arrayList;
            }
            List list = Collections.emptyList();
            return list;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasPolygonsByXZ(int x, int z) {
        lock.readLock().lock();
        try {
            for (Map.Entry<BlockPos, List<AlertPolygon>> entry : polygonMap.entrySet()) {
                List<AlertPolygon> list;
                BlockPos pos = entry.getKey();
                if (pos.getX() != x || pos.getZ() != z || (list = entry.getValue()) == null || list.isEmpty()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public static Collection<AlertPolygon> getAllPolygons() {
        lock.readLock().lock();
        try {
            ArrayList<AlertPolygon> all = new ArrayList<AlertPolygon>();
            for (List<AlertPolygon> list : polygonMap.values()) {
                if (list == null) continue;
                all.addAll(list);
            }
            ArrayList<AlertPolygon> arrayList = all;
            return arrayList;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    public static void clearAll() {
        lock.writeLock().lock();
        try {
            polygonMap.clear();
            lastUpdateTime.clear();
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int cleanupStaleEntries() {
        lock.writeLock().lock();
        try {
            long currentTime = System.currentTimeMillis();
            int removedCount = 0;
            Iterator<Map.Entry<BlockPos, Long>> iterator = lastUpdateTime.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<BlockPos, Long> entry = iterator.next();
                if (currentTime - entry.getValue() <= 300000L) continue;
                BlockPos pos = entry.getKey();
                polygonMap.remove(pos);
                iterator.remove();
                ++removedCount;
                if (!WarningConfig.isDebugMode()) continue;
                WXMCDebugLogger.debug("[DEBUG] Removed stale polygon entry for radar at {}", pos);
            }
            int n = removedCount;
            return n;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int cleanupDeadStorms(Set<Long> activeStormIds) {
        lock.writeLock().lock();
        try {
            int removedCount = 0;
            for (Map.Entry<BlockPos, List<AlertPolygon>> entry2 : polygonMap.entrySet()) {
                List<AlertPolygon> polygons = entry2.getValue();
                int before = polygons.size();
                polygons.removeIf(poly -> !activeStormIds.contains(poly.stormId));
                removedCount += before - polygons.size();
                if (!polygons.isEmpty()) continue;
                lastUpdateTime.remove(entry2.getKey());
            }
            polygonMap.entrySet().removeIf(entry -> ((List)entry.getValue()).isEmpty());
            if (WarningConfig.isDebugMode() && removedCount > 0) {
                WXMCDebugLogger.debug("[DEBUG] Cleaned up {} polygons for dead storms", removedCount);
            }
            int n = removedCount;
            return n;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    public static String getStatusSummary() {
        lock.readLock().lock();
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("AlertPolygonManager Status:\n");
            sb.append("- Total Radars: ").append(polygonMap.size()).append("\n");
            sb.append("- Total Polygons: ").append(AlertPolygonManager.getTotalPolygonCount()).append("\n");
            for (Map.Entry<BlockPos, List<AlertPolygon>> entry : polygonMap.entrySet()) {
                sb.append("- Radar at ").append(entry.getKey().toShortString()).append(": ").append(entry.getValue().size()).append(" polygons\n");
            }
            String string = sb.toString();
            return string;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void debugPrintState() {
        lock.readLock().lock();
        try {
            for (Map.Entry<BlockPos, List<AlertPolygon>> entry : polygonMap.entrySet()) {
                System.out.println("Radar at " + String.valueOf(entry.getKey()) + ": " + entry.getValue().size() + " polygons");
                for (AlertPolygon poly : entry.getValue()) {
                    System.out.println("  " + String.valueOf(poly));
                }
            }
        }
        finally {
            lock.readLock().unlock();
        }
    }
}

