/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.warnings;

import dev.wxmc.weatheraddon.warnings.StormType;
import dev.wxmc.weatheraddon.warnings.TrackedStorm;
import dev.wxmc.weatheraddon.warnings.WarningLevel;
import net.minecraft.world.phys.Vec3;

public class AlertPolygon {
    public final long stormId;
    public final double centerX;
    public final double centerZ;
    public final float halfWidth;
    public final float halfHeight;
    public final float rotationDeg;
    public final int level;
    public final int stormType;
    public final int stormStage;

    public AlertPolygon(long stormId, double centerX, double centerZ, float halfWidth, float halfHeight, float rotationDeg, int level, int stormType, int stormStage) {
        this.stormId = stormId;
        this.centerX = centerX;
        this.centerZ = centerZ;
        this.halfWidth = halfWidth;
        this.halfHeight = halfHeight;
        this.rotationDeg = rotationDeg;
        this.level = level;
        this.stormType = stormType;
        this.stormStage = stormStage;
    }

    public static AlertPolygon fromStorm(TrackedStorm storm, double radarMinX, double radarMinZ, double radarMaxX, double radarMaxZ) {
        double radarWidth = radarMaxX - radarMinX;
        double radarHeight = radarMaxZ - radarMinZ;
        Vec3 corePos = storm.getCorePosition();
        double centerX = (corePos.x - radarMinX) / radarWidth;
        double centerZ = (corePos.z - radarMinZ) / radarHeight;
        float stormWidth = Math.max(storm.getWidth(), 50.0f);
        float halfWidth = (float)((double)stormWidth / radarWidth) / 2.0f;
        float halfHeight = (float)((double)stormWidth * 1.5 / radarHeight) / 2.0f;
        float rotationDeg = storm.getMovementDirection();
        return new AlertPolygon(storm.getId(), centerX, centerZ, halfWidth, halfHeight, rotationDeg, storm.getCurrentWarningLevel().ordinal(), storm.getStormType(), storm.getStage());
    }

    public WarningLevel getWarningLevel() {
        WarningLevel[] levels = WarningLevel.values();
        if (this.level >= 0 && this.level < levels.length) {
            return levels[this.level];
        }
        return WarningLevel.NONE;
    }

    public int getColor() {
        return this.getWarningLevel().getColor();
    }

    public StormType getStormType() {
        return StormType.fromId(this.stormType);
    }

    public boolean isSupercellShape() {
        return this.getStormType().usesTrapezoidShape();
    }

    public boolean isSquallLineShape() {
        return this.getStormType().usesRectangleShape();
    }

    public boolean isWithinRadarBounds() {
        return this.centerX >= -0.1 && this.centerX <= 1.1 && this.centerZ >= -0.1 && this.centerZ <= 1.1;
    }

    public String toString() {
        return String.format("AlertPolygon[storm=%d, pos=(%.2f,%.2f), level=%s]", this.stormId, this.centerX, this.centerZ, this.getWarningLevel().getShortCode());
    }
}

