/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.util;

import dev.wxmc.weatheraddon.util.WXMCDebugLogger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.world.phys.Vec3;

public class WindCache {
    public static final int GRID_SIZE = 32;
    public static final long CACHE_TICKS = 3L;
    public static final long CLEANUP_INTERVAL = 100L;
    private static final Map<WindCacheKey, WindCacheEntry> windCache = new ConcurrentHashMap<WindCacheKey, WindCacheEntry>();
    private static long lastCleanupTime = 0L;

    public static Vec3 getCached(WindCacheKey key, long gameTime) {
        WindCacheEntry cached = windCache.get(key);
        if (cached != null && gameTime - cached.timestamp < 3L) {
            return cached.wind;
        }
        return null;
    }

    public static void put(WindCacheKey key, Vec3 wind, long gameTime) {
        windCache.put(key, new WindCacheEntry(wind, gameTime));
    }

    public static void cleanupIfNeeded(long gameTime) {
        if (gameTime - lastCleanupTime > 100L) {
            WindCache.cleanup(gameTime);
            lastCleanupTime = gameTime;
        }
    }

    private static void cleanup(long currentTime) {
        windCache.entrySet().removeIf(entry -> currentTime - ((WindCacheEntry)entry.getValue()).timestamp > 30L);
        if (windCache.size() > 10000) {
            WXMCDebugLogger.debug("[WIND-CACHE] Cache exceeded 10000 entries, clearing");
            windCache.clear();
        }
    }

    public static WindCacheKey createKey(Vec3 position, String dimension, boolean ignoreStorms, boolean ignoreTornadoes, boolean windCheck, boolean windAnyway) {
        return new WindCacheKey((int)Math.floor(position.x / 32.0), (int)Math.floor(position.y / 64.0), (int)Math.floor(position.z / 32.0), dimension, ignoreStorms, ignoreTornadoes, windCheck, windAnyway);
    }

    public static class WindCacheEntry {
        public final Vec3 wind;
        public final long timestamp;

        public WindCacheEntry(Vec3 wind, long timestamp) {
            this.wind = wind;
            this.timestamp = timestamp;
        }
    }

    public record WindCacheKey(int gridX, int gridY, int gridZ, String dimension, boolean ignoreStorms, boolean ignoreTornadoes, boolean windCheck, boolean windAnyway) {
    }
}

