/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.util;

import dev.wxmc.weatheraddon.WXMCWeatherAddon;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import net.neoforged.fml.loading.FMLPaths;

public class WXMCFiles {
    private static final String WXMC_FOLDER = "WXMC";
    private static final String TORDB_FOLDER = "TorDB";
    private static final String PHOTOS_FOLDER = "photos";

    public static Path getWXMCConfigDir() {
        Path configDir = FMLPaths.CONFIGDIR.get().resolve(WXMC_FOLDER);
        WXMCFiles.ensureDirectoryExists(configDir);
        return configDir;
    }

    public static Path getTorDBDir() {
        Path tordbDir = WXMCFiles.getWXMCConfigDir().resolve(TORDB_FOLDER);
        WXMCFiles.ensureDirectoryExists(tordbDir);
        return tordbDir;
    }

    public static Path getEntryPhotosDir(String entryId) {
        Path photosDir = WXMCFiles.getTorDBDir().resolve(entryId).resolve(PHOTOS_FOLDER);
        WXMCFiles.ensureDirectoryExists(photosDir);
        return photosDir;
    }

    public static Path getPhotoPath(String entryId, int photoIndex) {
        return WXMCFiles.getEntryPhotosDir(entryId).resolve("photo_" + photoIndex + ".png");
    }

    public static boolean photoExists(String entryId, int photoIndex) {
        return Files.exists(WXMCFiles.getPhotoPath(entryId, photoIndex), new LinkOption[0]);
    }

    public static int getPhotoCount(String entryId) {
        Path photosDir = WXMCFiles.getTorDBDir().resolve(entryId).resolve(PHOTOS_FOLDER);
        if (!Files.exists(photosDir, new LinkOption[0])) {
            return 0;
        }
        int count = 0;
        while (Files.exists(photosDir.resolve("photo_" + count + ".png"), new LinkOption[0])) {
            ++count;
        }
        return count;
    }

    public static void deleteEntryPhotos(String entryId) {
        Path entryDir = WXMCFiles.getTorDBDir().resolve(entryId);
        if (Files.exists(entryDir, new LinkOption[0])) {
            try (Stream<Path> pathStream = Files.walk(entryDir, new FileVisitOption[0]);){
                pathStream.sorted((a, b) -> -a.compareTo((Path)b)).forEach(path -> {
                    try {
                        Files.deleteIfExists(path);
                    }
                    catch (IOException e) {
                        WXMCWeatherAddon.LOGGER.warn("Failed to delete: {}", path, (Object)e);
                    }
                });
            }
            catch (IOException e) {
                WXMCWeatherAddon.LOGGER.warn("Failed to delete entry photos for: {}", (Object)entryId, (Object)e);
            }
        }
    }

    private static void ensureDirectoryExists(Path dir) {
        if (!Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
                WXMCWeatherAddon.LOGGER.debug("Created directory: {}", (Object)dir);
            }
            catch (IOException e) {
                WXMCWeatherAddon.LOGGER.error("Failed to create directory: {}", (Object)dir, (Object)e);
            }
        }
    }
}

