/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.util;

import dev.wxmc.weatheraddon.WXMCWeatherAddon;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class WXMCDebugLogger {
    private static final String LOG_FILE = "logs/wxmc-debug.log";
    private static final DateTimeFormatter TIMESTAMP_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private static final int MAX_FILE_SIZE_MB = 10;
    private static final int MAX_BACKUP_FILES = 3;
    private static final BlockingQueue<String> logQueue = new LinkedBlockingQueue<String>();
    private static volatile boolean running = false;
    private static Thread writerThread;
    private static PrintWriter writer;

    public static synchronized void init() {
        if (running) {
            return;
        }
        try {
            Path logsDir = Paths.get("logs", new String[0]);
            if (!Files.exists(logsDir, new LinkOption[0])) {
                Files.createDirectories(logsDir, new FileAttribute[0]);
            }
            WXMCDebugLogger.rotateLogIfNeeded();
            writer = new PrintWriter((Writer)new BufferedWriter(new FileWriter(LOG_FILE, true)), true);
            running = true;
            writerThread = new Thread(WXMCDebugLogger::writerLoop, "WXMC-DebugLogger");
            writerThread.setDaemon(true);
            writerThread.start();
            WXMCDebugLogger.info("=".repeat(60));
            WXMCDebugLogger.info("WXMC Debug Logger initialized - " + LocalDateTime.now().format(TIMESTAMP_FORMAT));
            WXMCDebugLogger.info("=".repeat(60));
        }
        catch (IOException e) {
            WXMCWeatherAddon.LOGGER.warn("Failed to initialize WXMC debug logger: {}", (Object)e.getMessage());
        }
    }

    public static synchronized void shutdown() {
        if (!running) {
            return;
        }
        WXMCDebugLogger.info("WXMC Debug Logger shutting down");
        running = false;
        if (writerThread != null) {
            writerThread.interrupt();
            try {
                writerThread.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (writer != null) {
            String msg;
            while ((msg = (String)logQueue.poll()) != null) {
                writer.println(msg);
            }
            writer.close();
            writer = null;
        }
    }

    public static void debug(String message) {
        WXMCDebugLogger.log("DEBUG", message);
    }

    public static void debug(String format, Object ... args) {
        WXMCDebugLogger.log("DEBUG", WXMCDebugLogger.formatMessage(format, args));
    }

    public static void info(String message) {
        WXMCDebugLogger.log("INFO", message);
    }

    public static void info(String format, Object ... args) {
        WXMCDebugLogger.log("INFO", WXMCDebugLogger.formatMessage(format, args));
    }

    public static void warn(String message) {
        WXMCDebugLogger.log("WARN", message);
        WXMCWeatherAddon.LOGGER.warn(message);
    }

    public static void warn(String format, Object ... args) {
        String msg = WXMCDebugLogger.formatMessage(format, args);
        WXMCDebugLogger.log("WARN", msg);
        WXMCWeatherAddon.LOGGER.warn(msg);
    }

    public static void error(String message) {
        WXMCDebugLogger.log("ERROR", message);
        WXMCWeatherAddon.LOGGER.error(message);
    }

    public static void error(String format, Object ... args) {
        String msg = WXMCDebugLogger.formatMessage(format, args);
        WXMCDebugLogger.log("ERROR", msg);
        WXMCWeatherAddon.LOGGER.error(msg);
    }

    public static void error(String message, Throwable t) {
        WXMCDebugLogger.log("ERROR", message + " - " + t.getMessage());
        WXMCWeatherAddon.LOGGER.error(message, t);
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        WXMCDebugLogger.log("ERROR", sw.toString());
    }

    private static void log(String level, String message) {
        if (!running) {
            return;
        }
        String timestamp = LocalDateTime.now().format(TIMESTAMP_FORMAT);
        String formattedMessage = String.format("[%s] [%s] [WXMC] %s", timestamp, level, message);
        logQueue.offer(formattedMessage);
    }

    private static String formatMessage(String format, Object ... args) {
        Object result = format;
        for (Object arg : args) {
            int idx = ((String)result).indexOf("{}");
            if (idx < 0) continue;
            result = ((String)result).substring(0, idx) + String.valueOf(arg) + ((String)result).substring(idx + 2);
        }
        return result;
    }

    private static void writerLoop() {
        while (running || !logQueue.isEmpty()) {
            try {
                String message = logQueue.poll(100L, TimeUnit.MILLISECONDS);
                if (message == null || writer == null) continue;
                writer.println(message);
            }
            catch (InterruptedException e) {
                if (running) continue;
                break;
            }
        }
    }

    private static void rotateLogIfNeeded() {
        try {
            Path logPath = Paths.get(LOG_FILE, new String[0]);
            if (!Files.exists(logPath, new LinkOption[0])) {
                return;
            }
            long sizeBytes = Files.size(logPath);
            long sizeMB = sizeBytes / 0x100000L;
            if (sizeMB >= 10L) {
                for (int i = 2; i >= 1; --i) {
                    Path older = Paths.get("logs/wxmc-debug.log." + i, new String[0]);
                    Path newer = Paths.get("logs/wxmc-debug.log." + (i + 1), new String[0]);
                    if (!Files.exists(older, new LinkOption[0])) continue;
                    if (i == 2) {
                        Files.delete(older);
                        continue;
                    }
                    Files.move(older, newer, StandardCopyOption.REPLACE_EXISTING);
                }
                Files.move(logPath, Paths.get("logs/wxmc-debug.log.1", new String[0]), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

