/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.util;

import dev.wxmc.weatheraddon.util.WXMCDebugLogger;
import java.lang.reflect.Method;
import java.util.UUID;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.cacheddata.CachedPermissionData;
import net.luckperms.api.model.data.DataMutateResult;
import net.luckperms.api.model.user.User;
import net.luckperms.api.model.user.UserManager;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.ScopedNode;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class PermissionHelper {
    public static final String ADMIN = "wxmc.admin";
    public static final String DAMAGE_ASSESSMENT_SUBMIT = "wxmc.damageassessment.submit";
    public static final String DAMAGE_ASSESSMENT_DELETE = "wxmc.damageassessment.delete";
    public static final String TORNADO_COUNT = "wxmc.tornadocount";
    public static final String TORNADO_COUNT_ADMIN = "wxmc.tornadocount.admin";
    public static final String WARNING_MANAGE = "wxmc.warning.manage";
    public static final String TORNADO_REPORTS_10 = "wxmc.tornadoreports.10";
    private static Boolean luckPermsAvailable = null;
    private static Boolean bukkitAvailable = null;

    public static boolean isLuckPermsAvailable() {
        if (luckPermsAvailable == null) {
            try {
                Class.forName("net.luckperms.api.LuckPermsProvider");
                luckPermsAvailable = true;
                WXMCDebugLogger.info("LuckPerms API detected - using LuckPerms for permissions");
            }
            catch (ClassNotFoundException e) {
                luckPermsAvailable = false;
                WXMCDebugLogger.info("LuckPerms API not found directly");
            }
        }
        return luckPermsAvailable;
    }

    public static boolean isBukkitAvailable() {
        if (bukkitAvailable == null) {
            try {
                Class.forName("org.bukkit.Bukkit");
                bukkitAvailable = true;
                WXMCDebugLogger.info("Bukkit API detected - using Bukkit permissions (hybrid server)");
            }
            catch (ClassNotFoundException e) {
                bukkitAvailable = false;
                WXMCDebugLogger.info("Bukkit API not found - using vanilla OP levels for permissions");
            }
        }
        return bukkitAvailable;
    }

    public static boolean isPermissionSystemAvailable() {
        return PermissionHelper.isLuckPermsAvailable() || PermissionHelper.isBukkitAvailable();
    }

    public static boolean hasPermission(ServerPlayer player, String permission) {
        if (player == null) {
            return false;
        }
        if (PermissionHelper.isLuckPermsAvailable()) {
            return PermissionHelper.checkLuckPerms(player.getUUID(), permission);
        }
        if (PermissionHelper.isBukkitAvailable()) {
            try {
                Boolean result = PermissionHelper.checkBukkitPermission(player, permission);
                if (result != null) {
                    return result;
                }
            }
            catch (Throwable t) {
                WXMCDebugLogger.debug("Bukkit permission check failed: {}", t.getMessage());
            }
        }
        return player.hasPermissions(PermissionHelper.getFallbackOpLevel(permission));
    }

    public static boolean hasPermission(CommandSourceStack source, String permission) {
        if (source == null) {
            return false;
        }
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            return PermissionHelper.hasPermission(player, permission);
        }
        return true;
    }

    private static boolean checkLuckPerms(UUID playerUuid, String permission) {
        try {
            return LuckPermsChecker.hasPermission(playerUuid, permission);
        }
        catch (Throwable t) {
            WXMCDebugLogger.debug("LuckPerms check failed, falling back to OP level: {}", t.getMessage());
            luckPermsAvailable = false;
            return false;
        }
    }

    private static Boolean checkBukkitPermission(ServerPlayer player, String permission) {
        try {
            Class<?> bukkitClass = Class.forName("org.bukkit.Bukkit");
            Method getPlayerMethod = bukkitClass.getMethod("getPlayer", UUID.class);
            Object bukkitPlayer = getPlayerMethod.invoke(null, player.getUUID());
            if (bukkitPlayer == null) {
                WXMCDebugLogger.debug("Bukkit player not found for UUID: {}", player.getUUID());
                return null;
            }
            Method hasPermissionMethod = bukkitPlayer.getClass().getMethod("hasPermission", String.class);
            return (Boolean)hasPermissionMethod.invoke(bukkitPlayer, permission);
        }
        catch (ClassNotFoundException e) {
            WXMCDebugLogger.debug("Bukkit class not found: {}", e.getMessage());
            bukkitAvailable = false;
            return null;
        }
        catch (Exception e) {
            WXMCDebugLogger.debug("Bukkit permission check error: {}", e.getMessage());
            return null;
        }
    }

    public static boolean grantPermission(UUID playerUuid, String permission) {
        if (!PermissionHelper.isLuckPermsAvailable()) {
            WXMCDebugLogger.debug("Cannot grant permission {} - LuckPerms not available", permission);
            return false;
        }
        try {
            return LuckPermsChecker.grantPermission(playerUuid, permission);
        }
        catch (Throwable t) {
            WXMCDebugLogger.debug("Failed to grant permission {}: {}", permission, t.getMessage());
            return false;
        }
    }

    public static boolean removePermission(UUID playerUuid, String permission) {
        if (!PermissionHelper.isLuckPermsAvailable()) {
            WXMCDebugLogger.debug("Cannot remove permission {} - LuckPerms not available", permission);
            return false;
        }
        try {
            return LuckPermsChecker.removePermission(playerUuid, permission);
        }
        catch (Throwable t) {
            WXMCDebugLogger.debug("Failed to remove permission {}: {}", permission, t.getMessage());
            return false;
        }
    }

    private static int getFallbackOpLevel(String permission) {
        return switch (permission) {
            case TORNADO_COUNT, TORNADO_REPORTS_10 -> 0;
            case ADMIN, DAMAGE_ASSESSMENT_SUBMIT, DAMAGE_ASSESSMENT_DELETE, TORNADO_COUNT_ADMIN, WARNING_MANAGE -> 2;
            default -> 2;
        };
    }

    private static class LuckPermsChecker {
        private LuckPermsChecker() {
        }

        static boolean hasPermission(UUID playerUuid, String permission) {
            LuckPerms luckPerms = LuckPermsProvider.get();
            User user = luckPerms.getUserManager().getUser(playerUuid);
            if (user == null) {
                user = (User)luckPerms.getUserManager().loadUser(playerUuid).join();
            }
            if (user == null) {
                return false;
            }
            CachedPermissionData permissionData = user.getCachedData().getPermissionData();
            return permissionData.checkPermission(permission).asBoolean();
        }

        static boolean grantPermission(UUID playerUuid, String permission) {
            LuckPerms luckPerms = LuckPermsProvider.get();
            UserManager userManager = luckPerms.getUserManager();
            User user = (User)userManager.loadUser(playerUuid).join();
            if (user == null) {
                WXMCDebugLogger.debug("Could not load user {} to grant permission", playerUuid);
                return false;
            }
            ScopedNode node = Node.builder((String)permission).build();
            DataMutateResult result = user.data().add((Node)node);
            userManager.saveUser(user);
            WXMCDebugLogger.info("Granted permission {} to {} (result: {})", permission, playerUuid, result.name());
            return result.wasSuccessful();
        }

        static boolean removePermission(UUID playerUuid, String permission) {
            LuckPerms luckPerms = LuckPermsProvider.get();
            UserManager userManager = luckPerms.getUserManager();
            User user = (User)userManager.loadUser(playerUuid).join();
            if (user == null) {
                WXMCDebugLogger.debug("Could not load user {} to remove permission", playerUuid);
                return false;
            }
            ScopedNode node = Node.builder((String)permission).build();
            DataMutateResult result = user.data().remove((Node)node);
            userManager.saveUser(user);
            WXMCDebugLogger.info("Removed permission {} from {} (result: {})", permission, playerUuid, result.name());
            return result.wasSuccessful();
        }
    }
}

