/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.sounding;

import com.google.gson.annotations.SerializedName;

public class SoundingLevel {
    @SerializedName(value="height_m")
    private float heightM;
    @SerializedName(value="temperature_c")
    private float temperatureC;
    @SerializedName(value="dewpoint_c")
    private float dewpointC;
    @SerializedName(value="pressure_mb")
    private float pressureMb;
    @SerializedName(value="wind_direction_deg")
    private Float windDirectionDeg;
    @SerializedName(value="wind_speed_kts")
    private Float windSpeedKts;

    public SoundingLevel() {
    }

    public SoundingLevel(float heightM, float temperatureC, float dewpointC, float pressureMb) {
        this.heightM = heightM;
        this.temperatureC = temperatureC;
        this.dewpointC = dewpointC;
        this.pressureMb = pressureMb;
    }

    public SoundingLevel(float heightM, float temperatureC, float dewpointC, float pressureMb, Float windDirectionDeg, Float windSpeedKts) {
        this.heightM = heightM;
        this.temperatureC = temperatureC;
        this.dewpointC = dewpointC;
        this.pressureMb = pressureMb;
        this.windDirectionDeg = windDirectionDeg;
        this.windSpeedKts = windSpeedKts;
    }

    public float getHeightM() {
        return this.heightM;
    }

    public float getTemperatureC() {
        return this.temperatureC;
    }

    public float getDewpointC() {
        return this.dewpointC;
    }

    public float getPressureMb() {
        return this.pressureMb;
    }

    public Float getWindDirectionDeg() {
        return this.windDirectionDeg;
    }

    public Float getWindSpeedKts() {
        return this.windSpeedKts;
    }

    public boolean hasWindData() {
        return this.windDirectionDeg != null && this.windSpeedKts != null;
    }

    public float getWindU() {
        if (!this.hasWindData()) {
            return 0.0f;
        }
        return -this.windSpeedKts.floatValue() * (float)Math.sin(Math.toRadians(this.windDirectionDeg.floatValue()));
    }

    public float getWindV() {
        if (!this.hasWindData()) {
            return 0.0f;
        }
        return -this.windSpeedKts.floatValue() * (float)Math.cos(Math.toRadians(this.windDirectionDeg.floatValue()));
    }

    public float getVirtualTemperatureC() {
        float t = this.temperatureC;
        float dp = this.dewpointC;
        float p = this.pressureMb;
        float e = 6.11f * (float)Math.pow(10.0, 7.5f * dp / (237.3f + dp));
        float tKelvin = t + 273.15f;
        float tvKelvin = tKelvin / (1.0f - 0.379f * e / p);
        return tvKelvin - 273.15f;
    }

    public String toString() {
        return String.format("SoundingLevel[height=%.0fm, T=%.1f\u00b0C, Td=%.1f\u00b0C, P=%.1fmb]", Float.valueOf(this.heightM), Float.valueOf(this.temperatureC), Float.valueOf(this.dewpointC), Float.valueOf(this.pressureMb));
    }
}

