/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.sounding;

import dev.wxmc.weatheraddon.sounding.SoundingData;
import dev.wxmc.weatheraddon.sounding.SoundingLevel;

public class SoundingInterpolator {
    public static SoundingLevel interpolate(SoundingData sounding, float targetHeight) {
        if (sounding == null || !sounding.isValid()) {
            return null;
        }
        SoundingLevel below = sounding.getLevelBelow(targetHeight);
        SoundingLevel above = sounding.getLevelAbove(targetHeight);
        if (below == null || above == null) {
            return null;
        }
        if (below == above || below.getHeightM() == above.getHeightM()) {
            return below;
        }
        float t = (targetHeight - below.getHeightM()) / (above.getHeightM() - below.getHeightM());
        t = Math.max(0.0f, Math.min(1.0f, t));
        float temperature = SoundingInterpolator.lerp(below.getTemperatureC(), above.getTemperatureC(), t);
        float dewpoint = SoundingInterpolator.lerp(below.getDewpointC(), above.getDewpointC(), t);
        float pressure = SoundingInterpolator.lerp(below.getPressureMb(), above.getPressureMb(), t);
        Float windDir = null;
        Float windSpd = null;
        if (below.getWindDirectionDeg() != null && above.getWindDirectionDeg() != null) {
            windDir = Float.valueOf(SoundingInterpolator.lerpAngle(below.getWindDirectionDeg().floatValue(), above.getWindDirectionDeg().floatValue(), t));
            windSpd = Float.valueOf(SoundingInterpolator.lerp(below.getWindSpeedKts().floatValue(), above.getWindSpeedKts().floatValue(), t));
        }
        return new SoundingLevel(targetHeight, temperature, dewpoint, pressure, windDir, windSpd);
    }

    public static float[] interpolateForPMWeather(SoundingData sounding, float targetHeight) {
        SoundingLevel interpolated = SoundingInterpolator.interpolate(sounding, targetHeight);
        if (interpolated == null) {
            return null;
        }
        return new float[]{interpolated.getTemperatureC(), interpolated.getDewpointC(), interpolated.getPressureMb(), interpolated.getVirtualTemperatureC()};
    }

    private static float lerp(float a, float b, float t) {
        return a + (b - a) * t;
    }

    private static float lerpAngle(float a, float b, float t) {
        float diff = (b = (b % 360.0f + 360.0f) % 360.0f) - (a = (a % 360.0f + 360.0f) % 360.0f);
        if (diff > 180.0f) {
            diff -= 360.0f;
        }
        if (diff < -180.0f) {
            diff += 360.0f;
        }
        float result = a + diff * t;
        return (result % 360.0f + 360.0f) % 360.0f;
    }

    public static float calculateVirtualTemperature(float temperature, float dewpoint, float pressure) {
        float e = 6.11f * (float)Math.pow(10.0, 7.5f * dewpoint / (237.3f + dewpoint));
        float tKelvin = temperature + 273.15f;
        float tvKelvin = tKelvin / (1.0f - 0.379f * e / pressure);
        return tvKelvin - 273.15f;
    }
}

