/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.sounding;

import dev.wxmc.weatheraddon.Config;
import dev.wxmc.weatheraddon.sounding.SoundingData;
import dev.wxmc.weatheraddon.util.WXMCDebugLogger;
import java.util.concurrent.CompletableFuture;

public class SoundingFetcher {
    private static SoundingData currentSounding = null;
    private static long lastUpdateTime = 0L;
    private static String currentRiskCategory = null;

    public static void init() {
        WXMCDebugLogger.info("[SOUNDING] Client-side sounding storage initialized");
    }

    public static SoundingData getCurrentSounding() {
        return currentSounding;
    }

    public static boolean hasSounding() {
        boolean hasSounding = currentSounding != null && currentSounding.isValid();
        return hasSounding;
    }

    public static boolean hasSoundingWithDebug(String context) {
        boolean hasSounding;
        boolean bl = hasSounding = currentSounding != null && currentSounding.isValid();
        if (Config.shouldLogSoundingDebug()) {
            if (hasSounding) {
                WXMCDebugLogger.debug("[SOUNDING DEBUG] [CLIENT] hasSounding check ({}): TRUE - {} ({}) with {} levels", context, currentSounding.getStationId(), currentRiskCategory, currentSounding.getLevelCount());
            } else {
                WXMCDebugLogger.debug("[SOUNDING DEBUG] [CLIENT] hasSounding check ({}): FALSE - No valid sounding data available", context);
                if (currentSounding == null) {
                    WXMCDebugLogger.debug("[SOUNDING DEBUG] [CLIENT]   Reason: currentSounding is null");
                } else {
                    WXMCDebugLogger.debug("[SOUNDING DEBUG] [CLIENT]   Reason: sounding.isValid() returned false");
                }
            }
        }
        return hasSounding;
    }

    public static String getCurrentRiskCategory() {
        return currentRiskCategory;
    }

    public static long getSecondsSinceLastUpdate() {
        if (lastUpdateTime == 0L) {
            return -1L;
        }
        return (System.currentTimeMillis() - lastUpdateTime) / 1000L;
    }

    public static void clearCache() {
        currentSounding = null;
        currentRiskCategory = null;
        lastUpdateTime = 0L;
        WXMCDebugLogger.info("[SOUNDING] Client cache cleared");
    }

    public static void setSounding(SoundingData data) {
        SoundingData previousSounding = currentSounding;
        currentSounding = data;
        lastUpdateTime = System.currentTimeMillis();
        if (data != null) {
            WXMCDebugLogger.info("[SOUNDING] Received sounding: {} ({}) with {} levels", data.getStationId(), data.getStationName(), data.getLevelCount());
            if (Config.shouldLogSoundingDebug()) {
                WXMCDebugLogger.debug("[SOUNDING DEBUG] [CLIENT] ========== SOUNDING RECEIVED ==========");
                WXMCDebugLogger.debug("[SOUNDING DEBUG] [CLIENT] Station ID: {}", data.getStationId());
                WXMCDebugLogger.debug("[SOUNDING DEBUG] [CLIENT] Station Name: {}", data.getStationName());
                WXMCDebugLogger.debug("[SOUNDING DEBUG] [CLIENT] Level Count: {}", data.getLevelCount());
                WXMCDebugLogger.debug("[SOUNDING DEBUG] [CLIENT] Height Range: {}m - {}m", (int)data.getMinHeight(), (int)data.getMaxHeight());
                WXMCDebugLogger.debug("[SOUNDING DEBUG] [CLIENT] Valid: {}", data.isValid());
                WXMCDebugLogger.debug("[SOUNDING DEBUG] [CLIENT] Previous sounding: {}", previousSounding != null ? previousSounding.getStationId() : "none");
                WXMCDebugLogger.debug("[SOUNDING DEBUG] [CLIENT] ===========================================");
            }
        } else if (Config.shouldLogSoundingDebug()) {
            WXMCDebugLogger.debug("[SOUNDING DEBUG] [CLIENT] Received null sounding data!");
        }
    }

    public static void setSounding(SoundingData data, String riskCategory) {
        SoundingData previousSounding = currentSounding;
        String previousRisk = currentRiskCategory;
        currentSounding = data;
        currentRiskCategory = riskCategory;
        lastUpdateTime = System.currentTimeMillis();
        if (data != null) {
            WXMCDebugLogger.info("[SOUNDING] Received {} sounding: {} ({}) with {} levels", riskCategory, data.getStationId(), data.getStationName(), data.getLevelCount());
            if (Config.shouldLogSoundingDebug()) {
                WXMCDebugLogger.debug("[SOUNDING DEBUG] [CLIENT] ========== SOUNDING RECEIVED ==========");
                WXMCDebugLogger.debug("[SOUNDING DEBUG] [CLIENT] Risk Category: {}", riskCategory);
                WXMCDebugLogger.debug("[SOUNDING DEBUG] [CLIENT] Station ID: {}", data.getStationId());
                WXMCDebugLogger.debug("[SOUNDING DEBUG] [CLIENT] Station Name: {}", data.getStationName());
                WXMCDebugLogger.debug("[SOUNDING DEBUG] [CLIENT] Level Count: {}", data.getLevelCount());
                WXMCDebugLogger.debug("[SOUNDING DEBUG] [CLIENT] Height Range: {}m - {}m", (int)data.getMinHeight(), (int)data.getMaxHeight());
                WXMCDebugLogger.debug("[SOUNDING DEBUG] [CLIENT] Valid: {}", data.isValid());
                WXMCDebugLogger.debug("[SOUNDING DEBUG] [CLIENT] Previous: {} ({})", previousSounding != null ? previousSounding.getStationId() : "none", previousRisk != null ? previousRisk : "none");
                WXMCDebugLogger.debug("[SOUNDING DEBUG] [CLIENT] ===========================================");
            }
        } else if (Config.shouldLogSoundingDebug()) {
            WXMCDebugLogger.debug("[SOUNDING DEBUG] [CLIENT] Received null sounding data for risk category: {}", riskCategory);
        }
    }

    public static boolean isStale() {
        if (currentSounding == null) {
            return true;
        }
        long maxAgeMs = 1800000L;
        return System.currentTimeMillis() - lastUpdateTime > maxAgeMs;
    }

    @Deprecated
    public static CompletableFuture<SoundingData> fetchSounding() {
        return CompletableFuture.completedFuture(currentSounding);
    }

    public static String getDebugStatus() {
        StringBuilder sb = new StringBuilder();
        sb.append("=== Client Sounding Status ===\n");
        sb.append("Has Sounding: ").append(SoundingFetcher.hasSounding()).append("\n");
        sb.append("Current Sounding: ").append(currentSounding != null ? currentSounding.getStationId() : "null").append("\n");
        sb.append("Risk Category: ").append(currentRiskCategory != null ? currentRiskCategory : "unknown").append("\n");
        if (currentSounding != null) {
            sb.append("Station Name: ").append(currentSounding.getStationName()).append("\n");
            sb.append("Level Count: ").append(currentSounding.getLevelCount()).append("\n");
            sb.append("Height Range: ").append((int)currentSounding.getMinHeight()).append("m - ").append((int)currentSounding.getMaxHeight()).append("m\n");
            sb.append("Is Valid: ").append(currentSounding.isValid()).append("\n");
        }
        sb.append("Last Update: ");
        if (lastUpdateTime == 0L) {
            sb.append("Never\n");
        } else {
            long secondsAgo = SoundingFetcher.getSecondsSinceLastUpdate();
            sb.append(secondsAgo).append(" seconds ago\n");
        }
        sb.append("Is Stale: ").append(SoundingFetcher.isStale()).append("\n");
        return sb.toString();
    }

    public static void logDebugStatus() {
        if (Config.shouldLogSoundingDebug()) {
            WXMCDebugLogger.debug("[SOUNDING DEBUG] [CLIENT] Current Status:");
            WXMCDebugLogger.debug("[SOUNDING DEBUG] [CLIENT]   Has Sounding: {}", SoundingFetcher.hasSounding());
            WXMCDebugLogger.debug("[SOUNDING DEBUG] [CLIENT]   Current: {} ({})", currentSounding != null ? currentSounding.getStationId() : "null", currentRiskCategory != null ? currentRiskCategory : "unknown");
            if (currentSounding != null) {
                WXMCDebugLogger.debug("[SOUNDING DEBUG] [CLIENT]   Levels: {}, Range: {}m - {}m", currentSounding.getLevelCount(), (int)currentSounding.getMinHeight(), (int)currentSounding.getMaxHeight());
            }
            WXMCDebugLogger.debug("[SOUNDING DEBUG] [CLIENT]   Last Update: {} seconds ago", lastUpdateTime == 0L ? "never" : Long.valueOf(SoundingFetcher.getSecondsSinceLastUpdate()));
        }
    }
}

