/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.sounding;

import com.google.gson.annotations.SerializedName;
import dev.wxmc.weatheraddon.sounding.SoundingLevel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class SoundingData {
    private Metadata metadata;
    private Indices indices;
    private List<SoundingLevel> levels;
    private transient List<SoundingLevel> sortedLevels;
    private transient String sourceFileName;
    private transient String sourceFolder;

    public SoundingData() {
        this.levels = new ArrayList<SoundingLevel>();
    }

    public SoundingData(String stationId, String stationName, List<SoundingLevel> levels) {
        this.metadata = new Metadata();
        this.metadata.stationId = stationId;
        this.metadata.validTime = stationName;
        this.levels = levels != null ? levels : new ArrayList();
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public Indices getIndices() {
        return this.indices;
    }

    public List<SoundingLevel> getLevels() {
        return this.levels;
    }

    public String getStationId() {
        return this.metadata != null ? this.metadata.getStationId() : null;
    }

    public String getStationName() {
        if (this.metadata == null) {
            return null;
        }
        if (this.metadata.getLatitude() != 0.0 && this.metadata.getLongitude() != 0.0) {
            return String.format("%.2f, %.2f", this.metadata.getLatitude(), this.metadata.getLongitude());
        }
        return this.metadata.getValidTime();
    }

    public String getTimestamp() {
        return this.metadata != null ? this.metadata.getValidTime() : null;
    }

    public List<SoundingLevel> getSortedLevels() {
        if (this.sortedLevels == null && this.levels != null) {
            this.sortedLevels = new ArrayList<SoundingLevel>(this.levels);
            this.sortedLevels.sort(Comparator.comparingDouble(SoundingLevel::getHeightM));
        }
        return this.sortedLevels;
    }

    public boolean isValid() {
        return this.levels != null && !this.levels.isEmpty();
    }

    public float getMinHeight() {
        if (this.levels == null || this.levels.isEmpty()) {
            return 0.0f;
        }
        return (float)this.levels.stream().mapToDouble(SoundingLevel::getHeightM).min().orElse(0.0);
    }

    public float getMaxHeight() {
        if (this.levels == null || this.levels.isEmpty()) {
            return 0.0f;
        }
        return (float)this.levels.stream().mapToDouble(SoundingLevel::getHeightM).max().orElse(0.0);
    }

    public int getLevelCount() {
        return this.levels != null ? this.levels.size() : 0;
    }

    public boolean hasWindData() {
        if (this.levels == null || this.levels.isEmpty()) {
            return false;
        }
        return this.levels.stream().anyMatch(SoundingLevel::hasWindData);
    }

    public List<SoundingLevel> getWindLevels() {
        if (this.levels == null) {
            return new ArrayList<SoundingLevel>();
        }
        return this.levels.stream().filter(SoundingLevel::hasWindData).sorted(Comparator.comparingDouble(SoundingLevel::getHeightM)).toList();
    }

    public SoundingLevel getLevelBelow(float targetHeight) {
        List<SoundingLevel> sorted = this.getSortedLevels();
        if (sorted == null || sorted.isEmpty()) {
            return null;
        }
        SoundingLevel below = null;
        for (SoundingLevel level : sorted) {
            if (!(level.getHeightM() <= targetHeight)) break;
            below = level;
        }
        return below != null ? below : sorted.get(0);
    }

    public SoundingLevel getLevelAbove(float targetHeight) {
        List<SoundingLevel> sorted = this.getSortedLevels();
        if (sorted == null || sorted.isEmpty()) {
            return null;
        }
        for (SoundingLevel level : sorted) {
            if (!(level.getHeightM() >= targetHeight)) continue;
            return level;
        }
        return sorted.get(sorted.size() - 1);
    }

    public String toString() {
        return String.format("SoundingData[station=%s, levels=%d, range=%.0f-%.0fm]", this.getStationId(), this.getLevelCount(), Float.valueOf(this.getMinHeight()), Float.valueOf(this.getMaxHeight()));
    }

    public void setSourceFile(String fileName, String folder) {
        this.sourceFileName = fileName;
        this.sourceFolder = folder;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public String getSourceFolder() {
        return this.sourceFolder;
    }

    public boolean hasSourceInfo() {
        return this.sourceFileName != null && this.sourceFolder != null;
    }

    public static class Metadata {
        @SerializedName(value="station_id")
        private String stationId;
        @SerializedName(value="valid_time")
        private String validTime;
        private double latitude;
        private double longitude;
        private String source;
        private int levels;

        public String getStationId() {
            return this.stationId;
        }

        public String getValidTime() {
            return this.validTime;
        }

        public double getLatitude() {
            return this.latitude;
        }

        public double getLongitude() {
            return this.longitude;
        }

        public String getSource() {
            return this.source;
        }

        public int getLevelCount() {
            return this.levels;
        }
    }

    public static class Indices {
        @SerializedName(value="SBCAPE")
        private int sbcape;
        @SerializedName(value="SBCIN")
        private int sbcin;
        @SerializedName(value="MLCAPE")
        private int mlcape;
        @SerializedName(value="MLCIN")
        private int mlcin;
        @SerializedName(value="3CAPE")
        private int cape3km;
        @SerializedName(value="LCL_m_AGL")
        private int lclAgl;
        @SerializedName(value="LFC_m_AGL")
        private int lfcAgl;
        @SerializedName(value="EL_m_AGL")
        private int elAgl;
        @SerializedName(value="SRH_0_1km")
        private int srh01;
        @SerializedName(value="SRH_0_3km")
        private int srh03;
        @SerializedName(value="Shear_0_6km_kts")
        private int shear06;
        @SerializedName(value="RM_dir")
        private int rmDir;
        @SerializedName(value="RM_spd")
        private int rmSpd;
        @SerializedName(value="LM_dir")
        private int lmDir;
        @SerializedName(value="LM_spd")
        private int lmSpd;

        public int getSBCAPE() {
            return this.sbcape;
        }

        public int getSBCIN() {
            return this.sbcin;
        }

        public int getMLCAPE() {
            return this.mlcape;
        }

        public int getMLCIN() {
            return this.mlcin;
        }

        public int get3CAPE() {
            return this.cape3km;
        }

        public int getLCL() {
            return this.lclAgl;
        }

        public int getLFC() {
            return this.lfcAgl;
        }

        public int getEL() {
            return this.elAgl;
        }

        public int getSRH01() {
            return this.srh01;
        }

        public int getSRH03() {
            return this.srh03;
        }

        public int getShear06() {
            return this.shear06;
        }

        public int getRMDirection() {
            return this.rmDir;
        }

        public int getRMSpeed() {
            return this.rmSpd;
        }

        public int getLMDirection() {
            return this.lmDir;
        }

        public int getLMSpeed() {
            return this.lmSpd;
        }
    }
}

