/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.sounding;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.wxmc.weatheraddon.Config;
import dev.wxmc.weatheraddon.sounding.ServerSoundingManager;
import dev.wxmc.weatheraddon.sounding.SoundingData;
import dev.wxmc.weatheraddon.util.PermissionHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public class SoundingCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sounding").requires(source -> PermissionHelper.hasPermission(source, "wxmc.admin"))).then(Commands.literal((String)"status").executes(SoundingCommand::showStatus))).then(Commands.literal((String)"reload").executes(SoundingCommand::reloadFiles)));
    }

    private static int showStatus(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        boolean enabled = Config.isRealWorldSoundingsEnabled();
        SoundingData currentSounding = ServerSoundingManager.getCurrentSounding();
        ServerSoundingManager.RiskCategory currentRisk = ServerSoundingManager.getCurrentRisk();
        int totalCount = ServerSoundingManager.getTotalSoundingCount();
        source.sendSuccess(() -> Component.literal((String)"=== Server Sounding Status ===").withStyle(ChatFormatting.GOLD), false);
        source.sendSuccess(() -> Component.literal((String)"Enabled: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)(enabled ? "Yes" : "No")).withStyle(enabled ? ChatFormatting.GREEN : ChatFormatting.RED)), false);
        source.sendSuccess(() -> Component.literal((String)"Match Risk: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)(Config.shouldMatchSoundingToRisk() ? "Yes" : "No")).withStyle(ChatFormatting.WHITE)), false);
        source.sendSuccess(() -> Component.literal((String)"Change Interval: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)(Config.getSoundingChangeIntervalMinutes() + " minutes")).withStyle(ChatFormatting.WHITE)), false);
        source.sendSuccess(() -> Component.literal((String)"Total Soundings: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.valueOf(totalCount)).withStyle(totalCount > 0 ? ChatFormatting.GREEN : ChatFormatting.RED)), false);
        source.sendSuccess(() -> Component.literal((String)"By Category:").withStyle(ChatFormatting.GRAY), false);
        for (ServerSoundingManager.RiskCategory cat : ServerSoundingManager.RiskCategory.values()) {
            int count = ServerSoundingManager.getSoundingCount(cat);
            if (count <= 0) continue;
            source.sendSuccess(() -> Component.literal((String)("  " + cat.getFolderName() + ": ")).withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.literal((String)String.valueOf(count)).withStyle(ChatFormatting.WHITE)), false);
        }
        if (currentSounding != null) {
            source.sendSuccess(() -> Component.literal((String)"").append((Component)Component.literal((String)"Current Sounding:").withStyle(ChatFormatting.AQUA)), false);
            source.sendSuccess(() -> Component.literal((String)"  Station: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)(currentSounding.getStationId() + " (" + currentSounding.getStationName() + ")")).withStyle(ChatFormatting.WHITE)), false);
            source.sendSuccess(() -> Component.literal((String)"  Risk: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)(currentRisk != null ? currentRisk.getFolderName() : "Unknown")).withStyle(SoundingCommand.getRiskColor(currentRisk))), false);
            source.sendSuccess(() -> Component.literal((String)"  Levels: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)String.valueOf(currentSounding.getLevelCount())).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)(" (" + (int)currentSounding.getMinHeight() + "m - " + (int)currentSounding.getMaxHeight() + "m)")).withStyle(ChatFormatting.DARK_GRAY)), false);
        } else {
            source.sendSuccess(() -> Component.literal((String)"Current Sounding: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)"None loaded").withStyle(ChatFormatting.RED)), false);
        }
        return 1;
    }

    private static int reloadFiles(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.sendSuccess(() -> Component.literal((String)"Reloading sounding files...").withStyle(ChatFormatting.YELLOW), false);
        ServerSoundingManager.reload();
        int totalCount = ServerSoundingManager.getTotalSoundingCount();
        source.sendSuccess(() -> Component.literal((String)"Loaded ").withStyle(ChatFormatting.GREEN).append((Component)Component.literal((String)String.valueOf(totalCount)).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)" sounding files").withStyle(ChatFormatting.GREEN)), false);
        return 1;
    }

    private static ChatFormatting getRiskColor(ServerSoundingManager.RiskCategory risk) {
        if (risk == null) {
            return ChatFormatting.GRAY;
        }
        return switch (risk) {
            default -> throw new MatchException(null, null);
            case ServerSoundingManager.RiskCategory.HIGH -> ChatFormatting.LIGHT_PURPLE;
            case ServerSoundingManager.RiskCategory.MDT -> ChatFormatting.RED;
            case ServerSoundingManager.RiskCategory.ENH -> ChatFormatting.GOLD;
            case ServerSoundingManager.RiskCategory.SLGT -> ChatFormatting.YELLOW;
            case ServerSoundingManager.RiskCategory.MRGL -> ChatFormatting.GREEN;
            case ServerSoundingManager.RiskCategory.TSTM -> ChatFormatting.DARK_GREEN;
        };
    }
}

