/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.sounding;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.protomanly.pmweather.event.GameBusEvents;
import dev.protomanly.pmweather.weather.WeatherHandler;
import dev.wxmc.weatheraddon.Config;
import dev.wxmc.weatheraddon.WXMCWeatherAddon;
import dev.wxmc.weatheraddon.network.SoundingNetworkHandler;
import dev.wxmc.weatheraddon.outlook.OutlookManager;
import dev.wxmc.weatheraddon.sounding.SoundingData;
import dev.wxmc.weatheraddon.util.WXMCDebugLogger;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.loading.FMLPaths;

public class ServerSoundingManager {
    private static final Gson GSON = new GsonBuilder().create();
    private static final Map<RiskCategory, List<SoundingData>> soundingsByCategory = new EnumMap<RiskCategory, List<SoundingData>>(RiskCategory.class);
    private static SoundingData currentSounding = null;
    private static RiskCategory currentRisk = null;
    private static RiskCategory previousRisk = null;
    private static RiskCategory riskOverride = null;
    private static RiskCategory day1Override = null;
    private static RiskCategory day2Override = null;
    private static RiskCategory day3Override = null;
    private static long lastRiskCheck = 0L;
    private static final long RISK_CHECK_INTERVAL_MS = 5000L;
    private static MinecraftServer server = null;

    public static void init(MinecraftServer minecraftServer) {
        server = minecraftServer;
        ServerSoundingManager.loadAllSoundings();
        WXMCDebugLogger.info("[SERVER SOUNDING] Manager initialized");
        if (Config.shouldLogSoundingDebug()) {
            int total = ServerSoundingManager.getTotalSoundingCount();
            WXMCDebugLogger.debug("[SOUNDING DEBUG] ========== INITIALIZATION SUMMARY ==========");
            WXMCDebugLogger.debug("[SOUNDING DEBUG] Real-world soundings enabled: {}", Config.isRealWorldSoundingsEnabled());
            WXMCDebugLogger.debug("[SOUNDING DEBUG] Match risk to PMWeather: {}", Config.shouldMatchSoundingToRisk());
            WXMCDebugLogger.debug("[SOUNDING DEBUG] Change interval: {} minutes", Config.getSoundingChangeIntervalMinutes());
            WXMCDebugLogger.debug("[SOUNDING DEBUG] Soundings directory: {}", ServerSoundingManager.getSoundingsPath().toAbsolutePath());
            WXMCDebugLogger.debug("[SOUNDING DEBUG] Total soundings loaded: {}", total);
            for (RiskCategory cat : RiskCategory.values()) {
                int count = ServerSoundingManager.getSoundingCount(cat);
                WXMCDebugLogger.debug("[SOUNDING DEBUG]   {}: {} soundings", cat.getFolderName(), count);
            }
            if (total == 0) {
                WXMCDebugLogger.debug("[SOUNDING DEBUG] WARNING: No soundings loaded! PMWeather fallback will be used.");
                WXMCDebugLogger.debug("[SOUNDING DEBUG] Add JSON sounding files to: {}", ServerSoundingManager.getSoundingsPath().toAbsolutePath());
            }
            WXMCDebugLogger.debug("[SOUNDING DEBUG] =============================================");
        }
    }

    public static void shutdown() {
        server = null;
        currentSounding = null;
        currentRisk = null;
        soundingsByCategory.clear();
        WXMCDebugLogger.info("[SERVER SOUNDING] Manager shutdown");
    }

    public static void loadAllSoundings() {
        soundingsByCategory.clear();
        Path soundingsRoot = ServerSoundingManager.getSoundingsPath();
        ServerSoundingManager.createDirectoryStructure(soundingsRoot);
        int totalLoaded = 0;
        for (RiskCategory category : RiskCategory.values()) {
            Path categoryPath = soundingsRoot.resolve(category.getFolderName());
            List<SoundingData> soundings = ServerSoundingManager.loadSoundingsFromDirectory(categoryPath);
            soundingsByCategory.put(category, soundings);
            totalLoaded += soundings.size();
            if (soundings.isEmpty()) continue;
            WXMCDebugLogger.info("[SERVER SOUNDING] Loaded {} soundings for {}", soundings.size(), category.getFolderName());
        }
        WXMCDebugLogger.info("[SERVER SOUNDING] Total loaded: {} soundings across {} categories", totalLoaded, RiskCategory.values().length);
    }

    public static Path getSoundingsPath() {
        return FMLPaths.CONFIGDIR.get().resolve("wxmc").resolve("soundings");
    }

    private static void createDirectoryStructure(Path root) {
        try {
            Files.createDirectories(root, new FileAttribute[0]);
            for (RiskCategory category : RiskCategory.values()) {
                Files.createDirectories(root.resolve(category.getFolderName()), new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            WXMCWeatherAddon.LOGGER.error("[SERVER SOUNDING] Failed to create directory structure: {}", (Object)e.getMessage());
        }
    }

    private static List<SoundingData> loadSoundingsFromDirectory(Path directory) {
        ArrayList<SoundingData> soundings = new ArrayList<SoundingData>();
        if (!Files.exists(directory, new LinkOption[0]) || !Files.isDirectory(directory, new LinkOption[0])) {
            return soundings;
        }
        String folderName = directory.getFileName().toString();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory, "*.json");){
            for (Path file : stream) {
                try {
                    String json = Files.readString(file);
                    SoundingData data = (SoundingData)GSON.fromJson(json, SoundingData.class);
                    if (data != null && data.isValid()) {
                        data.setSourceFile(file.getFileName().toString(), folderName);
                        soundings.add(data);
                        continue;
                    }
                    WXMCDebugLogger.debug("[SERVER SOUNDING] Invalid sounding file: {}", file.getFileName());
                }
                catch (Exception e) {
                    WXMCWeatherAddon.LOGGER.error("[SERVER SOUNDING] Failed to load {}: {}", (Object)file.getFileName(), (Object)e.getMessage());
                }
            }
        }
        catch (IOException e) {
            WXMCWeatherAddon.LOGGER.error("[SERVER SOUNDING] Failed to read directory {}: {}", (Object)directory, (Object)e.getMessage());
        }
        return soundings;
    }

    public static void onServerTick() {
        if (!Config.isRealWorldSoundingsEnabled()) {
            return;
        }
        if (server == null) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - lastRiskCheck >= 5000L) {
            lastRiskCheck = now;
            RiskCategory newRisk = ServerSoundingManager.calculateCurrentRisk();
            if (Config.shouldLogSoundingDebug()) {
                WXMCDebugLogger.debug("[SOUNDING DEBUG] Tick check - Current risk: {}, Previous risk: {}, Has sounding: {}", newRisk != null ? newRisk.getFolderName() : "null", previousRisk != null ? previousRisk.getFolderName() : "null", currentSounding != null);
            }
            if (currentSounding == null || newRisk != previousRisk && newRisk != null) {
                if (previousRisk != null && newRisk != previousRisk) {
                    WXMCDebugLogger.info("[SERVER SOUNDING] Risk changed from {} to {}", previousRisk.getFolderName(), newRisk.getFolderName());
                }
                if (currentSounding == null && Config.shouldLogSoundingDebug()) {
                    WXMCDebugLogger.debug("[SOUNDING DEBUG] No current sounding - attempting to select one for risk: {}", newRisk != null ? newRisk.getFolderName() : "null");
                }
                previousRisk = newRisk;
                ServerSoundingManager.updateSoundingForRisk(newRisk);
            }
        }
    }

    public static void updateSounding() {
        RiskCategory risk = ServerSoundingManager.calculateCurrentRisk();
        ServerSoundingManager.updateSoundingForRisk(risk);
    }

    private static void updateSoundingForRisk(RiskCategory risk) {
        if (risk == null) {
            return;
        }
        SoundingData newSounding = ServerSoundingManager.selectSoundingForRisk(risk);
        if (newSounding != null) {
            currentSounding = newSounding;
            currentRisk = risk;
            WXMCDebugLogger.info("[SERVER SOUNDING] Selected {} sounding: {} ({})", risk.getFolderName(), newSounding.getStationId(), newSounding.getStationName());
            ServerSoundingManager.syncToAllClients();
        }
    }

    public static RiskCategory calculateCurrentRisk() {
        if (riskOverride != null) {
            if (Config.shouldLogSoundingDebug()) {
                WXMCDebugLogger.debug("[SOUNDING DEBUG] Using manual risk override: {}", riskOverride.getFolderName());
            }
            return riskOverride;
        }
        if (server == null) {
            if (Config.shouldLogSoundingDebug()) {
                WXMCDebugLogger.debug("[SOUNDING DEBUG] calculateCurrentRisk: Server is null, defaulting to TSTM");
            }
            return RiskCategory.TSTM;
        }
        try {
            ServerLevel level = server.overworld();
            if (level == null) {
                if (Config.shouldLogSoundingDebug()) {
                    WXMCDebugLogger.debug("[SOUNDING DEBUG] calculateCurrentRisk: Overworld level is null, defaulting to TSTM");
                }
                return RiskCategory.TSTM;
            }
            List players = level.players();
            if (!players.isEmpty()) {
                ServerPlayer player = (ServerPlayer)players.get(0);
                surfaceY = level.getHeight(Heightmap.Types.WORLD_SURFACE, (int)player.getX(), (int)player.getZ());
                Vec3 pos = new Vec3(player.getX(), (double)surfaceY, player.getZ());
            } else {
                BlockPos spawnPos = level.getSharedSpawnPos();
                surfaceY = level.getHeight(Heightmap.Types.WORLD_SURFACE, spawnPos.getX(), spawnPos.getZ());
                Vec3 pos = new Vec3((double)spawnPos.getX(), (double)surfaceY, (double)spawnPos.getZ());
            }
            WeatherHandler weatherHandler = (WeatherHandler)GameBusEvents.MANAGERS.get(level.dimension());
            if (weatherHandler == null) {
                if (Config.shouldLogSoundingDebug()) {
                    WXMCDebugLogger.debug("[SOUNDING DEBUG] calculateCurrentRisk: PMWeather WeatherHandler not available for dimension {}, defaulting to TSTM", level.dimension().location());
                }
                return RiskCategory.TSTM;
            }
            float riskValue = OutlookManager.getCurrentRiskValue();
            RiskCategory category = ServerSoundingManager.riskValueToCategory(riskValue);
            if (Config.shouldLogSoundingDebug()) {
                WXMCDebugLogger.debug("[SOUNDING DEBUG] Current Day 1 risk: {} (value: {})", category.getFolderName(), String.format("%.3f", Float.valueOf(riskValue)));
            }
            return category;
        }
        catch (Exception e) {
            WXMCWeatherAddon.LOGGER.error("[SERVER SOUNDING] Error calculating risk from PMWeather: {}", (Object)e.getMessage());
            if (Config.shouldLogSoundingDebug()) {
                WXMCDebugLogger.debug("[SOUNDING DEBUG] Full exception: ", e);
            }
            return RiskCategory.TSTM;
        }
    }

    private static RiskCategory riskValueToCategory(float riskValue) {
        if (riskValue > 1.5f) {
            return RiskCategory.HIGH;
        }
        if (riskValue > 1.2f) {
            return RiskCategory.MDT;
        }
        if (riskValue > 0.8f) {
            return RiskCategory.ENH;
        }
        if (riskValue > 0.6f) {
            return RiskCategory.SLGT;
        }
        if (riskValue > 0.3f) {
            return RiskCategory.MRGL;
        }
        return RiskCategory.TSTM;
    }

    private static SoundingData selectSoundingForRisk(RiskCategory targetRisk) {
        int startIdx;
        List<SoundingData> candidates;
        if (Config.shouldLogSoundingDebug()) {
            WXMCDebugLogger.debug("[SOUNDING DEBUG] Selecting sounding for risk category: {}", targetRisk.getFolderName());
        }
        if ((candidates = soundingsByCategory.get((Object)targetRisk)) != null && !candidates.isEmpty()) {
            SoundingData selected = candidates.get(ThreadLocalRandom.current().nextInt(candidates.size()));
            if (Config.shouldLogSoundingDebug()) {
                WXMCDebugLogger.debug("[SOUNDING DEBUG] Selected from target category {}: {} ({}) - {} of {} available", targetRisk.getFolderName(), selected.getStationId(), selected.getStationName(), 1, candidates.size());
            }
            return selected;
        }
        if (Config.shouldLogSoundingDebug()) {
            WXMCDebugLogger.debug("[SOUNDING DEBUG] No soundings in target category {}, trying fallback...", targetRisk.getFolderName());
        }
        RiskCategory[] fallbackOrder = RiskCategory.values();
        for (int i = startIdx = targetRisk.ordinal() + 1; i < fallbackOrder.length; ++i) {
            candidates = soundingsByCategory.get((Object)fallbackOrder[i]);
            if (candidates == null || candidates.isEmpty()) continue;
            SoundingData selected = candidates.get(ThreadLocalRandom.current().nextInt(candidates.size()));
            WXMCDebugLogger.info("[SERVER SOUNDING] Falling back from {} to {}", new Object[]{targetRisk, fallbackOrder[i]});
            if (Config.shouldLogSoundingDebug()) {
                WXMCDebugLogger.debug("[SOUNDING DEBUG] Fallback selected: {} ({}) from category {}", selected.getStationId(), selected.getStationName(), fallbackOrder[i].getFolderName());
            }
            return selected;
        }
        if (Config.shouldLogSoundingDebug()) {
            WXMCDebugLogger.debug("[SOUNDING DEBUG] No soundings in lower categories, trying any category...");
        }
        for (RiskCategory cat : RiskCategory.values()) {
            candidates = soundingsByCategory.get((Object)cat);
            if (candidates == null || candidates.isEmpty()) continue;
            SoundingData selected = candidates.get(ThreadLocalRandom.current().nextInt(candidates.size()));
            if (Config.shouldLogSoundingDebug()) {
                WXMCDebugLogger.debug("[SOUNDING DEBUG] Last resort - selected {} ({}) from category {}", selected.getStationId(), selected.getStationName(), cat.getFolderName());
            }
            return selected;
        }
        WXMCDebugLogger.debug("[SERVER SOUNDING] No soundings available in any category!");
        if (Config.shouldLogSoundingDebug()) {
            WXMCDebugLogger.debug("[SOUNDING DEBUG] ========================================");
            WXMCDebugLogger.debug("[SOUNDING DEBUG] FALLBACK TO PMWEATHER ACTIVATED!");
            WXMCDebugLogger.debug("[SOUNDING DEBUG] No WXMC sounding files found.");
            WXMCDebugLogger.debug("[SOUNDING DEBUG] PMWeather's noise-based simulation will be used.");
            WXMCDebugLogger.debug("[SOUNDING DEBUG] To use real soundings, add JSON files to:");
            WXMCDebugLogger.debug("[SOUNDING DEBUG]   {}", ServerSoundingManager.getSoundingsPath().toAbsolutePath());
            WXMCDebugLogger.debug("[SOUNDING DEBUG] ========================================");
        }
        return null;
    }

    public static void syncToAllClients() {
        if (currentSounding == null) {
            return;
        }
        SoundingNetworkHandler.broadcastSounding(currentSounding, currentRisk);
    }

    public static void syncToPlayer(ServerPlayer player) {
        if (currentSounding == null) {
            return;
        }
        SoundingNetworkHandler.sendSounding(player, currentSounding, currentRisk);
    }

    public static void forceUpdate() {
        previousRisk = null;
        ServerSoundingManager.updateSounding();
    }

    public static void forceRisk(RiskCategory risk) {
        SoundingData sounding = ServerSoundingManager.selectSoundingForRisk(risk);
        if (sounding != null) {
            currentSounding = sounding;
            currentRisk = risk;
            ServerSoundingManager.syncToAllClients();
        }
    }

    public static void setRiskOverride(RiskCategory risk) {
        RiskCategory previousOverride = riskOverride;
        riskOverride = risk;
        if (risk != null) {
            WXMCDebugLogger.info("[SERVER SOUNDING] Risk override SET to: {}", risk.getFolderName());
            previousRisk = null;
            ServerSoundingManager.updateSoundingForRisk(risk);
        } else {
            WXMCDebugLogger.info("[SERVER SOUNDING] Risk override CLEARED - reverting to PMWeather calculation");
            previousRisk = null;
            ServerSoundingManager.updateSounding();
        }
    }

    public static void clearRiskOverride() {
        ServerSoundingManager.setRiskOverride(null);
    }

    public static boolean hasRiskOverride() {
        return riskOverride != null;
    }

    public static RiskCategory getRiskOverride() {
        return riskOverride;
    }

    public static void setDay1Override(RiskCategory risk) {
        day1Override = risk;
        if (risk != null) {
            WXMCDebugLogger.info("[SERVER SOUNDING] Day 1 outlook override SET to: {}", risk.getFolderName());
        } else {
            WXMCDebugLogger.info("[SERVER SOUNDING] Day 1 outlook override CLEARED");
        }
    }

    public static void setDay2Override(RiskCategory risk) {
        day2Override = risk;
        if (risk != null) {
            WXMCDebugLogger.info("[SERVER SOUNDING] Day 2 outlook override SET to: {}", risk.getFolderName());
        } else {
            WXMCDebugLogger.info("[SERVER SOUNDING] Day 2 outlook override CLEARED");
        }
    }

    public static void setDay3Override(RiskCategory risk) {
        day3Override = risk;
        if (risk != null) {
            WXMCDebugLogger.info("[SERVER SOUNDING] Day 3 outlook override SET to: {}", risk.getFolderName());
        } else {
            WXMCDebugLogger.info("[SERVER SOUNDING] Day 3 outlook override CLEARED");
        }
    }

    public static void clearDayOverrides() {
        day1Override = null;
        day2Override = null;
        day3Override = null;
        WXMCDebugLogger.info("[SERVER SOUNDING] All day outlook overrides CLEARED");
    }

    public static RiskCategory getDay1Override() {
        return day1Override;
    }

    public static RiskCategory getDay2Override() {
        return day2Override;
    }

    public static RiskCategory getDay3Override() {
        return day3Override;
    }

    public static boolean hasAnyDayOverride() {
        return day1Override != null || day2Override != null || day3Override != null;
    }

    public static RiskCategory getOverrideForAdvance(int advanceTicks) {
        if (advanceTicks < 24000) {
            return day1Override;
        }
        if (advanceTicks < 48000) {
            return day2Override;
        }
        return day3Override;
    }

    public static void reload() {
        ServerSoundingManager.loadAllSoundings();
        ServerSoundingManager.updateSounding();
    }

    public static SoundingData getCurrentSounding() {
        return currentSounding;
    }

    public static RiskCategory getCurrentRisk() {
        return currentRisk;
    }

    public static int getSoundingCount(RiskCategory category) {
        List<SoundingData> list = soundingsByCategory.get((Object)category);
        return list != null ? list.size() : 0;
    }

    public static int getTotalSoundingCount() {
        int total = 0;
        for (List<SoundingData> list : soundingsByCategory.values()) {
            total += list.size();
        }
        return total;
    }

    public static enum RiskCategory {
        HIGH("HIGH"),
        MDT("MDT"),
        ENH("ENH"),
        SLGT("SLGT"),
        MRGL("MRGL"),
        TSTM("TSTM");

        private final String folderName;

        private RiskCategory(String folderName) {
            this.folderName = folderName;
        }

        public String getFolderName() {
            return this.folderName;
        }
    }
}

