/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.radar;

import dev.wxmc.weatheraddon.radar.ColorTablePreset;
import dev.wxmc.weatheraddon.radar.VelocityColorTablePreset;
import java.awt.Color;
import net.minecraft.util.Mth;

public class WXMCColorTables {
    public static Color getReflectivity(ColorTablePreset preset, float dbz, Color startColor) {
        return switch (preset) {
            default -> throw new MatchException(null, null);
            case ColorTablePreset.BEN_MITCHELL -> WXMCColorTables.getBenMitchellReflectivity(dbz, startColor);
            case ColorTablePreset.COD -> WXMCColorTables.getCoDReflectivity(dbz, startColor);
            case ColorTablePreset.PMWEATHER_DEFAULT -> WXMCColorTables.getPMWeatherReflectivity(dbz, startColor);
            case ColorTablePreset.RADAR_OMEGA -> WXMCColorTables.getRadarOmegaReflectivity(dbz, startColor);
            case ColorTablePreset.RADAR_SCOPE -> WXMCColorTables.getRadarScopeReflectivity(dbz, startColor);
        };
    }

    public static Color lerp(float delta, Color c1, Color c2) {
        delta = Mth.clamp((float)delta, (float)0.0f, (float)1.0f);
        return new Color((int)Mth.lerp((float)delta, (float)c1.getRed(), (float)c2.getRed()), (int)Mth.lerp((float)delta, (float)c1.getGreen(), (float)c2.getGreen()), (int)Mth.lerp((float)delta, (float)c1.getBlue(), (float)c2.getBlue()));
    }

    private static Color getPMWeatherReflectivity(float val, Color startColor) {
        Color color = startColor;
        color = WXMCColorTables.lerp(Math.clamp(val / 19.0f, 0.0f, 1.0f), color, new Color(6069678));
        color = WXMCColorTables.lerp(Math.clamp((val - 19.0f) / 8.0f, 0.0f, 1.0f), color, new Color(746505));
        color = WXMCColorTables.lerp(Math.clamp((val - 27.0f) / 13.0f, 0.0f, 1.0f), color, new Color(12956416));
        if (val >= 40.0f) {
            color = new Color(16421888);
        }
        color = WXMCColorTables.lerp(Math.clamp((val - 40.0f) / 10.0f, 0.0f, 1.0f), color, new Color(11688204));
        if (val >= 50.0f) {
            color = new Color(16327435);
        }
        color = WXMCColorTables.lerp(Math.clamp((val - 50.0f) / 10.0f, 0.0f, 1.0f), color, new Color(0x822820));
        if (val >= 60.0f) {
            color = new Color(13277620);
        }
        color = WXMCColorTables.lerp(Math.clamp((val - 60.0f) / 10.0f, 0.0f, 1.0f), color, new Color(12721266));
        if (val >= 70.0f) {
            color = new Color(0xFFFFFF);
        }
        return color;
    }

    private static Color getBenMitchellReflectivity(float val, Color startColor) {
        if (val < 10.0f) {
            return startColor;
        }
        Color color = startColor;
        color = WXMCColorTables.lerpRange(val, 10.0f, 12.0f, startColor, new Color(106, 90, 205), color);
        color = WXMCColorTables.lerpRange(val, 12.0f, 14.0f, new Color(106, 90, 205), new Color(72, 61, 139), color);
        color = WXMCColorTables.lerpRange(val, 14.0f, 16.0f, new Color(72, 61, 139), new Color(70, 130, 180), color);
        color = WXMCColorTables.lerpRange(val, 16.0f, 18.0f, new Color(70, 130, 180), new Color(95, 158, 160), color);
        color = WXMCColorTables.lerpRange(val, 18.0f, 20.0f, new Color(95, 158, 160), new Color(0, 139, 139), color);
        color = WXMCColorTables.lerpRange(val, 20.0f, 22.0f, new Color(0, 139, 139), new Color(34, 139, 34), color);
        color = WXMCColorTables.lerpRange(val, 22.0f, 24.0f, new Color(34, 139, 34), new Color(60, 179, 113), color);
        color = WXMCColorTables.lerpRange(val, 24.0f, 26.0f, new Color(60, 179, 113), new Color(107, 142, 35), color);
        color = WXMCColorTables.lerpRange(val, 26.0f, 28.0f, new Color(107, 142, 35), new Color(154, 205, 50), color);
        color = WXMCColorTables.lerpRange(val, 28.0f, 30.0f, new Color(154, 205, 50), new Color(205, 173, 0), color);
        color = WXMCColorTables.lerpRange(val, 30.0f, 32.0f, new Color(205, 173, 0), new Color(255, 215, 0), color);
        color = WXMCColorTables.lerpRange(val, 32.0f, 34.0f, new Color(255, 215, 0), new Color(255, 255, 0), color);
        color = WXMCColorTables.lerpRange(val, 34.0f, 36.0f, new Color(255, 255, 0), new Color(255, 165, 0), color);
        color = WXMCColorTables.lerpRange(val, 36.0f, 38.0f, new Color(255, 165, 0), new Color(255, 140, 0), color);
        color = WXMCColorTables.lerpRange(val, 38.0f, 40.0f, new Color(255, 140, 0), new Color(255, 127, 0), color);
        color = WXMCColorTables.lerpRange(val, 40.0f, 42.0f, new Color(255, 127, 0), new Color(255, 99, 71), color);
        color = WXMCColorTables.lerpRange(val, 42.0f, 44.0f, new Color(255, 99, 71), new Color(255, 69, 0), color);
        color = WXMCColorTables.lerpRange(val, 44.0f, 46.0f, new Color(255, 69, 0), new Color(226, 1, 30), color);
        color = WXMCColorTables.lerpRange(val, 46.0f, 48.0f, new Color(226, 1, 30), new Color(200, 6, 30), color);
        color = WXMCColorTables.lerpRange(val, 48.0f, 50.0f, new Color(200, 6, 30), new Color(185, 1, 30), color);
        color = WXMCColorTables.lerpRange(val, 50.0f, 52.0f, new Color(185, 1, 30), new Color(252, 156, 156), color);
        color = WXMCColorTables.lerpRange(val, 52.0f, 54.0f, new Color(252, 156, 156), new Color(255, 182, 193), color);
        color = WXMCColorTables.lerpRange(val, 54.0f, 56.0f, new Color(255, 182, 193), new Color(238, 130, 238), color);
        color = WXMCColorTables.lerpRange(val, 56.0f, 58.0f, new Color(238, 130, 238), new Color(219, 112, 147), color);
        color = WXMCColorTables.lerpRange(val, 58.0f, 60.0f, new Color(219, 112, 147), new Color(218, 112, 214), color);
        color = WXMCColorTables.lerpRange(val, 60.0f, 62.0f, new Color(218, 112, 214), new Color(186, 85, 211), color);
        color = WXMCColorTables.lerpRange(val, 62.0f, 64.0f, new Color(186, 85, 211), new Color(153, 50, 204), color);
        color = WXMCColorTables.lerpRange(val, 64.0f, 66.0f, new Color(153, 50, 204), new Color(160, 32, 240), color);
        color = WXMCColorTables.lerpRange(val, 66.0f, 68.0f, new Color(160, 32, 240), new Color(159, 121, 238), color);
        color = WXMCColorTables.lerpRange(val, 68.0f, 70.0f, new Color(159, 121, 238), new Color(171, 130, 255), color);
        color = WXMCColorTables.lerpRange(val, 70.0f, 72.0f, new Color(171, 130, 255), new Color(138, 143, 255), color);
        color = WXMCColorTables.lerpRange(val, 72.0f, 74.0f, new Color(138, 143, 255), new Color(54, 62, 255), color);
        color = WXMCColorTables.lerpRange(val, 74.0f, 76.0f, new Color(54, 62, 255), new Color(45, 48, 122), color);
        color = WXMCColorTables.lerpRange(val, 76.0f, 78.0f, new Color(45, 48, 122), new Color(45, 48, 82), color);
        color = WXMCColorTables.lerpRange(val, 78.0f, 80.0f, new Color(45, 48, 82), new Color(32, 40, 44), color);
        if (val >= 80.0f) {
            color = new Color(0, 0, 0);
        }
        color = WXMCColorTables.lerpRange(val, 80.0f, 82.0f, new Color(0, 0, 0), new Color(64, 64, 64), color);
        color = WXMCColorTables.lerpRange(val, 82.0f, 84.0f, new Color(64, 64, 64), new Color(102, 102, 102), color);
        color = WXMCColorTables.lerpRange(val, 84.0f, 86.0f, new Color(102, 102, 102), new Color(140, 140, 140), color);
        color = WXMCColorTables.lerpRange(val, 86.0f, 88.0f, new Color(140, 140, 140), new Color(179, 179, 179), color);
        color = WXMCColorTables.lerpRange(val, 88.0f, 90.0f, new Color(179, 179, 179), new Color(204, 204, 204), color);
        color = WXMCColorTables.lerpRange(val, 90.0f, 92.0f, new Color(204, 204, 204), new Color(230, 230, 230), color);
        color = WXMCColorTables.lerpRange(val, 92.0f, 94.0f, new Color(230, 230, 230), new Color(255, 255, 255), color);
        if (val >= 94.0f) {
            color = new Color(255, 255, 255);
        }
        return color;
    }

    private static Color getCoDReflectivity(float val, Color startColor) {
        if (val < 5.0f) {
            return startColor;
        }
        Color color = startColor;
        color = WXMCColorTables.lerpRange(val, 5.0f, 25.0f, new Color(16, 78, 139), new Color(0, 238, 238), color);
        color = WXMCColorTables.lerpRange(val, 25.0f, 38.0f, new Color(0, 139, 0), new Color(127, 255, 0), color);
        color = WXMCColorTables.lerpRange(val, 38.0f, 50.0f, new Color(255, 255, 0), new Color(255, 127, 0), color);
        color = WXMCColorTables.lerpRange(val, 50.0f, 65.0f, new Color(255, 0, 0), new Color(139, 0, 0), color);
        color = WXMCColorTables.lerpRange(val, 65.0f, 75.0f, new Color(255, 0, 255), new Color(145, 44, 238), color);
        color = WXMCColorTables.lerpRange(val, 75.0f, 80.0f, new Color(255, 228, 220), new Color(255, 255, 255), color);
        if (val >= 80.0f) {
            color = new Color(255, 255, 255);
        }
        return color;
    }

    private static Color getRadarOmegaReflectivity(float val, Color startColor) {
        if (val < 0.0f) {
            return startColor;
        }
        Color color = startColor;
        color = WXMCColorTables.lerpRange(val, 0.0f, 20.0f, new Color(62, 69, 71), new Color(191, 193, 197), color);
        color = WXMCColorTables.lerpRange(val, 20.0f, 30.0f, new Color(191, 193, 197), new Color(135, 229, 125), color);
        color = WXMCColorTables.lerpRange(val, 30.0f, 35.0f, new Color(135, 229, 125), new Color(48, 102, 43), color);
        color = WXMCColorTables.lerpRange(val, 35.0f, 50.0f, new Color(48, 102, 43), new Color(253, 227, 0), color);
        color = WXMCColorTables.lerpRange(val, 50.0f, 60.0f, new Color(254, 26, 0), new Color(181, 0, 52), color);
        color = WXMCColorTables.lerpRange(val, 60.0f, 70.0f, new Color(163, 0, 136), new Color(254, 4, 250), color);
        color = WXMCColorTables.lerpRange(val, 70.0f, 80.0f, new Color(67, 190, 254), new Color(19, 144, 242), color);
        color = WXMCColorTables.lerpRange(val, 80.0f, 85.0f, new Color(166, 176, 150), new Color(255, 231, 188), color);
        if (val >= 85.0f) {
            color = new Color(255, 231, 188);
        }
        return color;
    }

    private static Color getRadarScopeReflectivity(float val, Color startColor) {
        if (val < 5.0f) {
            return startColor;
        }
        Color color = startColor;
        color = WXMCColorTables.lerpRange(val, 5.0f, 17.5f, new Color(29, 37, 60), new Color(89, 155, 171), color);
        color = WXMCColorTables.lerpRange(val, 17.5f, 22.5f, new Color(89, 155, 171), new Color(33, 186, 72), color);
        color = WXMCColorTables.lerpRange(val, 22.5f, 32.5f, new Color(33, 186, 72), new Color(5, 101, 1), color);
        color = WXMCColorTables.lerpRange(val, 32.5f, 37.5f, new Color(5, 101, 1), new Color(251, 252, 0), color);
        color = WXMCColorTables.lerpRange(val, 37.5f, 42.5f, new Color(199, 176, 0), new Color(253, 149, 2), color);
        color = WXMCColorTables.lerpRange(val, 42.5f, 50.0f, new Color(172, 92, 2), new Color(253, 38, 0), color);
        color = WXMCColorTables.lerpRange(val, 50.0f, 60.0f, new Color(135, 43, 22), new Color(193, 148, 179), color);
        color = WXMCColorTables.lerpRange(val, 60.0f, 70.0f, new Color(200, 23, 119), new Color(165, 2, 215), color);
        color = WXMCColorTables.lerpRange(val, 70.0f, 75.0f, new Color(64, 0, 146), new Color(135, 255, 253), color);
        color = WXMCColorTables.lerpRange(val, 75.0f, 80.0f, new Color(54, 120, 142), new Color(173, 99, 64), color);
        color = WXMCColorTables.lerpRange(val, 80.0f, 85.0f, new Color(173, 99, 64), new Color(105, 0, 4), color);
        color = WXMCColorTables.lerpRange(val, 85.0f, 95.0f, new Color(105, 0, 4), new Color(0, 0, 0), color);
        return color;
    }

    public static Color getVelocity(VelocityColorTablePreset preset, float vel) {
        return switch (preset) {
            default -> throw new MatchException(null, null);
            case VelocityColorTablePreset.PMWEATHER_DEFAULT -> null;
            case VelocityColorTablePreset.ALPHA -> WXMCColorTables.getAlphaVelocity(vel);
            case VelocityColorTablePreset.MACDONALD_EMMERSON -> WXMCColorTables.getMacDonaldEmmersonVelocity(vel);
            case VelocityColorTablePreset.SAM_BV -> WXMCColorTables.getSamBVVelocity(vel);
            case VelocityColorTablePreset.SR_RADAR_LOOPS -> WXMCColorTables.getSRRadarLoopsVelocity(vel);
        };
    }

    private static Color getAlphaVelocity(float vel) {
        float kts = vel;
        Color color = new Color(128, 128, 128);
        if (kts <= -120.0f) {
            return new Color(0, 0, 155);
        }
        if (kts <= -50.0f) {
            return WXMCColorTables.lerpVel(kts, -120.0f, -50.0f, new Color(0, 0, 155), new Color(0, 255, 255));
        }
        if (kts <= -10.0f) {
            return WXMCColorTables.lerpVel(kts, -50.0f, -10.0f, new Color(0, 255, 255), new Color(0, 102, 0));
        }
        if (kts <= 0.0f) {
            return WXMCColorTables.lerpVel(kts, -10.0f, 0.0f, new Color(0, 102, 0), new Color(128, 128, 128));
        }
        if (kts <= 10.0f) {
            return WXMCColorTables.lerpVel(kts, 0.0f, 10.0f, new Color(128, 128, 128), new Color(96, 13, 23));
        }
        if (kts <= 30.0f) {
            return WXMCColorTables.lerpVel(kts, 10.0f, 30.0f, new Color(96, 13, 23), new Color(200, 0, 0));
        }
        if (kts <= 60.0f) {
            return WXMCColorTables.lerpVel(kts, 30.0f, 60.0f, new Color(200, 0, 0), new Color(255, 255, 0));
        }
        if (kts <= 120.0f) {
            return WXMCColorTables.lerpVel(kts, 60.0f, 120.0f, new Color(255, 255, 0), new Color(120, 60, 0));
        }
        return new Color(120, 60, 0);
    }

    private static Color getMacDonaldEmmersonVelocity(float vel) {
        float kts = vel;
        if (kts <= -60.0f) {
            return new Color(188, 229, 165);
        }
        if (kts <= -50.0f) {
            return WXMCColorTables.lerpVel(kts, -60.0f, -50.0f, new Color(188, 229, 165), new Color(114, 195, 173));
        }
        if (kts <= -40.0f) {
            return WXMCColorTables.lerpVel(kts, -50.0f, -40.0f, new Color(114, 195, 173), new Color(59, 167, 187));
        }
        if (kts <= -30.0f) {
            return WXMCColorTables.lerpVel(kts, -40.0f, -30.0f, new Color(59, 167, 187), new Color(26, 127, 190));
        }
        if (kts <= -20.0f) {
            return WXMCColorTables.lerpVel(kts, -30.0f, -20.0f, new Color(26, 127, 190), new Color(28, 72, 157));
        }
        if (kts <= -10.0f) {
            return WXMCColorTables.lerpVel(kts, -20.0f, -10.0f, new Color(28, 72, 157), new Color(11, 26, 119));
        }
        if (kts <= 0.0f) {
            return WXMCColorTables.lerpVel(kts, -10.0f, 0.0f, new Color(11, 26, 119), new Color(153, 153, 153));
        }
        if (kts <= 10.0f) {
            return WXMCColorTables.lerpVel(kts, 0.0f, 10.0f, new Color(153, 153, 153), new Color(162, 0, 29));
        }
        if (kts <= 20.0f) {
            return WXMCColorTables.lerpVel(kts, 10.0f, 20.0f, new Color(162, 0, 29), new Color(211, 0, 26));
        }
        if (kts <= 30.0f) {
            return WXMCColorTables.lerpVel(kts, 20.0f, 30.0f, new Color(211, 0, 26), new Color(234, 66, 25));
        }
        if (kts <= 40.0f) {
            return WXMCColorTables.lerpVel(kts, 30.0f, 40.0f, new Color(234, 66, 25), new Color(254, 120, 44));
        }
        if (kts <= 50.0f) {
            return WXMCColorTables.lerpVel(kts, 40.0f, 50.0f, new Color(254, 120, 44), new Color(242, 168, 55));
        }
        if (kts <= 60.0f) {
            return WXMCColorTables.lerpVel(kts, 50.0f, 60.0f, new Color(242, 168, 55), new Color(249, 217, 90));
        }
        return new Color(249, 217, 90);
    }

    private static Color getSamBVVelocity(float vel) {
        float mph = vel * 1.15f;
        if (mph <= -200.0f) {
            return new Color(255, 220, 220);
        }
        if (mph <= -140.0f) {
            return WXMCColorTables.lerpVel(mph, -200.0f, -140.0f, new Color(255, 220, 220), new Color(255, 20, 180));
        }
        if (mph <= -120.0f) {
            return WXMCColorTables.lerpVel(mph, -140.0f, -120.0f, new Color(255, 20, 180), new Color(250, 4, 130));
        }
        if (mph <= -100.0f) {
            return WXMCColorTables.lerpVel(mph, -120.0f, -100.0f, new Color(250, 4, 130), new Color(105, 2, 142));
        }
        if (mph <= -90.0f) {
            return WXMCColorTables.lerpVel(mph, -100.0f, -90.0f, new Color(105, 2, 142), new Color(25, 1, 142));
        }
        if (mph <= -70.0f) {
            return WXMCColorTables.lerpVel(mph, -90.0f, -70.0f, new Color(25, 1, 142), new Color(55, 226, 229));
        }
        if (mph <= -50.0f) {
            return WXMCColorTables.lerpVel(mph, -70.0f, -50.0f, new Color(55, 226, 229), new Color(180, 240, 243));
        }
        if (mph <= -40.0f) {
            return WXMCColorTables.lerpVel(mph, -50.0f, -40.0f, new Color(180, 240, 243), new Color(10, 248, 35));
        }
        if (mph <= -10.0f) {
            return WXMCColorTables.lerpVel(mph, -40.0f, -10.0f, new Color(10, 248, 35), new Color(72, 112, 71));
        }
        if (mph <= 0.0f) {
            return WXMCColorTables.lerpVel(mph, -10.0f, 0.0f, new Color(72, 112, 71), new Color(130, 106, 120));
        }
        if (mph <= 10.0f) {
            return WXMCColorTables.lerpVel(mph, 0.0f, 10.0f, new Color(130, 106, 120), new Color(105, 0, 0));
        }
        if (mph <= 40.0f) {
            return WXMCColorTables.lerpVel(mph, 10.0f, 40.0f, new Color(105, 0, 0), new Color(249, 58, 84));
        }
        if (mph <= 55.0f) {
            return WXMCColorTables.lerpVel(mph, 40.0f, 55.0f, new Color(249, 58, 84), new Color(255, 157, 206));
        }
        if (mph <= 60.0f) {
            return WXMCColorTables.lerpVel(mph, 55.0f, 60.0f, new Color(255, 157, 206), new Color(255, 230, 169));
        }
        if (mph <= 80.0f) {
            return WXMCColorTables.lerpVel(mph, 60.0f, 80.0f, new Color(255, 230, 169), new Color(254, 137, 80));
        }
        if (mph <= 120.0f) {
            return WXMCColorTables.lerpVel(mph, 80.0f, 120.0f, new Color(254, 137, 80), new Color(97, 6, 2));
        }
        if (mph <= 140.0f) {
            return WXMCColorTables.lerpVel(mph, 120.0f, 140.0f, new Color(97, 6, 2), new Color(60, 0, 0));
        }
        if (mph <= 200.0f) {
            return WXMCColorTables.lerpVel(mph, 140.0f, 200.0f, new Color(60, 0, 0), new Color(45, 0, 0));
        }
        return new Color(45, 0, 0);
    }

    private static Color getSRRadarLoopsVelocity(float vel) {
        float mph = vel * 1.15f;
        if (mph <= -100.0f) {
            return new Color(0, 0, 80);
        }
        if (mph <= -95.0f) {
            return WXMCColorTables.lerpVel(mph, -100.0f, -95.0f, new Color(0, 0, 80), new Color(0, 0, 161));
        }
        if (mph <= -90.0f) {
            return WXMCColorTables.lerpVel(mph, -95.0f, -90.0f, new Color(0, 0, 161), new Color(5, 42, 255));
        }
        if (mph <= -85.0f) {
            return WXMCColorTables.lerpVel(mph, -90.0f, -85.0f, new Color(5, 42, 255), new Color(23, 88, 255));
        }
        if (mph <= -80.0f) {
            return WXMCColorTables.lerpVel(mph, -85.0f, -80.0f, new Color(23, 88, 255), new Color(63, 109, 255));
        }
        if (mph <= -75.0f) {
            return WXMCColorTables.lerpVel(mph, -80.0f, -75.0f, new Color(63, 109, 255), new Color(99, 117, 255));
        }
        if (mph <= -70.0f) {
            return WXMCColorTables.lerpVel(mph, -75.0f, -70.0f, new Color(99, 117, 255), new Color(115, 155, 255));
        }
        if (mph <= -65.0f) {
            return WXMCColorTables.lerpVel(mph, -70.0f, -65.0f, new Color(115, 155, 255), new Color(125, 187, 255));
        }
        if (mph <= -60.0f) {
            return WXMCColorTables.lerpVel(mph, -65.0f, -60.0f, new Color(125, 187, 255), new Color(151, 211, 255));
        }
        if (mph <= -55.0f) {
            return WXMCColorTables.lerpVel(mph, -60.0f, -55.0f, new Color(151, 211, 255), new Color(176, 224, 236));
        }
        if (mph <= -50.0f) {
            return WXMCColorTables.lerpVel(mph, -55.0f, -50.0f, new Color(176, 224, 236), new Color(176, 255, 236));
        }
        if (mph <= -45.0f) {
            return WXMCColorTables.lerpVel(mph, -50.0f, -45.0f, new Color(176, 255, 236), new Color(176, 255, 196));
        }
        if (mph <= -40.0f) {
            return WXMCColorTables.lerpVel(mph, -45.0f, -40.0f, new Color(176, 255, 196), new Color(180, 255, 165));
        }
        if (mph <= -30.0f) {
            return WXMCColorTables.lerpVel(mph, -40.0f, -30.0f, new Color(180, 255, 165), new Color(97, 206, 114));
        }
        if (mph <= -25.0f) {
            return WXMCColorTables.lerpVel(mph, -30.0f, -25.0f, new Color(97, 206, 114), new Color(76, 182, 95));
        }
        if (mph <= -20.0f) {
            return WXMCColorTables.lerpVel(mph, -25.0f, -20.0f, new Color(76, 182, 95), new Color(16, 175, 49));
        }
        if (mph <= -15.0f) {
            return WXMCColorTables.lerpVel(mph, -20.0f, -15.0f, new Color(16, 175, 49), new Color(0, 134, 22));
        }
        if (mph <= -10.0f) {
            return WXMCColorTables.lerpVel(mph, -15.0f, -10.0f, new Color(0, 134, 22), new Color(5, 94, 23));
        }
        if (mph <= -5.0f) {
            return WXMCColorTables.lerpVel(mph, -10.0f, -5.0f, new Color(5, 94, 23), new Color(7, 40, 14));
        }
        if (mph <= 0.0f) {
            return WXMCColorTables.lerpVel(mph, -5.0f, 0.0f, new Color(7, 40, 14), new Color(110, 110, 110));
        }
        if (mph <= 10.0f) {
            return WXMCColorTables.lerpVel(mph, 0.0f, 10.0f, new Color(110, 110, 110), new Color(33, 0, 0));
        }
        if (mph <= 50.0f) {
            return WXMCColorTables.lerpVel(mph, 10.0f, 50.0f, new Color(33, 0, 0), new Color(255, 55, 26));
        }
        if (mph <= 58.0f) {
            return WXMCColorTables.lerpVel(mph, 50.0f, 58.0f, new Color(255, 55, 26), new Color(254, 154, 39));
        }
        if (mph <= 70.0f) {
            return WXMCColorTables.lerpVel(mph, 58.0f, 70.0f, new Color(254, 154, 39), new Color(255, 255, 0));
        }
        if (mph <= 120.0f) {
            return WXMCColorTables.lerpVel(mph, 70.0f, 120.0f, new Color(255, 255, 0), new Color(164, 89, 68));
        }
        if (mph <= 160.0f) {
            return WXMCColorTables.lerpVel(mph, 120.0f, 160.0f, new Color(164, 89, 68), new Color(0, 0, 0));
        }
        return new Color(0, 0, 0);
    }

    private static Color lerpVel(float val, float min, float max, Color c1, Color c2) {
        float delta = (val - min) / (max - min);
        return WXMCColorTables.lerp(delta, c1, c2);
    }

    private static Color lerpRange(float val, float min, float max, Color c1, Color c2, Color existing) {
        if (val < min) {
            return existing;
        }
        if (val >= max) {
            return c2;
        }
        float delta = (val - min) / (max - min);
        return WXMCColorTables.lerp(delta, c1, c2);
    }
}

