/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.radar;

public enum VelocityColorTablePreset {
    ALPHA("Alpha", "Almany Designs velocity style"),
    MACDONALD_EMMERSON("MacDonald Emmerson", "NWS 8-bit velocity curve"),
    PMWEATHER_DEFAULT("PMWeather Default", "Default PMWeather Velocity"),
    SAM_BV("SamBV", "Sam's velocity palette"),
    SR_RADAR_LOOPS("SRRadarLoops", "SRRadarLoops style");

    private final String displayName;
    private final String description;

    private VelocityColorTablePreset(String displayName, String description) {
        this.displayName = displayName;
        this.description = description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public VelocityColorTablePreset next() {
        VelocityColorTablePreset[] values = VelocityColorTablePreset.values();
        return values[(this.ordinal() + 1) % values.length];
    }

    public static VelocityColorTablePreset byOrdinal(int ordinal) {
        VelocityColorTablePreset[] values = VelocityColorTablePreset.values();
        return values[Math.floorMod(ordinal, values.length)];
    }
}

