/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.radar;

import dev.wxmc.weatheraddon.WXMCWeatherAddon;
import dev.wxmc.weatheraddon.radar.ColorTablePreset;
import dev.wxmc.weatheraddon.radar.VelocityColorTablePreset;
import dev.wxmc.weatheraddon.util.WXMCFiles;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;

public class RadarColorConfig {
    private static final String CONFIG_FILE = "radar-colors.properties";
    private static final String PRESET_KEY = "reflectivity_preset";
    private static final String VELOCITY_PRESET_KEY = "velocity_preset";
    private static ColorTablePreset currentPreset = ColorTablePreset.PMWEATHER_DEFAULT;
    private static VelocityColorTablePreset currentVelocityPreset = VelocityColorTablePreset.PMWEATHER_DEFAULT;
    private static boolean loaded = false;

    public static ColorTablePreset getCurrentPreset() {
        if (!loaded) {
            RadarColorConfig.load();
        }
        return currentPreset;
    }

    public static void setCurrentPreset(ColorTablePreset preset) {
        currentPreset = preset;
        WXMCWeatherAddon.LOGGER.info("Radar color table changed to: {}", (Object)preset.getDisplayName());
        RadarColorConfig.save();
    }

    public static boolean isCustomColorsEnabled() {
        if (!loaded) {
            RadarColorConfig.load();
        }
        return currentPreset != ColorTablePreset.PMWEATHER_DEFAULT;
    }

    public static void cycleNext() {
        RadarColorConfig.setCurrentPreset(currentPreset.next());
    }

    public static VelocityColorTablePreset getCurrentVelocityPreset() {
        if (!loaded) {
            RadarColorConfig.load();
        }
        return currentVelocityPreset;
    }

    public static void setCurrentVelocityPreset(VelocityColorTablePreset preset) {
        currentVelocityPreset = preset;
        WXMCWeatherAddon.LOGGER.info("Velocity color table changed to: {}", (Object)preset.getDisplayName());
        RadarColorConfig.save();
    }

    public static boolean isCustomVelocityColorsEnabled() {
        if (!loaded) {
            RadarColorConfig.load();
        }
        return currentVelocityPreset != VelocityColorTablePreset.PMWEATHER_DEFAULT;
    }

    public static void cycleNextVelocity() {
        RadarColorConfig.setCurrentVelocityPreset(currentVelocityPreset.next());
    }

    public static void load() {
        loaded = true;
        Path configPath = WXMCFiles.getWXMCConfigDir().resolve(CONFIG_FILE);
        if (!Files.exists(configPath, new LinkOption[0])) {
            return;
        }
        try {
            String velocityPresetName;
            Properties props = new Properties();
            props.load(Files.newBufferedReader(configPath));
            String presetName = props.getProperty(PRESET_KEY);
            if (presetName != null) {
                try {
                    currentPreset = ColorTablePreset.valueOf(presetName);
                    WXMCWeatherAddon.LOGGER.info("Loaded radar color preset: {}", (Object)currentPreset.getDisplayName());
                }
                catch (IllegalArgumentException e) {
                    WXMCWeatherAddon.LOGGER.warn("Unknown preset '{}', using default", (Object)presetName);
                }
            }
            if ((velocityPresetName = props.getProperty(VELOCITY_PRESET_KEY)) != null) {
                try {
                    currentVelocityPreset = VelocityColorTablePreset.valueOf(velocityPresetName);
                    WXMCWeatherAddon.LOGGER.info("Loaded velocity color preset: {}", (Object)currentVelocityPreset.getDisplayName());
                }
                catch (IllegalArgumentException e) {
                    WXMCWeatherAddon.LOGGER.warn("Unknown velocity preset '{}', using default", (Object)velocityPresetName);
                }
            }
        }
        catch (IOException e) {
            WXMCWeatherAddon.LOGGER.warn("Failed to load radar color config: {}", (Object)e.getMessage());
        }
    }

    private static void save() {
        Path configPath = WXMCFiles.getWXMCConfigDir().resolve(CONFIG_FILE);
        try {
            Properties props = new Properties();
            props.setProperty(PRESET_KEY, currentPreset.name());
            props.setProperty(VELOCITY_PRESET_KEY, currentVelocityPreset.name());
            props.store(Files.newBufferedWriter(configPath, new OpenOption[0]), "WXMC Weather Addon - Radar Color Preferences");
            WXMCWeatherAddon.LOGGER.debug("Saved radar color presets: {}, {}", (Object)currentPreset.name(), (Object)currentVelocityPreset.name());
        }
        catch (IOException e) {
            WXMCWeatherAddon.LOGGER.warn("Failed to save radar color config: {}", (Object)e.getMessage());
        }
    }
}

