/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.outlook;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.wxmc.weatheraddon.WXMCWeatherAddon;
import dev.wxmc.weatheraddon.compat.SereneSeasonsCompat;
import dev.wxmc.weatheraddon.util.WXMCDebugLogger;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;

public class OutlookManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String SAVE_FILE = "wxmc_outlook.json";
    private static RiskCategory day1 = RiskCategory.NONE;
    private static RiskCategory day2 = RiskCategory.NONE;
    private static RiskCategory day3 = RiskCategory.NONE;
    private static ProbCategory day4 = ProbCategory.NONE;
    private static ProbCategory day5 = ProbCategory.NONE;
    private static ProbCategory day6 = ProbCategory.NONE;
    private static ProbCategory day7 = ProbCategory.NONE;
    private static int upgradeDay1 = 20;
    private static int upgradeDay2 = 20;
    private static int upgradeDay3 = 20;
    private static int upgradeDay4 = 20;
    private static int upgradeDay5 = 20;
    private static int upgradeDay6 = 20;
    private static final long MIDNIGHT_TICKS = 18000L;
    private static final long TICKS_PER_DAY = 24000L;
    private static boolean rolledOverToday = false;
    private static long lastTickTime = -1L;
    private static MinecraftServer server = null;
    private static Path savePath = null;
    private static boolean bypassMixin = false;
    private static boolean manualMode = false;
    private static final int SEASON_CHECK_INTERVAL = 100;
    private static int seasonCheckCounter = 0;
    private static final SeasonalProfile EARLY_WINTER_PROFILE = new SeasonalProfile("Early Winter", 10, 10, 10, 5, 5, 5, 96, 3, 1);
    private static final SeasonalProfile MID_WINTER_PROFILE = new SeasonalProfile("Mid Winter", 5, 5, 5, 2, 2, 2, 98, 1, 1);
    private static final SeasonalProfile LATE_WINTER_PROFILE = new SeasonalProfile("Late Winter", 15, 10, 10, 5, 5, 5, 92, 5, 3);
    private static final SeasonalProfile EARLY_SPRING_PROFILE = new SeasonalProfile("Early Spring", 25, 20, 20, 15, 15, 15, 85, 10, 5);
    private static final SeasonalProfile MID_SPRING_PROFILE = new SeasonalProfile("Mid Spring", 40, 25, 25, 20, 20, 20, 70, 20, 10);
    private static final SeasonalProfile LATE_SPRING_PROFILE = new SeasonalProfile("Late Spring", 35, 20, 20, 15, 15, 15, 70, 20, 10);
    private static final SeasonalProfile EARLY_SUMMER_PROFILE = new SeasonalProfile("Early Summer", 25, 20, 20, 15, 15, 15, 85, 10, 5);
    private static final SeasonalProfile MID_SUMMER_PROFILE = new SeasonalProfile("Mid Summer", 20, 15, 15, 10, 10, 10, 85, 10, 5);
    private static final SeasonalProfile LATE_SUMMER_PROFILE = new SeasonalProfile("Late Summer", 20, 15, 15, 10, 10, 10, 85, 10, 5);
    private static final SeasonalProfile EARLY_AUTUMN_PROFILE = new SeasonalProfile("Early Autumn", 20, 15, 15, 10, 10, 10, 85, 10, 5);
    private static final SeasonalProfile MID_AUTUMN_PROFILE = new SeasonalProfile("Mid Autumn", 30, 15, 15, 10, 10, 10, 85, 10, 5);
    private static final SeasonalProfile LATE_AUTUMN_PROFILE = new SeasonalProfile("Late Autumn", 15, 10, 10, 5, 5, 5, 92, 5, 3);
    private static final SeasonalProfile DEFAULT_PROFILE;
    private static SeasonalProfile activeProfile;

    public static void init(MinecraftServer minecraftServer) {
        server = minecraftServer;
        rolledOverToday = false;
        lastTickTime = -1L;
        seasonCheckCounter = 0;
        savePath = server.getWorldPath(LevelResource.ROOT).resolve(SAVE_FILE);
        OutlookManager.load();
        if (SereneSeasonsCompat.isLoaded()) {
            SereneSeasonsCompat.setSeasonChangeCallback(OutlookManager::onSeasonChange);
            WXMCDebugLogger.info("[OUTLOOK] Serene Seasons integration enabled - seasonal profiles active");
        }
        WXMCDebugLogger.info("[OUTLOOK] Manager initialized, save path: {}", savePath);
    }

    public static void shutdown() {
        if (server != null) {
            OutlookManager.save();
        }
        server = null;
        savePath = null;
        SereneSeasonsCompat.resetTracking();
        activeProfile = DEFAULT_PROFILE;
        WXMCDebugLogger.info("[OUTLOOK] Manager shutdown");
    }

    public static void onServerTick(long gameTime) {
        long lastTimeOfDay;
        if (server == null) {
            return;
        }
        long timeOfDay = gameTime % 24000L;
        long l = lastTimeOfDay = lastTickTime >= 0L ? lastTickTime % 24000L : -1L;
        if (!rolledOverToday && lastTimeOfDay >= 0L && lastTimeOfDay < 18000L && timeOfDay >= 18000L) {
            WXMCDebugLogger.info("[OUTLOOK] Midnight reached - triggering day rollover (gameTime={}, timeOfDay={}, lastTimeOfDay={})", gameTime, timeOfDay, lastTimeOfDay);
            OutlookManager.performDayRollover();
            rolledOverToday = true;
            OutlookManager.save();
        }
        if (lastTimeOfDay > timeOfDay) {
            WXMCDebugLogger.debug("[OUTLOOK] Time wrapped or moved backwards - resetting rollover flag (lastTimeOfDay={}, timeOfDay={})", lastTimeOfDay, timeOfDay);
            rolledOverToday = false;
        }
        lastTickTime = gameTime;
        if (SereneSeasonsCompat.isLoaded() && ++seasonCheckCounter >= 100) {
            seasonCheckCounter = 0;
            ServerLevel overworld = server.getLevel(Level.OVERWORLD);
            if (overworld != null) {
                SereneSeasonsCompat.checkForSeasonChange((Level)overworld);
            }
        }
    }

    public static void save() {
        if (savePath == null) {
            return;
        }
        try {
            JsonObject json = new JsonObject();
            json.addProperty("day1", day1.name());
            json.addProperty("day2", day2.name());
            json.addProperty("day3", day3.name());
            json.addProperty("day4", day4.name());
            json.addProperty("day5", day5.name());
            json.addProperty("day6", day6.name());
            json.addProperty("day7", day7.name());
            json.addProperty("upgradeDay1", (Number)upgradeDay1);
            json.addProperty("upgradeDay2", (Number)upgradeDay2);
            json.addProperty("upgradeDay3", (Number)upgradeDay3);
            json.addProperty("upgradeDay4", (Number)upgradeDay4);
            json.addProperty("upgradeDay5", (Number)upgradeDay5);
            json.addProperty("upgradeDay6", (Number)upgradeDay6);
            Path tempPath = savePath.resolveSibling(String.valueOf(savePath.getFileName()) + ".tmp");
            Files.writeString(tempPath, (CharSequence)GSON.toJson((JsonElement)json), new OpenOption[0]);
            Files.move(tempPath, savePath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            WXMCDebugLogger.debug("[OUTLOOK] Saved outlook data to {}", savePath);
        }
        catch (IOException e) {
            WXMCWeatherAddon.LOGGER.error("[OUTLOOK] Failed to save outlook data: {}", (Object)e.getMessage());
        }
    }

    public static void load() {
        if (savePath == null || !Files.exists(savePath, new LinkOption[0])) {
            WXMCDebugLogger.info("[OUTLOOK] No saved outlook data found, generating initial random outlook");
            OutlookManager.generateInitialOutlook();
            OutlookManager.save();
            return;
        }
        try {
            Enum loaded;
            String content = Files.readString(savePath);
            JsonObject json = JsonParser.parseString((String)content).getAsJsonObject();
            if (json.has("day1")) {
                loaded = RiskCategory.valueOf(json.get("day1").getAsString());
                Enum enum_ = day1 = loaded != null ? loaded : RiskCategory.NONE;
            }
            if (json.has("day2")) {
                loaded = RiskCategory.valueOf(json.get("day2").getAsString());
                Enum enum_ = day2 = loaded != null ? loaded : RiskCategory.NONE;
            }
            if (json.has("day3")) {
                loaded = RiskCategory.valueOf(json.get("day3").getAsString());
                Enum enum_ = day3 = loaded != null ? loaded : RiskCategory.NONE;
            }
            if (json.has("day4")) {
                loaded = ProbCategory.valueOf(json.get("day4").getAsString());
                Enum enum_ = day4 = loaded != null ? loaded : ProbCategory.NONE;
            }
            if (json.has("day5")) {
                loaded = ProbCategory.valueOf(json.get("day5").getAsString());
                Enum enum_ = day5 = loaded != null ? loaded : ProbCategory.NONE;
            }
            if (json.has("day6")) {
                loaded = ProbCategory.valueOf(json.get("day6").getAsString());
                Enum enum_ = day6 = loaded != null ? loaded : ProbCategory.NONE;
            }
            if (json.has("day7")) {
                loaded = ProbCategory.valueOf(json.get("day7").getAsString());
                Enum enum_ = day7 = loaded != null ? loaded : ProbCategory.NONE;
            }
            if (json.has("upgradeDay1")) {
                upgradeDay1 = json.get("upgradeDay1").getAsInt();
            }
            if (json.has("upgradeDay2")) {
                upgradeDay2 = json.get("upgradeDay2").getAsInt();
            }
            if (json.has("upgradeDay3")) {
                upgradeDay3 = json.get("upgradeDay3").getAsInt();
            }
            if (json.has("upgradeDay4")) {
                upgradeDay4 = json.get("upgradeDay4").getAsInt();
            }
            if (json.has("upgradeDay5")) {
                upgradeDay5 = json.get("upgradeDay5").getAsInt();
            }
            if (json.has("upgradeDay6")) {
                upgradeDay6 = json.get("upgradeDay6").getAsInt();
            }
            WXMCDebugLogger.info("[OUTLOOK] Loaded outlook data: D1={}, D2={}, D3={}, D4={}, D5={}, D6={}, D7={}", day1.getName(), day2.getName(), day3.getName(), day4.getName(), day5.getName(), day6.getName(), day7.getName());
        }
        catch (Exception e) {
            WXMCWeatherAddon.LOGGER.error("[OUTLOOK] Failed to load outlook data: {}", (Object)e.getMessage());
        }
    }

    private static void performDayRollover() {
        WXMCDebugLogger.info("[OUTLOOK] Day rollover triggered");
        RiskCategory oldDay2 = day2;
        RiskCategory oldDay3 = day3;
        ProbCategory oldDay4 = day4;
        ProbCategory oldDay5 = day5;
        ProbCategory oldDay6 = day6;
        ProbCategory oldDay7 = day7;
        day1 = OutlookManager.maybeUpgrade(oldDay2, upgradeDay1);
        day2 = OutlookManager.maybeUpgrade(oldDay3, upgradeDay2);
        day3 = OutlookManager.convertProbToRisk(OutlookManager.maybeUpgradeProb(oldDay4, upgradeDay3));
        if (day3 == RiskCategory.HIGH) {
            day3 = RiskCategory.MDT;
        }
        day4 = OutlookManager.maybeUpgradeProb(oldDay5, upgradeDay4);
        day5 = OutlookManager.maybeUpgradeProb(oldDay6, upgradeDay5);
        day6 = OutlookManager.maybeUpgradeProb(oldDay7, upgradeDay6);
        day7 = OutlookManager.generateRandomDay7();
        WXMCDebugLogger.info("[OUTLOOK] New outlook: D1={}, D2={}, D3={}, D4={}, D5={}, D6={}, D7={}", day1.getName(), day2.getName(), day3.getName(), day4.getName(), day5.getName(), day6.getName(), day7.getName());
    }

    private static void generateInitialOutlook() {
        day1 = OutlookManager.generateRandomRisk();
        day2 = OutlookManager.generateRandomRisk();
        day3 = OutlookManager.generateRandomRisk();
        if (day3 == RiskCategory.HIGH) {
            day3 = RiskCategory.MDT;
        }
        day4 = OutlookManager.generateRandomDay7();
        day5 = OutlookManager.generateRandomDay7();
        day6 = OutlookManager.generateRandomDay7();
        day7 = OutlookManager.generateRandomDay7();
        WXMCDebugLogger.info("[OUTLOOK] Generated initial outlook: D1={}, D2={}, D3={}, D4={}, D5={}, D6={}, D7={}", day1.getName(), day2.getName(), day3.getName(), day4.getName(), day5.getName(), day6.getName(), day7.getName());
    }

    private static RiskCategory generateRandomRisk() {
        int roll = ThreadLocalRandom.current().nextInt(100);
        if (roll < 30) {
            return RiskCategory.NONE;
        }
        if (roll < 55) {
            return RiskCategory.TSTM;
        }
        if (roll < 75) {
            return RiskCategory.MRGL;
        }
        if (roll < 87) {
            return RiskCategory.SLGT;
        }
        if (roll < 95) {
            return RiskCategory.ENH;
        }
        if (roll < 99) {
            return RiskCategory.MDT;
        }
        return RiskCategory.HIGH;
    }

    private static ProbCategory generateRandomDay7() {
        int totalWeight = activeProfile.totalDay7Weight();
        int roll = ThreadLocalRandom.current().nextInt(totalWeight);
        if (roll < activeProfile.day7NoneWeight()) {
            return ProbCategory.NONE;
        }
        if (roll < activeProfile.day7NoneWeight() + activeProfile.day7Prob15Weight()) {
            return ProbCategory.PROB_15;
        }
        return ProbCategory.PROB_30;
    }

    private static RiskCategory maybeUpgrade(RiskCategory risk, int chance) {
        if (risk == RiskCategory.HIGH) {
            return risk;
        }
        if (ThreadLocalRandom.current().nextInt(100) < chance) {
            RiskCategory upgraded = risk.upgrade();
            WXMCDebugLogger.info("[OUTLOOK] Risk upgraded: {} -> {}", risk.getName(), upgraded.getName());
            return upgraded;
        }
        return risk;
    }

    private static ProbCategory maybeUpgradeProb(ProbCategory prob, int chance) {
        if (prob == ProbCategory.PROB_30) {
            return prob;
        }
        if (ThreadLocalRandom.current().nextInt(100) < chance) {
            ProbCategory upgraded = prob.upgradeProb();
            WXMCDebugLogger.info("[OUTLOOK] Prob upgraded: {} -> {}", prob.getName(), upgraded.getName());
            return upgraded;
        }
        return prob;
    }

    private static RiskCategory convertProbToRisk(ProbCategory prob) {
        return switch (prob.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> RiskCategory.NONE;
            case 1 -> RiskCategory.SLGT;
            case 2 -> RiskCategory.ENH;
        };
    }

    public static RiskCategory getDay1() {
        return day1;
    }

    public static RiskCategory getDay2() {
        return day2;
    }

    public static RiskCategory getDay3() {
        return day3;
    }

    public static ProbCategory getDay4() {
        return day4;
    }

    public static ProbCategory getDay5() {
        return day5;
    }

    public static ProbCategory getDay6() {
        return day6;
    }

    public static ProbCategory getDay7() {
        return day7;
    }

    public static void setDay1(RiskCategory risk) {
        day1 = risk != null ? risk : RiskCategory.NONE;
        WXMCDebugLogger.info("[OUTLOOK] Day 1 set to: {}", day1.getName());
        OutlookManager.save();
    }

    public static void setDay2(RiskCategory risk) {
        day2 = risk != null ? risk : RiskCategory.NONE;
        WXMCDebugLogger.info("[OUTLOOK] Day 2 set to: {}", day2.getName());
        OutlookManager.save();
    }

    public static void setDay3(RiskCategory risk) {
        if (risk == RiskCategory.HIGH) {
            risk = RiskCategory.MDT;
            WXMCDebugLogger.debug("[OUTLOOK] Day 3 cannot be HIGH, capping at MDT");
        }
        day3 = risk != null ? risk : RiskCategory.NONE;
        WXMCDebugLogger.info("[OUTLOOK] Day 3 set to: {}", day3.getName());
        OutlookManager.save();
    }

    public static void setDay4(ProbCategory prob) {
        day4 = prob != null ? prob : ProbCategory.NONE;
        WXMCDebugLogger.info("[OUTLOOK] Day 4 set to: {}", day4.getName());
        OutlookManager.save();
    }

    public static void setDay5(ProbCategory prob) {
        day5 = prob != null ? prob : ProbCategory.NONE;
        WXMCDebugLogger.info("[OUTLOOK] Day 5 set to: {}", day5.getName());
        OutlookManager.save();
    }

    public static void setDay6(ProbCategory prob) {
        day6 = prob != null ? prob : ProbCategory.NONE;
        WXMCDebugLogger.info("[OUTLOOK] Day 6 set to: {}", day6.getName());
        OutlookManager.save();
    }

    public static void setDay7(ProbCategory prob) {
        day7 = prob != null ? prob : ProbCategory.NONE;
        WXMCDebugLogger.info("[OUTLOOK] Day 7 set to: {}", day7.getName());
        OutlookManager.save();
    }

    public static void clearAll() {
        day1 = RiskCategory.NONE;
        day2 = RiskCategory.NONE;
        day3 = RiskCategory.NONE;
        day4 = ProbCategory.NONE;
        day5 = ProbCategory.NONE;
        day6 = ProbCategory.NONE;
        day7 = ProbCategory.NONE;
        WXMCDebugLogger.info("[OUTLOOK] All days cleared to NONE");
        OutlookManager.save();
    }

    public static void setUpgradeChance(int day, int chance) {
        int clampedChance = Math.max(0, Math.min(100, chance));
        switch (day) {
            case 1: {
                upgradeDay1 = clampedChance;
                break;
            }
            case 2: {
                upgradeDay2 = clampedChance;
                break;
            }
            case 3: {
                upgradeDay3 = clampedChance;
                break;
            }
            case 4: {
                upgradeDay4 = clampedChance;
                break;
            }
            case 5: {
                upgradeDay5 = clampedChance;
                break;
            }
            case 6: {
                upgradeDay6 = clampedChance;
                break;
            }
            default: {
                WXMCDebugLogger.debug("[OUTLOOK] Invalid day for upgrade chance: {}", day);
                return;
            }
        }
        WXMCDebugLogger.info("[OUTLOOK] Day {} upgrade chance set to: {}%", day, clampedChance);
        OutlookManager.save();
    }

    public static void setAllUpgradeChances(int chance) {
        int clampedChance;
        upgradeDay1 = clampedChance = Math.max(0, Math.min(100, chance));
        upgradeDay2 = clampedChance;
        upgradeDay3 = clampedChance;
        upgradeDay4 = clampedChance;
        upgradeDay5 = clampedChance;
        upgradeDay6 = clampedChance;
        WXMCDebugLogger.info("[OUTLOOK] All upgrade chances set to: {}%", clampedChance);
        OutlookManager.save();
    }

    public static int getUpgradeChance(int day) {
        return switch (day) {
            case 1 -> upgradeDay1;
            case 2 -> upgradeDay2;
            case 3 -> upgradeDay3;
            case 4 -> upgradeDay4;
            case 5 -> upgradeDay5;
            case 6 -> upgradeDay6;
            default -> 0;
        };
    }

    public static float getCurrentRiskValue() {
        return day1.getRiskValue();
    }

    public static float getCurrentRiskValue(Level level) {
        float baseRisk = day1.getRiskValue();
        if (level != null && SereneSeasonsCompat.isLoaded()) {
            float seasonalModifier = SereneSeasonsCompat.getSeasonalRiskModifier(level);
            float modifiedRisk = baseRisk * seasonalModifier;
            SereneSeasonsCompat.Season season = SereneSeasonsCompat.getCurrentSeason(level);
            if (season != null) {
                WXMCDebugLogger.debug("[OUTLOOK] Seasonal modifier applied: {} x {} ({}) = {}", Float.valueOf(baseRisk), Float.valueOf(seasonalModifier), season.name(), Float.valueOf(modifiedRisk));
            }
            return modifiedRisk;
        }
        return baseRisk;
    }

    public static boolean hasActiveOutlook() {
        return day1 != RiskCategory.NONE || day2 != RiskCategory.NONE || day3 != RiskCategory.NONE || day4 != ProbCategory.NONE || day5 != ProbCategory.NONE || day6 != ProbCategory.NONE || day7 != ProbCategory.NONE;
    }

    public static void forceRollover() {
        OutlookManager.performDayRollover();
    }

    public static boolean shouldBypassMixin() {
        return bypassMixin;
    }

    public static void setBypassMixin(boolean bypass) {
        bypassMixin = bypass;
    }

    public static boolean isManualMode() {
        return manualMode;
    }

    public static void enableManualMode() {
        if (!manualMode) {
            manualMode = true;
            WXMCDebugLogger.info("[OUTLOOK] Manual mode enabled - PMWeather auto-updates disabled");
            WXMCDebugLogger.info("[OUTLOOK] Use '/outlook auto' to re-enable automatic updates");
        }
    }

    public static void disableManualMode() {
        if (manualMode) {
            manualMode = false;
            WXMCDebugLogger.info("[OUTLOOK] Manual mode disabled - PMWeather auto-updates enabled");
        }
    }

    public static RiskCategory riskValueToCategory(float riskValue) {
        if (riskValue > 1.5f) {
            return RiskCategory.HIGH;
        }
        if (riskValue > 1.2f) {
            return RiskCategory.MDT;
        }
        if (riskValue > 0.8f) {
            return RiskCategory.ENH;
        }
        if (riskValue > 0.6f) {
            return RiskCategory.SLGT;
        }
        if (riskValue > 0.3f) {
            return RiskCategory.MRGL;
        }
        if (riskValue > 0.15f) {
            return RiskCategory.TSTM;
        }
        return RiskCategory.NONE;
    }

    private static void onSeasonChange(SereneSeasonsCompat.SeasonChangeInfo info) {
        if (info.previousSubSeason() == null) {
            WXMCDebugLogger.info("[OUTLOOK] Initial sub-season detected: {} - applying seasonal profile", new Object[]{info.newSubSeason()});
        } else {
            WXMCDebugLogger.info("[OUTLOOK] Sub-season changed from {} to {} - applying new seasonal profile", new Object[]{info.previousSubSeason(), info.newSubSeason()});
        }
        OutlookManager.applySeasonalProfile(info.newSubSeason());
    }

    public static void applySeasonalProfile(SereneSeasonsCompat.SubSeason subSeason) {
        SeasonalProfile newProfile;
        if (subSeason == null) {
            activeProfile = DEFAULT_PROFILE;
            WXMCDebugLogger.info("[OUTLOOK] Applied DEFAULT seasonal profile");
            OutlookManager.applyProfileValues(activeProfile);
            return;
        }
        activeProfile = newProfile = (switch (subSeason) {
            default -> throw new MatchException(null, null);
            case SereneSeasonsCompat.SubSeason.EARLY_WINTER -> EARLY_WINTER_PROFILE;
            case SereneSeasonsCompat.SubSeason.MID_WINTER -> MID_WINTER_PROFILE;
            case SereneSeasonsCompat.SubSeason.LATE_WINTER -> LATE_WINTER_PROFILE;
            case SereneSeasonsCompat.SubSeason.EARLY_SPRING -> EARLY_SPRING_PROFILE;
            case SereneSeasonsCompat.SubSeason.MID_SPRING -> MID_SPRING_PROFILE;
            case SereneSeasonsCompat.SubSeason.LATE_SPRING -> LATE_SPRING_PROFILE;
            case SereneSeasonsCompat.SubSeason.EARLY_SUMMER -> EARLY_SUMMER_PROFILE;
            case SereneSeasonsCompat.SubSeason.MID_SUMMER -> MID_SUMMER_PROFILE;
            case SereneSeasonsCompat.SubSeason.LATE_SUMMER -> LATE_SUMMER_PROFILE;
            case SereneSeasonsCompat.SubSeason.EARLY_AUTUMN -> EARLY_AUTUMN_PROFILE;
            case SereneSeasonsCompat.SubSeason.MID_AUTUMN -> MID_AUTUMN_PROFILE;
            case SereneSeasonsCompat.SubSeason.LATE_AUTUMN -> LATE_AUTUMN_PROFILE;
        });
        OutlookManager.applyProfileValues(newProfile);
    }

    private static void applyProfileValues(SeasonalProfile profile) {
        upgradeDay1 = profile.upgradeDay1();
        upgradeDay2 = profile.upgradeDay2();
        upgradeDay3 = profile.upgradeDay3();
        upgradeDay4 = profile.upgradeDay4();
        upgradeDay5 = profile.upgradeDay5();
        upgradeDay6 = profile.upgradeDay6();
        WXMCDebugLogger.info("[OUTLOOK] Applied {} profile - Upgrade chances: D1={}%, D2={}%, D3={}%, D4={}%, D5={}%, D6={}%", profile.name(), upgradeDay1, upgradeDay2, upgradeDay3, upgradeDay4, upgradeDay5, upgradeDay6);
        WXMCDebugLogger.info("[OUTLOOK] Day7 generation weights: NONE={}%, 15%={}%, 30%={}%", profile.day7NoneWeight(), profile.day7Prob15Weight(), profile.day7Prob30Weight());
        OutlookManager.save();
    }

    public static SeasonalProfile getActiveProfile() {
        return activeProfile;
    }

    public static void applyCurrentSeasonProfile(Level level) {
        if (!SereneSeasonsCompat.isLoaded() || level == null) {
            return;
        }
        SereneSeasonsCompat.SubSeason currentSubSeason = SereneSeasonsCompat.getCurrentSubSeason(level);
        if (currentSubSeason != null) {
            OutlookManager.applySeasonalProfile(currentSubSeason);
        }
    }

    static {
        activeProfile = DEFAULT_PROFILE = new SeasonalProfile("Default", 20, 20, 20, 20, 20, 20, 85, 10, 5);
    }

    public record SeasonalProfile(String name, int upgradeDay1, int upgradeDay2, int upgradeDay3, int upgradeDay4, int upgradeDay5, int upgradeDay6, int day7NoneWeight, int day7Prob15Weight, int day7Prob30Weight) {
        public int totalDay7Weight() {
            return this.day7NoneWeight + this.day7Prob15Weight + this.day7Prob30Weight;
        }
    }

    public static enum RiskCategory {
        NONE("NONE", 0xAAAAAA, 0.0f),
        TSTM("TSTM", 12642496, 0.14f),
        MRGL("MRGL", 0x66A366, 0.88f),
        SLGT("SLGT", 16769126, 1.15f),
        ENH("ENH", 16753920, 1.55f),
        MDT("MDT", 0xFF0000, 2.0f),
        HIGH("HIGH", 0xFF00FF, 2.3f);

        private final String name;
        private final int color;
        private final float riskValue;

        private RiskCategory(String name, int color, float riskValue) {
            this.name = name;
            this.color = color;
            this.riskValue = riskValue;
        }

        public String getName() {
            return this.name;
        }

        public int getColor() {
            return this.color;
        }

        public float getRiskValue() {
            return this.riskValue;
        }

        public String getColorCode() {
            return String.format("%06X", this.color);
        }

        public RiskCategory upgrade() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> TSTM;
                case 1 -> MRGL;
                case 2 -> SLGT;
                case 3 -> ENH;
                case 4 -> MDT;
                case 5 -> HIGH;
                case 6 -> HIGH;
            };
        }

        public static RiskCategory fromName(String name) {
            for (RiskCategory cat : RiskCategory.values()) {
                if (!cat.name.equalsIgnoreCase(name)) continue;
                return cat;
            }
            return null;
        }
    }

    public static enum ProbCategory {
        NONE("NONE", 0xAAAAAA),
        PROB_15("15%", 16769126),
        PROB_30("30%", 16753920);

        private final String name;
        private final int color;

        private ProbCategory(String name, int color) {
            this.name = name;
            this.color = color;
        }

        public String getName() {
            return this.name;
        }

        public int getColor() {
            return this.color;
        }

        public String getColorCode() {
            return String.format("%06X", this.color);
        }

        public ProbCategory upgradeProb() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> PROB_15;
                case 1 -> PROB_30;
                case 2 -> PROB_30;
            };
        }

        public static ProbCategory fromName(String name) {
            for (ProbCategory cat : ProbCategory.values()) {
                if (!cat.name.equalsIgnoreCase(name) && !cat.name.replace("%", "").equals(name)) continue;
                return cat;
            }
            return null;
        }
    }
}

