/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.outlook;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import dev.wxmc.weatheraddon.outlook.OutlookManager;
import dev.wxmc.weatheraddon.util.PermissionHelper;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;

public class OutlookCommand {
    private static final SuggestionProvider<CommandSourceStack> RISK_SUGGESTIONS = (context, builder) -> {
        for (OutlookManager.RiskCategory cat : OutlookManager.RiskCategory.values()) {
            builder.suggest(cat.getName());
        }
        return builder.buildFuture();
    };
    private static final SuggestionProvider<CommandSourceStack> RISK_NO_HIGH_SUGGESTIONS = (context, builder) -> {
        for (OutlookManager.RiskCategory cat : OutlookManager.RiskCategory.values()) {
            if (cat == OutlookManager.RiskCategory.HIGH) continue;
            builder.suggest(cat.getName());
        }
        return builder.buildFuture();
    };
    private static final SuggestionProvider<CommandSourceStack> PROB_SUGGESTIONS = (context, builder) -> {
        builder.suggest("NONE");
        builder.suggest("15");
        builder.suggest("30");
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"outlook").requires(source -> PermissionHelper.hasPermission(source, "wxmc.admin"))).executes(context -> OutlookCommand.showOutlook((CommandContext<CommandSourceStack>)context))).then(Commands.literal((String)"day1").then(Commands.argument((String)"risk", (ArgumentType)StringArgumentType.word()).suggests(RISK_SUGGESTIONS).executes(context -> OutlookCommand.setDay1((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"risk")))))).then(Commands.literal((String)"day2").then(Commands.argument((String)"risk", (ArgumentType)StringArgumentType.word()).suggests(RISK_SUGGESTIONS).executes(context -> OutlookCommand.setDay2((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"risk")))))).then(Commands.literal((String)"day3").then(Commands.argument((String)"risk", (ArgumentType)StringArgumentType.word()).suggests(RISK_NO_HIGH_SUGGESTIONS).executes(context -> OutlookCommand.setDay3((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"risk")))))).then(Commands.literal((String)"day4").then(Commands.argument((String)"prob", (ArgumentType)StringArgumentType.word()).suggests(PROB_SUGGESTIONS).executes(context -> OutlookCommand.setDay4((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"prob")))))).then(Commands.literal((String)"day5").then(Commands.argument((String)"prob", (ArgumentType)StringArgumentType.word()).suggests(PROB_SUGGESTIONS).executes(context -> OutlookCommand.setDay5((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"prob")))))).then(Commands.literal((String)"day6").then(Commands.argument((String)"prob", (ArgumentType)StringArgumentType.word()).suggests(PROB_SUGGESTIONS).executes(context -> OutlookCommand.setDay6((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"prob")))))).then(Commands.literal((String)"day7").then(Commands.argument((String)"prob", (ArgumentType)StringArgumentType.word()).suggests(PROB_SUGGESTIONS).executes(context -> OutlookCommand.setDay7((CommandContext<CommandSourceStack>)context, StringArgumentType.getString((CommandContext)context, (String)"prob")))))).then(Commands.literal((String)"rollover").executes(context -> OutlookCommand.forceRollover((CommandContext<CommandSourceStack>)context)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"upgrade").then(Commands.argument((String)"chance", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(context -> OutlookCommand.setAllUpgradeChances((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"chance"))))).then(Commands.literal((String)"day1").then(Commands.argument((String)"chance", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(context -> OutlookCommand.setDayUpgradeChance((CommandContext<CommandSourceStack>)context, 1, IntegerArgumentType.getInteger((CommandContext)context, (String)"chance")))))).then(Commands.literal((String)"day2").then(Commands.argument((String)"chance", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(context -> OutlookCommand.setDayUpgradeChance((CommandContext<CommandSourceStack>)context, 2, IntegerArgumentType.getInteger((CommandContext)context, (String)"chance")))))).then(Commands.literal((String)"day3").then(Commands.argument((String)"chance", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(context -> OutlookCommand.setDayUpgradeChance((CommandContext<CommandSourceStack>)context, 3, IntegerArgumentType.getInteger((CommandContext)context, (String)"chance")))))).then(Commands.literal((String)"day4").then(Commands.argument((String)"chance", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(context -> OutlookCommand.setDayUpgradeChance((CommandContext<CommandSourceStack>)context, 4, IntegerArgumentType.getInteger((CommandContext)context, (String)"chance")))))).then(Commands.literal((String)"day5").then(Commands.argument((String)"chance", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(context -> OutlookCommand.setDayUpgradeChance((CommandContext<CommandSourceStack>)context, 5, IntegerArgumentType.getInteger((CommandContext)context, (String)"chance")))))).then(Commands.literal((String)"day6").then(Commands.argument((String)"chance", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(context -> OutlookCommand.setDayUpgradeChance((CommandContext<CommandSourceStack>)context, 6, IntegerArgumentType.getInteger((CommandContext)context, (String)"chance")))))));
    }

    private static int showOutlook(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        MutableComponent message = Component.literal((String)"=== 7-Day Convective Outlook ===\n").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xFFAA00)));
        message.append((Component)Component.literal((String)"Day-1: ").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xFFFFFF))));
        message.append((Component)OutlookCommand.formatRisk(OutlookManager.getDay1()));
        message.append((Component)Component.literal((String)"\n"));
        message.append((Component)Component.literal((String)"Day-2: ").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xFFFFFF))));
        message.append((Component)OutlookCommand.formatRisk(OutlookManager.getDay2()));
        message.append((Component)Component.literal((String)"\n"));
        message.append((Component)Component.literal((String)"Day-3: ").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xFFFFFF))));
        message.append((Component)OutlookCommand.formatRisk(OutlookManager.getDay3()));
        message.append((Component)Component.literal((String)"\n"));
        message.append((Component)Component.literal((String)"Day-4: ").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xFFFFFF))));
        message.append((Component)OutlookCommand.formatProb(OutlookManager.getDay4()));
        message.append((Component)Component.literal((String)"\n"));
        message.append((Component)Component.literal((String)"Day-5: ").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xFFFFFF))));
        message.append((Component)OutlookCommand.formatProb(OutlookManager.getDay5()));
        message.append((Component)Component.literal((String)"\n"));
        message.append((Component)Component.literal((String)"Day-6: ").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xFFFFFF))));
        message.append((Component)OutlookCommand.formatProb(OutlookManager.getDay6()));
        message.append((Component)Component.literal((String)"\n"));
        message.append((Component)Component.literal((String)"Day-7: ").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xFFFFFF))));
        message.append((Component)OutlookCommand.formatProb(OutlookManager.getDay7()));
        message.append((Component)Component.literal((String)"\n"));
        message.append((Component)Component.literal((String)"\nUpgrade Chances: ").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAAAAAA))));
        message.append((Component)Component.literal((String)("D1:" + OutlookManager.getUpgradeChance(1) + "% ")).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x888888))));
        message.append((Component)Component.literal((String)("D2:" + OutlookManager.getUpgradeChance(2) + "% ")).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x888888))));
        message.append((Component)Component.literal((String)("D3:" + OutlookManager.getUpgradeChance(3) + "% ")).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x888888))));
        message.append((Component)Component.literal((String)("D4:" + OutlookManager.getUpgradeChance(4) + "% ")).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x888888))));
        message.append((Component)Component.literal((String)("D5:" + OutlookManager.getUpgradeChance(5) + "% ")).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x888888))));
        message.append((Component)Component.literal((String)("D6:" + OutlookManager.getUpgradeChance(6) + "%")).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x888888))));
        source.sendSuccess(() -> message, false);
        return 1;
    }

    private static MutableComponent formatRisk(OutlookManager.RiskCategory risk) {
        return Component.literal((String)risk.getName()).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)risk.getColor())));
    }

    private static MutableComponent formatProb(OutlookManager.ProbCategory prob) {
        return Component.literal((String)prob.getName()).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)prob.getColor())));
    }

    private static int setDay1(CommandContext<CommandSourceStack> context, String riskName) {
        OutlookManager.RiskCategory risk;
        if (((CommandSourceStack)context.getSource()).getLevel() != null) {
            boolean isAllowedTime;
            long timeOfDay = ((CommandSourceStack)context.getSource()).getLevel().getDayTime() % 24000L;
            boolean bl = isAllowedTime = timeOfDay >= 18000L || timeOfDay < 2000L;
            if (!isAllowedTime) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Day 1 outlook can only be changed between 12:00 AM and 7:59 AM (current time: " + OutlookCommand.formatMCTime(timeOfDay) + ")")));
                return 0;
            }
        }
        if ((risk = OutlookManager.RiskCategory.fromName(riskName)) == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Invalid risk: " + riskName)));
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Valid options: NONE, TSTM, MRGL, SLGT, ENH, MDT, HIGH"));
            return 0;
        }
        OutlookManager.enableManualMode();
        OutlookManager.setDay1(risk);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Day 1 set to: ").append((Component)OutlookCommand.formatRisk(risk)), true);
        return 1;
    }

    private static String formatMCTime(long ticks) {
        int mcHour = (int)((ticks / 1000L + 6L) % 24L);
        int mcMinute = (int)(ticks % 1000L * 60L / 1000L);
        String period = mcHour >= 12 ? "PM" : "AM";
        int displayHour = mcHour % 12;
        if (displayHour == 0) {
            displayHour = 12;
        }
        return String.format("%d:%02d %s", displayHour, mcMinute, period);
    }

    private static int setDay2(CommandContext<CommandSourceStack> context, String riskName) {
        OutlookManager.RiskCategory risk = OutlookManager.RiskCategory.fromName(riskName);
        if (risk == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Invalid risk: " + riskName)));
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Valid options: NONE, TSTM, MRGL, SLGT, ENH, MDT, HIGH"));
            return 0;
        }
        OutlookManager.enableManualMode();
        OutlookManager.setDay2(risk);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Day 2 set to: ").append((Component)OutlookCommand.formatRisk(risk)), true);
        return 1;
    }

    private static int setDay3(CommandContext<CommandSourceStack> context, String riskName) {
        OutlookManager.RiskCategory risk = OutlookManager.RiskCategory.fromName(riskName);
        if (risk == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Invalid risk: " + riskName)));
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Valid options: NONE, TSTM, MRGL, SLGT, ENH, MDT (HIGH not allowed for Day 3)"));
            return 0;
        }
        if (risk == OutlookManager.RiskCategory.HIGH) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Day 3 cannot be set to HIGH (max is MDT)"));
            return 0;
        }
        OutlookManager.enableManualMode();
        OutlookManager.setDay3(risk);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Day 3 set to: ").append((Component)OutlookCommand.formatRisk(risk)), true);
        return 1;
    }

    private static int setDay4(CommandContext<CommandSourceStack> context, String probName) {
        OutlookManager.ProbCategory prob = OutlookCommand.parseProbCategory(probName);
        if (prob == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Invalid probability: " + probName)));
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Valid options: NONE, 15, 30"));
            return 0;
        }
        OutlookManager.enableManualMode();
        OutlookManager.setDay4(prob);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Day 4 set to: ").append((Component)OutlookCommand.formatProb(prob)), true);
        return 1;
    }

    private static int setDay5(CommandContext<CommandSourceStack> context, String probName) {
        OutlookManager.ProbCategory prob = OutlookCommand.parseProbCategory(probName);
        if (prob == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Invalid probability: " + probName)));
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Valid options: NONE, 15, 30"));
            return 0;
        }
        OutlookManager.enableManualMode();
        OutlookManager.setDay5(prob);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Day 5 set to: ").append((Component)OutlookCommand.formatProb(prob)), true);
        return 1;
    }

    private static int setDay6(CommandContext<CommandSourceStack> context, String probName) {
        OutlookManager.ProbCategory prob = OutlookCommand.parseProbCategory(probName);
        if (prob == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Invalid probability: " + probName)));
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Valid options: NONE, 15, 30"));
            return 0;
        }
        OutlookManager.enableManualMode();
        OutlookManager.setDay6(prob);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Day 6 set to: ").append((Component)OutlookCommand.formatProb(prob)), true);
        return 1;
    }

    private static int setDay7(CommandContext<CommandSourceStack> context, String probName) {
        OutlookManager.ProbCategory prob = OutlookCommand.parseProbCategory(probName);
        if (prob == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Invalid probability: " + probName)));
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Valid options: NONE, 15, 30"));
            return 0;
        }
        OutlookManager.enableManualMode();
        OutlookManager.setDay7(prob);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Day 7 set to: ").append((Component)OutlookCommand.formatProb(prob)), true);
        return 1;
    }

    private static OutlookManager.ProbCategory parseProbCategory(String name) {
        if (name.equalsIgnoreCase("NONE")) {
            return OutlookManager.ProbCategory.NONE;
        }
        if (name.equals("15") || name.equalsIgnoreCase("15%")) {
            return OutlookManager.ProbCategory.PROB_15;
        }
        if (name.equals("30") || name.equalsIgnoreCase("30%")) {
            return OutlookManager.ProbCategory.PROB_30;
        }
        return null;
    }

    private static int forceRollover(CommandContext<CommandSourceStack> context) {
        OutlookManager.forceRollover();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Day rollover triggered"), true);
        return 1;
    }

    private static int setAllUpgradeChances(CommandContext<CommandSourceStack> context, int chance) {
        OutlookManager.setAllUpgradeChances(chance);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("All upgrade chances set to: " + chance + "%")), true);
        return 1;
    }

    private static int setDayUpgradeChance(CommandContext<CommandSourceStack> context, int day, int chance) {
        OutlookManager.setUpgradeChance(day, chance);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Day " + day + " upgrade chance set to: " + chance + "%")), true);
        return 1;
    }
}

