/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.network;

import dev.wxmc.weatheraddon.WXMCWeatherAddon;
import dev.wxmc.weatheraddon.client.ClientNetworkHandlers;
import dev.wxmc.weatheraddon.warnings.AlertPolygon;
import dev.wxmc.weatheraddon.warnings.WarningLevel;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class WarningNetworkHandler {
    @SubscribeEvent
    public static void onRegisterPayloads(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("wxmcweatheraddon").versioned("1.0.0");
        if (FMLEnvironment.dist == Dist.CLIENT) {
            registrar.playToClient(WarningAlertPacket.TYPE, WarningAlertPacket.STREAM_CODEC, WarningNetworkHandler::handleWarningAlertClient);
            registrar.playToClient(RadarPolygonSyncPacket.TYPE, RadarPolygonSyncPacket.STREAM_CODEC, WarningNetworkHandler::handleRadarPolygonSyncClient);
            registrar.playToClient(WarningTemplateUpdatePacket.TYPE, WarningTemplateUpdatePacket.STREAM_CODEC, WarningNetworkHandler::handleWarningTemplateUpdateClient);
            registrar.playToClient(RadarRemovedPacket.TYPE, RadarRemovedPacket.STREAM_CODEC, WarningNetworkHandler::handleRadarRemovedClient);
            registrar.playToClient(SirenSoundStartPacket.TYPE, SirenSoundStartPacket.STREAM_CODEC, WarningNetworkHandler::handleSirenSoundStartClient);
            registrar.playToClient(SirenSoundStopPacket.TYPE, SirenSoundStopPacket.STREAM_CODEC, WarningNetworkHandler::handleSirenSoundStopClient);
        } else {
            registrar.playToClient(WarningAlertPacket.TYPE, WarningAlertPacket.STREAM_CODEC, (packet, context) -> {});
            registrar.playToClient(RadarPolygonSyncPacket.TYPE, RadarPolygonSyncPacket.STREAM_CODEC, (packet, context) -> {});
            registrar.playToClient(WarningTemplateUpdatePacket.TYPE, WarningTemplateUpdatePacket.STREAM_CODEC, (packet, context) -> {});
            registrar.playToClient(RadarRemovedPacket.TYPE, RadarRemovedPacket.STREAM_CODEC, (packet, context) -> {});
            registrar.playToClient(SirenSoundStartPacket.TYPE, SirenSoundStartPacket.STREAM_CODEC, (packet, context) -> {});
            registrar.playToClient(SirenSoundStopPacket.TYPE, SirenSoundStopPacket.STREAM_CODEC, (packet, context) -> {});
        }
        WXMCWeatherAddon.LOGGER.info("Warning network packets registered");
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleWarningAlertClient(WarningAlertPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> ClientNetworkHandlers.handleWarningAlert(packet.stormId(), packet.level(), packet.shortMessage(), packet.stormX(), packet.stormZ(), packet.direction(), packet.rawTemplate(), packet.warningColor(), packet.warningId()));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleRadarPolygonSyncClient(RadarPolygonSyncPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> ClientNetworkHandlers.handleRadarPolygonSync(packet.radarPos(), packet.polygons()));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleWarningTemplateUpdateClient(WarningTemplateUpdatePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> ClientNetworkHandlers.handleWarningTemplateUpdate(packet.warningId(), packet.rawTemplate()));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleRadarRemovedClient(RadarRemovedPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> ClientNetworkHandlers.handleRadarRemoved(packet.radarPos()));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleSirenSoundStartClient(SirenSoundStartPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> ClientNetworkHandlers.handleSirenSoundStart(packet.sirenPos(), packet.frequencyOrdinal()));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleSirenSoundStopClient(SirenSoundStopPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> ClientNetworkHandlers.handleSirenSoundStop(packet.sirenPos()));
    }

    public static void sendWarningAlert(ServerPlayer player, long stormId, WarningLevel level, String shortMessage, double stormX, double stormZ, String direction, String rawTemplate, int warningColor, String warningId) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new WarningAlertPacket(stormId, level, shortMessage, stormX, stormZ, direction, rawTemplate, warningColor, warningId), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendWarningAlert(ServerPlayer player, long stormId, WarningLevel level, String shortMessage, double stormX, double stormZ, String direction) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new WarningAlertPacket(stormId, level, shortMessage, stormX, stormZ, direction, "", 0xFFFFFF, ""), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void broadcastWarningAlert(long stormId, WarningLevel level, String shortMessage, double stormX, double stormZ, String direction) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new WarningAlertPacket(stormId, level, shortMessage, stormX, stormZ, direction, "", 0xFFFFFF, ""), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void broadcastRadarPolygons(BlockPos radarPos, List<AlertPolygon> polygons) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new RadarPolygonSyncPacket(radarPos, polygons), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendRadarPolygons(ServerPlayer player, BlockPos radarPos, List<AlertPolygon> polygons) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new RadarPolygonSyncPacket(radarPos, polygons), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendWarningTemplateUpdate(ServerPlayer player, String warningId, String rawTemplate) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new WarningTemplateUpdatePacket(warningId, rawTemplate), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void broadcastRadarRemoved(BlockPos radarPos) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new RadarRemovedPacket(radarPos), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void broadcastSirenSoundStart(BlockPos sirenPos, int frequencyOrdinal) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SirenSoundStartPacket(sirenPos, frequencyOrdinal), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void broadcastSirenSoundStop(BlockPos sirenPos) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SirenSoundStopPacket(sirenPos), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public record WarningAlertPacket(long stormId, WarningLevel level, String shortMessage, double stormX, double stormZ, String direction, String rawTemplate, int warningColor, String warningId) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<WarningAlertPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"wxmcweatheraddon", (String)"warning_alert"));
        public static final StreamCodec<FriendlyByteBuf, WarningAlertPacket> STREAM_CODEC = StreamCodec.of(WarningAlertPacket::encode, WarningAlertPacket::decode);

        public static void encode(FriendlyByteBuf buf, WarningAlertPacket packet) {
            buf.writeLong(packet.stormId);
            buf.writeEnum((Enum)packet.level);
            buf.writeUtf(packet.shortMessage, 256);
            buf.writeDouble(packet.stormX);
            buf.writeDouble(packet.stormZ);
            buf.writeUtf(packet.direction, 32);
            buf.writeUtf(packet.rawTemplate, 8192);
            buf.writeInt(packet.warningColor);
            buf.writeUtf(packet.warningId, 64);
        }

        public static WarningAlertPacket decode(FriendlyByteBuf buf) {
            return new WarningAlertPacket(buf.readLong(), (WarningLevel)buf.readEnum(WarningLevel.class), buf.readUtf(256), buf.readDouble(), buf.readDouble(), buf.readUtf(32), buf.readUtf(8192), buf.readInt(), buf.readUtf(64));
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record RadarPolygonSyncPacket(BlockPos radarPos, List<AlertPolygon> polygons) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<RadarPolygonSyncPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"wxmcweatheraddon", (String)"radar_polygon_sync"));
        public static final StreamCodec<FriendlyByteBuf, RadarPolygonSyncPacket> STREAM_CODEC = StreamCodec.of(RadarPolygonSyncPacket::encode, RadarPolygonSyncPacket::decode);

        public static void encode(FriendlyByteBuf buf, RadarPolygonSyncPacket packet) {
            buf.writeBlockPos(packet.radarPos);
            if (packet.polygons == null) {
                buf.writeInt(0);
                return;
            }
            buf.writeInt(packet.polygons.size());
            for (AlertPolygon poly : packet.polygons) {
                buf.writeLong(poly.stormId);
                buf.writeDouble(poly.centerX);
                buf.writeDouble(poly.centerZ);
                buf.writeFloat(poly.halfWidth);
                buf.writeFloat(poly.halfHeight);
                buf.writeFloat(poly.rotationDeg);
                buf.writeInt(poly.level);
                buf.writeInt(poly.stormType);
                buf.writeInt(poly.stormStage);
            }
        }

        public static RadarPolygonSyncPacket decode(FriendlyByteBuf buf) {
            BlockPos pos = buf.readBlockPos();
            int count = buf.readInt();
            ArrayList<AlertPolygon> polygons = new ArrayList<AlertPolygon>(count);
            for (int i = 0; i < count; ++i) {
                polygons.add(new AlertPolygon(buf.readLong(), buf.readDouble(), buf.readDouble(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readInt(), buf.readInt(), buf.readInt()));
            }
            return new RadarPolygonSyncPacket(pos, polygons);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record WarningTemplateUpdatePacket(String warningId, String rawTemplate) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<WarningTemplateUpdatePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"wxmcweatheraddon", (String)"warning_template_update"));
        public static final StreamCodec<FriendlyByteBuf, WarningTemplateUpdatePacket> STREAM_CODEC = StreamCodec.of(WarningTemplateUpdatePacket::encode, WarningTemplateUpdatePacket::decode);

        public static void encode(FriendlyByteBuf buf, WarningTemplateUpdatePacket packet) {
            buf.writeUtf(packet.warningId, 64);
            buf.writeUtf(packet.rawTemplate, 8192);
        }

        public static WarningTemplateUpdatePacket decode(FriendlyByteBuf buf) {
            return new WarningTemplateUpdatePacket(buf.readUtf(64), buf.readUtf(8192));
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record RadarRemovedPacket(BlockPos radarPos) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<RadarRemovedPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"wxmcweatheraddon", (String)"radar_removed"));
        public static final StreamCodec<FriendlyByteBuf, RadarRemovedPacket> STREAM_CODEC = StreamCodec.of(RadarRemovedPacket::encode, RadarRemovedPacket::decode);

        public static void encode(FriendlyByteBuf buf, RadarRemovedPacket packet) {
            buf.writeBlockPos(packet.radarPos);
        }

        public static RadarRemovedPacket decode(FriendlyByteBuf buf) {
            return new RadarRemovedPacket(buf.readBlockPos());
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record SirenSoundStartPacket(BlockPos sirenPos, int frequencyOrdinal) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SirenSoundStartPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"wxmcweatheraddon", (String)"siren_sound_start"));
        public static final StreamCodec<FriendlyByteBuf, SirenSoundStartPacket> STREAM_CODEC = StreamCodec.of(SirenSoundStartPacket::encode, SirenSoundStartPacket::decode);

        public static void encode(FriendlyByteBuf buf, SirenSoundStartPacket packet) {
            buf.writeBlockPos(packet.sirenPos);
            buf.writeInt(packet.frequencyOrdinal);
        }

        public static SirenSoundStartPacket decode(FriendlyByteBuf buf) {
            return new SirenSoundStartPacket(buf.readBlockPos(), buf.readInt());
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record SirenSoundStopPacket(BlockPos sirenPos) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SirenSoundStopPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"wxmcweatheraddon", (String)"siren_sound_stop"));
        public static final StreamCodec<FriendlyByteBuf, SirenSoundStopPacket> STREAM_CODEC = StreamCodec.of(SirenSoundStopPacket::encode, SirenSoundStopPacket::decode);

        public static void encode(FriendlyByteBuf buf, SirenSoundStopPacket packet) {
            buf.writeBlockPos(packet.sirenPos);
        }

        public static SirenSoundStopPacket decode(FriendlyByteBuf buf) {
            return new SirenSoundStopPacket(buf.readBlockPos());
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

