/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.network;

import dev.wxmc.weatheraddon.Config;
import dev.wxmc.weatheraddon.client.ClientNetworkHandlers;
import dev.wxmc.weatheraddon.sounding.ServerSoundingManager;
import dev.wxmc.weatheraddon.sounding.SoundingData;
import dev.wxmc.weatheraddon.sounding.SoundingLevel;
import dev.wxmc.weatheraddon.util.WXMCDebugLogger;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class SoundingNetworkHandler {
    @SubscribeEvent
    public static void onRegisterPayloads(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("wxmcweatheraddon").versioned("1.0.0");
        if (FMLEnvironment.dist == Dist.CLIENT) {
            registrar.playToClient(SoundingSyncPacket.TYPE, SoundingSyncPacket.STREAM_CODEC, SoundingNetworkHandler::handleSoundingSyncClient);
            registrar.playToClient(SoundingClearPacket.TYPE, SoundingClearPacket.STREAM_CODEC, SoundingNetworkHandler::handleSoundingClearClient);
        } else {
            registrar.playToClient(SoundingSyncPacket.TYPE, SoundingSyncPacket.STREAM_CODEC, (packet, context) -> {});
            registrar.playToClient(SoundingClearPacket.TYPE, SoundingClearPacket.STREAM_CODEC, (packet, context) -> {});
        }
        WXMCDebugLogger.info("[SOUNDING NET] Sounding network packets registered");
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleSoundingSyncClient(SoundingSyncPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> ClientNetworkHandlers.handleSoundingSync(packet));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleSoundingClearClient(SoundingClearPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> ClientNetworkHandlers.handleSoundingClear());
    }

    private static SoundingSyncPacket createPacket(SoundingData data, ServerSoundingManager.RiskCategory risk) {
        ArrayList<SoundingSyncPacket.LevelData> levels = new ArrayList<SoundingSyncPacket.LevelData>();
        for (SoundingLevel level : data.getLevels()) {
            levels.add(new SoundingSyncPacket.LevelData(level.getHeightM(), level.getTemperatureC(), level.getDewpointC(), level.getPressureMb(), level.getWindDirectionDeg() != null ? level.getWindDirectionDeg().floatValue() : 0.0f, level.getWindSpeedKts() != null ? level.getWindSpeedKts().floatValue() : 0.0f, level.hasWindData()));
        }
        return new SoundingSyncPacket(data.getStationId() != null ? data.getStationId() : "UNKNOWN", data.getStationName() != null ? data.getStationName() : "Unknown Station", data.getTimestamp() != null ? data.getTimestamp() : "", risk != null ? risk.getFolderName() : "TSTM", levels);
    }

    public static void sendSounding(ServerPlayer player, SoundingData data, ServerSoundingManager.RiskCategory risk) {
        if (data == null) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SoundingClearPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return;
        }
        SoundingSyncPacket packet = SoundingNetworkHandler.createPacket(data, risk);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        if (Config.isDebugMode()) {
            WXMCDebugLogger.debug("[SOUNDING NET] Sent sounding to {}: {} ({}) - {} levels", player.getName().getString(), data.getStationId(), risk.getFolderName(), data.getLevelCount());
        }
    }

    public static void broadcastSounding(SoundingData data, ServerSoundingManager.RiskCategory risk) {
        if (data == null) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SoundingClearPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return;
        }
        SoundingSyncPacket packet = SoundingNetworkHandler.createPacket(data, risk);
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        WXMCDebugLogger.info("[SOUNDING NET] Broadcast sounding to all players: {} ({}) - {} levels", data.getStationId(), risk.getFolderName(), data.getLevelCount());
    }

    public static void broadcastClear() {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SoundingClearPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public record SoundingSyncPacket(String stationId, String stationName, String timestamp, String riskCategory, List<LevelData> levels) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SoundingSyncPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"wxmcweatheraddon", (String)"sounding_sync"));
        public static final StreamCodec<FriendlyByteBuf, SoundingSyncPacket> STREAM_CODEC = StreamCodec.of(SoundingSyncPacket::encode, SoundingSyncPacket::decode);

        public static void encode(FriendlyByteBuf buf, SoundingSyncPacket packet) {
            buf.writeUtf(packet.stationId, 32);
            buf.writeUtf(packet.stationName, 128);
            buf.writeUtf(packet.timestamp, 64);
            buf.writeUtf(packet.riskCategory, 16);
            buf.writeInt(packet.levels.size());
            for (LevelData level : packet.levels) {
                LevelData.encode(buf, level);
            }
        }

        public static SoundingSyncPacket decode(FriendlyByteBuf buf) {
            String stationId = buf.readUtf(32);
            String stationName = buf.readUtf(128);
            String timestamp = buf.readUtf(64);
            String riskCategory = buf.readUtf(16);
            int levelCount = buf.readInt();
            ArrayList<LevelData> levels = new ArrayList<LevelData>(levelCount);
            for (int i = 0; i < levelCount; ++i) {
                levels.add(LevelData.decode(buf));
            }
            return new SoundingSyncPacket(stationId, stationName, timestamp, riskCategory, levels);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public SoundingData toSoundingData() {
            ArrayList<SoundingLevel> soundingLevels = new ArrayList<SoundingLevel>(this.levels.size());
            for (LevelData level : this.levels) {
                if (level.hasWind) {
                    soundingLevels.add(new SoundingLevel(level.heightM, level.temperatureC, level.dewpointC, level.pressureMb, Float.valueOf(level.windDirectionDeg), Float.valueOf(level.windSpeedKts)));
                    continue;
                }
                soundingLevels.add(new SoundingLevel(level.heightM, level.temperatureC, level.dewpointC, level.pressureMb));
            }
            return new SoundingData(this.stationId, this.stationName, soundingLevels);
        }

        public record LevelData(float heightM, float temperatureC, float dewpointC, float pressureMb, float windDirectionDeg, float windSpeedKts, boolean hasWind) {
            public static void encode(FriendlyByteBuf buf, LevelData level) {
                buf.writeFloat(level.heightM);
                buf.writeFloat(level.temperatureC);
                buf.writeFloat(level.dewpointC);
                buf.writeFloat(level.pressureMb);
                buf.writeBoolean(level.hasWind);
                if (level.hasWind) {
                    buf.writeFloat(level.windDirectionDeg);
                    buf.writeFloat(level.windSpeedKts);
                }
            }

            public static LevelData decode(FriendlyByteBuf buf) {
                float height = buf.readFloat();
                float temp = buf.readFloat();
                float dewpoint = buf.readFloat();
                float pressure = buf.readFloat();
                boolean hasWind = buf.readBoolean();
                float windDir = 0.0f;
                float windSpd = 0.0f;
                if (hasWind) {
                    windDir = buf.readFloat();
                    windSpd = buf.readFloat();
                }
                return new LevelData(height, temp, dewpoint, pressure, windDir, windSpd, hasWind);
            }
        }
    }

    public record SoundingClearPacket() implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SoundingClearPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"wxmcweatheraddon", (String)"sounding_clear"));
        public static final StreamCodec<FriendlyByteBuf, SoundingClearPacket> STREAM_CODEC = StreamCodec.of(SoundingClearPacket::encode, SoundingClearPacket::decode);

        public static void encode(FriendlyByteBuf buf, SoundingClearPacket packet) {
        }

        public static SoundingClearPacket decode(FriendlyByteBuf buf) {
            return new SoundingClearPacket();
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

