/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.network;

import dev.wxmc.weatheraddon.client.ClientNetworkHandlers;
import dev.wxmc.weatheraddon.compat.PhotoMetadataStorage;
import dev.wxmc.weatheraddon.util.WXMCDebugLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class PhotoMetadataNetworkHandler {
    @SubscribeEvent
    public static void onRegisterPayloads(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("wxmcweatheraddon").versioned("1.0.0");
        if (FMLEnvironment.dist == Dist.CLIENT) {
            registrar.playToClient(PhotoMetadataSyncPacket.TYPE, PhotoMetadataSyncPacket.STREAM_CODEC, PhotoMetadataNetworkHandler::handlePhotoMetadataSyncClient);
            registrar.playToClient(PhotoMetadataBulkSyncPacket.TYPE, PhotoMetadataBulkSyncPacket.STREAM_CODEC, PhotoMetadataNetworkHandler::handlePhotoMetadataBulkSyncClient);
        } else {
            registrar.playToClient(PhotoMetadataSyncPacket.TYPE, PhotoMetadataSyncPacket.STREAM_CODEC, (packet, context) -> {});
            registrar.playToClient(PhotoMetadataBulkSyncPacket.TYPE, PhotoMetadataBulkSyncPacket.STREAM_CODEC, (packet, context) -> {});
        }
        WXMCDebugLogger.info("[PHOTO META NET] Photo metadata network packets registered");
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handlePhotoMetadataSyncClient(PhotoMetadataSyncPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> ClientNetworkHandlers.handlePhotoMetadataSync(packet));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handlePhotoMetadataBulkSyncClient(PhotoMetadataBulkSyncPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> ClientNetworkHandlers.handlePhotoMetadataBulkSync(packet));
    }

    public static void broadcastPhotoMetadata(String photoId, String photographer, int x, int z) {
        PhotoMetadataSyncPacket packet = new PhotoMetadataSyncPacket(photoId, photographer, x, z);
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        WXMCDebugLogger.debug("[PHOTO META NET] Broadcast photo metadata: {} by {} at ({}, {})", photoId, photographer, x, z);
    }

    public static void syncAllMetadataToPlayer(ServerPlayer player) {
        Map<String, PhotoMetadataStorage.PhotoMetadata> allMetadata = PhotoMetadataStorage.getAllMetadata();
        if (allMetadata.isEmpty()) {
            WXMCDebugLogger.debug("[PHOTO META NET] No photo metadata to sync to {}", player.getName().getString());
            return;
        }
        ArrayList<PhotoMetadataBulkSyncPacket.PhotoMetadataEntry> entries = new ArrayList<PhotoMetadataBulkSyncPacket.PhotoMetadataEntry>();
        for (Map.Entry<String, PhotoMetadataStorage.PhotoMetadata> entry : allMetadata.entrySet()) {
            PhotoMetadataStorage.PhotoMetadata meta = entry.getValue();
            entries.add(new PhotoMetadataBulkSyncPacket.PhotoMetadataEntry(entry.getKey(), meta.getPhotographer(), meta.getX(), meta.getZ()));
        }
        PhotoMetadataBulkSyncPacket packet = new PhotoMetadataBulkSyncPacket(entries);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        WXMCDebugLogger.info("[PHOTO META NET] Synced {} photo metadata entries to {}", entries.size(), player.getName().getString());
    }

    public record PhotoMetadataSyncPacket(String photoId, String photographer, int x, int z) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PhotoMetadataSyncPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"wxmcweatheraddon", (String)"photo_metadata_sync"));
        public static final StreamCodec<FriendlyByteBuf, PhotoMetadataSyncPacket> STREAM_CODEC = StreamCodec.of(PhotoMetadataSyncPacket::encode, PhotoMetadataSyncPacket::decode);

        public static void encode(FriendlyByteBuf buf, PhotoMetadataSyncPacket packet) {
            buf.writeUtf(packet.photoId, 128);
            buf.writeUtf(packet.photographer, 64);
            buf.writeInt(packet.x);
            buf.writeInt(packet.z);
        }

        public static PhotoMetadataSyncPacket decode(FriendlyByteBuf buf) {
            String photoId = buf.readUtf(128);
            String photographer = buf.readUtf(64);
            int x = buf.readInt();
            int z = buf.readInt();
            return new PhotoMetadataSyncPacket(photoId, photographer, x, z);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record PhotoMetadataBulkSyncPacket(List<PhotoMetadataEntry> entries) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PhotoMetadataBulkSyncPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"wxmcweatheraddon", (String)"photo_metadata_bulk_sync"));
        public static final StreamCodec<FriendlyByteBuf, PhotoMetadataBulkSyncPacket> STREAM_CODEC = StreamCodec.of(PhotoMetadataBulkSyncPacket::encode, PhotoMetadataBulkSyncPacket::decode);

        public static void encode(FriendlyByteBuf buf, PhotoMetadataBulkSyncPacket packet) {
            buf.writeInt(packet.entries.size());
            for (PhotoMetadataEntry entry : packet.entries) {
                PhotoMetadataEntry.encode(buf, entry);
            }
        }

        public static PhotoMetadataBulkSyncPacket decode(FriendlyByteBuf buf) {
            int count = buf.readInt();
            ArrayList<PhotoMetadataEntry> entries = new ArrayList<PhotoMetadataEntry>(count);
            for (int i = 0; i < count; ++i) {
                entries.add(PhotoMetadataEntry.decode(buf));
            }
            return new PhotoMetadataBulkSyncPacket(entries);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public record PhotoMetadataEntry(String photoId, String photographer, int x, int z) {
            public static void encode(FriendlyByteBuf buf, PhotoMetadataEntry entry) {
                buf.writeUtf(entry.photoId, 128);
                buf.writeUtf(entry.photographer, 64);
                buf.writeInt(entry.x);
                buf.writeInt(entry.z);
            }

            public static PhotoMetadataEntry decode(FriendlyByteBuf buf) {
                return new PhotoMetadataEntry(buf.readUtf(128), buf.readUtf(64), buf.readInt(), buf.readInt());
            }
        }
    }
}

