/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.network;

import dev.wxmc.weatheraddon.WXMCWeatherAddon;
import dev.wxmc.weatheraddon.client.ClientNetworkHandlers;
import dev.wxmc.weatheraddon.compat.BukkitEventBridge;
import dev.wxmc.weatheraddon.data.SubmissionReview;
import dev.wxmc.weatheraddon.data.TornadoDatabase;
import dev.wxmc.weatheraddon.data.TornadoEntry;
import dev.wxmc.weatheraddon.data.TornadoRating;
import dev.wxmc.weatheraddon.util.PermissionHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class DamageAssessmentNetworkHandler {
    @SubscribeEvent
    public static void onRegisterPayloads(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("wxmcweatheraddon").versioned("1.3.0");
        registrar.playToServer(SubmitAssessmentPacket.TYPE, SubmitAssessmentPacket.STREAM_CODEC, DamageAssessmentNetworkHandler::handleSubmitAssessment);
        registrar.playToServer(RequestDatabasePacket.TYPE, RequestDatabasePacket.STREAM_CODEC, DamageAssessmentNetworkHandler::handleRequestDatabase);
        registrar.playToServer(SubmitReviewPacket.TYPE, SubmitReviewPacket.STREAM_CODEC, DamageAssessmentNetworkHandler::handleSubmitReview);
        registrar.playToServer(AdminActionPacket.TYPE, AdminActionPacket.STREAM_CODEC, DamageAssessmentNetworkHandler::handleAdminAction);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            registrar.playToClient(DatabaseEntriesPacket.TYPE, DatabaseEntriesPacket.STREAM_CODEC, DamageAssessmentNetworkHandler::handleDatabaseEntriesClient);
            registrar.playToClient(SubmissionResultPacket.TYPE, SubmissionResultPacket.STREAM_CODEC, DamageAssessmentNetworkHandler::handleSubmissionResultClient);
            registrar.playToClient(OpenAssessmentGuiPacket.TYPE, OpenAssessmentGuiPacket.STREAM_CODEC, DamageAssessmentNetworkHandler::handleOpenGuiClient);
        } else {
            registrar.playToClient(DatabaseEntriesPacket.TYPE, DatabaseEntriesPacket.STREAM_CODEC, (packet, context) -> {});
            registrar.playToClient(SubmissionResultPacket.TYPE, SubmissionResultPacket.STREAM_CODEC, (packet, context) -> {});
            registrar.playToClient(OpenAssessmentGuiPacket.TYPE, OpenAssessmentGuiPacket.STREAM_CODEC, (packet, context) -> {});
        }
        WXMCWeatherAddon.LOGGER.info("Damage assessment network packets registered (v1.3.0 with admin actions)");
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleDatabaseEntriesClient(DatabaseEntriesPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> ClientNetworkHandlers.handleDatabaseEntries(packet.entries(), packet.isAdmin()));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleSubmissionResultClient(SubmissionResultPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> ClientNetworkHandlers.handleSubmissionResult(packet.success(), packet.message()));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleOpenGuiClient(OpenAssessmentGuiPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> ClientNetworkHandlers.handleOpenAssessmentGui());
    }

    private static void handleSubmitAssessment(SubmitAssessmentPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            if (packet.eventId() == null || packet.eventId().isBlank()) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SubmissionResultPacket(false, "Event ID is required."), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return;
            }
            if (packet.photoIds().size() < 3) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SubmissionResultPacket(false, "At least 3 photos are required."), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return;
            }
            TornadoEntry entry = new TornadoEntry(UUID.randomUUID(), packet.eventId().trim(), packet.rating(), packet.windspeedEst() != null ? packet.windspeedEst().trim() : "", packet.coordX(), packet.coordZ(), packet.notes() != null ? packet.notes().trim() : "", player.getUUID(), player.getName().getString(), System.currentTimeMillis(), Collections.unmodifiableList(new ArrayList<String>(packet.photoIds())), Collections.emptyList());
            TornadoDatabase.getOrCreate(player.getServer()).addEntry(entry);
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SubmissionResultPacket(true, "Assessment submitted successfully with " + packet.photoIds().size() + " photos!"), (CustomPacketPayload[])new CustomPacketPayload[0]);
            WXMCWeatherAddon.LOGGER.info("Player {} submitted tornado assessment: {} ({}) with {} photos", new Object[]{player.getName().getString(), packet.eventId(), packet.rating().getDisplayName(), packet.photoIds().size()});
            BukkitEventBridge.fireTornadoAssessed(player, entry.entryId(), entry.rating().name(), entry.rating().ordinal(), packet.photoIds().size(), entry.coordX(), entry.coordZ());
        });
    }

    private static void handleRequestDatabase(RequestDatabasePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            List<TornadoEntry> entries = TornadoDatabase.getOrCreate(player.getServer()).getEntries();
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new DatabaseEntriesPacket(new ArrayList<TornadoEntry>(entries)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        });
    }

    private static void handleSubmitReview(SubmitReviewPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            TornadoDatabase db = TornadoDatabase.getOrCreate(player.getServer());
            Optional<TornadoEntry> entryOpt = db.getEntry(packet.entryId());
            if (entryOpt.isEmpty()) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SubmissionResultPacket(false, "Entry not found."), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return;
            }
            TornadoEntry entry = entryOpt.get();
            boolean isVerifiedAdmin = false;
            if (packet.isAdmin() && (player.hasPermissions(2) || PermissionHelper.hasPermission(player, "wxmc.admin"))) {
                isVerifiedAdmin = true;
            }
            if (!isVerifiedAdmin && entry.submitterUUID().equals(player.getUUID())) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SubmissionResultPacket(false, "You cannot review your own submission."), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return;
            }
            if (!isVerifiedAdmin && entry.hasUserReviewed(player.getUUID())) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SubmissionResultPacket(false, "You have already reviewed this submission."), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return;
            }
            SubmissionReview review = new SubmissionReview(UUID.randomUUID(), player.getUUID(), player.getName().getString(), packet.agreement(), packet.suggestedRating(), packet.notes() != null ? packet.notes().trim() : "", System.currentTimeMillis());
            db.addReviewToEntry(packet.entryId(), review);
            String successMessage = isVerifiedAdmin ? "Review submitted successfully! (Admin)" : "Review submitted successfully!";
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SubmissionResultPacket(true, successMessage), (CustomPacketPayload[])new CustomPacketPayload[0]);
            WXMCWeatherAddon.LOGGER.info("Player {} submitted review for entry {}: {}{}", new Object[]{player.getName().getString(), packet.entryId(), packet.agreement().getDisplayName(), isVerifiedAdmin ? " (admin)" : ""});
        });
    }

    private static void handleAdminAction(AdminActionPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            if (!player.hasPermissions(2) && !PermissionHelper.hasPermission(player, "wxmc.admin")) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SubmissionResultPacket(false, "You do not have admin permission."), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return;
            }
            TornadoDatabase db = TornadoDatabase.getOrCreate(player.getServer());
            switch (packet.action().ordinal()) {
                case 0: {
                    boolean success = db.removeEntry(packet.entryId());
                    if (success) {
                        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SubmissionResultPacket(true, "Entry deleted."), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        WXMCWeatherAddon.LOGGER.info("Admin {} deleted entry {}", (Object)player.getName().getString(), (Object)packet.entryId());
                        break;
                    }
                    PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SubmissionResultPacket(false, "Entry not found."), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    break;
                }
                case 1: {
                    boolean success = db.acceptEntry(packet.entryId());
                    if (success) {
                        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SubmissionResultPacket(true, "Entry accepted."), (CustomPacketPayload[])new CustomPacketPayload[0]);
                        WXMCWeatherAddon.LOGGER.info("Admin {} accepted entry {}", (Object)player.getName().getString(), (Object)packet.entryId());
                        break;
                    }
                    PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SubmissionResultPacket(false, "Entry not found."), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        });
    }

    public static void sendDatabaseRequest() {
        PacketDistributor.sendToServer((CustomPacketPayload)new RequestDatabasePacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendDatabaseEntries(ServerPlayer player, List<TornadoEntry> entries) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new DatabaseEntriesPacket(entries, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendDatabaseEntriesAdmin(ServerPlayer player, List<TornadoEntry> entries) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new DatabaseEntriesPacket(entries, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendOpenGui(ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new OpenAssessmentGuiPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public record SubmitAssessmentPacket(String eventId, TornadoRating rating, String windspeedEst, int coordX, int coordZ, String notes, List<String> photoIds) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SubmitAssessmentPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"wxmcweatheraddon", (String)"submit_assessment"));
        public static final StreamCodec<FriendlyByteBuf, SubmitAssessmentPacket> STREAM_CODEC = StreamCodec.of(SubmitAssessmentPacket::encode, SubmitAssessmentPacket::decode);

        public static void encode(FriendlyByteBuf buf, SubmitAssessmentPacket packet) {
            buf.writeUtf(packet.eventId, 64);
            buf.writeEnum((Enum)packet.rating);
            buf.writeUtf(packet.windspeedEst, 32);
            buf.writeInt(packet.coordX);
            buf.writeInt(packet.coordZ);
            buf.writeUtf(packet.notes, 512);
            buf.writeInt(packet.photoIds.size());
            for (String id : packet.photoIds) {
                buf.writeUtf(id, 128);
            }
        }

        public static SubmitAssessmentPacket decode(FriendlyByteBuf buf) {
            String eventId = buf.readUtf(64);
            TornadoRating rating = (TornadoRating)buf.readEnum(TornadoRating.class);
            String windspeedEst = buf.readUtf(32);
            int coordX = buf.readInt();
            int coordZ = buf.readInt();
            String notes = buf.readUtf(512);
            int photoCount = buf.readInt();
            ArrayList<String> photoIds = new ArrayList<String>(photoCount);
            for (int i = 0; i < photoCount; ++i) {
                photoIds.add(buf.readUtf(128));
            }
            return new SubmitAssessmentPacket(eventId, rating, windspeedEst, coordX, coordZ, notes, photoIds);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record RequestDatabasePacket() implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<RequestDatabasePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"wxmcweatheraddon", (String)"request_database"));
        public static final StreamCodec<FriendlyByteBuf, RequestDatabasePacket> STREAM_CODEC = StreamCodec.of((buf, packet) -> {}, buf -> new RequestDatabasePacket());

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record SubmitReviewPacket(UUID entryId, SubmissionReview.ReviewAgreement agreement, TornadoRating suggestedRating, String notes, boolean isAdmin) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SubmitReviewPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"wxmcweatheraddon", (String)"submit_review"));
        public static final StreamCodec<FriendlyByteBuf, SubmitReviewPacket> STREAM_CODEC = StreamCodec.of(SubmitReviewPacket::encode, SubmitReviewPacket::decode);

        public SubmitReviewPacket(UUID entryId, SubmissionReview.ReviewAgreement agreement, TornadoRating suggestedRating, String notes) {
            this(entryId, agreement, suggestedRating, notes, false);
        }

        public static void encode(FriendlyByteBuf buf, SubmitReviewPacket packet) {
            buf.writeUUID(packet.entryId);
            buf.writeEnum((Enum)packet.agreement);
            buf.writeBoolean(packet.suggestedRating != null);
            if (packet.suggestedRating != null) {
                buf.writeEnum((Enum)packet.suggestedRating);
            }
            buf.writeUtf(packet.notes != null ? packet.notes : "", 512);
            buf.writeBoolean(packet.isAdmin);
        }

        public static SubmitReviewPacket decode(FriendlyByteBuf buf) {
            UUID entryId = buf.readUUID();
            SubmissionReview.ReviewAgreement agreement = (SubmissionReview.ReviewAgreement)buf.readEnum(SubmissionReview.ReviewAgreement.class);
            TornadoRating suggestedRating = null;
            if (buf.readBoolean()) {
                suggestedRating = (TornadoRating)buf.readEnum(TornadoRating.class);
            }
            String notes = buf.readUtf(512);
            boolean isAdmin = buf.readBoolean();
            return new SubmitReviewPacket(entryId, agreement, suggestedRating, notes, isAdmin);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record AdminActionPacket(UUID entryId, Action action) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<AdminActionPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"wxmcweatheraddon", (String)"admin_action"));
        public static final StreamCodec<FriendlyByteBuf, AdminActionPacket> STREAM_CODEC = StreamCodec.of(AdminActionPacket::encode, AdminActionPacket::decode);

        public static void encode(FriendlyByteBuf buf, AdminActionPacket packet) {
            buf.writeUUID(packet.entryId);
            buf.writeEnum((Enum)packet.action);
        }

        public static AdminActionPacket decode(FriendlyByteBuf buf) {
            UUID entryId = buf.readUUID();
            Action action = (Action)buf.readEnum(Action.class);
            return new AdminActionPacket(entryId, action);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public static enum Action {
            DELETE,
            ACCEPT;

        }
    }

    public record DatabaseEntriesPacket(List<TornadoEntry> entries, boolean isAdmin) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<DatabaseEntriesPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"wxmcweatheraddon", (String)"database_entries"));
        public static final StreamCodec<FriendlyByteBuf, DatabaseEntriesPacket> STREAM_CODEC = StreamCodec.of(DatabaseEntriesPacket::encode, DatabaseEntriesPacket::decode);

        public DatabaseEntriesPacket(List<TornadoEntry> entries) {
            this(entries, false);
        }

        public static void encode(FriendlyByteBuf buf, DatabaseEntriesPacket packet) {
            buf.writeBoolean(packet.isAdmin);
            buf.writeInt(packet.entries.size());
            for (TornadoEntry entry : packet.entries) {
                List<SubmissionReview> reviews;
                buf.writeUUID(entry.entryId());
                buf.writeUtf(entry.eventId(), 64);
                buf.writeEnum((Enum)entry.rating());
                buf.writeUtf(entry.windspeedEst(), 32);
                buf.writeInt(entry.coordX());
                buf.writeInt(entry.coordZ());
                buf.writeUtf(entry.notes(), 512);
                buf.writeUUID(entry.submitterUUID());
                buf.writeUtf(entry.submitterName(), 64);
                buf.writeLong(entry.timestamp());
                List<String> photoIds = entry.photoIds();
                buf.writeInt(photoIds != null ? photoIds.size() : 0);
                if (photoIds != null) {
                    for (String id : photoIds) {
                        buf.writeUtf(id, 128);
                    }
                }
                buf.writeInt((reviews = entry.reviews()) != null ? reviews.size() : 0);
                if (reviews != null) {
                    for (SubmissionReview review : reviews) {
                        buf.writeUUID(review.reviewId());
                        buf.writeUUID(review.reviewerUUID());
                        buf.writeUtf(review.reviewerName(), 64);
                        buf.writeEnum((Enum)review.agreement());
                        buf.writeBoolean(review.suggestedRating() != null);
                        if (review.suggestedRating() != null) {
                            buf.writeEnum((Enum)review.suggestedRating());
                        }
                        buf.writeUtf(review.notes() != null ? review.notes() : "", 512);
                        buf.writeLong(review.timestamp());
                    }
                }
                buf.writeBoolean(entry.accepted());
            }
        }

        public static DatabaseEntriesPacket decode(FriendlyByteBuf buf) {
            boolean isAdmin = buf.readBoolean();
            int count = buf.readInt();
            ArrayList<TornadoEntry> entries = new ArrayList<TornadoEntry>(count);
            for (int i = 0; i < count; ++i) {
                UUID entryId = buf.readUUID();
                String eventId = buf.readUtf(64);
                TornadoRating rating = (TornadoRating)buf.readEnum(TornadoRating.class);
                String windspeedEst = buf.readUtf(32);
                int coordX = buf.readInt();
                int coordZ = buf.readInt();
                String notes = buf.readUtf(512);
                UUID submitterUUID = buf.readUUID();
                String submitterName = buf.readUtf(64);
                long timestamp = buf.readLong();
                int photoCount = buf.readInt();
                ArrayList<String> photoIds = new ArrayList<String>(photoCount);
                for (int j = 0; j < photoCount; ++j) {
                    photoIds.add(buf.readUtf(128));
                }
                int reviewCount = buf.readInt();
                ArrayList<SubmissionReview> reviews = new ArrayList<SubmissionReview>(reviewCount);
                for (int j = 0; j < reviewCount; ++j) {
                    UUID reviewId = buf.readUUID();
                    UUID reviewerUUID = buf.readUUID();
                    String reviewerName = buf.readUtf(64);
                    SubmissionReview.ReviewAgreement agreement = (SubmissionReview.ReviewAgreement)buf.readEnum(SubmissionReview.ReviewAgreement.class);
                    TornadoRating suggestedRating = null;
                    if (buf.readBoolean()) {
                        suggestedRating = (TornadoRating)buf.readEnum(TornadoRating.class);
                    }
                    String reviewNotes = buf.readUtf(512);
                    long reviewTimestamp = buf.readLong();
                    reviews.add(new SubmissionReview(reviewId, reviewerUUID, reviewerName, agreement, suggestedRating, reviewNotes, reviewTimestamp));
                }
                boolean accepted = buf.readBoolean();
                entries.add(new TornadoEntry(entryId, eventId, rating, windspeedEst, coordX, coordZ, notes, submitterUUID, submitterName, timestamp, Collections.unmodifiableList(photoIds), Collections.unmodifiableList(reviews), accepted));
            }
            return new DatabaseEntriesPacket(entries, isAdmin);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record SubmissionResultPacket(boolean success, String message) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SubmissionResultPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"wxmcweatheraddon", (String)"submission_result"));
        public static final StreamCodec<FriendlyByteBuf, SubmissionResultPacket> STREAM_CODEC = StreamCodec.of(SubmissionResultPacket::encode, SubmissionResultPacket::decode);

        public static void encode(FriendlyByteBuf buf, SubmissionResultPacket packet) {
            buf.writeBoolean(packet.success);
            buf.writeUtf(packet.message, 256);
        }

        public static SubmissionResultPacket decode(FriendlyByteBuf buf) {
            return new SubmissionResultPacket(buf.readBoolean(), buf.readUtf(256));
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public record OpenAssessmentGuiPacket() implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<OpenAssessmentGuiPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"wxmcweatheraddon", (String)"open_assessment_gui"));
        public static final StreamCodec<FriendlyByteBuf, OpenAssessmentGuiPacket> STREAM_CODEC = StreamCodec.of((buf, packet) -> {}, buf -> new OpenAssessmentGuiPacket());

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

