/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.mixin;

import dev.protomanly.pmweather.weather.WindEngine;
import dev.wxmc.weatheraddon.util.WindCache;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WindEngine.class}, remap=false)
public class WindEngineCachingMixin {
    @Inject(method={"getWind(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/level/Level;ZZZZ)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void wxmc$getCachedWind(Vec3 position, Level level, boolean ignoreStorms, boolean ignoreTornadoes, boolean windCheck, boolean windAnyway, CallbackInfoReturnable<Vec3> cir) {
        if (level == null) {
            return;
        }
        long gameTime = level.getGameTime();
        WindCache.cleanupIfNeeded(gameTime);
        WindCache.WindCacheKey key = WindCache.createKey(position, level.dimension().location().toString(), ignoreStorms, ignoreTornadoes, windCheck, windAnyway);
        Vec3 cached = WindCache.getCached(key, gameTime);
        if (cached != null) {
            cir.setReturnValue((Object)cached);
        }
    }

    @Inject(method={"getWind(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/level/Level;ZZZZ)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="RETURN")})
    private static void wxmc$cacheWindResult(Vec3 position, Level level, boolean ignoreStorms, boolean ignoreTornadoes, boolean windCheck, boolean windAnyway, CallbackInfoReturnable<Vec3> cir) {
        if (level == null) {
            return;
        }
        Vec3 result = (Vec3)cir.getReturnValue();
        if (result == null) {
            return;
        }
        if (Double.isNaN(result.x) || Double.isNaN(result.y) || Double.isNaN(result.z)) {
            return;
        }
        long gameTime = level.getGameTime();
        WindCache.WindCacheKey key = WindCache.createKey(position, level.dimension().location().toString(), ignoreStorms, ignoreTornadoes, windCheck, windAnyway);
        WindCache.put(key, result, gameTime);
    }
}

