/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.mixin;

import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class WXMCMixinPlugin
implements IMixinConfigPlugin {
    private static boolean pmweatherPresent = false;
    private static boolean radarRendererPresent = false;
    private static boolean thermodynamicEnginePresent = false;
    private static boolean soundingViewerRendererPresent = false;
    private static boolean soundingViewerBlockPresent = false;
    private static boolean exposurePresent = false;

    public void onLoad(String mixinPackage) {
        String colorTablesPath = "dev/protomanly/pmweather/util/ColorTables.class";
        String radarRendererPath = "dev/protomanly/pmweather/render/RadarRenderer.class";
        String thermodynamicEnginePath = "dev/protomanly/pmweather/weather/ThermodynamicEngine.class";
        String soundingViewerRendererPath = "dev/protomanly/pmweather/render/SoundingViewerRenderer.class";
        String soundingViewerBlockPath = "dev/protomanly/pmweather/block/SoundingViewerBlock.class";
        pmweatherPresent = this.getClass().getClassLoader().getResource(colorTablesPath) != null;
        radarRendererPresent = this.getClass().getClassLoader().getResource(radarRendererPath) != null;
        thermodynamicEnginePresent = this.getClass().getClassLoader().getResource(thermodynamicEnginePath) != null;
        soundingViewerRendererPresent = this.getClass().getClassLoader().getResource(soundingViewerRendererPath) != null;
        soundingViewerBlockPresent = this.getClass().getClassLoader().getResource(soundingViewerBlockPath) != null;
        String photographItemPath = "io/github/mortuusars/exposure/world/item/PhotographItem.class";
        exposurePresent = this.getClass().getClassLoader().getResource(photographItemPath) != null;
        System.out.println("[WXMC] MixinPlugin: PMWeather ColorTables present? " + pmweatherPresent);
        System.out.println("[WXMC] MixinPlugin: PMWeather RadarRenderer present? " + radarRendererPresent);
        System.out.println("[WXMC] MixinPlugin: PMWeather ThermodynamicEngine present? " + thermodynamicEnginePresent);
        System.out.println("[WXMC] MixinPlugin: PMWeather SoundingViewerRenderer present? " + soundingViewerRendererPresent);
        System.out.println("[WXMC] MixinPlugin: PMWeather SoundingViewerBlock present? " + soundingViewerBlockPresent);
        System.out.println("[WXMC] MixinPlugin: Exposure PhotographItem present? " + exposurePresent);
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (mixinClassName.endsWith("ColorTablesMixin")) {
            System.out.println("[WXMC] MixinPlugin: shouldApplyMixin for ColorTablesMixin? " + pmweatherPresent);
            return pmweatherPresent;
        }
        if (mixinClassName.endsWith("RadarRendererMixin")) {
            System.out.println("[WXMC] MixinPlugin: shouldApplyMixin for RadarRendererMixin? " + radarRendererPresent);
            return radarRendererPresent;
        }
        if (mixinClassName.endsWith("ThermodynamicEngineMixin")) {
            System.out.println("[WXMC] MixinPlugin: shouldApplyMixin for ThermodynamicEngineMixin? " + thermodynamicEnginePresent);
            return thermodynamicEnginePresent;
        }
        if (mixinClassName.endsWith("SoundingViewerRendererMixin")) {
            System.out.println("[WXMC] MixinPlugin: shouldApplyMixin for SoundingViewerRendererMixin? " + soundingViewerRendererPresent);
            return soundingViewerRendererPresent;
        }
        if (mixinClassName.endsWith("SoundingViewerBlockMixin")) {
            System.out.println("[WXMC] MixinPlugin: shouldApplyMixin for SoundingViewerBlockMixin? " + soundingViewerBlockPresent);
            return soundingViewerBlockPresent;
        }
        if (mixinClassName.endsWith("PhotographItemMixin")) {
            System.out.println("[WXMC] MixinPlugin: shouldApplyMixin for PhotographItemMixin? " + exposurePresent);
            return exposurePresent;
        }
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
        if (mixinClassName.endsWith("ColorTablesMixin") || mixinClassName.endsWith("RadarRendererMixin") || mixinClassName.endsWith("ThermodynamicEngineMixin") || mixinClassName.endsWith("SoundingViewerRendererMixin") || mixinClassName.endsWith("SoundingViewerBlockMixin") || mixinClassName.endsWith("PhotographItemMixin")) {
            System.out.println("[WXMC] MixinPlugin: Successfully applied " + mixinClassName + " to " + targetClassName);
        }
    }
}

