/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.mixin;

import dev.protomanly.pmweather.PMWeather;
import dev.protomanly.pmweather.weather.Storm;
import dev.wxmc.weatheraddon.outlook.OutlookManager;
import dev.wxmc.weatheraddon.util.WXMCDebugLogger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Storm.class}, remap=false)
public class ViolenceRollMixin {
    @Shadow
    public int maxStage;
    @Shadow
    public int maxWindspeed;
    @Shadow
    public int stormType;

    @Inject(method={"initFirstTime"}, at={@At(value="TAIL")})
    private void wxmc$applyViolenceRoll(CallbackInfo ci) {
        int maxBoost;
        int minBoost;
        int boostedWindspeed;
        if (this.stormType != 0 || this.maxStage < 3) {
            return;
        }
        OutlookManager.RiskCategory risk = OutlookManager.getDay1();
        float violenceChance = this.getViolenceChance(risk);
        if (violenceChance <= 0.0f) {
            return;
        }
        float roll = PMWeather.RANDOM.nextFloat();
        if (roll <= violenceChance && (boostedWindspeed = PMWeather.RANDOM.nextInt(minBoost = this.getMinBoostWindspeed(risk), (maxBoost = 220) + 1)) > this.maxWindspeed) {
            WXMCDebugLogger.info("[VIOLENCE-ROLL] Rare violent tornado! Risk: {}, Original max: {} mph, Boosted to: {} mph", risk.getName(), this.maxWindspeed, boostedWindspeed);
            this.maxWindspeed = boostedWindspeed;
        }
    }

    private float getViolenceChance(OutlookManager.RiskCategory risk) {
        return switch (risk) {
            default -> throw new MatchException(null, null);
            case OutlookManager.RiskCategory.NONE -> 0.001f;
            case OutlookManager.RiskCategory.TSTM -> 0.005f;
            case OutlookManager.RiskCategory.MRGL -> 0.01f;
            case OutlookManager.RiskCategory.SLGT -> 0.02f;
            case OutlookManager.RiskCategory.ENH -> 0.04f;
            case OutlookManager.RiskCategory.MDT -> 0.0f;
            case OutlookManager.RiskCategory.HIGH -> 0.0f;
        };
    }

    private int getMinBoostWindspeed(OutlookManager.RiskCategory risk) {
        return switch (risk) {
            default -> throw new MatchException(null, null);
            case OutlookManager.RiskCategory.NONE -> 166;
            case OutlookManager.RiskCategory.TSTM -> 200;
            case OutlookManager.RiskCategory.MRGL -> 190;
            case OutlookManager.RiskCategory.SLGT -> 180;
            case OutlookManager.RiskCategory.ENH -> 200;
            case OutlookManager.RiskCategory.MDT -> 200;
            case OutlookManager.RiskCategory.HIGH -> 200;
        };
    }
}

