/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.mixin;

import dev.protomanly.pmweather.block.entity.RadarBlockEntity;
import dev.protomanly.pmweather.weather.ThermodynamicEngine;
import dev.protomanly.pmweather.weather.WeatherHandler;
import dev.wxmc.weatheraddon.Config;
import dev.wxmc.weatheraddon.WXMCWeatherAddon;
import dev.wxmc.weatheraddon.sounding.SoundingData;
import dev.wxmc.weatheraddon.sounding.SoundingFetcher;
import dev.wxmc.weatheraddon.sounding.SoundingInterpolator;
import dev.wxmc.weatheraddon.util.WXMCDebugLogger;
import javax.annotation.Nullable;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ThermodynamicEngine.class}, remap=false)
public class ThermodynamicEngineMixin {
    private static long lastDebugLogTime = 0L;
    private static int injectionCount = 0;
    private static int fallbackCount = 0;
    private static final long DEBUG_LOG_INTERVAL_MS = 10000L;

    @Inject(method={"samplePoint(Ldev/protomanly/pmweather/weather/WeatherHandler;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/level/Level;Ldev/protomanly/pmweather/block/entity/RadarBlockEntity;ILjava/lang/Integer;)Ldev/protomanly/pmweather/weather/ThermodynamicEngine$AtmosphericDataPoint;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void wxmc$injectRealWorldSounding(WeatherHandler weatherHandler, Vec3 pos, Level level, @Nullable RadarBlockEntity radarBlockEntity, int advance, @Nullable Integer groundHeight, CallbackInfoReturnable<ThermodynamicEngine.AtmosphericDataPoint> cir) {
        float[] data;
        if (!Config.isRealWorldSoundingsEnabled()) {
            ThermodynamicEngineMixin.logFallback("Real-world soundings disabled in config");
            return;
        }
        if (!SoundingFetcher.hasSounding()) {
            ThermodynamicEngineMixin.logFallback("No valid sounding data available");
            return;
        }
        SoundingData sounding = SoundingFetcher.getCurrentSounding();
        if (sounding == null || !sounding.isValid()) {
            ThermodynamicEngineMixin.logFallback("Sounding is null or invalid");
            return;
        }
        int ground = groundHeight != null ? groundHeight.intValue() : level.getSeaLevel();
        float heightAGL = (float)pos.y - (float)ground;
        if (heightAGL < 0.0f) {
            heightAGL = 0.0f;
        }
        if ((data = SoundingInterpolator.interpolateForPMWeather(sounding, heightAGL)) == null) {
            ThermodynamicEngineMixin.logFallback("Interpolation failed at " + (int)heightAGL + "m AGL");
            if (Config.isDebugMode()) {
                WXMCWeatherAddon.LOGGER.info("[REAL SOUNDING] Interpolation failed at {}m AGL, falling back to PMWeather", (Object)((int)heightAGL));
            }
            return;
        }
        ThermodynamicEngine.AtmosphericDataPoint result = new ThermodynamicEngine.AtmosphericDataPoint(data[0], data[1], data[2], data[3]);
        ++injectionCount;
        if (Config.isDebugMode()) {
            WXMCWeatherAddon.LOGGER.info("[REAL SOUNDING] {}m AGL: T={}C, Td={}C, P={}mb", new Object[]{(int)heightAGL, String.format("%.1f", Float.valueOf(data[0])), String.format("%.1f", Float.valueOf(data[1])), String.format("%.1f", Float.valueOf(data[2]))});
        }
        ThermodynamicEngineMixin.logDebugSummary();
        cir.setReturnValue((Object)result);
    }

    private static void logFallback(String reason) {
        if (Config.shouldLogSoundingDebug() && ++fallbackCount % 100 == 1) {
            WXMCDebugLogger.debug("[SOUNDING DEBUG] [MIXIN] Fallback to PMWeather: {} (count: {})", reason, fallbackCount);
        }
        ThermodynamicEngineMixin.logDebugSummary();
    }

    private static void logDebugSummary() {
        if (!Config.shouldLogSoundingDebug()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - lastDebugLogTime >= 10000L) {
            lastDebugLogTime = now;
            int total = injectionCount + fallbackCount;
            if (total > 0) {
                float injectionRate = (float)injectionCount * 100.0f / (float)total;
                WXMCDebugLogger.debug("[SOUNDING DEBUG] [MIXIN] === Injection Summary ===");
                WXMCDebugLogger.debug("[SOUNDING DEBUG] [MIXIN] WXMC Sounding Injections: {} ({:.1f}%)", injectionCount, Float.valueOf(injectionRate));
                WXMCDebugLogger.debug("[SOUNDING DEBUG] [MIXIN] PMWeather Fallbacks: {} ({:.1f}%)", fallbackCount, Float.valueOf(100.0f - injectionRate));
                WXMCDebugLogger.debug("[SOUNDING DEBUG] [MIXIN] Total Samples: {}", total);
                if (injectionCount == 0 && fallbackCount > 0) {
                    WXMCDebugLogger.debug("[SOUNDING DEBUG] [MIXIN] WARNING: All samples falling back to PMWeather!");
                    WXMCDebugLogger.debug("[SOUNDING DEBUG] [MIXIN] Check: sounding files loaded? sounding synced to client?");
                }
            }
            injectionCount = 0;
            fallbackCount = 0;
        }
    }
}

