/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.mixin;

import dev.protomanly.pmweather.PMWeather;
import dev.protomanly.pmweather.weather.Storm;
import dev.wxmc.weatheraddon.outlook.OutlookManager;
import dev.wxmc.weatheraddon.util.WXMCDebugLogger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Storm.class}, remap=false)
public class StormStageMixin {
    @Shadow
    public int maxStage;
    @Shadow
    public int stormType;

    @Inject(method={"initFirstTime"}, at={@At(value="TAIL")})
    private void wxmc$applyRiskBasedStageChances(CallbackInfo ci) {
        if (this.stormType != 0) {
            return;
        }
        OutlookManager.RiskCategory risk = OutlookManager.getDay1();
        int newMaxStage = 0;
        if (this.rollForStage(this.getStage1Chance(risk))) {
            newMaxStage = 1;
        }
        if (this.rollForStage(this.getStage2Chance(risk))) {
            newMaxStage = 2;
        }
        if (this.rollForStage(this.getStage3Chance(risk))) {
            newMaxStage = 3;
        }
        if (newMaxStage != this.maxStage) {
            WXMCDebugLogger.debug("[STORM-STAGE] Overriding maxStage: {} -> {} (risk: {})", this.maxStage, newMaxStage, risk.getName());
        }
        this.maxStage = newMaxStage;
    }

    private boolean rollForStage(int chanceInOne) {
        if (chanceInOne <= 0) {
            return false;
        }
        if (chanceInOne == 1) {
            return true;
        }
        return PMWeather.RANDOM.nextInt(chanceInOne) == 0;
    }

    private int getStage1Chance(OutlookManager.RiskCategory risk) {
        return switch (risk) {
            default -> throw new MatchException(null, null);
            case OutlookManager.RiskCategory.NONE -> 1000;
            case OutlookManager.RiskCategory.TSTM -> 25;
            case OutlookManager.RiskCategory.MRGL -> 10;
            case OutlookManager.RiskCategory.SLGT -> 5;
            case OutlookManager.RiskCategory.ENH -> 1;
            case OutlookManager.RiskCategory.MDT -> 1;
            case OutlookManager.RiskCategory.HIGH -> 1;
        };
    }

    private int getStage2Chance(OutlookManager.RiskCategory risk) {
        return switch (risk) {
            default -> throw new MatchException(null, null);
            case OutlookManager.RiskCategory.NONE -> 1000;
            case OutlookManager.RiskCategory.TSTM -> 100;
            case OutlookManager.RiskCategory.MRGL -> 10;
            case OutlookManager.RiskCategory.SLGT -> 5;
            case OutlookManager.RiskCategory.ENH -> 2;
            case OutlookManager.RiskCategory.MDT -> 2;
            case OutlookManager.RiskCategory.HIGH -> 1;
        };
    }

    private int getStage3Chance(OutlookManager.RiskCategory risk) {
        return switch (risk) {
            default -> throw new MatchException(null, null);
            case OutlookManager.RiskCategory.NONE -> 1000;
            case OutlookManager.RiskCategory.TSTM -> 100;
            case OutlookManager.RiskCategory.MRGL -> 20;
            case OutlookManager.RiskCategory.SLGT -> 7;
            case OutlookManager.RiskCategory.ENH -> 3;
            case OutlookManager.RiskCategory.MDT -> 1;
            case OutlookManager.RiskCategory.HIGH -> 1;
        };
    }
}

