/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.mixin;

import dev.protomanly.pmweather.weather.Storm;
import dev.wxmc.weatheraddon.util.WXMCDebugLogger;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Storm.class}, remap=false)
public class StormNaNFixMixin {
    @Shadow
    public Vec3 position;
    @Shadow
    public Vec3 velocity;
    @Shadow
    public float width;
    @Shadow
    public boolean dead;
    @Shadow
    public long ID;

    @Inject(method={"nbtSyncFromServer"}, at={@At(value="TAIL")})
    private void wxmc$sanitizeAfterNbtLoad(CallbackInfo ci) {
        boolean hadNaN = false;
        if (StormNaNFixMixin.hasNaN(this.position)) {
            WXMCDebugLogger.debug("[NaN-FIX] Storm {} has NaN position, marking as dead", this.ID);
            hadNaN = true;
        }
        if (StormNaNFixMixin.hasNaN(this.velocity)) {
            WXMCDebugLogger.debug("[NaN-FIX] Storm {} has NaN velocity, marking as dead", this.ID);
            hadNaN = true;
        }
        if (Float.isNaN(this.width)) {
            WXMCDebugLogger.debug("[NaN-FIX] Storm {} has NaN width, marking as dead", this.ID);
            hadNaN = true;
        }
        if (hadNaN) {
            this.dead = true;
            WXMCDebugLogger.debug("[NaN-FIX] Killed corrupted storm {} to prevent audio/data corruption", this.ID);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void wxmc$checkForNaNOnTick(CallbackInfo ci) {
        if (this.dead) {
            return;
        }
        if (StormNaNFixMixin.hasNaN(this.position) || StormNaNFixMixin.hasNaN(this.velocity) || Float.isNaN(this.width)) {
            WXMCDebugLogger.debug("[NaN-FIX] Storm {} became corrupted with NaN during runtime, killing it", this.ID);
            this.dead = true;
        }
    }

    private static boolean hasNaN(Vec3 vec) {
        if (vec == null) {
            return false;
        }
        return Double.isNaN(vec.x) || Double.isNaN(vec.y) || Double.isNaN(vec.z);
    }
}

