/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.mixin;

import dev.protomanly.pmweather.weather.Storm;
import dev.protomanly.pmweather.weather.WeatherHandler;
import dev.protomanly.pmweather.weather.WindEngine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WindEngine.class}, remap=false)
public class StormDistanceCullingMixin {
    @Unique
    private static final double WXMC_SUPERCELL_CULL_DISTANCE = 4000.0;
    @Unique
    private static final double WXMC_HURRICANE_CULL_DISTANCE = 8000.0;
    @Unique
    private static final double WXMC_SQUALL_CULL_DISTANCE = 6000.0;
    @Unique
    private static final ThreadLocal<Vec3> wxmc$currentQueryPosition = new ThreadLocal();

    @Redirect(method={"getWind(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/level/Level;ZZZZ)Lnet/minecraft/world/phys/Vec3;"}, at=@At(value="INVOKE", target="Ldev/protomanly/pmweather/weather/WeatherHandler;getStorms()Ljava/util/Collection;"))
    private static Collection<Storm> wxmc$getFilteredStorms(WeatherHandler weatherHandler) {
        Vec3 position = wxmc$currentQueryPosition.get();
        if (position == null) {
            return weatherHandler.getStorms();
        }
        List allStorms = weatherHandler.getStorms();
        ArrayList<Storm> nearbyStorms = new ArrayList<Storm>();
        for (Storm storm : allStorms) {
            double cullDistance;
            if (storm == null || storm.position == null || Double.isNaN(storm.position.x) || Double.isNaN(storm.position.z)) continue;
            double dx = position.x - storm.position.x;
            double dz = position.z - storm.position.z;
            double distanceSquared = dx * dx + dz * dz;
            if (!(distanceSquared <= (cullDistance = (switch (storm.stormType) {
                case 0 -> 4000.0;
                case 1 -> 6000.0;
                case 2 -> 8000.0;
                default -> 4000.0;
            })) * cullDistance)) continue;
            nearbyStorms.add(storm);
        }
        return nearbyStorms;
    }

    @Inject(method={"getWind(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/level/Level;ZZZZ)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")})
    private static void wxmc$capturePosition(Vec3 position, Level level, boolean ignoreStorms, boolean ignoreTornadoes, boolean windCheck, boolean windAnyway, CallbackInfoReturnable<Vec3> cir) {
        wxmc$currentQueryPosition.set(position);
    }

    @Inject(method={"getWind(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/level/Level;ZZZZ)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="RETURN")})
    private static void wxmc$clearPosition(Vec3 position, Level level, boolean ignoreStorms, boolean ignoreTornadoes, boolean windCheck, boolean windAnyway, CallbackInfoReturnable<Vec3> cir) {
        wxmc$currentQueryPosition.remove();
    }
}

