/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import dev.protomanly.pmweather.block.SoundingViewerBlock;
import dev.protomanly.pmweather.block.entity.SoundingViewerBlockEntity;
import dev.protomanly.pmweather.block.entity.WeatherPlatformBlockEntity;
import dev.protomanly.pmweather.render.SoundingViewerRenderer;
import dev.protomanly.pmweather.weather.Sounding;
import dev.wxmc.weatheraddon.client.SoundingDisplayMode;
import dev.wxmc.weatheraddon.sounding.SoundingData;
import dev.wxmc.weatheraddon.sounding.SoundingFetcher;
import dev.wxmc.weatheraddon.sounding.SoundingLevel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SoundingViewerRenderer.class}, remap=false)
public class SoundingViewerRendererMixin<T extends BlockEntity> {
    @Unique
    private static long wxmc$animationStartTime = 0L;
    @Unique
    private static int wxmc$lastSoundingHash = 0;
    @Unique
    private static final float MS_PER_LEVEL = 2000.0f;
    @Unique
    private static Map<BlockPos, Boolean> wxmc$balloonWasLaunched = new HashMap<BlockPos, Boolean>();
    @Unique
    private static Map<BlockPos, SoundingData> wxmc$capturedSoundings = new HashMap<BlockPos, SoundingData>();
    @Unique
    private static final float MIN_PRESSURE = 100.0f;
    @Unique
    private static final float MAX_PRESSURE = 1050.0f;
    @Unique
    private static final float MIN_TEMP = -50.0f;
    @Unique
    private static final float MAX_TEMP = 50.0f;
    @Unique
    private static final float TEMP_RANGE = 100.0f;
    @Unique
    private static final float SKEW_DEGREES = 33.333332f;
    @Unique
    private static final float SKEW_YRANGE = (float)(Math.tan(Math.toRadians(33.33333206176758)) * 100.0);
    @Unique
    private static final float LOG_PMAX = (float)Math.log(1050.0);
    @Unique
    private static final float LOG_PMIN = (float)Math.log(100.0);
    @Unique
    private static final float[] COLOR_ISOTHERM = new float[]{0.4f, 0.4f, 0.4f, 0.8f};
    @Unique
    private static final float[] COLOR_ISOBAR = new float[]{0.5f, 0.5f, 0.5f, 0.8f};
    @Unique
    private static final float[] COLOR_DRY_ADIABAT = new float[]{0.3f, 0.3f, 0.3f, 0.6f};
    @Unique
    private static final float[] COLOR_MOIST_ADIABAT = new float[]{0.25f, 0.35f, 0.25f, 0.5f};
    @Unique
    private static final float[] COLOR_TEMP = new float[]{1.0f, 0.2f, 0.2f, 1.0f};
    @Unique
    private static final float[] COLOR_DEWPOINT = new float[]{0.2f, 1.0f, 0.2f, 1.0f};
    @Unique
    private static final float[] COLOR_VTEMP = new float[]{0.5f, 0.1f, 0.1f, 0.8f};
    @Unique
    private static final float HODO_MAX_SPEED = 100.0f;
    @Unique
    private static final float[] HODO_COLOR_0_1KM = new float[]{1.0f, 0.333f, 1.0f, 1.0f};
    @Unique
    private static final float[] HODO_COLOR_1_3KM = new float[]{0.667f, 0.0f, 0.0f, 1.0f};
    @Unique
    private static final float[] HODO_COLOR_3_6KM = new float[]{0.0f, 0.667f, 0.0f, 1.0f};
    @Unique
    private static final float[] HODO_COLOR_6_9KM = new float[]{1.0f, 1.0f, 0.333f, 1.0f};
    @Unique
    private static final float[] HODO_COLOR_9_12KM = new float[]{0.333f, 1.0f, 1.0f, 1.0f};
    @Unique
    private static final float[] HODO_COLOR_RING = new float[]{0.33f, 0.33f, 0.33f, 0.8f};

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    private void wxmc$renderSkewT(T blockEntity, float v, PoseStack poseStack, MultiBufferSource multiBufferSource, int j, int j1, CallbackInfo ci) {
        SoundingData currentSounding;
        boolean justLaunched;
        boolean balloonHasLaunched;
        if (!(blockEntity instanceof SoundingViewerBlockEntity)) {
            return;
        }
        SoundingViewerBlockEntity soundingViewer = (SoundingViewerBlockEntity)blockEntity;
        if (Minecraft.getInstance().player.position().distanceTo(blockEntity.getBlockPos().getCenter()) > 25.0) {
            ci.cancel();
            return;
        }
        BlockPos viewerPos = blockEntity.getBlockPos();
        if (!soundingViewer.isConnected) {
            wxmc$balloonWasLaunched.put(viewerPos, false);
            wxmc$capturedSoundings.remove(viewerPos);
            ci.cancel();
            return;
        }
        BlockEntity connectedEntity = blockEntity.getLevel().getBlockEntity(soundingViewer.connectedTo);
        if (!(connectedEntity instanceof WeatherPlatformBlockEntity)) {
            wxmc$balloonWasLaunched.put(viewerPos, false);
            wxmc$capturedSoundings.remove(viewerPos);
            ci.cancel();
            return;
        }
        WeatherPlatformBlockEntity weatherPlatform = (WeatherPlatformBlockEntity)connectedEntity;
        boolean bl = balloonHasLaunched = weatherPlatform.sounding != null;
        if (!balloonHasLaunched) {
            wxmc$balloonWasLaunched.put(viewerPos, false);
            wxmc$capturedSoundings.remove(viewerPos);
            ci.cancel();
            return;
        }
        boolean wasLaunched = wxmc$balloonWasLaunched.getOrDefault(viewerPos, false);
        boolean bl2 = justLaunched = !wasLaunched && balloonHasLaunched;
        if (justLaunched && (currentSounding = SoundingFetcher.getCurrentSounding()) != null && currentSounding.isValid()) {
            wxmc$capturedSoundings.put(viewerPos, currentSounding);
            wxmc$animationStartTime = System.currentTimeMillis();
            wxmc$lastSoundingHash = this.wxmc$getWXMCSoundingHash(currentSounding);
            System.out.println("[WXMC] Balloon launched - captured sounding: " + currentSounding.getStationId() + " with " + currentSounding.getLevelCount() + " levels");
        }
        wxmc$balloonWasLaunched.put(viewerPos, balloonHasLaunched);
        SoundingData capturedSounding = wxmc$capturedSoundings.get(viewerPos);
        if (capturedSounding == null || !capturedSounding.isValid()) {
            return;
        }
        ci.cancel();
        try {
            if (SoundingDisplayMode.isHodographMode(blockEntity.getBlockPos())) {
                this.wxmc$doHodographRender(blockEntity, poseStack, multiBufferSource);
            } else {
                this.wxmc$doSkewTRenderFromWXMC(blockEntity, poseStack, capturedSounding);
            }
        }
        catch (Exception e) {
            System.err.println("[WXMC] Sounding render error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Unique
    private int wxmc$getLevelsToShow() {
        if (wxmc$animationStartTime == 0L) {
            wxmc$animationStartTime = System.currentTimeMillis();
        }
        long elapsed = System.currentTimeMillis() - wxmc$animationStartTime;
        return (int)((float)elapsed / 2000.0f) + 1;
    }

    @Unique
    private boolean wxmc$isAnimationComplete(int totalLevels) {
        return this.wxmc$getLevelsToShow() >= totalLevels;
    }

    @Unique
    @Deprecated
    private int wxmc$getSoundingHash(Sounding sounding) {
        if (sounding == null || sounding.data == null) {
            return 0;
        }
        int size = sounding.data.size();
        return size * 31 + sounding.data.hashCode();
    }

    @Unique
    private int wxmc$getWXMCSoundingHash(SoundingData sounding) {
        if (sounding == null || sounding.getLevels() == null) {
            return 0;
        }
        String stationId = sounding.getStationId();
        int stationHash = stationId != null ? stationId.hashCode() : 0;
        return sounding.getLevelCount() * 31 + stationHash;
    }

    @Unique
    private void wxmc$doSkewTRenderFromWXMC(T blockEntity, PoseStack poseStack, SoundingData soundingData) {
        BlockState state = blockEntity.getBlockState();
        Direction direction = (Direction)state.getValue((Property)SoundingViewerBlock.FACING);
        Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
        matrix4fStack.pushMatrix();
        matrix4fStack.mul((Matrix4fc)poseStack.last().pose());
        matrix4fStack.translate(0.5f, 0.5f, 0.5f);
        Quaternionf rotation = switch (direction) {
            case Direction.NORTH -> Axis.YP.rotationDegrees(180.0f);
            case Direction.EAST -> Axis.YP.rotationDegrees(90.0f);
            case Direction.WEST -> Axis.YP.rotationDegrees(270.0f);
            default -> Axis.YP.rotationDegrees(0.0f);
        };
        matrix4fStack.rotate((Quaternionfc)rotation);
        matrix4fStack.translate(0.0f, 0.0f, 0.55f);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.enableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.defaultBlendFunc();
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        Vector3f topLeft = new Vector3f(-1.0f, 1.0f, 0.0f);
        Vector3f bottomLeft = new Vector3f(-1.0f, -1.0f, 0.0f);
        Vector3f bottomRight = new Vector3f(1.0f, -1.0f, 0.0f);
        Vector3f topRight = new Vector3f(1.0f, 1.0f, 0.0f);
        bufferBuilder.addVertex(topLeft).setColor(0.0f, 0.0f, 0.0f, 1.0f);
        bufferBuilder.addVertex(bottomLeft).setColor(0.0f, 0.0f, 0.0f, 1.0f);
        bufferBuilder.addVertex(bottomRight).setColor(0.0f, 0.0f, 0.0f, 1.0f);
        bufferBuilder.addVertex(topRight).setColor(0.0f, 0.0f, 0.0f, 1.0f);
        MeshData meshData = bufferBuilder.build();
        if (meshData != null) {
            BufferUploader.drawWithShader((MeshData)meshData);
        }
        BufferBuilder lineBuilder = tesselator.begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
        this.wxmc$drawIsobars(lineBuilder);
        this.wxmc$drawIsotherms(lineBuilder);
        this.wxmc$drawDryAdiabats(lineBuilder);
        this.wxmc$drawMoistAdiabats(lineBuilder);
        this.wxmc$drawSoundingTracesFromWXMC(lineBuilder, soundingData);
        meshData = lineBuilder.build();
        if (meshData != null) {
            BufferUploader.drawWithShader((MeshData)meshData);
        }
        matrix4fStack.mul((Matrix4fc)poseStack.last().pose().invert());
        matrix4fStack.translate(-0.5f, -0.5f, -0.5f);
        matrix4fStack.rotate((Quaternionfc)rotation.invert());
        matrix4fStack.translate(0.0f, 0.0f, -0.55f);
        matrix4fStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    }

    @Unique
    private void wxmc$drawSoundingTracesFromWXMC(BufferBuilder builder, SoundingData soundingData) {
        List<SoundingLevel> levels = soundingData.getSortedLevels();
        if (levels == null || levels.isEmpty()) {
            return;
        }
        int maxLevels = this.wxmc$getLevelsToShow();
        if (maxLevels < 1) {
            return;
        }
        Vec2 lastTempPoint = null;
        Vec2 lastDewPoint = null;
        int levelCount = 0;
        for (SoundingLevel level : levels) {
            if (levelCount >= maxLevels) break;
            ++levelCount;
            float pressure = level.getPressureMb();
            float temperature = level.getTemperatureC();
            float dewpoint = level.getDewpointC();
            if (pressure < 100.0f) break;
            Vec2 tempPoint = this.wxmc$skewTPosition(temperature, pressure);
            if (lastTempPoint != null) {
                builder.addVertex(lastTempPoint.x, lastTempPoint.y, 0.01f).setColor(COLOR_TEMP[0], COLOR_TEMP[1], COLOR_TEMP[2], COLOR_TEMP[3]);
                builder.addVertex(tempPoint.x, tempPoint.y, 0.01f).setColor(COLOR_TEMP[0], COLOR_TEMP[1], COLOR_TEMP[2], COLOR_TEMP[3]);
            }
            lastTempPoint = tempPoint;
            Vec2 dewPoint = this.wxmc$skewTPosition(dewpoint, pressure);
            if (lastDewPoint != null) {
                builder.addVertex(lastDewPoint.x, lastDewPoint.y, 0.01f).setColor(COLOR_DEWPOINT[0], COLOR_DEWPOINT[1], COLOR_DEWPOINT[2], COLOR_DEWPOINT[3]);
                builder.addVertex(dewPoint.x, dewPoint.y, 0.01f).setColor(COLOR_DEWPOINT[0], COLOR_DEWPOINT[1], COLOR_DEWPOINT[2], COLOR_DEWPOINT[3]);
            }
            lastDewPoint = dewPoint;
        }
    }

    @Unique
    private void wxmc$drawIsobars(BufferBuilder builder) {
        int[] pressureLevels;
        for (int p : pressureLevels = new int[]{1000, 925, 850, 700, 500, 400, 300, 250, 200, 150, 100}) {
            float y = this.wxmc$pressureToY(p);
            if (!(y >= -1.0f) || !(y <= 1.0f)) continue;
            builder.addVertex(-1.0f, y, 0.003f).setColor(COLOR_ISOBAR[0], COLOR_ISOBAR[1], COLOR_ISOBAR[2], COLOR_ISOBAR[3]);
            builder.addVertex(1.0f, y, 0.003f).setColor(COLOR_ISOBAR[0], COLOR_ISOBAR[1], COLOR_ISOBAR[2], COLOR_ISOBAR[3]);
        }
    }

    @Unique
    private void wxmc$drawIsotherms(BufferBuilder builder) {
        for (int temp = -150; temp <= 60; temp += 10) {
            int p = 1050;
            while ((float)p >= 100.0f) {
                int pNext = p - 25;
                if ((float)pNext < 100.0f) {
                    pNext = 100;
                }
                Vec2 p1 = this.wxmc$skewTPosition(temp, p);
                Vec2 p2 = this.wxmc$skewTPosition(temp, pNext);
                if (p1.x > -1.5f && p1.x < 1.5f && p2.x > -1.5f && p2.x < 1.5f) {
                    Vec2 c1 = this.wxmc$clipToBounds(p1);
                    Vec2 c2 = this.wxmc$clipToBounds(p2);
                    if (c1.x != c2.x || c1.y != c2.y) {
                        if (temp == 0 || temp == -20) {
                            builder.addVertex(c1.x, c1.y, 0.002f).setColor(0.0f, 0.0f, 1.0f, 0.8f);
                            builder.addVertex(c2.x, c2.y, 0.002f).setColor(0.0f, 0.0f, 1.0f, 0.8f);
                        } else {
                            builder.addVertex(c1.x, c1.y, 0.002f).setColor(COLOR_ISOTHERM[0], COLOR_ISOTHERM[1], COLOR_ISOTHERM[2], COLOR_ISOTHERM[3]);
                            builder.addVertex(c2.x, c2.y, 0.002f).setColor(COLOR_ISOTHERM[0], COLOR_ISOTHERM[1], COLOR_ISOTHERM[2], COLOR_ISOTHERM[3]);
                        }
                    }
                }
                p -= 25;
            }
        }
    }

    @Unique
    private void wxmc$drawDryAdiabats(BufferBuilder builder) {
        for (int thetaC = -50; thetaC <= 80; thetaC += 20) {
            float thetaK = (float)thetaC + 273.15f;
            Vec2 lastPoint = null;
            int p = 1050;
            while ((float)p >= 100.0f) {
                float tempK = thetaK / (float)Math.pow(1000.0f / (float)p, 0.2857142686843872);
                float tempC = tempK - 273.15f;
                Vec2 point = this.wxmc$skewTPosition(tempC, p);
                if (lastPoint != null && (point.x > -1.5f || lastPoint.x > -1.5f) && (point.x < 1.5f || lastPoint.x < 1.5f)) {
                    Vec2 clippedLast = this.wxmc$clipToBounds(lastPoint);
                    Vec2 clippedPoint = this.wxmc$clipToBounds(point);
                    if (clippedLast.x != clippedPoint.x || clippedLast.y != clippedPoint.y) {
                        builder.addVertex(clippedLast.x, clippedLast.y, 0.001f).setColor(COLOR_DRY_ADIABAT[0], COLOR_DRY_ADIABAT[1], COLOR_DRY_ADIABAT[2], COLOR_DRY_ADIABAT[3]);
                        builder.addVertex(clippedPoint.x, clippedPoint.y, 0.001f).setColor(COLOR_DRY_ADIABAT[0], COLOR_DRY_ADIABAT[1], COLOR_DRY_ADIABAT[2], COLOR_DRY_ADIABAT[3]);
                    }
                }
                lastPoint = point;
                p -= 10;
            }
        }
    }

    @Unique
    private void wxmc$drawMoistAdiabats(BufferBuilder builder) {
        float[] startTemps;
        for (float startTemp : startTemps = new float[]{-20.0f, -10.0f, 0.0f, 8.0f, 16.0f, 24.0f, 32.0f}) {
            Vec2 lastPoint = null;
            float temp = startTemp;
            int p = 1000;
            while ((float)p >= 100.0f) {
                Vec2 point = this.wxmc$skewTPosition(temp, p);
                if (lastPoint != null && (this.wxmc$isInBounds(point) || this.wxmc$isInBounds(lastPoint))) {
                    Vec2 clippedLast = this.wxmc$clipToBounds(lastPoint);
                    Vec2 clippedPoint = this.wxmc$clipToBounds(point);
                    builder.addVertex(clippedLast.x, clippedLast.y, 0.001f).setColor(COLOR_MOIST_ADIABAT[0], COLOR_MOIST_ADIABAT[1], COLOR_MOIST_ADIABAT[2], COLOR_MOIST_ADIABAT[3]);
                    builder.addVertex(clippedPoint.x, clippedPoint.y, 0.001f).setColor(COLOR_MOIST_ADIABAT[0], COLOR_MOIST_ADIABAT[1], COLOR_MOIST_ADIABAT[2], COLOR_MOIST_ADIABAT[3]);
                }
                lastPoint = point;
                float lapseRate = this.wxmc$moistAdiabaticLapseRate(temp, p);
                temp -= lapseRate * 25.0f / 100.0f;
                p -= 25;
            }
        }
    }

    @Unique
    private Vec2 wxmc$skewTPosition(float temp, float pressure) {
        float y = this.wxmc$pressureToY(pressure);
        float heightFraction = (y + 1.0f) / 2.0f;
        float skewedMaxTemp = 50.0f - heightFraction * SKEW_YRANGE;
        float x = 1.0f - (skewedMaxTemp - temp) / 100.0f * 2.0f;
        return new Vec2(x, y);
    }

    @Unique
    private float wxmc$pressureToY(float pressure) {
        float scl1 = LOG_PMAX - LOG_PMIN;
        float scl2 = LOG_PMAX - (float)Math.log(pressure);
        float normalized = scl2 / scl1;
        return normalized * 2.0f - 1.0f;
    }

    @Unique
    private float wxmc$moistAdiabaticLapseRate(float tempC, float pressure) {
        float es = 6.112f * (float)Math.exp(17.67f * tempC / (tempC + 243.5f));
        float rs = 0.622f * es / (pressure - es);
        float tempK = tempC + 273.15f;
        float Lv = 2501000.0f - 2370.0f * tempC;
        float numerator = 1.0f + Lv * rs / (287.0f * tempK);
        float denominator = 1.0f + Lv * Lv * rs * 0.622f / (288148.0f * tempK * tempK);
        return 9.8f * numerator / denominator / 1000.0f;
    }

    @Unique
    private boolean wxmc$isInBounds(Vec2 point) {
        return point.x >= -1.0f && point.x <= 1.0f && point.y >= -1.0f && point.y <= 1.0f;
    }

    @Unique
    private Vec2 wxmc$clipToBounds(Vec2 point) {
        float x = Math.max(-1.0f, Math.min(1.0f, point.x));
        float y = Math.max(-1.0f, Math.min(1.0f, point.y));
        return new Vec2(x, y);
    }

    @Unique
    private void wxmc$doHodographRender(T blockEntity, PoseStack poseStack, MultiBufferSource multiBufferSource) {
        BlockState state = blockEntity.getBlockState();
        Direction direction = (Direction)state.getValue((Property)SoundingViewerBlock.FACING);
        Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
        matrix4fStack.pushMatrix();
        matrix4fStack.mul((Matrix4fc)poseStack.last().pose());
        matrix4fStack.translate(0.5f, 0.5f, 0.5f);
        Quaternionf rotation = switch (direction) {
            case Direction.NORTH -> Axis.YP.rotationDegrees(180.0f);
            case Direction.EAST -> Axis.YP.rotationDegrees(90.0f);
            case Direction.WEST -> Axis.YP.rotationDegrees(270.0f);
            default -> Axis.YP.rotationDegrees(0.0f);
        };
        matrix4fStack.rotate((Quaternionfc)rotation);
        matrix4fStack.translate(0.0f, 0.0f, 0.55f);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.enableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.defaultBlendFunc();
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        bufferBuilder.addVertex(-1.0f, 1.0f, 0.0f).setColor(0.0f, 0.0f, 0.0f, 1.0f);
        bufferBuilder.addVertex(-1.0f, -1.0f, 0.0f).setColor(0.0f, 0.0f, 0.0f, 1.0f);
        bufferBuilder.addVertex(1.0f, -1.0f, 0.0f).setColor(0.0f, 0.0f, 0.0f, 1.0f);
        bufferBuilder.addVertex(1.0f, 1.0f, 0.0f).setColor(0.0f, 0.0f, 0.0f, 1.0f);
        MeshData meshData = bufferBuilder.build();
        if (meshData != null) {
            BufferUploader.drawWithShader((MeshData)meshData);
        }
        BufferBuilder lineBuilder = tesselator.begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
        this.wxmc$drawHodographRings(lineBuilder);
        this.wxmc$drawHodographAxes(lineBuilder);
        SoundingData soundingData = SoundingFetcher.getCurrentSounding();
        if (soundingData != null && soundingData.hasWindData()) {
            this.wxmc$drawHodographTrace(lineBuilder, soundingData);
        }
        if ((meshData = lineBuilder.build()) != null) {
            BufferUploader.drawWithShader((MeshData)meshData);
        }
        matrix4fStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    }

    @Unique
    private void wxmc$drawHodographRings(BufferBuilder builder) {
        int[] speeds;
        for (int speed : speeds = new int[]{10, 20, 30, 40, 50, 60, 70, 80, 90, 100}) {
            float radius = (float)speed / 100.0f;
            if (radius > 1.0f) continue;
            int segments = 36;
            for (int i = 0; i < segments; ++i) {
                float angle1 = (float)(Math.PI * 2 * (double)i / (double)segments);
                float angle2 = (float)(Math.PI * 2 * (double)(i + 1) / (double)segments);
                float x1 = radius * (float)Math.cos(angle1);
                float y1 = radius * (float)Math.sin(angle1);
                float x2 = radius * (float)Math.cos(angle2);
                float y2 = radius * (float)Math.sin(angle2);
                builder.addVertex(x1, y1, 0.001f).setColor(HODO_COLOR_RING[0], HODO_COLOR_RING[1], HODO_COLOR_RING[2], HODO_COLOR_RING[3]);
                builder.addVertex(x2, y2, 0.001f).setColor(HODO_COLOR_RING[0], HODO_COLOR_RING[1], HODO_COLOR_RING[2], HODO_COLOR_RING[3]);
            }
        }
    }

    @Unique
    private void wxmc$drawHodographAxes(BufferBuilder builder) {
        float[] axisColor = new float[]{0.5f, 0.5f, 0.5f, 1.0f};
        builder.addVertex(-1.0f, 0.0f, 0.002f).setColor(axisColor[0], axisColor[1], axisColor[2], axisColor[3]);
        builder.addVertex(1.0f, 0.0f, 0.002f).setColor(axisColor[0], axisColor[1], axisColor[2], axisColor[3]);
        builder.addVertex(0.0f, -1.0f, 0.002f).setColor(axisColor[0], axisColor[1], axisColor[2], axisColor[3]);
        builder.addVertex(0.0f, 1.0f, 0.002f).setColor(axisColor[0], axisColor[1], axisColor[2], axisColor[3]);
    }

    @Unique
    private void wxmc$drawHodographTrace(BufferBuilder builder, SoundingData soundingData) {
        List<SoundingLevel> windLevels = soundingData.getWindLevels();
        if (windLevels.isEmpty()) {
            return;
        }
        int maxLevels = this.wxmc$getLevelsToShow();
        if (maxLevels < 1) {
            return;
        }
        SoundingLevel lastLevel = null;
        float lastU = 0.0f;
        float lastV = 0.0f;
        int levelCount = 0;
        for (SoundingLevel level : windLevels) {
            if (levelCount >= maxLevels) break;
            ++levelCount;
            float heightM = level.getHeightM();
            float u = level.getWindU();
            float v = level.getWindV();
            float[] color = this.wxmc$getHodographColor(heightM);
            if (color == null) break;
            float x = u / 100.0f;
            float y = v / 100.0f;
            x = Math.max(-1.0f, Math.min(1.0f, x));
            y = Math.max(-1.0f, Math.min(1.0f, y));
            if (lastLevel != null) {
                float lastX = lastU / 100.0f;
                float lastY = lastV / 100.0f;
                lastX = Math.max(-1.0f, Math.min(1.0f, lastX));
                lastY = Math.max(-1.0f, Math.min(1.0f, lastY));
                builder.addVertex(lastX, lastY, 0.01f).setColor(color[0], color[1], color[2], color[3]);
                builder.addVertex(x, y, 0.01f).setColor(color[0], color[1], color[2], color[3]);
            }
            lastLevel = level;
            lastU = u;
            lastV = v;
        }
    }

    @Unique
    private float[] wxmc$getHodographColor(float heightM) {
        SoundingData soundingData = SoundingFetcher.getCurrentSounding();
        float surfaceHeight = soundingData != null ? soundingData.getMinHeight() : 350.0f;
        float heightAGL = heightM - surfaceHeight;
        if (heightAGL > 12000.0f) {
            return null;
        }
        if (heightAGL <= 1000.0f) {
            return HODO_COLOR_0_1KM;
        }
        if (heightAGL <= 3000.0f) {
            return HODO_COLOR_1_3KM;
        }
        if (heightAGL <= 6000.0f) {
            return HODO_COLOR_3_6KM;
        }
        if (heightAGL <= 9000.0f) {
            return HODO_COLOR_6_9KM;
        }
        return HODO_COLOR_9_12KM;
    }
}

