/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.mixin;

import dev.protomanly.pmweather.block.SoundingViewerBlock;
import dev.protomanly.pmweather.block.entity.SoundingViewerBlockEntity;
import dev.wxmc.weatheraddon.client.SoundingDisplayMode;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SoundingViewerBlock.class}, remap=false)
public class SoundingViewerBlockMixin {
    @Inject(method={"useItemOn"}, at={@At(value="HEAD")}, cancellable=true)
    private void wxmc$onUseItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult, CallbackInfoReturnable<ItemInteractionResult> cir) {
        if (!stack.isEmpty()) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof SoundingViewerBlockEntity)) {
            return;
        }
        SoundingViewerBlockEntity soundingViewer = (SoundingViewerBlockEntity)blockEntity;
        if (!soundingViewer.isConnected) {
            if (level.isClientSide()) {
                player.displayClientMessage((Component)Component.literal((String)"\u00a7cNot connected to a Balloon Platform"), true);
            }
            cir.setReturnValue((Object)ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION);
            return;
        }
        if (level.isClientSide()) {
            boolean isHodograph = SoundingDisplayMode.toggle(pos);
            String mode = isHodograph ? "Hodograph" : "Skew-T";
            player.displayClientMessage((Component)Component.literal((String)("Display mode: " + mode)), true);
        }
        cir.setReturnValue((Object)ItemInteractionResult.SUCCESS);
    }
}

