/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.wxmc.weatheraddon.WXMCWeatherAddon;
import dev.wxmc.weatheraddon.util.WXMCDebugLogger;
import dev.wxmc.weatheraddon.warnings.AlertPolygon;
import dev.wxmc.weatheraddon.warnings.AlertPolygonManager;
import dev.wxmc.weatheraddon.warnings.WarningConfig;
import dev.wxmc.weatheraddon.warnings.WarningLevel;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(targets={"dev.protomanly.pmweather.render.RadarRenderer"}, remap=false)
public class RadarRendererMixin {
    private static boolean logged = false;
    private static final float BASE_RENDER_DIAMETER = 3.0f;
    private static final float UPGRADED_RENDER_DIAMETER = 6.0f;
    private static final float RANGE_UPGRADE_MULTIPLIER = 4.0f;
    private static final float LINE_WIDTH = 0.015f;
    private static final float POLYGON_ALPHA = 1.0f;
    private static int debugCounter = 0;

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;applyModelViewMatrix()V", ordinal=1)}, require=0)
    private void pmwu_renderWarningPolygons(BlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, CallbackInfo ci) {
        ArrayList<AlertPolygon> polys;
        if (!logged) {
            WXMCWeatherAddon.LOGGER.info("RadarRendererMixin is active! Polygon rendering enabled on PMWeather radars.");
            logged = true;
        }
        BlockPos radarPos = blockEntity.getBlockPos();
        boolean hasRangeUpgrade = this.checkHasRangeUpgrade(blockEntity);
        if (++debugCounter % 100 == 0) {
            int totalPolygons = AlertPolygonManager.getTotalPolygonCount();
            String allPositions = AlertPolygonManager.getAllPositionsWithPolygons();
            WXMCDebugLogger.debug("[MIXIN-DEBUG] BlockEntity pos={}, type={}, hasRangeUpgrade={}, totalPolygons={}, storedAt={}", radarPos, blockEntity.getClass().getSimpleName(), hasRangeUpgrade, totalPolygons, allPositions);
        }
        if (!((Boolean)WarningConfig.SHOW_RADAR_POLYGONS.get()).booleanValue()) {
            return;
        }
        Collection<AlertPolygon> originalPolys = AlertPolygonManager.getPolygonsAt(radarPos);
        if (originalPolys.isEmpty()) {
            originalPolys = AlertPolygonManager.getPolygonsAt(radarPos.above());
        }
        if (originalPolys.isEmpty()) {
            originalPolys = AlertPolygonManager.getPolygonsByXZ(radarPos.getX(), radarPos.getZ());
        }
        if (!originalPolys.isEmpty() && debugCounter % 100 == 0) {
            WXMCDebugLogger.debug("[MIXIN-DEBUG] FOUND {} polygon(s) for radar at {}!", originalPolys.size(), radarPos);
        }
        if (originalPolys.isEmpty()) {
            return;
        }
        try {
            polys = new ArrayList<AlertPolygon>(originalPolys);
        }
        catch (Exception e) {
            return;
        }
        if (polys.isEmpty()) {
            return;
        }
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tess = Tesselator.getInstance();
        BufferBuilder buf = tess.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        for (AlertPolygon poly : polys) {
            try {
                this.renderPolygon(buf, poly, hasRangeUpgrade);
            }
            catch (Exception exception) {}
        }
        MeshData mesh = buf.build();
        if (mesh != null) {
            BufferUploader.drawWithShader((MeshData)mesh);
        }
    }

    private boolean checkHasRangeUpgrade(BlockEntity blockEntity) {
        try {
            Field field = blockEntity.getClass().getField("hasRangeUpgrade");
            return field.getBoolean(blockEntity);
        }
        catch (Exception e) {
            return false;
        }
    }

    private void renderPolygon(BufferBuilder buf, AlertPolygon poly, boolean hasRangeUpgrade) {
        float halfH;
        float halfW;
        float offsetZ;
        float offsetX;
        float renderDiameter;
        WarningLevel level = poly.getWarningLevel();
        int color = level.getColor();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = 1.0f;
        if (hasRangeUpgrade) {
            renderDiameter = 6.0f;
            offsetX = ((float)poly.centerX - 0.5f) / 4.0f;
            offsetZ = ((float)poly.centerZ - 0.5f) / 4.0f;
            halfW = Math.max(poly.halfWidth / 4.0f * renderDiameter, 0.02f);
            halfH = Math.max(poly.halfHeight / 4.0f * renderDiameter, 0.02f);
        } else {
            renderDiameter = 3.0f;
            offsetX = (float)poly.centerX - 0.5f;
            offsetZ = (float)poly.centerZ - 0.5f;
            halfW = Math.max(poly.halfWidth * renderDiameter, 0.02f);
            halfH = Math.max(poly.halfHeight * renderDiameter, 0.02f);
        }
        float centerX = offsetX * renderDiameter;
        float centerZ = offsetZ * renderDiameter;
        double radians = Math.toRadians(poly.rotationDeg);
        float cos = (float)Math.cos(radians);
        float sin = (float)Math.sin(radians);
        float y = 0.02f;
        Vector3f[] corners = new Vector3f[4];
        if (poly.stormType == 0) {
            float trapezoidalFactor = 0.2f;
            float narrowHW = halfW * (1.0f - trapezoidalFactor);
            float wideHW = halfW * (1.0f + trapezoidalFactor);
            corners[0] = new Vector3f(-narrowHW * cos - halfH * sin + centerX, y, -narrowHW * sin + halfH * cos + centerZ);
            corners[1] = new Vector3f(narrowHW * cos - halfH * sin + centerX, y, narrowHW * sin + halfH * cos + centerZ);
            corners[2] = new Vector3f(wideHW * cos - -halfH * sin + centerX, y, wideHW * sin + -halfH * cos + centerZ);
            corners[3] = new Vector3f(-wideHW * cos - -halfH * sin + centerX, y, -wideHW * sin + -halfH * cos + centerZ);
        } else {
            float correctedRotation = poly.rotationDeg + 90.0f;
            double radians2 = Math.toRadians(correctedRotation);
            float cos2 = (float)Math.cos(radians2);
            float sin2 = (float)Math.sin(radians2);
            corners[0] = new Vector3f(-halfW * cos2 - -halfH * sin2 + centerX, y, -halfW * sin2 + -halfH * cos2 + centerZ);
            corners[1] = new Vector3f(halfW * cos2 - -halfH * sin2 + centerX, y, halfW * sin2 + -halfH * cos2 + centerZ);
            corners[2] = new Vector3f(halfW * cos2 - halfH * sin2 + centerX, y, halfW * sin2 + halfH * cos2 + centerZ);
            corners[3] = new Vector3f(-halfW * cos2 - halfH * sin2 + centerX, y, -halfW * sin2 + halfH * cos2 + centerZ);
        }
        for (int i = 0; i < 4; ++i) {
            Vector3f start = corners[i];
            Vector3f end = corners[(i + 1) % 4];
            float dx = end.x - start.x;
            float dz = end.z - start.z;
            float length = (float)Math.sqrt(dx * dx + dz * dz);
            if (length < 1.0E-5f) continue;
            float invLength = 1.0f / length;
            float dirX = dx * invLength;
            float dirZ = dz * invLength;
            float perpX = -dirZ * 0.015f;
            float perpZ = dirX * 0.015f;
            float extension = 0.0075f;
            Vector3f extStart = new Vector3f(start.x - dirX * extension, start.y, start.z - dirZ * extension);
            Vector3f extEnd = new Vector3f(end.x + dirX * extension, end.y, end.z + dirZ * extension);
            Vector3f topLeft = new Vector3f(extStart.x + perpX, extStart.y, extStart.z + perpZ);
            Vector3f bottomLeft = new Vector3f(extStart.x - perpX, extStart.y, extStart.z - perpZ);
            Vector3f bottomRight = new Vector3f(extEnd.x - perpX, extEnd.y, extEnd.z - perpZ);
            Vector3f topRight = new Vector3f(extEnd.x + perpX, extEnd.y, extEnd.z + perpZ);
            buf.addVertex(topLeft.x, topLeft.y, topLeft.z).setColor(r, g, b, a);
            buf.addVertex(topRight.x, topRight.y, topRight.z).setColor(r, g, b, a);
            buf.addVertex(bottomRight.x, bottomRight.y, bottomRight.z).setColor(r, g, b, a);
            buf.addVertex(bottomLeft.x, bottomLeft.y, bottomLeft.z).setColor(r, g, b, a);
            buf.addVertex(topLeft.x, topLeft.y, topLeft.z).setColor(r, g, b, a);
            buf.addVertex(bottomLeft.x, bottomLeft.y, bottomLeft.z).setColor(r, g, b, a);
            buf.addVertex(bottomRight.x, bottomRight.y, bottomRight.z).setColor(r, g, b, a);
            buf.addVertex(topRight.x, topRight.y, topRight.z).setColor(r, g, b, a);
        }
    }
}

