/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.mixin;

import dev.wxmc.weatheraddon.client.PhotoMetadataClientStorage;
import dev.wxmc.weatheraddon.compat.ExposureCompat;
import io.github.mortuusars.exposure.world.item.PhotographItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PhotographItem.class}, remap=false)
public class PhotographItemMixin {
    @Inject(method={"appendHoverText"}, at={@At(value="TAIL")})
    private void wxmc$appendPhotoMetadata(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag, CallbackInfo ci) {
        String photoId = ExposureCompat.getPhotoId(stack);
        if (photoId == null || photoId.isEmpty()) {
            return;
        }
        PhotoMetadataClientStorage.PhotoMetadata metadata = PhotoMetadataClientStorage.getMetadata(photoId);
        if (metadata == null) {
            return;
        }
        if (!tooltipComponents.isEmpty()) {
            tooltipComponents.add((Component)Component.empty());
        }
        tooltipComponents.add((Component)Component.literal((String)"Photo Metadata:").withStyle(ChatFormatting.GOLD));
        tooltipComponents.add((Component)Component.literal((String)"Photographer: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)metadata.getPhotographer()).withStyle(ChatFormatting.WHITE)));
        tooltipComponents.add((Component)Component.literal((String)"Coordinates: ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)(metadata.getX() + ", " + metadata.getZ())).withStyle(ChatFormatting.WHITE)));
    }
}

