/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiGraphics.class})
public abstract class GuiGraphicsMixin {
    private static final float WARNING_TOOLTIP_SCALE = 0.65f;

    @Shadow
    public abstract PoseStack pose();

    @Shadow
    public abstract int guiWidth();

    @Shadow
    public abstract int guiHeight();

    @Inject(method={"renderTooltipInternal"}, at={@At(value="HEAD")}, cancellable=true)
    private void wxmc_onRenderTooltip(Font font, List<ClientTooltipComponent> components, int mouseX, int mouseY, ClientTooltipPositioner positioner, CallbackInfo ci) {
        if (components.isEmpty()) {
            return;
        }
        boolean isWarningTooltip = false;
        try {
            ClientTooltipComponent firstComponent = components.get(0);
            String componentString = firstComponent.toString();
            if (componentString.contains("\u200b\u200c\u200b")) {
                isWarningTooltip = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!isWarningTooltip) {
            return;
        }
        ci.cancel();
        this.renderScaledWarningTooltip((GuiGraphics)this, font, components, mouseX, mouseY, positioner);
    }

    private void renderScaledWarningTooltip(GuiGraphics graphics, Font font, List<ClientTooltipComponent> components, int mouseX, int mouseY, ClientTooltipPositioner positioner) {
        ClientTooltipComponent component;
        int i;
        if (components.isEmpty()) {
            return;
        }
        PoseStack poseStack = graphics.pose();
        int tooltipWidth = 0;
        int tooltipHeight = components.size() == 1 ? -2 : 0;
        for (ClientTooltipComponent component2 : components) {
            int componentWidth = component2.getWidth(font);
            if (componentWidth > tooltipWidth) {
                tooltipWidth = componentWidth;
            }
            tooltipHeight += component2.getHeight();
        }
        int screenWidth = this.guiWidth();
        int screenHeight = this.guiHeight();
        int scaledWidth = (int)((float)tooltipWidth * 0.65f);
        int scaledHeight = (int)((float)tooltipHeight * 0.65f);
        int x = mouseX + 12;
        int y = mouseY - 12;
        if (x + scaledWidth + 6 > screenWidth) {
            x = mouseX - scaledWidth - 16;
        }
        if (x < 4) {
            x = 4;
        }
        if (y + scaledHeight + 6 > screenHeight) {
            y = screenHeight - scaledHeight - 6;
        }
        if (y < 4) {
            y = 4;
        }
        poseStack.pushPose();
        poseStack.translate((float)x, (float)y, 400.0f);
        poseStack.scale(0.65f, 0.65f, 1.0f);
        int backgroundColor = -267386864;
        int borderColorTop = 0x505000FF;
        int borderColorBottom = 1344798847;
        int bgX = 0;
        int bgY = 0;
        int bgWidth = tooltipWidth + 6;
        int bgHeight = tooltipHeight + 6;
        graphics.fill(bgX, bgY, bgX + bgWidth, bgY + bgHeight, backgroundColor);
        graphics.fill(bgX, bgY, bgX + bgWidth, bgY + 1, borderColorTop);
        graphics.fill(bgX, bgY + bgHeight - 1, bgX + bgWidth, bgY + bgHeight, borderColorBottom);
        graphics.fill(bgX, bgY + 1, bgX + 1, bgY + bgHeight - 1, borderColorTop);
        graphics.fill(bgX + bgWidth - 1, bgY + 1, bgX + bgWidth, bgY + bgHeight - 1, borderColorBottom);
        int textY = 3;
        for (i = 0; i < components.size(); ++i) {
            component = components.get(i);
            component.renderText(font, 3, textY, poseStack.last().pose(), graphics.bufferSource());
            textY += component.getHeight() + (i == 0 ? 2 : 0);
        }
        textY = 3;
        for (i = 0; i < components.size(); ++i) {
            component = components.get(i);
            component.renderImage(font, 3, textY, graphics);
            textY += component.getHeight() + (i == 0 ? 2 : 0);
        }
        poseStack.popPose();
    }
}

