/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.mixin;

import dev.protomanly.pmweather.event.GameBusEvents;
import dev.wxmc.weatheraddon.util.WXMCDebugLogger;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={GameBusEvents.class}, remap=false)
public class GameBusEventsNaNFixMixin {
    private static final Vec3 DEFAULT_WIND_DIRECTION = new Vec3(-1.0, 0.0, -1.0).normalize();

    @Redirect(method={"lambda$onLevelTick$3"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;normalize()Lnet/minecraft/world/phys/Vec3;"))
    private static Vec3 wxmc$safeNormalize(Vec3 vec) {
        if (vec.length() < 1.0E-4) {
            WXMCDebugLogger.debug("[NaN-FIX] Prevented NaN: wind.normalize() called on zero vector, using default direction");
            return DEFAULT_WIND_DIRECTION;
        }
        Vec3 normalized = vec.normalize();
        if (Double.isNaN(normalized.x) || Double.isNaN(normalized.y) || Double.isNaN(normalized.z)) {
            WXMCDebugLogger.debug("[NaN-FIX] Prevented NaN: normalize() produced NaN, using default direction");
            return DEFAULT_WIND_DIRECTION;
        }
        return normalized;
    }
}

