/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.mixin;

import dev.wxmc.weatheraddon.WXMCWeatherAddon;
import dev.wxmc.weatheraddon.radar.RadarColorConfig;
import dev.wxmc.weatheraddon.radar.WXMCColorTables;
import java.awt.Color;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(targets={"dev.protomanly.pmweather.util.ColorTables"}, remap=false)
public class ColorTablesMixin {
    private static boolean loggedReflectivity = false;
    private static boolean loggedVelocity = false;

    @Inject(method={"getReflectivity(FLjava/awt/Color;)Ljava/awt/Color;"}, at={@At(value="HEAD")}, cancellable=true, require=0)
    private static void wxmc_customReflectivity(float val, Color startColor, CallbackInfoReturnable<Color> cir) {
        if (!loggedReflectivity) {
            WXMCWeatherAddon.LOGGER.info("ColorTablesMixin (Reflectivity) is active! Custom color tables enabled: {}", (Object)RadarColorConfig.isCustomColorsEnabled());
            loggedReflectivity = true;
        }
        if (RadarColorConfig.isCustomColorsEnabled()) {
            Color customColor = WXMCColorTables.getReflectivity(RadarColorConfig.getCurrentPreset(), val, startColor);
            cir.setReturnValue((Object)customColor);
        }
    }

    @Inject(method={"getVelocity(F)Ljava/awt/Color;"}, at={@At(value="HEAD")}, cancellable=true, require=0)
    private static void wxmc_customVelocity(float vel, CallbackInfoReturnable<Color> cir) {
        Color customColor;
        if (!loggedVelocity) {
            WXMCWeatherAddon.LOGGER.info("ColorTablesMixin (Velocity) is active! Custom velocity color tables enabled: {}", (Object)RadarColorConfig.isCustomVelocityColorsEnabled());
            loggedVelocity = true;
        }
        if (RadarColorConfig.isCustomVelocityColorsEnabled() && (customColor = WXMCColorTables.getVelocity(RadarColorConfig.getCurrentVelocityPreset(), vel)) != null) {
            cir.setReturnValue((Object)customColor);
        }
    }
}

