/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.item;

import dev.wxmc.weatheraddon.block.LoudounSirenBlockEntity;
import dev.wxmc.weatheraddon.block.TornadoSirenBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TornadoTunerItem
extends Item {
    public TornadoTunerItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        Level level = context.getLevel();
        BlockEntity blockEntity = level.getBlockEntity(pos = context.getClickedPos());
        if (blockEntity instanceof TornadoSirenBlockEntity) {
            TornadoSirenBlockEntity sirenEntity = (TornadoSirenBlockEntity)blockEntity;
            if (!level.isClientSide()) {
                if (sirenEntity.isPlaying()) {
                    if (context.getPlayer() != null) {
                        context.getPlayer().displayClientMessage((Component)Component.literal((String)"Cannot change frequency while siren is sounding."), false);
                    }
                    return InteractionResult.FAIL;
                }
                TornadoSirenBlockEntity.SirenFrequency newFreq = sirenEntity.toggleFrequency();
                level.playSound(null, pos, (SoundEvent)SoundEvents.NOTE_BLOCK_PLING.value(), SoundSource.BLOCKS, 1.0f, newFreq == TornadoSirenBlockEntity.SirenFrequency.HZ_523 ? 1.0f : 1.26f);
                if (context.getPlayer() != null) {
                    context.getPlayer().displayClientMessage((Component)Component.literal((String)("Tornado Siren frequency set to " + newFreq.getDisplayName() + ".")), false);
                }
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        if (blockEntity instanceof LoudounSirenBlockEntity) {
            LoudounSirenBlockEntity loudounEntity = (LoudounSirenBlockEntity)blockEntity;
            if (!level.isClientSide()) {
                if (loudounEntity.isPlaying()) {
                    if (context.getPlayer() != null) {
                        context.getPlayer().displayClientMessage((Component)Component.literal((String)"Cannot change frequency while siren is sounding."), false);
                    }
                    return InteractionResult.FAIL;
                }
                LoudounSirenBlockEntity.SirenFrequency newFreq = loudounEntity.toggleFrequency();
                level.playSound(null, pos, (SoundEvent)SoundEvents.NOTE_BLOCK_PLING.value(), SoundSource.BLOCKS, 1.0f, newFreq == LoudounSirenBlockEntity.SirenFrequency.HZ_523 ? 1.0f : 1.26f);
                if (context.getPlayer() != null) {
                    context.getPlayer().displayClientMessage((Component)Component.literal((String)("Loudoun Siren frequency set to " + newFreq.getDisplayName() + ".")), false);
                }
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return InteractionResult.PASS;
    }
}

