/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;

public class EASReceiverItem
extends Item {
    public static final String TAG_ENABLED = "eas_enabled";

    public EASReceiverItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            boolean currentState = EASReceiverItem.isEnabled(stack);
            boolean newState = !currentState;
            EASReceiverItem.setEnabled(stack, newState);
            if (!level.isClientSide()) {
                level.playSound(null, player.getX(), player.getY(), player.getZ(), newState ? SoundEvents.EXPERIENCE_ORB_PICKUP : (SoundEvent)SoundEvents.NOTE_BLOCK_BASS.value(), SoundSource.PLAYERS, 0.5f, newState ? 1.2f : 0.8f);
                MutableComponent status = Component.literal((String)"EAS Receiver: ");
                if (newState) {
                    status.append((Component)Component.literal((String)"ON").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)43520))));
                } else {
                    status.append((Component)Component.literal((String)"OFF").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAA0000))));
                }
                player.displayClientMessage((Component)status, true);
            }
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        boolean enabled = EASReceiverItem.isEnabled(stack);
        MutableComponent statusLine = Component.literal((String)"Status: ");
        if (enabled) {
            statusLine.append((Component)Component.literal((String)"ON").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)43520))));
        } else {
            statusLine.append((Component)Component.literal((String)"OFF").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAA0000))));
        }
        tooltipComponents.add((Component)statusLine);
        tooltipComponents.add((Component)Component.literal((String)"Receive weather warnings when enabled").withStyle(ChatFormatting.GRAY));
    }

    public static boolean isEnabled(ItemStack stack) {
        if (stack.isEmpty() || !(stack.getItem() instanceof EASReceiverItem)) {
            return false;
        }
        CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (customData == null) {
            return false;
        }
        CompoundTag tag = customData.copyTag();
        return tag.getBoolean(TAG_ENABLED);
    }

    public static void setEnabled(ItemStack stack, boolean enabled) {
        CustomData existingData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        CompoundTag tag = existingData != null ? existingData.copyTag() : new CompoundTag();
        tag.putBoolean(TAG_ENABLED, enabled);
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
    }

    public static boolean playerHasEnabledReceiver(Player player) {
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (!EASReceiverItem.isEnabled(stack)) continue;
            return true;
        }
        return false;
    }
}

