/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.data;

import dev.wxmc.weatheraddon.WXMCWeatherAddon;
import dev.wxmc.weatheraddon.data.SubmissionReview;
import dev.wxmc.weatheraddon.data.TornadoRating;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public record TornadoEntry(UUID entryId, String eventId, TornadoRating rating, String windspeedEst, int coordX, int coordZ, String notes, UUID submitterUUID, String submitterName, long timestamp, List<String> photoIds, List<SubmissionReview> reviews, boolean accepted) {
    public TornadoEntry(UUID entryId, String eventId, TornadoRating rating, String windspeedEst, int coordX, int coordZ, String notes, UUID submitterUUID, String submitterName, long timestamp, List<String> photoIds, List<SubmissionReview> reviews) {
        this(entryId, eventId, rating, windspeedEst, coordX, coordZ, notes, submitterUUID, submitterName, timestamp, photoIds, reviews, false);
    }

    public int photoCount() {
        return this.photoIds != null ? this.photoIds.size() : 0;
    }

    public int reviewCount() {
        return this.reviews != null ? this.reviews.size() : 0;
    }

    public int upvoteCount() {
        if (this.reviews == null) {
            return 0;
        }
        return (int)this.reviews.stream().filter(r -> r.agreement() == SubmissionReview.ReviewAgreement.AGREE).count();
    }

    public int downvoteCount() {
        if (this.reviews == null) {
            return 0;
        }
        return (int)this.reviews.stream().filter(r -> r.agreement() == SubmissionReview.ReviewAgreement.DISAGREE).count();
    }

    public TornadoEntry withAccepted(boolean accepted) {
        return new TornadoEntry(this.entryId, this.eventId, this.rating, this.windspeedEst, this.coordX, this.coordZ, this.notes, this.submitterUUID, this.submitterName, this.timestamp, this.photoIds, this.reviews, accepted);
    }

    public TornadoEntry withReview(SubmissionReview review) {
        ArrayList<SubmissionReview> newReviews = new ArrayList<SubmissionReview>(this.reviews != null ? this.reviews : new ArrayList());
        newReviews.add(review);
        return new TornadoEntry(this.entryId, this.eventId, this.rating, this.windspeedEst, this.coordX, this.coordZ, this.notes, this.submitterUUID, this.submitterName, this.timestamp, this.photoIds, Collections.unmodifiableList(newReviews), this.accepted);
    }

    public boolean hasUserReviewed(UUID userUUID) {
        if (this.reviews == null) {
            return false;
        }
        return this.reviews.stream().anyMatch(r -> r.reviewerUUID().equals(userUUID));
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.putUUID("entryId", this.entryId);
        tag.putString("eventId", this.eventId);
        tag.putString("rating", this.rating.name());
        tag.putString("windspeedEst", this.windspeedEst);
        tag.putInt("coordX", this.coordX);
        tag.putInt("coordZ", this.coordZ);
        tag.putString("notes", this.notes);
        tag.putUUID("submitterUUID", this.submitterUUID);
        tag.putString("submitterName", this.submitterName);
        tag.putLong("timestamp", this.timestamp);
        tag.putBoolean("accepted", this.accepted);
        ListTag photoIdList = new ListTag();
        if (this.photoIds != null) {
            for (String id : this.photoIds) {
                photoIdList.add((Object)StringTag.valueOf((String)id));
            }
        }
        tag.put("photoIds", (Tag)photoIdList);
        ListTag reviewsList = new ListTag();
        if (this.reviews != null) {
            for (SubmissionReview review : this.reviews) {
                reviewsList.add((Object)review.save());
            }
        }
        tag.put("reviews", (Tag)reviewsList);
        return tag;
    }

    public static TornadoEntry load(CompoundTag tag) {
        ArrayList<String> photoIds = new ArrayList<String>();
        if (tag.contains("photoIds", 9)) {
            ListTag photoIdList = tag.getList("photoIds", 8);
            for (int i = 0; i < photoIdList.size(); ++i) {
                photoIds.add(photoIdList.getString(i));
            }
        }
        ArrayList<SubmissionReview> reviews = new ArrayList<SubmissionReview>();
        if (tag.contains("reviews", 9)) {
            ListTag reviewsList = tag.getList("reviews", 10);
            for (int i = 0; i < reviewsList.size(); ++i) {
                try {
                    reviews.add(SubmissionReview.load(reviewsList.getCompound(i)));
                    continue;
                }
                catch (Exception e) {
                    WXMCWeatherAddon.LOGGER.warn("Failed to load review {}: {}", (Object)i, (Object)e.getMessage());
                }
            }
        }
        boolean accepted = tag.contains("accepted") && tag.getBoolean("accepted");
        try {
            return new TornadoEntry(tag.getUUID("entryId"), tag.getString("eventId"), TornadoRating.valueOf(tag.getString("rating")), tag.getString("windspeedEst"), tag.getInt("coordX"), tag.getInt("coordZ"), tag.getString("notes"), tag.getUUID("submitterUUID"), tag.getString("submitterName"), tag.getLong("timestamp"), Collections.unmodifiableList(photoIds), Collections.unmodifiableList(reviews), accepted);
        }
        catch (IllegalArgumentException e) {
            WXMCWeatherAddon.LOGGER.warn("Failed to load tornado entry: invalid rating value");
            return new TornadoEntry(tag.getUUID("entryId"), tag.getString("eventId"), TornadoRating.EF0, tag.getString("windspeedEst"), tag.getInt("coordX"), tag.getInt("coordZ"), tag.getString("notes"), tag.getUUID("submitterUUID"), tag.getString("submitterName"), tag.getLong("timestamp"), Collections.unmodifiableList(photoIds), Collections.unmodifiableList(reviews), accepted);
        }
    }
}

