/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.data;

import dev.wxmc.weatheraddon.WXMCWeatherAddon;
import dev.wxmc.weatheraddon.compat.BukkitEventBridge;
import dev.wxmc.weatheraddon.data.SubmissionReview;
import dev.wxmc.weatheraddon.data.TornadoEntry;
import dev.wxmc.weatheraddon.data.TornadoRating;
import dev.wxmc.weatheraddon.util.PermissionHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class TornadoDatabase
extends SavedData {
    private static final String DATA_NAME = "wxmc_tornado_database";
    private static final int MAX_ENTRIES = 10000;
    private final List<TornadoEntry> entries = new ArrayList<TornadoEntry>();

    public static TornadoDatabase load(CompoundTag tag, HolderLookup.Provider provider) {
        TornadoDatabase data = new TornadoDatabase();
        if (tag.contains("entries", 9)) {
            ListTag entriesTag = tag.getList("entries", 10);
            for (int i = 0; i < entriesTag.size() && i < 10000; ++i) {
                try {
                    TornadoEntry entry = TornadoEntry.load(entriesTag.getCompound(i));
                    data.entries.add(entry);
                    continue;
                }
                catch (Exception e) {
                    WXMCWeatherAddon.LOGGER.warn("Failed to load tornado database entry {}: {}", (Object)i, (Object)e.getMessage());
                }
            }
        }
        WXMCWeatherAddon.LOGGER.info("Loaded {} tornado database entries", (Object)data.entries.size());
        return data;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        ListTag entriesTag = new ListTag();
        for (TornadoEntry entry : this.entries) {
            entriesTag.add((Object)entry.save());
        }
        tag.put("entries", (Tag)entriesTag);
        return tag;
    }

    public static TornadoDatabase getOrCreate(MinecraftServer server) {
        DimensionDataStorage storage = server.overworld().getDataStorage();
        return (TornadoDatabase)storage.computeIfAbsent(new SavedData.Factory(TornadoDatabase::new, TornadoDatabase::load), DATA_NAME);
    }

    public void addEntry(TornadoEntry entry) {
        if (this.entries.size() >= 10000) {
            TornadoEntry removed = this.entries.remove(0);
            WXMCWeatherAddon.LOGGER.info("Removed oldest tornado entry {} to make room", (Object)removed.entryId());
        }
        this.entries.add(entry);
        this.setDirty();
        WXMCWeatherAddon.LOGGER.info("Added tornado database entry: {} by {} ({})", new Object[]{entry.eventId(), entry.submitterName(), entry.rating().getDisplayName()});
    }

    public List<TornadoEntry> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public int getEntryCount() {
        return this.entries.size();
    }

    public Optional<TornadoEntry> getEntry(UUID entryId) {
        return this.entries.stream().filter(e -> e.entryId().equals(entryId)).findFirst();
    }

    public boolean removeEntry(UUID entryId) {
        boolean removed = this.entries.removeIf(e -> e.entryId().equals(entryId));
        if (removed) {
            this.setDirty();
            WXMCWeatherAddon.LOGGER.info("Removed tornado database entry: {}", (Object)entryId);
        }
        return removed;
    }

    public List<TornadoEntry> getEntriesBySubmitter(UUID submitterUUID) {
        return this.entries.stream().filter(e -> e.submitterUUID().equals(submitterUUID)).toList();
    }

    public List<TornadoEntry> getEntriesByRating(TornadoRating rating) {
        return this.entries.stream().filter(e -> e.rating() == rating).toList();
    }

    public void clearAll() {
        int count = this.entries.size();
        this.entries.clear();
        this.setDirty();
        WXMCWeatherAddon.LOGGER.info("Cleared all {} tornado database entries", (Object)count);
    }

    public boolean addReviewToEntry(UUID entryId, SubmissionReview review) {
        for (int i = 0; i < this.entries.size(); ++i) {
            TornadoEntry entry = this.entries.get(i);
            if (!entry.entryId().equals(entryId)) continue;
            TornadoEntry updatedEntry = entry.withReview(review);
            this.entries.set(i, updatedEntry);
            this.setDirty();
            WXMCWeatherAddon.LOGGER.info("Added review by {} to entry {}: {}", new Object[]{review.reviewerName(), entryId, review.agreement().getDisplayName()});
            return true;
        }
        return false;
    }

    public boolean updateEntryRating(UUID entryId, TornadoRating newRating) {
        for (int i = 0; i < this.entries.size(); ++i) {
            TornadoEntry entry = this.entries.get(i);
            if (!entry.entryId().equals(entryId)) continue;
            TornadoEntry updatedEntry = new TornadoEntry(entry.entryId(), entry.eventId(), newRating, entry.windspeedEst(), entry.coordX(), entry.coordZ(), entry.notes(), entry.submitterUUID(), entry.submitterName(), entry.timestamp(), entry.photoIds(), entry.reviews(), entry.accepted());
            this.entries.set(i, updatedEntry);
            this.setDirty();
            WXMCWeatherAddon.LOGGER.info("Admin updated entry {} rating from {} to {}", new Object[]{entryId, entry.rating().getDisplayName(), newRating.getDisplayName()});
            return true;
        }
        return false;
    }

    public boolean acceptEntry(UUID entryId) {
        for (int i = 0; i < this.entries.size(); ++i) {
            TornadoEntry entry = this.entries.get(i);
            if (!entry.entryId().equals(entryId)) continue;
            if (entry.accepted()) {
                return true;
            }
            TornadoEntry updatedEntry = entry.withAccepted(true);
            this.entries.set(i, updatedEntry);
            this.setDirty();
            UUID submitterUUID = entry.submitterUUID();
            int acceptedCount = this.countAcceptedEntriesBySubmitter(submitterUUID);
            String permission = "wxmc.tordb." + acceptedCount;
            if (PermissionHelper.grantPermission(submitterUUID, permission)) {
                WXMCWeatherAddon.LOGGER.info("Granted {} to {} for accepted entry {}", new Object[]{permission, entry.submitterName(), entryId});
            }
            BukkitEventBridge.fireTornadoEntryAccepted(submitterUUID, entry.submitterName(), acceptedCount, entry.rating().ordinal(), entry.entryId());
            WXMCWeatherAddon.LOGGER.info("Admin accepted entry {} ({}) - submitter {} now has {} accepted entries", new Object[]{entryId, entry.rating().getDisplayName(), entry.submitterName(), acceptedCount});
            return true;
        }
        return false;
    }

    public int countAcceptedEntriesBySubmitter(UUID submitterUUID) {
        return (int)this.entries.stream().filter(e -> e.submitterUUID().equals(submitterUUID) && e.accepted()).count();
    }

    public boolean removeReviewFromEntry(UUID entryId, UUID reviewId) {
        for (int i = 0; i < this.entries.size(); ++i) {
            TornadoEntry entry = this.entries.get(i);
            if (!entry.entryId().equals(entryId)) continue;
            if (entry.reviews() == null || entry.reviews().isEmpty()) {
                return false;
            }
            List<SubmissionReview> newReviews = entry.reviews().stream().filter(r -> !r.reviewId().equals(reviewId)).toList();
            if (newReviews.size() == entry.reviews().size()) {
                return false;
            }
            TornadoEntry updatedEntry = new TornadoEntry(entry.entryId(), entry.eventId(), entry.rating(), entry.windspeedEst(), entry.coordX(), entry.coordZ(), entry.notes(), entry.submitterUUID(), entry.submitterName(), entry.timestamp(), entry.photoIds(), newReviews, entry.accepted());
            this.entries.set(i, updatedEntry);
            this.setDirty();
            WXMCWeatherAddon.LOGGER.info("Admin removed review {} from entry {}", (Object)reviewId, (Object)entryId);
            return true;
        }
        return false;
    }
}

