/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.data;

import dev.wxmc.weatheraddon.data.TornadoRating;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;

public record SubmissionReview(UUID reviewId, UUID reviewerUUID, String reviewerName, ReviewAgreement agreement, TornadoRating suggestedRating, String notes, long timestamp) {
    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.putUUID("reviewId", this.reviewId);
        tag.putUUID("reviewerUUID", this.reviewerUUID);
        tag.putString("reviewerName", this.reviewerName);
        tag.putString("agreement", this.agreement.name());
        if (this.suggestedRating != null) {
            tag.putString("suggestedRating", this.suggestedRating.name());
        }
        tag.putString("notes", this.notes != null ? this.notes : "");
        tag.putLong("timestamp", this.timestamp);
        return tag;
    }

    public static SubmissionReview load(CompoundTag tag) {
        ReviewAgreement agreement;
        TornadoRating suggested = null;
        if (tag.contains("suggestedRating")) {
            try {
                suggested = TornadoRating.valueOf(tag.getString("suggestedRating"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        try {
            agreement = ReviewAgreement.valueOf(tag.getString("agreement"));
        }
        catch (IllegalArgumentException e) {
            agreement = ReviewAgreement.AGREE;
        }
        return new SubmissionReview(tag.getUUID("reviewId"), tag.getUUID("reviewerUUID"), tag.getString("reviewerName"), agreement, suggested, tag.getString("notes"), tag.getLong("timestamp"));
    }

    public String getVerdictDisplay() {
        return this.agreement.getDisplayName();
    }

    public static enum ReviewAgreement {
        AGREE("Agree", 0x55FF55),
        DISAGREE("Disagree", 0xFF5555);

        private final String displayName;
        private final int color;

        private ReviewAgreement(String displayName, int color) {
            this.displayName = displayName;
            this.color = color;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public int getColor() {
            return this.color;
        }
    }
}

