/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.compat;

import dev.wxmc.weatheraddon.WXMCWeatherAddon;
import dev.wxmc.weatheraddon.util.WXMCDebugLogger;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import net.minecraft.world.level.Level;
import net.neoforged.fml.ModList;

public class SereneSeasonsCompat {
    private static Boolean sereneSeasonsLoaded = null;
    private static boolean reflectionInitialized = false;
    private static Method method_getSeasonState = null;
    private static Method method_getSeason = null;
    private static Method method_getSubSeason = null;
    private static Season lastKnownSeason = null;
    private static SubSeason lastKnownSubSeason = null;
    private static Consumer<SeasonChangeInfo> seasonChangeCallback = null;

    public static boolean isLoaded() {
        if (sereneSeasonsLoaded == null && (sereneSeasonsLoaded = Boolean.valueOf(ModList.get().isLoaded("sereneseasons"))).booleanValue()) {
            WXMCWeatherAddon.LOGGER.info("Serene Seasons detected - seasonal risk modifiers enabled");
            SereneSeasonsCompat.initReflection();
        }
        return sereneSeasonsLoaded;
    }

    private static void initReflection() {
        if (reflectionInitialized) {
            return;
        }
        reflectionInitialized = true;
        try {
            Class<?> seasonHelperClass = Class.forName("sereneseasons.api.season.SeasonHelper");
            method_getSeasonState = seasonHelperClass.getMethod("getSeasonState", Level.class);
            Class<?> seasonStateClass = Class.forName("sereneseasons.api.season.ISeasonState");
            method_getSeason = seasonStateClass.getMethod("getSeason", new Class[0]);
            method_getSubSeason = seasonStateClass.getMethod("getSubSeason", new Class[0]);
            WXMCWeatherAddon.LOGGER.info("Serene Seasons reflection initialized successfully");
        }
        catch (Exception e) {
            WXMCWeatherAddon.LOGGER.warn("Failed to initialize Serene Seasons reflection: {}", (Object)e.getMessage());
            method_getSeasonState = null;
            method_getSeason = null;
            method_getSubSeason = null;
        }
    }

    public static void setSeasonChangeCallback(Consumer<SeasonChangeInfo> callback) {
        seasonChangeCallback = callback;
    }

    public static void checkForSeasonChange(Level level) {
        boolean subSeasonChanged;
        if (!SereneSeasonsCompat.isLoaded() || level == null || level.isClientSide()) {
            return;
        }
        Season currentSeason = SereneSeasonsCompat.getCurrentSeason(level);
        SubSeason currentSubSeason = SereneSeasonsCompat.getCurrentSubSeason(level);
        if (currentSeason == null || currentSubSeason == null) {
            return;
        }
        if (lastKnownSeason == null) {
            lastKnownSeason = currentSeason;
            lastKnownSubSeason = currentSubSeason;
            WXMCDebugLogger.info("[SEASONS] Initial season detected: {} ({})", new Object[]{currentSeason, currentSubSeason});
            if (seasonChangeCallback != null) {
                SeasonChangeInfo info = new SeasonChangeInfo(null, currentSeason, null, currentSubSeason, true);
                try {
                    seasonChangeCallback.accept(info);
                }
                catch (Exception e) {
                    WXMCWeatherAddon.LOGGER.error("[SEASONS] Error in initial season callback: {}", (Object)e.getMessage());
                }
            }
            return;
        }
        boolean mainSeasonChanged = lastKnownSeason != currentSeason;
        boolean bl = subSeasonChanged = lastKnownSubSeason != currentSubSeason;
        if (subSeasonChanged) {
            SeasonChangeInfo info = new SeasonChangeInfo(lastKnownSeason, currentSeason, lastKnownSubSeason, currentSubSeason, mainSeasonChanged);
            if (mainSeasonChanged) {
                WXMCDebugLogger.info("[SEASONS] Main season changed: {} -> {}", new Object[]{lastKnownSeason, currentSeason});
            } else {
                WXMCDebugLogger.info("[SEASONS] Sub-season changed: {} -> {}", new Object[]{lastKnownSubSeason, currentSubSeason});
            }
            lastKnownSeason = currentSeason;
            lastKnownSubSeason = currentSubSeason;
            if (seasonChangeCallback != null) {
                try {
                    seasonChangeCallback.accept(info);
                }
                catch (Exception e) {
                    WXMCWeatherAddon.LOGGER.error("[SEASONS] Error in season change callback: {}", (Object)e.getMessage());
                }
            }
        }
    }

    public static Season getCurrentSeason(Level level) {
        if (!SereneSeasonsCompat.isLoaded() || level == null) {
            return null;
        }
        if (method_getSeasonState == null || method_getSeason == null) {
            return null;
        }
        try {
            Object seasonState = method_getSeasonState.invoke(null, level);
            if (seasonState == null) {
                return null;
            }
            Object seasonEnum = method_getSeason.invoke(seasonState, new Object[0]);
            if (seasonEnum == null) {
                return null;
            }
            String seasonName = seasonEnum.toString().toUpperCase();
            if (seasonName.equals("FALL")) {
                seasonName = "AUTUMN";
            }
            try {
                return Season.valueOf(seasonName);
            }
            catch (IllegalArgumentException e) {
                WXMCWeatherAddon.LOGGER.warn("Unknown season from Serene Seasons: {}", (Object)seasonName);
                return null;
            }
        }
        catch (Exception e) {
            WXMCWeatherAddon.LOGGER.warn("Failed to get current season: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static SubSeason getCurrentSubSeason(Level level) {
        if (!SereneSeasonsCompat.isLoaded() || level == null) {
            return null;
        }
        if (method_getSeasonState == null || method_getSubSeason == null) {
            return null;
        }
        try {
            Object seasonState = method_getSeasonState.invoke(null, level);
            if (seasonState == null) {
                return null;
            }
            Object subSeasonEnum = method_getSubSeason.invoke(seasonState, new Object[0]);
            if (subSeasonEnum == null) {
                return null;
            }
            String subSeasonName = subSeasonEnum.toString().toUpperCase();
            try {
                return SubSeason.valueOf(subSeasonName);
            }
            catch (IllegalArgumentException e) {
                WXMCWeatherAddon.LOGGER.warn("Unknown sub-season from Serene Seasons: {}", (Object)subSeasonName);
                return null;
            }
        }
        catch (Exception e) {
            WXMCWeatherAddon.LOGGER.warn("Failed to get current sub-season: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static Season getLastKnownSeason() {
        return lastKnownSeason;
    }

    public static SubSeason getLastKnownSubSeason() {
        return lastKnownSubSeason;
    }

    public static float getSeasonalRiskModifier(Level level) {
        Season season = SereneSeasonsCompat.getCurrentSeason(level);
        if (season == null) {
            return 1.0f;
        }
        return season.getRiskModifier();
    }

    public static float getSeasonalRiskModifier() {
        return 1.0f;
    }

    public static String getCurrentSeasonName(Level level) {
        Season season = SereneSeasonsCompat.getCurrentSeason(level);
        if (season == null) {
            return "Unknown";
        }
        return season.name().charAt(0) + season.name().substring(1).toLowerCase();
    }

    public static void resetTracking() {
        lastKnownSeason = null;
        lastKnownSubSeason = null;
    }

    public static enum Season {
        SPRING(1.4f),
        SUMMER(0.75f),
        AUTUMN(0.9f),
        WINTER(0.25f);

        private final float riskModifier;

        private Season(float riskModifier) {
            this.riskModifier = riskModifier;
        }

        public float getRiskModifier() {
            return this.riskModifier;
        }
    }

    public static enum SubSeason {
        EARLY_SPRING(Season.SPRING),
        MID_SPRING(Season.SPRING),
        LATE_SPRING(Season.SPRING),
        EARLY_SUMMER(Season.SUMMER),
        MID_SUMMER(Season.SUMMER),
        LATE_SUMMER(Season.SUMMER),
        EARLY_AUTUMN(Season.AUTUMN),
        MID_AUTUMN(Season.AUTUMN),
        LATE_AUTUMN(Season.AUTUMN),
        EARLY_WINTER(Season.WINTER),
        MID_WINTER(Season.WINTER),
        LATE_WINTER(Season.WINTER);

        private final Season parentSeason;

        private SubSeason(Season parentSeason) {
            this.parentSeason = parentSeason;
        }

        public Season getParentSeason() {
            return this.parentSeason;
        }
    }

    public record SeasonChangeInfo(Season previousSeason, Season newSeason, SubSeason previousSubSeason, SubSeason newSubSeason, boolean isMainSeasonChange) {
    }
}

