/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.compat;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import dev.wxmc.weatheraddon.util.WXMCDebugLogger;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;

public class PhotoMetadataStorage {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String STORAGE_FILE = "wxmc_photo_metadata.json";
    private static final Map<String, PhotoMetadata> metadata = new ConcurrentHashMap<String, PhotoMetadata>();
    private static MinecraftServer server = null;

    public static void init(MinecraftServer minecraftServer) {
        server = minecraftServer;
        PhotoMetadataStorage.load();
    }

    public static void shutdown() {
        PhotoMetadataStorage.save();
        metadata.clear();
        server = null;
    }

    public static void storeMetadata(String photoId, String photographer, int x, int z) {
        if (photoId == null || photoId.isEmpty()) {
            return;
        }
        metadata.put(photoId, new PhotoMetadata(photographer, x, z));
        WXMCDebugLogger.debug("[PhotoMetadata] Stored metadata for photo {}: {} at ({}, {})", photoId, photographer, x, z);
        PhotoMetadataStorage.save();
    }

    public static PhotoMetadata getMetadata(String photoId) {
        if (photoId == null || photoId.isEmpty()) {
            return null;
        }
        return metadata.get(photoId);
    }

    public static boolean hasMetadata(String photoId) {
        return photoId != null && metadata.containsKey(photoId);
    }

    public static Map<String, PhotoMetadata> getAllMetadata() {
        return Collections.unmodifiableMap(metadata);
    }

    private static Path getStoragePath() {
        if (server == null) {
            return null;
        }
        return server.getWorldPath(LevelResource.ROOT).resolve(STORAGE_FILE);
    }

    private static void load() {
        Path path = PhotoMetadataStorage.getStoragePath();
        if (path == null || !Files.exists(path, new LinkOption[0])) {
            WXMCDebugLogger.debug("[PhotoMetadata] No existing metadata file found");
            return;
        }
        try {
            String json = Files.readString(path);
            Type type = new TypeToken<Map<String, PhotoMetadata>>(){}.getType();
            Map loaded = (Map)GSON.fromJson(json, type);
            if (loaded != null) {
                metadata.clear();
                metadata.putAll(loaded);
                WXMCDebugLogger.info("[PhotoMetadata] Loaded {} photo metadata entries", metadata.size());
            }
        }
        catch (IOException e) {
            WXMCDebugLogger.warn("[PhotoMetadata] Failed to load metadata: {}", e.getMessage());
        }
    }

    private static void save() {
        Path path = PhotoMetadataStorage.getStoragePath();
        if (path == null) {
            return;
        }
        try {
            String json = GSON.toJson(metadata);
            Files.writeString(path, (CharSequence)json, new OpenOption[0]);
            WXMCDebugLogger.debug("[PhotoMetadata] Saved {} photo metadata entries", metadata.size());
        }
        catch (IOException e) {
            WXMCDebugLogger.warn("[PhotoMetadata] Failed to save metadata: {}", e.getMessage());
        }
    }

    public static class PhotoMetadata {
        private final String photographer;
        private final int x;
        private final int z;
        private final long timestamp;

        public PhotoMetadata(String photographer, int x, int z) {
            this.photographer = photographer;
            this.x = x;
            this.z = z;
            this.timestamp = System.currentTimeMillis();
        }

        public String getPhotographer() {
            return this.photographer;
        }

        public int getX() {
            return this.x;
        }

        public int getZ() {
            return this.z;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

