/*
 * Decompiled with CFR 0.152.
 */
package dev.wxmc.weatheraddon.compat;

import dev.wxmc.weatheraddon.compat.BukkitEventBridge;
import dev.wxmc.weatheraddon.compat.PhotoMetadataStorage;
import dev.wxmc.weatheraddon.network.PhotoMetadataNetworkHandler;
import dev.wxmc.weatheraddon.util.WXMCDebugLogger;
import dev.wxmc.weatheraddon.warnings.StormTracker;
import dev.wxmc.weatheraddon.warnings.TrackedStorm;
import io.github.mortuusars.exposure.neoforge.api.event.FrameAddedEvent;
import io.github.mortuusars.exposure.world.camera.frame.Frame;
import io.github.mortuusars.exposure.world.level.storage.ExposureIdentifier;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;

public class ExposureEventHandler {
    private static final double TORNADO_PHOTO_RANGE = 500.0;

    @SubscribeEvent
    public static void onFrameAdded(FrameAddedEvent event) {
        Entity entity = event.getCameraHolderEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        ExposureEventHandler.capturePhotoMetadata(event, player);
        StormTracker tracker = StormTracker.getInstance();
        if (!tracker.isPMWeatherAvailable()) {
            return;
        }
        List positionsInFrame = event.getPositionsInFrame();
        if (positionsInFrame.isEmpty()) {
            ExposureEventHandler.checkTornadoInPlayerView(player, tracker);
            return;
        }
        for (BlockPos pos : positionsInFrame) {
            TrackedStorm nearestTornado = ExposureEventHandler.findNearestTornado(tracker, pos.getX(), pos.getZ());
            if (nearestTornado == null) continue;
            ExposureEventHandler.fireTornadoPhotographedEvent(player, nearestTornado);
            return;
        }
        ExposureEventHandler.checkTornadoInPlayerView(player, tracker);
    }

    private static void capturePhotoMetadata(FrameAddedEvent event, ServerPlayer player) {
        try {
            Frame frame = event.getFrame();
            if (frame == null || frame == Frame.EMPTY) {
                WXMCDebugLogger.debug("[PhotoMetadata] Frame is null or empty, skipping metadata capture");
                return;
            }
            ExposureIdentifier identifier = frame.identifier();
            if (identifier == null) {
                WXMCDebugLogger.debug("[PhotoMetadata] Frame has no identifier, skipping metadata capture");
                return;
            }
            String photoId = identifier.id();
            if (photoId == null || photoId.isEmpty()) {
                WXMCDebugLogger.debug("[PhotoMetadata] Frame identifier has no ID, skipping metadata capture");
                return;
            }
            String photographerName = player.getName().getString();
            int x = (int)player.getX();
            int z = (int)player.getZ();
            PhotoMetadataStorage.storeMetadata(photoId, photographerName, x, z);
            PhotoMetadataNetworkHandler.broadcastPhotoMetadata(photoId, photographerName, x, z);
            WXMCDebugLogger.debug("[PhotoMetadata] Captured and broadcast metadata for photo {}: {} at ({}, {})", photoId, photographerName, x, z);
        }
        catch (Exception e) {
            WXMCDebugLogger.warn("[PhotoMetadata] Failed to capture photo metadata: {}", e.getMessage());
        }
    }

    private static void checkTornadoInPlayerView(ServerPlayer player, StormTracker tracker) {
        Vec3 lookVec = player.getLookAngle();
        double playerX = player.getX();
        double playerZ = player.getZ();
        for (int dist = 50; dist <= 500; dist += 50) {
            double checkX = playerX + lookVec.x * (double)dist;
            double checkZ = playerZ + lookVec.z * (double)dist;
            TrackedStorm tornado = ExposureEventHandler.findNearestTornado(tracker, checkX, checkZ);
            if (tornado == null) continue;
            ExposureEventHandler.fireTornadoPhotographedEvent(player, tornado);
            return;
        }
    }

    private static TrackedStorm findNearestTornado(StormTracker tracker, double x, double z) {
        for (TrackedStorm storm : tracker.getTrackedStorms()) {
            if (storm.getStage() < 3) continue;
            Vec3 stormPos = storm.getPosition();
            double dist = Math.sqrt(Math.pow(stormPos.x - x, 2.0) + Math.pow(stormPos.z - z, 2.0));
            if (!(dist <= 200.0)) continue;
            return storm;
        }
        return null;
    }

    private static void fireTornadoPhotographedEvent(ServerPlayer player, TrackedStorm tornado) {
        Vec3 pos = tornado.getPosition();
        int windspeed = tornado.getWindspeed();
        long stormId = tornado.getId();
        WXMCDebugLogger.debug("[Exposure] {} photographed tornado {} (windspeed: {} mph)", player.getName().getString(), stormId, windspeed);
        BukkitEventBridge.fireTornadoPhotographed(player, stormId, windspeed, pos.x, pos.z);
    }
}

